// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var TrendsView;
    return TrendsView = Hubii.View.extend({
      showing: false,
      appendCached: [],
      el: null,
      content: null,
      tmplTrend: function(j) {
        var html;
        html = "<a href='#' class='trend_block' rel='" + j.Label + "'> <div class='trend_block_title'> <h2 class='trend_title'>" + j.Label + "</h2> </div>";
        if (j.Image) {
          html += "<img class='trend_image' src='" + j.Image + "' />";
        }
        return html += "</a>";
      },
      tmplNoTrends: function() {
        return '<div id="no-news"> <i class="sprite no-news-here"></i> <p id="no-phrase">Sorry, no trends in this location</p> </div>';
      },
      tmplLoading: function() {
        return '<div id="loading"> <img src="img/loading_static.png" width="34" height="34" /> </div>';
      },
      initialize: function(options) {
        this.collection.on('reset', (function(_this) {
          return function() {
            if (_this.showing) {
              return _this.render();
            }
          };
        })(this));
        this.collection.on('add', (function(_this) {
          return function(model) {
            if (_this.showing) {
              return _this.addNews(model);
            }
          };
        })(this));
        return App.populator('trends', (function(_this) {
          return function(page, params) {
            return _this.populate(page, params);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
      },
      populate: function(page) {
        this.el = $(page);
        this.content = this.el.find('#trends');
        this.showing = true;
        this.el.find('.app-location').html(hA.selectedlocation.name);
        this.el.on('click', '.refresh-button', (function(_this) {
          return function() {
            _this.content.html(_this.tmplLoading());
            return hA.events.trigger('fetch_trends');
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            return _this.showing = false;
          };
        })(this));
        this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('hide_filters');
            hA.sendPageViewGA();
            _this.showing = true;
            return hA.events.trigger('mark_current_menu', document.getElementById('menu-trends-button'));
          };
        })(this));
        this.el.on('click', '.trend_block', (function(_this) {
          return function(e) {
            return hA.events.trigger('fire_search', $(e.currentTarget).attr('rel'), true);
          };
        })(this));
        return this.render();
      },
      destructor: function() {
        this.el.off('appHide');
        this.el.off('appShow');
        this.el.off('click', '.trend_block');
        this.el.off('click', '.refresh-button');
        this.el = null;
        this.content = null;
        return this.showing = false;
      },
      showNoTrendsMessage: function() {
        return this.content.html(this.tmplNoTrends(this.noNewsMessage)).find('#no-phrase').text(hA.t('no_trends_in_this_location'));
      },
      render: function() {
        this.el.find('#loading').remove();
        this.content.empty();
        if (this.collection.length) {
          return this.collection.each(this.addTrend, this);
        } else {
          return this.showNoTrendsMessage();
        }
      },
      addTrend: function(model) {
        var $toAppend;
        this.appendCached.push(this.tmplTrend(model.toJSON()));
        if (this.appendCached.length === this.collection.getFetchedLength()) {
          $toAppend = $(this.appendCached.join(''));
          this.content.append($toAppend);
          return this.appendCached = [];
        }
      }
    });
  });

}).call(this);
