// Copyright (c) 2015, Masahiko Imanaka. All rights reserved.
// Swiper.js - Detect swipe action on any element.

(function(exports) {
'use strict';

function Swiper(elm) {
  this.element = elm;
  this.startX = this.startY = null;
  this.elmId = null;
}

Swiper.prototype.swipeHandler = null;

Swiper.prototype.start = function () {
  this.element.addEventListener('touchstart', this);
  this.element.addEventListener('touchend', this);
};

Swiper.prototype.stop = function () {
  this.element.removeEventListener('touchstart', this);
  this.element.removeEventListener('touchend', this);
};

Swiper.prototype.handleEvent = function (ev) {
  var touch;
  switch(ev.type) {
    case 'touchstart':
      touch = ev.touches[0];
      this.startX = touch.pageX;
      this.startY = touch.pageY;
      this.touchID = touch.identifier;
      if (ev.target.id !== 'undefined') {
        this.elmId = ev.target.id;
      }
      break;

    case 'touchend':
      var dx, dy;
      touch = ev.changedTouches[0];
      if (touch.identifier != this.touchID) {
        return;
      }
      dx = touch.pageX - this.startX;
      dy = touch.pageY - this.startY;

      var angle = Math.atan2(dy, dx) * 180 / Math.PI;
      if (angle < 0) {
        angle += 360;
      }
      var direction;
      if (angle >= 315 || angle < 45) {
        direction = 'right';
      } else if (angle >= 45 && angle < 135) {
        direction = 'down';
      } else if (angle >= 135 && angle < 225) {
        direction = 'left';
      } else if (angle >= 225 && angle < 315) {
        direction = 'up';
      }
      if (typeof this.swipeHandler === 'function') {
        this.swipeHandler({
          id: this.elmId,
          dx: dx,
          dy: dy,
          angle: angle,
          direction: direction
        });
      }
      //console.log('touchend', direction, dx, dy);
      break;
    default:
  }
};

exports.Swiper = Swiper;

})(window);
