var layout =  new Layout();


// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {
  layout.init();
});

$(document).ready(function(){
  
//   alert ("screen resolution: height " + window.screen.availHeight + " width "+ window.screen.availWidth);
  
//   localStorage.clear();
//   localStorage.removeItem("1438343105");
  
  RenderPresetList();
  
  //change theme by settings
  var ThemeColorSettingFromStorage = localStorage.getItem("ThemeColorSettingStorage");
  if( ThemeColorSettingFromStorage == "true" ) {
    $( "meta#themeColor" ).replaceWith( '<meta content="#000" name="theme-color" id="themeColor">' );
    $( "link#appcss" ).replaceWith( '<link rel="stylesheet" href="css/theme-dark.css" id="appcss">' );
    $('input#DarkTheme').prop('checked', true);
  };
  
  //save theme settings to storage
  $( "input#DarkTheme" ).change(function() {    
    var ThemeColorSetting = $( 'input#DarkTheme' ).is(':checked');
    localStorage.setItem("ThemeColorSettingStorage",ThemeColorSetting);
  });
  
  //switche theme by UI
  $( "input#DarkTheme" ).change(function() {
    var state = $( "input#DarkTheme" ).is(':checked');
    if (state) {
      window.navigator.vibrate([50]);
      $( "meta#themeColor" ).replaceWith( '<meta content="#000" name="theme-color" id="themeColor">' );
      $( "link#appcss" ).replaceWith( '<link rel="stylesheet" href="css/theme-dark.css" id="appcss">' );
    }
    else {
      window.navigator.vibrate([50]);
      $( "meta#themeColor" ).replaceWith( '<meta content="#0d53bb" name="theme-color" id="themeColor">' );
      $( "link#appcss" ).replaceWith( '<link rel="stylesheet" href="css/theme-default.css" id="appcss">' );
    }
  });
  
  //   slide switche
  $("button#preset").click(function(){
    $("div#manual-slide").hide();
    $("div#addPresetSlide").hide();
    $("div#editPresetSlide").hide();
    $("div#preset-slide").show(200);
    
    $( "button#preset" ).addClass('selectedBottomButton');
    $( "button#manual" ).removeClass('selectedBottomButton');
  });
  $("button#manual").click(function(){
    $("div#preset-slide").hide();
    $("div#addPresetSlide").hide();
    $("div#editPresetSlide").hide();
    $("div#manual-slide").show(200); 
    
    $( "button#manual" ).addClass('selectedBottomButton');
    $( "button#preset" ).removeClass('selectedBottomButton');
  });
    $("button#addPreset").click(function(){
    $("div#preset-slide").hide();
    $("div#manual-slide").hide();
    $("div#editPresetSlide").hide();
    $("div#addPresetSlide").show(200);
    $( ".slides" ).removeClass( "left_selected" );
    $( ".center_menu button" ).removeClass('selectedBottomButton');
  });
    
  $('ul#presetMenu').on('click', 'button.editPreset', function(presetID){
    $("div#preset-slide").hide();
    $("div#manual-slide").hide();
    $("div#addPresetSlide").hide();
    $("div#editPresetSlide").show(200);
    $( ".slides" ).removeClass( "left_selected" );
    
    var itemID = presetID.target.id;
    var editPresetValues = JSON.parse(localStorage.getItem(itemID))
    
    $('input#preset-name-edit').val(editPresetValues["presetNameNew"]);
    $('select#coc-preset-edit option:contains(' + editPresetValues["presetCocNew"] + ')').prop('selected', true);
    $('select#focal-lenght-preset-edit').val(editPresetValues["presetFocalLenghtNew"]);
    $('select#aperture-preset-edit').val(editPresetValues["presetAperatureNew"]);
    $('input#edit-preset-id').val(itemID);

    $( ".center_menu button" ).removeClass('selectedBottomButton');
  });
  
  $('ul#presetMenu').on('click', 'button.deletePreset', function(presetID){
    var itemID = presetID.target.id;
    
    $("button.confirmDeletePreset").attr("id",itemID);    
    $("form#deleteConfirm").show();
  });
  
  $('ul#presetMenu').on('click', 'button.usePreset', function(presetID){
    $("div#manual-slide").hide();
    $("div#addPresetSlide").hide();
    $("div#editPresetSlide").hide();
    $("div#preset-slide").show(200);
    $( ".slides" ).removeClass( "left_selected" );
    
    var itemID = presetID.target.id;
    var usePresetValues = JSON.parse(localStorage.getItem(itemID));
    
    $('select#coc-preset option:contains(' + usePresetValues["presetCocNew"] + ')').prop('selected', true);
    $('select#focal-lenght-preset').val(usePresetValues["presetFocalLenghtNew"]);
    $('select#aperture-preset').val(usePresetValues["presetAperatureNew"]);  
    
    $( ".center_menu button" ).removeClass('selectedBottomButton');
    $( "button#preset" ).addClass('selectedBottomButton');
    
    RenderResult();
  });
  
  $("button.confirmDeletePreset").click(function(presetID){
    var itemIDToDelete = presetID.target.id;
    
    localStorage.removeItem(itemIDToDelete);
    $("form#deleteConfirm").hide();
    RenderPresetList();
  });
  
  $("button#confirmDeleteCancle").click(function(){
    $("form#deleteConfirm").hide();
  });
  
  $("button#editPresetSave").click(function(){
    var presetNameToSave =  $('input#preset-name-edit').val();
    var presetFocalLenghtToSave = $('select#focal-lenght-preset-edit').val();
    var presetApertureToSave = $('select#aperture-preset-edit').val();
    var presetIdToSave = $('input#edit-preset-id').val(); 
    var presetCocToSave = $( "select#coc-preset-edit option:selected" ).text()
    
    localStorage.removeItem(presetIdToSave);
    
    localStorage.setItem(presetIdToSave , JSON.stringify({
      presetNameNew: presetNameToSave,
      presetCocNew: presetCocToSave,
      presetFocalLenghtNew: presetFocalLenghtToSave,
      presetAperatureNew: presetApertureToSave
    }));
    
    $("div#editPresetSlide").hide();
    $("div#preset-slide").show(200);
    RenderPresetList();
    $( ".slides" ).addClass( "left_selected" );
    $( "button#preset" ).addClass('selectedBottomButton');
  });

  
  //render Result by hand change
  $( "select#aperture-preset" ).change(function() {    
    RenderResult();
  });
  
  $( "select#coc-preset" ).change(function() {    
    RenderResult();
  });
  
  $( "select#focal-lenght-preset" ).change(function() {    
    RenderResult();
  });
  
  $( "select#dof-subj-distance" ).change(function() {    
    RenderResult();
  });
  
  RenderResult();
  
  //calculate manual settings
  $( "button#manualCalculate" ).click(function() {
    RenderResultManual();
  });
  
  //add new preset
  $( "button#addNewPreset" ).click(function() {
    var presetNameNew = $( "#preset-name-new" ).val()
    var presetCocNew = $( "#coc-preset-new option:selected" ).text()
    var presetFocalLenghtNew = $( "#focal-lenght-preset-new" ).val()
    var presetAperatureNew = $( "#aperture-preset-new" ).val()
    
    localStorage.setItem(Math.floor(Date.now() / 1000) , JSON.stringify({
      presetNameNew: presetNameNew,
      presetCocNew: presetCocNew,
      presetFocalLenghtNew: presetFocalLenghtNew,
      presetAperatureNew: presetAperatureNew
    }));
    
    $("div#addPresetSlide").hide();
    $("div#preset-slide").show(200);
    RenderPresetList();
    $( ".slides" ).addClass( "left_selected" );
    $( "button#preset" ).addClass('selectedBottomButton');
  });
  
  //show edit buttons
  $( "button#showEditPreset" ).click(function() {
    $(".editPreset").toggle();
  });
  
  //show delete buttons
  $( "button#showDeletePreset" ).click(function() {
    $(".deletePreset").toggle();
  });
  
});

function CalculateHyperfocalAndDof(Aperture,CoC,FocalLenght,ObjectDistance) {
  var ObjectDistancemm = ObjectDistance * 1000;
  
  var HyperfocalDistancemm = ( FocalLenght * FocalLenght) / (Aperture * CoC) + FocalLenght;
  var HyperfocalDistance = Math.round(HyperfocalDistancemm) / 1000 ;
  var FocusFrom = Math.round(HyperfocalDistancemm / 2) / 1000;
  
  var NearDistanceOfSharpenesmm = ( ObjectDistancemm * ( HyperfocalDistancemm - FocalLenght) ) / ( HyperfocalDistancemm + ObjectDistancemm - 2*FocalLenght );
  var NearDistanceOfSharpenes = Math.round(NearDistanceOfSharpenesmm) / 1000 ;
  
  if ( (HyperfocalDistancemm - ObjectDistancemm) <= 0.00001) {
    var FarDistanceOfSharpenes = "infinity"; // set infinity at 10000m
  }
  else {
    var FarDistanceOfSharpenesmm = ( ObjectDistancemm * ( HyperfocalDistancemm - FocalLenght )) / ( HyperfocalDistancemm -  ObjectDistancemm );
    var FarDistanceOfSharpenes = Math.round(FarDistanceOfSharpenesmm) / 1000 ;
  }  
  
  var calculatedDistances = [];
  calculatedDistances["HyperfocalDistance"] = HyperfocalDistance;
  calculatedDistances["FocusFrom"] = FocusFrom;
  calculatedDistances["NearDistanceOfSharpenes"] = NearDistanceOfSharpenes;
  calculatedDistances["FarDistanceOfSharpenes"] = FarDistanceOfSharpenes;
  
  return calculatedDistances;
}


function RenderResultManual() {
  var FocalLenght = parseFloat( $( "#focal-lenght" ).val() );
  var Aperture = parseFloat( $( "#aperture" ).val() );
  var CoC = parseFloat( $( "#coc" ).val() );
  var ObjectDistance = parseFloat( $( "#subject-distance-manual" ).val() );
  
  var calculatedDistancesManual = CalculateHyperfocalAndDof(Aperture,CoC,FocalLenght,ObjectDistance);
  
  $( "#HyperfocalManual" ).text( calculatedDistancesManual["HyperfocalDistance"] );
  $( "#HyperfocalSharpFromManual" ).text( calculatedDistancesManual["FocusFrom"] );
  
  $( "#DofManualFocusTo" ).text( ObjectDistance );
  $( "#DofSharpFromManual" ).text( calculatedDistancesManual["NearDistanceOfSharpenes"] );
  $( "#DofSharptoManual" ).text( calculatedDistancesManual["FarDistanceOfSharpenes"] );  
}


function RenderResult() {
  var AperturePreset = parseFloat( $( "select#aperture-preset" ).val() );
  var CoCPreset = parseFloat( $( "select#coc-preset" ).val() );
  var FocalLenghtPreset = parseFloat( $( "select#focal-lenght-preset" ).val() );
  var ObjectDistancePreset = parseFloat( $( "select#dof-subj-distance" ).val() );
  
  var calculatedDistancesPreset = CalculateHyperfocalAndDof(AperturePreset,CoCPreset,FocalLenghtPreset,ObjectDistancePreset);
  
  
  
  $( "#helper-hyperfocal span.calchyp" ).text( calculatedDistancesPreset["HyperfocalDistance"] );
  $( "#helper-hyperfocal span.calcsharpfrommove" ).text( calculatedDistancesPreset["FocusFrom"] );
  
  $( "#helper-dof span.calcneardistancemove" ).text( calculatedDistancesPreset["NearDistanceOfSharpenes"] );
  $( "#helper-dof span.subjdistancemove" ).text( ObjectDistancePreset );
  $( "#helper-dof span.calcfardistancemove" ).text( calculatedDistancesPreset["FarDistanceOfSharpenes"] );
  
}

function RenderPresetList() {
  //reset menu
  $( "#presetMenu" ).html('');
  
  //sort by timestamp
  var keys = new Array();
  for(var i=0, len=localStorage.length; i<len; i++) {
   keys.push(localStorage.key(i));
  }
  keys.sort();
  
  
  var menuHTML = '';
  for(var i=0, len=keys.length; i<len; i++) {
    var key = keys[i];
    var value = localStorage[key];
    
    // check if key is timestamp    
    if ((new Date(parseInt(key))).getTime() > 0) {
      values = JSON.parse(localStorage.getItem(key));
      
//       menuHTML += '<li><button id="' + key + '" class="usePreset"><span>' + values['presetNameNew'] + '</span></button><button class="editPreset" id="' + key + '"  style="display:none;"><span data-icon="compose" aria-hidden="true"  style="display:none;" class="editPreset"></span></button>  <button class="deletePreset" id="' + key + '"  style="display:none;"><span data-icon="delete" aria-hidden="true"  style="display:none;" class="deletePreset"></span></button>';
      
      $( "#presetMenu" ).append( '<li><button id="' + key + '" class="usePreset"><span>' + values['presetNameNew'] + '</span></button><button class="editPreset" id="' + key + '"  style="display:none;"><span data-icon="compose" aria-hidden="true"  style="display:none;" class="editPreset"></span></button>  <button class="deletePreset" id="' + key + '"  style="display:none;"><span data-icon="delete" aria-hidden="true"  style="display:none;" class="deletePreset"></span></button>' );
    }
  }
  
//   $( "#presetMenu" ).html(menuHTML);
}
  