// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
angular.module('starter', ['ionic',"LocalStorageModule"])

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
    if(window.cordova && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }
  });
})

.service("ToDoService", function(localStorageService){

  this.key = "angular-todolist";

  if(localStorageService.get(this.key)){
    this.activities = localStorageService.get(this.key);
  }else{
    this.activities = [];
  }

  this.add = function(newActv){
    this.activities.push(newActv);
    this.updaLocalStorage();
  };
  this.updaLocalStorage = function(){
    localStorageService.set(this.key, this.activities);//1º Valor la clave del local storage 2º lo que ponemos
  };
  this.clean = function(){
    this.activities = [];
    this.updaLocalStorage();
    return this.getAll();
  };
  this.getAll = function(){
    return this.activities;
  };
  this.removeItem = function(item){
    this.activities = this.activities.filter(function(activty){
    return activty !== item;
  });
  this.updaLocalStorage();
    return this.getAll();
  };

})

.controller("ToDoController", function($scope,ToDoService){

  $scope.todo = ToDoService.getAll();
  $scope.newActv = {};

  $scope.addActv = function(){
    ToDoService.add($scope.newActv);
    $scope.newActv = {};
  };

  $scope.removeActv = function(item){
    $scope.todo = ToDoService.removeItem(item);
  };

  $scope.clean = function(){
    $scope.todo = ToDoService.clean();
  };
  
});