// Hide and Seek Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     draggable (Boolean): If true the view will follow the cursor position between the touch start and touch end.
//     alpha (Number): Amount of transparency amount ranging from 0 (completely transparent) to 0.5 to 1 (completely opaque). 
//         Example:
//              alpha: 0.5 // View will be rendered at half transparency
//     ignoreTransparentPixels (Boolean): If true the hotspot will register only if the pixel's alpha component under touch position is greater than 0.
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Hide and Seek Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after all the hidden items are found.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a target item is touched.
//         
// Round Properties
//
//     background
//         Properties:
//            filename: Filename of the background image.
//     items: A random item is selected at the start of each round to be the correct item.
//         Available States:
//             HIDDEN: Initial state of the label.
//             DRAG: Displayed when the item is being dragged.
//             FOUND: Displayed after the item is found.
//         Properties:
//             mask: Optional view coupled with an item.
//                 Properties:
//                     wiggleOnTouch (Boolean): A touch will cause the mask's item to vibrate.
//                     foundOnTouch (Boolean): A touch will cause the mask' item to be found.
//                     touchDisabled (Boolean): Touch events on the mask will be ignored.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "icon-hideSeek-instruments.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "startImage-hideSeek-instruments.jpg",
	audioEnabled: true,
	audioFilename: "audio-hideSeek-instruments.mp3",
	audio: { //all audio including intro, payoff, and music
		states: [
			{
				name: "intro",
				startTime: 0,
				duration: 3
			}, {
				name: "payoff",
				startTime: 4,
				duration: 3
			},
			{
				name: "music", 
				startTime: 9,
				duration: 21,
				loop: true
			}
		]
	},
	rounds: [
		{
			background: {
				filename: "background-123.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden", //the item appearing in its hidden state, can be partial image
									filename: "oscar-kazoo.png", //make a rectangle marquee in Photoshop to get the bounding rectangle of the object and export as transparent png
									x: 702, //x,y coordinates of objects can be found by opening the object in Photoshop, add on a layer mask to show the bounding rectangle, take the ruler tool and measure from top to bottom. Take this number and subtract 100 px. The x,y coordinates will then be placed here.
									y: 401
								},{
									type: "Drag", //item appearing in draggable state, should be full image even if hidden was partial
									filename: "oscar-kazoo.png",
									x: 702,
									y: 401,
									draggable: true
								},{
									type: "Found", //found animation
									filename: "oscar-kazoo-found.png",
									x: 672,
									y: 260,
									numFrames: 14
								}
							]
						},{
							states: [
								{
									type: "Hidden",
									filename: "rosita-accordion-hidden.png",
									x: 428,
									y: 311
								},{
									type: "Drag",
									filename: "rosita-accordion-hidden.png",
									x: 428,
									y: 311,
									draggable: true
								},{
									type: "Found",
									filename: "rosita-accordion-found.png",
									x: 392,
									y: 270,
									numFrames: 11
								}
							],
							mask: { //export the mask item covering above state and add 10px to each side of the image to allow for wiggle
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "door-123.png",
										x: 418, //original x,y coordinates - does not include the added 10px
										y: 289
									}, {
										type: "Found",
										filename: "door-123-open.png",
										x: 376,
										y: 286
									}, {
										type: "SWIPE_LEFT",
										filename: "door-123-open.png",
										foundOnState: true,
										x: 376,
										y: 286
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "bongo-hidden.png",
									x: 102,
									y: 526
								},{
									type: "Drag",
									filename: "bongo-hidden.png",
									x: 102,
									y: 526,
									draggable: true
								},{
									type: "Found",
									filename: "bongo-found.png",
									x: 91,
									y: 430,
									numFrames: 15
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "gate-123.png",
										x: 79,
										y: 562,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "maracas-hidden.png",
									x: 74,
									y: 380
								},{
									type: "Drag",
									filename: "maracas.png",
									x: 68,
									y: 374,
									draggable: true
								},{
									type: "Found",
									filename: "maracas-found.png",
									x: 38,
									y: 340,
									numFrames: 12
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "maracas-mask.png",
										x: 64,
										y: 370
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "triangle-hidden.png",
									x: 225,
									y: 357
								},{
									type: "Drag",
									filename: "triangle-drag.png",
									x: 225,
									y: 347,
									draggable: true
								},{
									type: "Found",
									filename: "triangle-found.png",
									x: 210,
									y: 346,
									numFrames: 14
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "triangle-mask.png",
										x: 216,
										y: 347
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "banjo-hidden.png",
									x: 640,
									y: 77
								},{
									type: "Drag",
									filename: "banjo-drag.png",
									x: 640,
									y: 77,
									draggable: true
								},{
									type: "Found",
									filename: "banjo-found.png",
									x: 540,
									y: 32,
									numFrames: 14
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "banjo-mask.png",
										x: 684,
										y: 112,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "electric-guitar-hidden.png",
									x: 884,
									y: 178
								},{
									type: "Drag",
									filename: "electric-guitar.png",
									x: 880,
									y: 177,
									draggable: true
								},{
									type: "Found",
									filename: "electric-guitar-found.png",
									x: 773,
									y: 171,
									numFrames: 8
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "electric-guitar-mask.png",
										x: 874,
										y: 262
										
									}
								]
							}
						}
					]
				}
			]
		},{ //Round 2
			background: {
				filename: "background-nest.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "piano-hidden.png",
									x: 465,
									y: 466
								},{
									type: "Drag",
									filename: "piano-drag.png",
									x: 440,
									y: 466,
									draggable: true
								},{												
									type: "Found",
									filename: "piano-found.png",
									x: 431,
									y: 457,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "piano-mask.png",
										x: 456,
										y: 480
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "rosita-clarinet-hidden.png",
									x: 759,
									y: 392
								},{
									type: "Drag",
									filename: "rosita-clarinet-hidden.png",
									x: 751,
									y: 392,
									draggable: true
								},{
									type: "Found",
									filename: "rosita-clarinet-found.png",
									x: 751,
									y: 386,
									numFrames: 10
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "rosita-clarinet-mask.png",
										x: 805,
										y: 431,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "snare-drum.png",
									x: 140,
									y: 490
								},{
									type: "Drag",
									filename: "snare-drum.png",
									x: 140,
									y: 490,
									draggable: true
								},{
									type: "Found",
									filename: "snare-drum-found.png",
									x: 130,
									y: 440,
									numFrames: 18
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "bush.png",
										x: 20,
										y: 450,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "maracas-2-hidden.png",
									x: 215,
									y: 372
								},{
									type: "Drag",
									filename: "maracas-2-drag.png",
									x: 191,
									y: 371,
									draggable: true
								},{
									type: "Found",
									filename: "maracas-found.png",
									x: 184,
									y: 363,
									numFrames: 12
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "maracas-2-mask.png",
										x: 205,
										y: 361,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "accordion-blue.png",
									x: 700,
									y: 267
								},{
									type: "Drag",
									filename: "accordion-blue.png",
									x: 700,
									y: 267,
									draggable: true
								},{
									type: "Found",
									filename: "accordion-blue-found.png",
									x: 650,
									y: 240,
									numFrames: 11
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								states: [
									{
										type: "Default",
										filename: "accordion-mask.png",
										x: 691,
										y: 344,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "drum-kit-hidden.png",
									x: 398,
									y: 297
								},{
									type: "Drag",
									filename: "drum-kit-drag.png",
									x: 392,
									y: 297,
									draggable: true
								},{
									type: "Found",
									filename: "drum-kit-found.png",
									x: 344,
									y: 240,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "drum-kit-mask.png",
										x: 388,
										y: 287,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "acoustic-guitar-hidden.png",
									x: 639,
									y: 82
								},{
									type: "Drag",
									filename: "acoustic-guitar-hidden.png",
									x: 639,
									y: 82,
									draggable: true
								},{
									type: "Found",
									filename: "acoustic-guitar-found.png",
									x: 600,
									y: 14,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "acoustic-guitar-mask.png",
										x: 712,
										y: 72,
										draggable: false
									}
								]
							}
						}
					]
				}
			]
		},{ //Round 3
			background: {
				filename: "background-store-outside.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "banjo-2.png",
									x: 139,
									y: 340
								},{
									type: "Drag",
									filename: "banjo-2.png",
									x: 139,
									y: 340,
									draggable: true
								},{												
									type: "Found",
									filename: "banjo-2-found.png",
									x: 60,
									y: 280,
									numFrames: 14
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "door-open-1.png",
										x: 89,
										y: 316
									}, {
										type: "Found",
										filename: "door-open-2.png",
										x: -15,
										y: 316
									}, {
										type: "SWIPE_LEFT",
										filename: "door-open-2.png",
										foundOnState: true,
										x: -15,
										y: 316
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "flute-hidden.png",
									x: 88,
									y: 104
								},{
									type: "Drag",
									filename: "flute.png",
									x: 88,
									y: 104,
									draggable: true
								},{												
									type: "Found",
									filename: "flute-found.png",
									x: 76,
									y: 98,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "flute-mask.png",
										x: 78,
										y: 94
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "trombone-hidden.png",
									x: 341,
									y: 84
								},{
									type: "Drag",
									filename: "trombone-drag.png",
									x: 267,
									y: 83,
									draggable: true
								},{												
									type: "Found",
									filename: "trombone-2-found.png",
									x: 360,
									y: 75,
									numFrames: 8
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "trombone-mask.png",
										x: 331,
										y: 74
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "tambourine.png",
									x: 397,
									y: 350
								},{
									type: "Drag",
									filename: "tambourine.png",
									x: 397,
									y: 350,
									draggable: true
								},{												
									type: "Found",
									filename: "tambourine-found.png",
									x: 431,
									y: 342,
									numFrames: 18
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "tambourine-mask.png",
										x: 381,
										y: 315
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "clarinet-hidden.png",
									x: 557,
									y: 508
								},{
									type: "Drag",
									filename: "clarinet-hidden.png",
									x: 557,
									y: 508,
									draggable: true
								},{												
									type: "Found",
									filename: "clarinet-found.png",
									x: 560,
									y: 400,
									numFrames: 10
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: true,
								touchDisabled: false,
								states: [
									{
										type: "Default",
										filename: "clarinet-mask.png",
										x: 573,
										y: 497,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "trumpet.png",
									x: 772,
									y: 520
								},{
									type: "Drag",
									filename: "trumpet.png",
									x: 772,
									y: 520,
									draggable: true
								},{												
									type: "Found",
									filename: "trumpet-found.png",
									x: 750,
									y: 470,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "trumpet-mask.png",
										x: 773,
										y: 486,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "snare-drum.png",
									x: 260,
									y: 460
								},{
									type: "Drag",
									filename: "snare-drum.png",
									x: 260,
									y: 460,
									draggable: true
								},{												
									type: "Found",
									filename: "snare-drum-found.png",
									x: 245,
									y: 405,
									numFrames: 18
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "newspaper-stand.png",
										x: 230,
										y: 548,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "xylophone-hidden.png",
									x: 598,
									y: 327
								},{
									type: "Drag",
									filename: "xylophone-drag.png",
									x: 569,
									y: 327,
									draggable: true
								},{												
									type: "Found",
									filename: "xylophone-found.png",
									x: 563,
									y: 240,
									numFrames: 12
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "xylophone-mask.png",
										x: 588,
										y: 360
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "rosita-maracas-hidden.png",
									x: 822,
									y: 330
								},{
									type: "Drag",
									filename: "rosita-maracas-drag.png",
									x: 784,
									y: 330,
									draggable: true
								},{												
									type: "Found",
									filename: "rosita-maracas-found.png",
									x: 740,
									y: 130,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "rosita-maracas-mask.png",
										x: 812,
										y: 375
									}
								]
							}
						}
					]
				}
			]
		},{ //Round 4
			background: {
				filename: "background-store-inside.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "flute.png",
									x: 644,
									y: 535
								},{
									type: "Drag",
									filename: "flute.png",
									x: 644,
									y: 535,
									draggable: true
								},{												
									type: "Found",
									filename: "flute-found.png",
									x: 590,
									y: 480,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "grapes.png",
										x: 651,
										y: 519,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "electric-guitar.png",
									x: 428,
									y: 315
								},{
									type: "Drag",
									filename: "electric-guitar.png",
									x: 428,
									y: 315,
									draggable: true
								},{												
									type: "Found",
									filename: "electric-guitar-found.png",
									x: 350,
									y: 240,
									numFrames: 8
								}
							],
							mask: {
								wiggleOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "apple-basket.png",
										x: 426,
										y: 468,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "tambourine-red.png",
									x: 98,
									y: 513
								},{
									type: "Drag",
									filename: "tambourine-red.png",
									x: 98,
									y: 513,
									draggable: true
								},{												
									type: "Found",
									filename: "tambourine-red-found.png",
									x: 90,
									y: 470,
									numFrames: 18
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "orange-crate.png",
										x: 0,
										y: 520,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "accordion-red.png",
									x: 284,
									y: 74
								},{
									type: "Drag",
									filename: "accordion-red.png",
									x: 284,
									y: 74,
									draggable: true
								},{												
									type: "Found",
									filename: "accordion-red-found.png",
									x: 280,
									y: 63,
									numFrames: 11
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "detergent-2.png",
										x: 240,
										y: 82,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "violin.png",
									x: 240,
									y: 323
								},{
									type: "Drag",
									filename: "violin.png",
									x: 240,
									y: 323,
									draggable: true
								},{												
									type: "Found",
									filename: "violin-2-found.png",
									x: 170,
									y: 295,
									numFrames: 11
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "cereal-boxes.png",
										x: 247,
										y: 378,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "clarinet-2.png",
									x: 50,
									y: 220
								},{
									type: "Drag",
									filename: "clarinet-2.png",
									x: 50,
									y: 220,
									draggable: true
								},{												
									type: "Found",
									filename: "clarinet-found.png",
									x: 42,
									y: 211,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "cans.png",
										x: 61,
										y: 248,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "trumpet.png",
									x: 218,
									y: 500
								},{
									type: "Drag",
									filename: "trumpet.png",
									x: 218,
									y: 500,
									draggable: true
								},{												
									type: "Found",
									filename: "trumpet-found.png",
									x: 208,
									y: 452,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "tuna-cans.png",
										x: 220,
										y: 530,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "rosita-drum-kit-hidden.png",
									x: 703,
									y: 138
								},{
									type: "Drag",
									filename: "rosita-drum-kit.png",
									x: 628,
									y: 138,
									draggable: true
								},{												
									type: "Found",
									filename: "rosita-drum-kit-found.png",
									x: 617,
									y: 100,
									numFrames: 10
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "rosita-drum-kit-mask.png",
										x: 693,
										y: 128,
										draggable: false
									}
								]
							}
						}
					]
				}
			]
		},{ //Round 5
			background: {
				filename: "background-laundromat.png"
			},
			itemGroups: [
				{
					items: [
						{
							states: [
								{
									type: "Hidden",
									filename: "clarinet-3-hidden.png",
									x: 797,
									y: 438
								},{
									type: "Drag",
									filename: "clarinet-3.png",
									x: 797,
									y: 379,
									draggable: true
								},{												
									type: "Found",
									filename: "clarinet-found.png",
									x: 789,
									y: 280,
									numFrames: 10
								}
							]
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "banjo-3-hidden.png",
									x: 676,
									y: 206
								},{
									type: "Drag",
									filename: "banjo-3.png",
									x: 676,
									y: 206,
									draggable: true
								},{												
									type: "Found",
									filename: "banjo-found.png",
									x: 608,
									y: 160,
									numFrames: 14
								}
							],
							mask: {
								wiggleOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "banjo-3-mask.png",
										x: 726,
										y: 196
									}
								]
							}
						},
						{
							states: [
								{
									type: "Hidden",
									filename: "trumpet-2.png",
									x: 122,
									y: 483
								},{
									type: "Drag",
									filename: "trumpet-2.png",
									x: 122,
									y: 483,
									draggable: true
								},{												
									type: "Found",
									filename: "trumpet-found.png",
									x: 80,
									y: 450,
									numFrames: 9
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "laundry-basket.png",
										x: 69,
										y: 510,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "rosita-tambourine-hidden.png",
									x: 371,
									y: 494
								},{
									type: "Drag",
									filename: "rosita-tambourine.png",
									x: 296,
									y: 491,
									draggable: true
								},{												
									type: "Found",
									filename: "rosita-tambourine-found.png",
									x: 315,
									y: 460,
									numFrames: 8
								}
							]
						},{
							states: [
								{
									type: "Hidden",
									filename: "flute-3.png",
									x: 43,
									y: 108
								},{
									type: "Drag",
									filename: "flute-3.png",
									x: 43,
									y: 108,
									draggable: true
								},{												
									type: "Found",
									filename: "flute-found.png",
									x: 35,
									y: 150,
									numFrames: 9
								}
							],
							mask: {
								wiggleOnTouch: true,
								foundOnTouch: false,
								touchDisabled: false,
								states: [
									{
										type: "Default",
										filename: "clock.png",
										x: 113,
										y: 68,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "kazoo.png",
									x: 505,
									y: 190
								},{
									type: "Drag",
									filename: "kazoo.png",
									x: 505,
									y: 190,
									draggable: true
								},{												
									type: "Found",
									filename: "kazoo-found.png",
									x: 505,
									y: 65,
									numFrames: 17
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "detergent.png",
										x: 435,
										y: 114,
										draggable: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "saxophone.png",
									x: 240,
									y: 44
								},{
									type: "Drag",
									filename: "saxophone.png",
									x: 240,
									y: 44,
									draggable: true
								},{												
									type: "Found",
									filename: "saxophone-found.png",
									x: 240,
									y: 36,
									numFrames: 16
								}
							],
							mask: {
								wiggleOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "laundry-bag.png",
										x: 244,
										y: 99,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "cymbals.png",
									x: 690,
									y: 530
								},{
									type: "Drag",
									filename: "cymbals.png",
									x: 690,
									y: 530,
									draggable: true
								},{												
									type: "Found",
									filename: "cymbals-found.png",
									x: 680,
									y: 500,
									numFrames: 11
								}
							],
							mask: {
								wiggleOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "laundry-barrel.png",
										x: 705,
										y: 600,
										draggable: true,
										ignoreTransparentPixels: true
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "snare-drum.png",
									x: 481,
									y: 351
								},{
									type: "Drag",
									filename: "snare-drum.png",
									x: 481,
									y: 351,
									draggable: true
								},{												
									type: "Found",
									filename: "snare-drum-found.png",
									x: 471,
									y: 300,
									numFrames: 18
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "laundry-door-closed.png",
										x: 463,
										y: 327,
										draggable: false
									},{
										type: "SWIPE_LEFT",
										filename: "laundry-door-open.png",
										x: 338,
										y: 327,
										draggable: false
									}
								]
							}
						},{
							states: [
								{
									type: "Hidden",
									filename: "maracas.png",
									x: 50,
									y: 371
								},{
									type: "Drag",
									filename: "maracas.png",
									x: 50,
									y: 371,
									draggable: true
								},{												
									type: "Found",
									filename: "maracas-found.png",
									x: 30,
									y: 341,
									numFrames: 12
								}
							],
							mask: {
								foundOnTouch: true,
								states: [
									{
										type: "Default",
										filename: "laundry-door-2-closed.png",
										x: 15,
										y: 325,
										draggable: false
									},{
										type: "SWIPE_RIGHT",
										filename: "laundry-door-2-open.png",
										x: 15,
										y: 325,
										draggable: false
									}
								]
							}
						}
					]
				}
			]
		}
	]
};