$(document).ready(function() {

	if (isPhoneGap()) {
		document.addEventListener("deviceready", onDeviceReady, false);
	} else {
		onDeviceReady();
	}
})
function isPhoneGap() {
	return (cordova || PhoneGap || phonegap) && /^file:\/{3}[^\/]/i.test(window.location.href) && /ios|iphone|ipod|ipad|android/i.test(navigator.userAgent);
}

function onDeviceReady() {
	document.addEventListener("backbutton", function(e) {
		e.preventDefault();
		navigator.app.backHistory();
		history.back();
	}, true);

	var screen_size = $(window).width();
	$("body").css("width", screen_size);
	$("#back_btn").click(function(e) {
		e.preventDefault();
		//navigator.app.backHistory();
		history.back();
	});
	
	if (isPhoneGap()) {
		$("#ft_list_escanear").click(function(e) { scannerPhoneGap(e);});
	} else {
		$("#ft_list_escanear").click(function(e) {scannerFirefoxOs(e);});
	}

	function alertDismissed() {
		// do something
	}

}

function scannerPhoneGap(e) {
	$("#loading_div").show();
	e.preventDefault();
	window.plugins.barcodeScanner.scan(function(result) {
		if (!result.cancelled) {
			if (result.format == "EAN_13") {
				window.location.href = "producto.html?barcode=" + result.text + "&lang=es&from=scan";
			} else if (result.format == "QR_CODE") {
				var str = result.text.split("/");
				var long = str.length;
				if (str[long - 2] == "qr.ibilimenaje.com") {
					window.location.href = "producto.html?barcode=" + str[long - 1] + "&lang=es&from=scan";
				} else {
					navigator.notification.alert("No es un QR Ibili valido", alertDismissed, "Ibili Menaje", "OK");
				}
			}
			$("#loading_div").css("display", "none");
		} else {
			$("#loading_div").css("display", "none");
		}
		/*
		 * alert("We got a barcode\n" + "Result: " + result.text +
		 * "\n" + "Format: " + result.format + "\n" + "Cancelled: " +
		 * result.cancelled);
		 */
	}, function(error) {
		alert("Scanning failed: " + error);
		$("#loading_div").css("display", "none");
	});
}

function read(a) {
    return a;
}

qrcode.callback = read;

function scannerFirefoxOs(e) {
	e.preventDefault();
	$("#loading_div").show();
	var pick = new MozActivity({
		name : "pick",
		data : {
			type : ["image/png", "image/jpg", "image/jpeg"]
		}
	});

	pick.onsuccess = function() {
		// Create image and set the returned blob as the src
		var img = document.createElement("img");
		img.src = window.URL.createObjectURL(pick.result.blob);

		var result = qrcode.decode(img.src);
		var str = result.text.split("/");
		var long = str.length;
		if (str[long - 2] == "qr.ibilimenaje.com") {
			window.location.href = "producto.html?barcode=" + str[long - 1] + "&lang=es&from=scan";
		} else {
			navigator.notification.alert("No es un QR Ibili valido", alertDismissed, "Ibili Menaje", "OK");
		}
		console.log(result + "THIS IS THE RESULT");
	};

	pick.onerror = function() {
		$.mobile.hidePageLoadingMsg();
		// If an error occurred or the user canceled the activity
		alert("Can't view the image!");
		$("#loading_div").css("display", "none");
	};
	$("#loading_div").css("display", "none");
}