var geocoder;
var map;
var initMarker;
var hotelAddress;
var currentLocation;
var browserSupportFlag = new Boolean();
var directionDisplay;
var directionsService = new google.maps.DirectionsService();
var markersArray = [];
var address = "";
var myLat = "";
var myLng = "";

//This executes Directions service and shows the map.
function initialize() {
	if(isCurrent=="true"){
		isCurrent = true;
	}
	else if(isCurrent=="false"){
		isCurrent = false;
	}
	geocoder = new google.maps.Geocoder();
	directionsDisplay = new google.maps.DirectionsRenderer();
	directionsDisplay.suppressMarkers = true;
	$('#map_canvas').css({width:'100%'});
	//$('#map_canvas').css({height:screen.height/2.5});
	$('#map_canvas').css({height:'200px'});
	var myOptions = {
		zoom : 15,
		mapTypeId : google.maps.MapTypeId.ROADMAP,
	}
	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
	directionsDisplay.setMap(map);
	clearOverlays();
	codeAddress("hotel", address);
}
//This shows the Map with the hotel address in place.
function initMap() {
	geocoder = new google.maps.Geocoder();
	$('#map_lay').css({width:'90%'});
	//$('#map_lay').css({height:screen.height/2.5});
	$('#map_lay').css({height:'200px'});
	var myOptions = {
		zoom : 15,
		mapTypeId : google.maps.MapTypeId.ROADMAP,
	}
	var mapHotel = new google.maps.Map(document.getElementById("map_lay"), myOptions);
	clearOverlays();
	geocoder.geocode({
		'address' : address
	}, function(results, status) {
		if(status == google.maps.GeocoderStatus.OK) {
			var markerHotel = new google.maps.Marker({
				map : mapHotel,
				position : results[0].geometry.location,
				clickable : true,
			});
			var contentString = '<html><div style="font-size: 1em;">'+replaceAll(address, "+", " ")+'</div></html>';
	        var infowindow = new google.maps.InfoWindow({
		        content: contentString,
		        maxWidth: 200
		    });
		    google.maps.event.addListener(markerHotel, 'click', function() {
				infowindow.open(mapHotel,markerHotel);
			});
			markersArray.push(markerHotel);
			google.maps.event.trigger(mapHotel, 'resize'); 
			mapHotel.setCenter(results[0].geometry.location);
			$("#loading_div").css("display", "none");
		} else {
			window.history.back();
			alert(invalid_address);
		}
	});
}
//This method puts markers in place.
function showMarkers() {
	var markerLocation = new google.maps.Marker({
		map : map,
		position : currentLocation,
		clickable : true,
	});
	markersArray.push(markerLocation);
	var markerHotel = new google.maps.Marker({
		map : map,
		position : hotelAddress,
		clickable : true,
		icon : 'http://google-maps-icons.googlecode.com/files/hotel-h.png'
	});
	markersArray.push(markerHotel);
}
//Removes every marker in Map.
function clearOverlays() {
  if (markersArray) {
    for (i in markersArray) {
      markersArray[i].setMap(null);
    }
  }
}
//Gets the coordinates for an address.
function codeAddress(typeLoc, searchLoc) {
	geocoder.geocode({
		'address' : searchLoc
	}, function(results, status) {
		if(status == google.maps.GeocoderStatus.OK) {
			if(typeLoc=="hotel"){
				hotelAddress = results[0].geometry.location;
				if(isCurrent){
					geoLocate();
				}
				else{
					codeAddress("search", search);
				}
			}
			else if(typeLoc=="search"){
				currentLocation = results[0].geometry.location;
				calcRoute();
			}
		} else {
			alert(invalid_address);
			handleError();
		}
	});
}
//It uses GeoLocation from Browser to determinate coordinates for an address.
function geoLocate() {
	// Try W3C Geolocation (Preferred)
	if(navigator.geolocation) {
		browserSupportFlag = true;
		navigator.geolocation.getCurrentPosition(function(position) {
			currentLocation = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
			calcRoute();
		}, function() {
			handleNoGeolocation(browserSupportFlag);
		});
	} else {
		browserSupportFlag = false;
		handleNoGeolocation(browserSupportFlag);
	}
}

function handleNoGeolocation(errorFlag) {
	if(errorFlag == true) {
		alert(geo_fail);
		handleError();
	} else {
		alert(browser_fail);
		handleError();
	}
}
//Get the best route from any place to the hotel address.
function calcRoute() {
	showMarkers();
	map.setCenter(currentLocation);
	var selectedMode = document.getElementById("travel_mode").value;
	var request = {
		origin : currentLocation,
		destination : hotelAddress,
		travelMode : google.maps.DirectionsTravelMode[selectedMode]
	};
	directionsService.route(request, function(response, status) {
		if(status == google.maps.DirectionsStatus.OK) {
			var route = response.routes[0];
			var distance = route.legs[0].distance.text;
			var duration = route.legs[0].duration.text;
			directionsDisplay.setDirections(response);
			google.maps.event.trigger(map, 'resize');
			$("#distance").text(distance);
			$("#duration").text(duration);
		}
		else{
			alert(no_route);
			handleError();
		}
	});
}

function handleError(){
	var markerHotel = new google.maps.Marker({
		map : map,
		position : hotelAddress,
		clickable : true,
		icon : 'http://google-maps-icons.googlecode.com/files/hotel-h.png'
	});
	markersArray.push(markerHotel);
	google.maps.event.trigger(map, 'resize');
	map.setCenter(hotelAddress);
	window.location.href="howto.php";
}

