var consultas = {
	queryService: function(service, token, params){
		var query_params = {
			uniqueid: token
		};

		/* Le agrego los parametros */
		for(var key in params){
            var attrName = key;
            var attrValue = params[key];
            query_params[attrName] = attrValue;
        }
        $("#dlg_loading").show();
		$(".mblSimpleDialogCover").show();
		call.to(service, query_params, function(response){
			
			$("#dlg_loading").hide();
			$(".mblSimpleDialogCover").hide();
			if(response=='failed conection'){
				$("#dlg_message_text").text("Error de comunicación. Pruebe de nuevo");
				$("#dlg_message").show();
				return;

			}
			
			respuesta = $(response).find(service+"Result").text();
			$("#dlg_loading").hide();
			if (respuesta == ""){
				$("#dlg_message_text").text("No se encontraron Resultados");
				$("#dlg_message").show();
				return;
			}

			if (respuesta.indexOf("No hay arribos")>=0 || respuesta.indexOf("No hay paradas")>=0){
				$("#dlg_message_text").html(respuesta);
				$("#dlg_message").show();
				return;
			}
			if (respuesta.indexOf("ERROR:")>=0){
				if (respuesta.indexOf("ERROR:2")>=0){
					$("#dlg_message_text_2").html(respuesta);
					$("#dlg_message_2").show();
				} else {
					$("#dlg_message_text").html(respuesta);
					$("#dlg_message").show();
				}
				return;
			}
			var entry = {
				query:service,
				params:params
			};

			var title = utils.formatResult(entry);
			

			/* Esto cambio hace que guardar en favoritos guarde la linea y la parada (encontrada)
			* Lo cual cambia el 'tipo' de consulta (el servicio a llamar cuando se clickee en favs)
			*/
			

			//alert(JSON.stringify(response));
			
			
			var matchesError = response.match(/Verifique/g);
			if ((matchesError !== null) && (matchesError.length > 0)){
				$("#results_favourite_button").hide();
			} else {
				$("#results_favourite_button").show();
			}
			
			var matchesError = response.match(/determinar/g);
			
			if ((matchesError !== null) && (matchesError.length > 0)){
				$("#results_favourite_button").hide();
			} else {
				$("#results_favourite_button").show();
			}

			var matches = response.match(/parada \d+/ig);
			if (((service == "GetBusPrediction") || (service == "GetBusStopNumber")) &&
			(matches !== null) && (matches.length > 0)){

				var queries = new Array();
				matches.forEach(function(entry, i){

					var parada_n = entry.substring(7);
					var query = {
						"line": params.line,
						"stop": parada_n
					};
					queries.push(query);
				});
				favourites.setCurrentMultiple("GetBusPredictionWithBusStop", queries);
				utils.setFavouriteStatus(true);
			} else {
				utils.setFavouriteStatus(!favourites.isFavourite(params.line,params.stop));
				
				var queries = new Array();
				queries.push(params);
				favourites.setCurrent(service, params);
			}
			utils.displayResults(title, response);
			if ((service == "GetBusPrediction") || (service == "GetBusStopNumber")){
				utils.makeResultListClickable(queries);
			}
			
		});
	},
	ask_phone : function(phone){

        $("#dlg_loading").show();
		$(".mblSimpleDialogCover").show();
		var phoneToSend = utils.validarCel(phone);
		call.to("SendCode", {msin: phoneToSend}, function(response){
			$("#dlg_loading").hide();
			$(".mblSimpleDialogCover").hide();
			resultado = $(response).find("SendCodeResult").text();	
			if(resultado.indexOf("7")>=0){

				// seteo actual page
				actual_page = $("#askPhone");

				$("#askPhone").show();
				$('#askCode').hide();
				$("#dlg_message_text").html("L&iacute;mite de intentos para verificar el c&oacute;digo excedido.");
				$("#dlg_message").show();	
				return;
			}
			if(response=="failed conection"){
				$("#dlg_message_text").html("Error de comunicaci&oacute;n. Pruebe de nuevo");
				$("#dlg_message").show();			
				return;
			}
			$("#ask_code_phone").text(phone);
			$("#askPhone").hide();
			$('#askCode').show();

			// seteo actual page
			actual_page = $("#askCode");			
		});
	},
	re_ask_phone : function(phone){
		var phoneToSend = utils.validarCel(phone);

		$("#dlg_loading").show();
		$(".mblSimpleDialogCover").show();
		call.to("SendCode", {msin: phoneToSend}, function(response){
			$("#dlg_loading").hide();
			$(".mblSimpleDialogCover").hide();
			if(response=="failed conection"){
				$("#dlg_message_text").html("Error de comunicaci&oacute;n. Pruebe de nuevo");
				$("#dlg_message").show();			
				return;
			}
			resultado = $(response).find("SendCodeResult").text();	
			if(resultado.indexOf("7")>=0){

				// seteo actual page
				actual_page = $("#askPhone");

				$("#askPhone").show();
				$('#askCode').hide();
				$("#dlg_message_text").html("L&iacute;mite de intentos para verificar el c&oacute;digo excedido.");
				$("#dlg_message").show();	
				return;
			}

			$("#dlg_loading").hide();
			$(".mblSimpleDialogCover").hide();
			$("#dlg_message_text").html("Se ha enviado de nuevo el c&oacute;digo");
			$("#dlg_message").show();		
		});
	},
	ask_code : function(phone,code){
		var phoneToSend = utils.validarCel(phone);
		call.to("VerifyCode", {msin: phoneToSend, code:code}, function(response){	
			$("#dlg_loading").hide();
			$(".mblSimpleDialogCover").hide();
			resultado = $(response).find("VerifyCodeResult").text();	
			if(resultado=="7"){

				// seteo actual page
				actual_page = $("#askPhone");

				$("#askPhone").show();
				$('#askCode').hide();
				$("#dlg_message_text").html("L&iacute;mite de intentos para verificar el c&oacute;digo excedido.");
				$("#dlg_message").show();	
				return;
			}
			if(response=="failed conection"){
				$("#dlg_message_text").html("Error de comunicaci&oacute;n. Pruebe de nuevo");
				$("#dlg_message").show();			
				return;
			}
			// Guardo el GUID
			utils.saveGUID(resultado);
			$("#askCode").hide();
			$('#main').show();

			// seteo actual page
			actual_page = $("#main");			
		});
	}
};