//var favourites = [];
var favouritos = [];

var favourites_storage_key = 'favourites';
var favourites_data = window.localStorage.getItem(favourites_storage_key);

if (favourites_data !== null){
favouritos = JSON.parse(favourites_data);
}

var current_query = null;

var current_multiple_query = null;

var current_favourite = null;

var favourites = {
	current_favourite : null ,
	button_pressed : function(){
		if (current_favourite !== null){
				current_query = favourites[current_favourite];
				
				/* Borrando de favoritos */
				favouritos.splice(current_favourite, 1);
				this.store();
				
				this.reload();
		
				current_favourite = null;
				current_multiple_query = null;
				utils.setFavouriteStatus(true);
			} else {
				/* Agrega la consulta actual a Favoritos */
				var itsok = false;
				
				if (current_multiple_query !== null){
					current_multiple_query.entries.forEach(function(entry, i){
						
						var fav = {
							"query": current_multiple_query.query,
							"params": entry
						};
						
						favouritos.unshift(fav);
					});
					
					itsok = true;
					current_multiple_query = null;
				} else if (current_query !== null){		
					favouritos.unshift(current_query);
					
					current_query = null;
					itsok = true;
				}
				
				if (itsok){
					this.store();
					this.reload();
				
					utils.setFavouriteStatus(false);
				}
			}
			this.reload();
			// Redirigir al Home
			$("#result").hide();
			$('#main').show();
			// Activar solapa Favoritos
			$("#favoritoh3").click();

	},
	store : function(){
		/* Guarda los favoritos en el storage */
		favourites_data = JSON.stringify(favouritos);
		window.localStorage.setItem(favourites_storage_key, favourites_data);
	},
	setCurrent : function(query, params){
		/* Cambia la consulta actual */
		var new_query = {
			"query":query,
			"params": {}
		};

		for(var key in params){
			var attrName = key;
			var attrValue = params[key];
			
			new_query.params[attrName] = attrValue;
		}
		
		current_query = new_query;
	},
	setCurrentMultiple : function(query, queries){
		current_multiple_query = {
			"query": query,
			"entries": queries
		};
	},
	isFavourite : function(line,stop){
		var favs=favouritos.map(function(elem){return elem.params});
		return favs.some(function(e){return e.line==line && e.stop==stop})
	},
	reload : function(){
		/* (Re)Carga los favoritos */
		var list = $("#favourites_list");
		var scroll = $("#favourites_scroll");
		
		list.html("");
		//scroll.scrollTo({x:0, y:0});
		
		if (favouritos.length == 0){
			$("#listadofavos").hide();
			$("#favourites_empty").show();
			return;
		}
		
		$("#listadofavos").show();
		$("#favourites_empty").hide();
		favouritos.forEach(function(entry, i){
			var title = utils.formatResult(entry);
			var $li = $("<li/>");
			$li.html(title);
			parametro=JSON.stringify(entry.params);
			$li.attr('data-query',entry.query);
			$li.attr('data-line',entry.params.line);
			$li.attr('data-stop',entry.params.stop);
			$("#favourites_list").append($li)
		});

	}
};