/*
 * Aplicacion principal
 */
define([
	"handsoft/soap",
	"handsoft/utils",
	"handsoft/message_dialog",
	"handsoft/favourites",
	"dijit/registry",
	"dojo/_base/lang"
	], function(soap, utils, message_dialog, favourites, registry, lang){
	
		return {
			verifyToken: function(callback) {
				/* Devuelve el token como parametro al callback,
				 * ya sea porque lo tenemos guardado o porque nos
				 * registramos via 3G, sino empieza el proceso
				 * de registro del movil via sms/codigo e ignora
				 * el callback */
				var got_token = utils.getGUID();
				if (got_token){
					/* Si pase un callback, llamar ese methodo
					 * con el nuevo token como parametro.
					 */
					if (callback !== null){
						callback(got_token);
					}
					
					return;
				}		

				soap.call("Register3G", null, function(response){					
					// Conexion 3G detectada, guardar el token
					utils.saveGUID(response);
					
					/* Si pase un callback, llamar ese methodo
					 * con el nuevo token como parametro.
					 */
					if (callback !== null){
						callback(response);
					}
					
				}, function(error_code, optional_message){
					if (error_code == "8"){
						var v = registry.byId("homepage");
						v.performTransition('ask_phone', 1, "fade", null);
						
						return;
					}
					
					// Mostar error en un dialogo
					message_dialog.show(utils.formatError(error_code));			
				});
			},
			queryService: function(service, token, params){
				var query_params = {
					uniqueid: token
				};
				
				/* Le agrego los parametros */
				lang.mixin(query_params, params);
				
				soap.call(service, query_params, function(response){
					if (response == ""){
						message_dialog.show("No se encontraron Resultados");

						return;
					}
					
					var entry = {
						query:service,
						params:params
					};
					var title = utils.formatResult(entry);
					
					/* Esto cambio hace que guardar en favoritos guarde la linea y la parada (encontrada)
					 * Lo cual cambia el 'tipo' de consulta (el servicio a llamar cuando se clickee en favs)
					 */
					var matches = response.match(/parada \d+/ig);
					if (((service == "GetBusPrediction") || (service == "GetBusStopNumber")) &&
						(matches !== null) && (matches.length > 0)){
						
						var queries = new Array();
						
						matches.forEach(function(entry, i){
							var parada_n = entry.substring(7);
							var query = {
								"line": params.line,
								"stop": parada_n
							};

							queries.push(query);
						});

						favourites.setCurrentMultiple("GetBusPredictionWithBusStop", queries);
					} else {
						favourites.setCurrent(service, params);
					}

					utils.displayResults(title, response);
					if ((service == "GetBusPrediction") || (service == "GetBusStopNumber")){
						utils.makeResultListClickable(params.line);
					}
					
					
				}, function(error_code, optional_message){
					if (error_code == "2"){
						// Invalid token, significa que 'expiro', borrar el guardado
						utils.clearGUID();
						
						if (optional_message === null){
							message_dialog.show("Tu acceso al servicio de iBus ha caducado. Intenta nuevamente.");
						} else {
							message_dialog.show(optional_message);
						}
						
						return;
					}
					message_dialog.show(utils.formatError(error_code));
				});
			}
		}
});
