var guid_storage_key = 'guid';
	
var connected = true;
var utils = {
	verifyToken: function(callback) {
		$("#dlg_loading").show();
		$(".mblSimpleDialogCover").show();
		var got_token = utils.getGUID();
		if (got_token!==null){
			/* Si pase un callback, llamar ese methodo
			 * con el nuevo token como parametro.
			 */
			 $(".mblSimpleDialogCover").hide();
			 $("#dlg_loading").hide();
			if (callback !== null){
				callback(got_token);
			}
			return;
		}
		
		call.to("Register3G", null, function(response){					
			
			// Conexion 3G detectada, guardar el token
			
			/* Si pase un callback, llamar ese methodo
			 * con el nuevo token como parametro.
			 */
			resultado = $(response).find('Register3GResult').text();
			$("#dlg_loading").hide();
			if(resultado=="ERROR:8"){
				$("#main").hide();
				/*$("#dlg_message_text").text("Registro via 3G no disponible");
				$("#dlg_message").show();*/
				$(".mblSimpleDialogCover").hide();
				$("#askPhone").show();

				// seteo actual page
				actual_page = $("#askPhone");
				return false;
			}
			utils.saveGUID(resultado);
			
			if (callback !== null){
				callback(resultado);
			}
			
		});
	},

	getGUID: function(){
		/* Retorna el GUID para usar en la consultas */
		var guid = window.localStorage.getItem(guid_storage_key);
		return (guid === false ? false : guid);
	},
	saveGUID: function(guid){
		/* Guarda el GUIDpara usar en la consultas */
		window.localStorage.setItem(guid_storage_key, guid);
		var guid = window.localStorage.getItem(guid_storage_key);
	},
	displayResults: function(title, data){			
		//var scroll = registry.byId("results_scroll");
		var text = utils.nl2br(data, false);
		
		var n=text.split("<br>");
		
		var display_text = "";
		
		$("#results_list").html("");
		
		for(i=1; i<=n.length; i++)
		{
			var response = n[i-1];
			
			if ((response != '') && (response != '\n') && (response != '\n') && (response != "\r\n")){
				var $node = $("<div/>");
				$node.addClass("result-list-item");
				$node.html("<strong>Opci&oacute;n #"+i+": </strong>" + response);
				$("#results_list").append($node);
			}
		}
		
		/*scroll._at.labelNode.innerHTML = title;*/
		
		//text
		
		$("#main").hide();
		$("#result").show();
		$("#results-conten").show();
		$("#resultsh3").click();
		$("#results_back_button").show();
		$("#footerAyudaBtn").hide();
		$("#div2").scrollTop();
		//v.performTransition('results', 1, "fade", null);
	},
	formatResult: function(entry){
		/* Devuelve una cadena para mostar el usuario */
		if (entry.query == "GetBusPredictionWithBusStop"){
			return "L&iacute;nea: #" + entry.params.line + " - Parada: " + entry.params.stop;
		} else if (entry.query == "GetBusPrediction"){
			return "L&iacute;nea #" + entry.params.line;
		} else if (entry.query == "GetBusStopNumber"){
			var street = this.capitalise(entry.params.street);
			return street + " - L&iacute;nea #" + entry.params.line; 
		}
		return null;
	},
	makeResultListClickable: function(queries){
		var items = $("#results_list div.result-list-item");
			
		$(items).each(function(index, element){
			$(this).attr("data-parada",queries[index].stop);
			$(this).attr("data-linea",queries[index].line);
		});
		
		
	},
	nl2br: function (str, is_xhtml) {
		var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br ' + '/>' : '<br>';
		
		return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
	},
	capitalise: function (texto)
	{
	    return texto.charAt(0).toUpperCase() + texto.slice(1);
	},
	validarCel: function(numero){
		/* Valida un numero Movistar y retorna
		 * un numero usable por los servicios: 59893XXXXXX
		 */
		var phone = numero.toString();
		
		/* Quito espacios */
		phone = phone.split(' ').join('');
		
		if (/^(093|094|095)\d{6}$/.test(phone)){
			//095097766
			phone = "598" + phone.substring(1, 9);
			return phone;
		} else if (/^(93|94|95)\d{6}$/.test(phone)){
			//95097766
			phone = "598" + phone;
			return phone;
		} else if (/^(598093|598094|598095)\d{6}$/.test(phone)){
			//598 095097766
			phone = "598" + phone.substring(4, 12);
			return phone;
		} else if (/^(59893|59894|59895)\d{6}$/.test(phone)){
			//598 95097766
			phone = "598" + phone.substring(3, 11);
			return phone;
		} else if (/^(\+598093|\+598094|\+598095)\d{6}$/.test(phone)){
			//+598 095097766
			phone = "598" + phone.substring(5, 13);
			return phone;
		} else if (/^(\+59893|\+59894|\+59895)\d{6}$/.test(phone)){
			//+598 95097766
			phone = "598" + phone.substring(4, 12);
			return phone;
		}
		
		return false;
	},
	setFavouriteStatus: function(added){
		$("#results_favourite_button").text((added ? "GUARDAR FAVORITO" : "ELIMINAR FAVORITO"));
	},
	validarInteger: function(numero){
		/* Valida que sea un numero */
		var numberFormat = /^\d+$/;
		
		if (numberFormat.test(numero)){
			return true;
		}
		
		return false;
	},
	isEmpty: function(string){
		return (string == "");
	},
	validarCodigo: function(code){
		/* Valida el codigo ingresado (el enviado via SMS) */
		
		//return this.validarInteger(code);
		
		return !this.isEmpty(code);
	}
};