/*
 * Pantalla pedir Telefono
 */
define([
	"dojo/on",
	"dojo/dom",
	"dojo/dom-attr",
	"dijit/registry",
	"handsoft/utils",
	"handsoft/soap",
	"handsoft/message_dialog",
	"handsoft/ask_code",
	"dojo/ready"], function(on, dom, domAttr, registry, utils, soap, message_dialog, ask_code, ready){

	ready(function(){
		var ask_phone_submit = dom.byId("ask_phone_submit");
		var ask_phone_input = dom.byId("ask_phone_input");
		
		/*
		 * Al solicitar un nuevo codigo
		 */
		on(ask_phone_submit, "click", function(evt){
			var input_phone = registry.byId("ask_phone_input").get("value");
			
			// Validar numero
			var phone = utils.validarCel(input_phone);
			if (phone === false){
				message_dialog.show(" El n&uacute;mero ingresado no es v&aacute;lido.<br />Servicio disponible s&oacute;lo para Movistar.");
				
				return;
			}
			/* Al usuario le mostramos su numero 'normal' */
			dom.byId("ask_code_phone").innerHTML = "0" + phone.substring(3);
			
			/* Pero guardar el formateado para los servicio */
			// FIXME: Guardarlo en otro lado q no sea el title
			// (ver: ask_code.js donde se lee desde el title tambien)
			domAttr.set("ask_code_phone", "title", phone);
			
			utils.setAskPhoneStatus(false, false);
			
			soap.call("SendCode", {msin: phone}, function(response){
				var view = registry.byId("ask_phone");
				view.performTransition('ask_code', 1, "fade", null);

			}, function(error_code, optional_message){
				message_dialog.show(utils.formatError(error_code));	
				
				utils.setAskPhoneStatus(true, false);
			});
		});
	});
});
