/*
 * Aplicacion principal
 */

var expand_parada = false;

define([
	"dojo/on",
	"dojo/dom",
	"dojo/window",
	"dojo/dom-style",
	"dojo/_base/event",
	"handsoft/soap",
	"handsoft/favourites",
	"handsoft/utils",
	"handsoft/message_dialog",
	"handsoft/ask_phone",
	"handsoft/ask_code",
	"handsoft/cutsa",
	"dijit/registry",
	"dojo/aspect",
	"dojo/ready"
	], function(on, dom, win, domStyle, dojoEvent, soap, favourites, utils, message_dialog, ask_phone, ask_code, cutsa, registry, aspect, ready){
	
	ready(function(){
		// Informacion del servicio
		soap.setOptions({
			url: "http://mobileapps.movistar.com.uy/ibus/SmartBus.svc", // Location
			ns: "http://tempuri.org",                   //Namespace
			port: "ISmartBus"                               //'Puerto 
		});

		var phoneView = registry.byId("ask_phone");
		var codeView = registry.byId("ask_code");
		var resultsView = registry.byId("results");
		var homepageView = registry.byId("homepage");
		var ayudaView = registry.byId("ayuda");

		aspect.after(homepageView, "onBeforeTransitionIn", function(){		
			if (expand_parada){
				registry.byId("home_accordion").expand(registry.byId("consulta_1_scroll"), false);
				expand_parada = false;
			}
			setTimeout(function(){
				var scrollable = registry.byId("favourites_scroll");
				scrollable.mostarScroll();
				
				var vs = win.getBox();
				var m = 179 + 145 + 91;
				var h = vs.h - m;
				if (h > 100){
					domStyle.set("favourites_scroll", "height", h.toString() + "px");
				} else {
					domStyle.set("favourites_scroll", "height", "100px");
				}
			}, 100);
		});
		
		aspect.after(phoneView, "onBeforeTransitionIn", function(){
			utils.setAskPhoneStatus(true, true);
		});
		aspect.after(codeView, "onBeforeTransitionIn", function(){
			utils.setAskCodeStatus(true, true);
		});
		aspect.after(resultsView, "onBeforeTransitionIn", function(){
			var scrollable = registry.byId("results_scroll");
			scrollable.mostarScroll();
			
			var vs = win.getBox();
			var m = 80 + 158 + 30 + 85;
			var h = vs.h - m;
			
			if (h > 100){
				domStyle.set("results_scroll", "height", h.toString() + "px");
			} else {
				domStyle.set("results_scroll", "height", "100px");
			}
		});
		aspect.after(ayudaView, "onBeforeTransitionIn", function(){
			var scrollable = registry.byId("ayuda_scroll");
			scrollable.mostarScroll();
			
			var vs = win.getBox();
			var m = 80 + 158 + 45;
			var h = vs.h - m;
			
			if (h > 100){
				domStyle.set("ayuda_scroll", "height", h.toString() + "px");
			} else {
				domStyle.set("ayuda_scroll", "height", "100px");
			}
		});
		
		var favourites_btn = dojo.query("#dijit__Contained_3 .mblAccordionTitleAnchor");
		on(favourites_btn, "click", function(evt){
			setTimeout(function(){
				var scrollable = registry.byId("favourites_scroll");
				scrollable.mostarScroll();
				
				var vs = win.getBox();
				var m = 179 + 145 + 91;
				var h = vs.h - m;
				
				if (h > 100){
					domStyle.set("favourites_scroll", "height", h.toString() + "px");
				} else {
					domStyle.set("favourites_scroll", "height", "100px");
				}
			}, 100);
		});

		/* Prevengo que el Titulo de la pantalla resultados se pueda contraer */
		var titulo_results = dojo.query("#results .mblAccordionTitleAnchor");
		on(titulo_results, "click", function(evt){
			dojoEvent.stop(evt);
		});
		
		var ayuda_results = dojo.query("#ayuda .mblAccordionTitleAnchor");
		on(ayuda_results, "click", function(evt){
			dojoEvent.stop(evt);
		});
		
		/*
		 * Buscar por parada
		 */
		var consulta_1_button = dom.byId("consulta_1_button");
		on(consulta_1_button, "click", function(evt){
			var linea = registry.byId("consulta_1_linea").get("value");
			var parada = registry.byId("consulta_1_parada").get("value");
			
			if (utils.isEmpty(linea)){
				message_dialog.show("Escriba el n&uacute;mero de l&iacute;nea");
				
				return;
			} else if (utils.isEmpty(parada)){
				message_dialog.show("Escriba el n&uacute;mero de parada");
				
				return;
			} else if (!utils.validarInteger(parada)){
				message_dialog.show("No parece un n&uacute;mero de parada v&aacute;lido");
				
				return;
			} 
			
			// Llamo al servicio
			cutsa.verifyToken(function(token){
				cutsa.queryService("GetBusPredictionWithBusStop", '', {
					line:linea, 
					stop:parada
				});
				utils.setFavouriteStatus(true);
			});
		});
		
		/*
		 * Buscar por linea
		 */
		var consulta_2_button = dom.byId("consulta_2_button");
		on(consulta_2_button, "click", function(evt){
			//var networkState = navigator.network.connection.type;
			/*if(networkState=="wifi"){
				message_dialog.show('La aplicación requiere tener Wifi apagado para operar correctamente. Por favor conecta tu dispositivo a la red 3G.');
				return;
			}*/
			var linea = registry.byId("consulta_2_linea").get("value");
			
			if (utils.isEmpty(linea)){
				message_dialog.show("Escriba el n&uacute;mero de l&iacute;nea");
				
				return;
			}
			
			// Llamo al servicio
			cutsa.verifyToken(function(token){
				cutsa.queryService("GetBusPrediction", '', {
					line:linea
				});
				utils.setFavouriteStatus(true);
			});
		});
		
		/*
		 * Buscar numero de parada
		 */
		var consulta_3_button = dom.byId("consulta_3_button");
		on(consulta_3_button, "click", function(evt){
			var linea = registry.byId("consulta_3_linea").get("value");
			var calle = registry.byId("consulta_3_calle").get("value");
			
			if (utils.isEmpty(linea)){
				message_dialog.show("Escriba el n&uacute;mero de l&iacute;nea");
				
				return;
			} else if (utils.isEmpty(calle)){
				message_dialog.show("Escriba la calle m&aacute;s cercana");
				
				return;
			}
			
			// Llamo al servicio
			cutsa.verifyToken(function(token){
				cutsa.queryService("GetBusStopNumber", '', {
					line:linea,
					street:calle
				});
				utils.setFavouriteStatus(true);
			});
		});
		
		var ayuda_button = dom.byId("footerAyudaBtn");
		on(ayuda_button, "touchstart", function(evt){
			var v = registry.byId("homepage");
			v.performTransition('ayuda', 1, "slide", null);
		});
		
		var volver_button = dom.byId("footerAyudaBack");
		on(volver_button, "touchstart", function(evt){
			var v = registry.byId("ayuda");
			v.performTransition('homepage', -1, "slide", null);
		});
		
		/*
		 * Listar favoritos!
		 */
		favourites.reload();
	});
});

