// NOT FOR FIREFOX ...
/*document.addEventListener("intel.xdk.device.ready",function(){
    //lock the application in portrait orientation
    //intel.xdk.device.setRotateOrientation("portrait");
    //intel.xdk.device.setAutoRotate(false);
    //hide splash screen
    intel.xdk.device.hideSplashScreen();
},false);*/
// ...

// FOR FIREFOX OS ...
//Hide custom splash screen page
setTimeout(function() {
    var activePage = $.mobile.activePage.attr("id");
    if(activePage === "loader") 
        $.mobile.changePage("#home");
}, 3000);
// ...

// ===================================================

function openDialogDetails(link) {
    $("#wikipedia").attr('src', link);
    $("#dialogTrigger").click();
}

// Input Validator/Handler
function handleInput(id) {
    var value = $(id).val();
    if (value.indexOf(',') !== -1) {
        value = value.replace(',', '.');
        $(id).val(value);
    }
    if (!($.isNumeric(value)) && value !== '') {
        $.mobile.changePage("#numbersOnly");
        $(id).val('');
        return false;
    } else
        return true;
}

function resetInputs() {
    $('input').val('');
    $('input').parent().removeClass('lockedInput');
}
function lockInputs() {
    setTimeout(function() {
        $('input').parent().addClass('lockedInput');
        $('input').blur();
    }, 250);
}

// Get number length
function getlength(number) {
  return number.toString().length;
}
// Retrieve decimal number
function retr_dec(number) {
    return ((+number).toFixed(20)).replace(/^-?\d*\.?|0+$/g, '').length
    /*var num = number.toString();
    var numberPart = num.split('.');
    var numberPart2 = numberPart[1];
    return numberPart2.toString().length;*/
}
// Handle numbers with decimals
function decHandler(number) {
    if(retr_dec(number)>1) 
        return parseFloat(number.toFixed(2));
    else
        return number;
}
// Handle conversion-generated numbers (using or not exponential notation based on its length)
function getExp(number) {
    //number = parseFloat(number.toFixed(16));
    //console.log(retr_dec(number));
    if(getlength(number) > 12) {
        console.log('getExp->exponential(4)');
        return parseFloat(number).toExponential(4);
    } else {
        /*if(retr_dec(number)>1) { 
            console.log('getExp->toFixed(6)');
            return parseFloat(number.toFixed(8));
        } else {*/
            console.log('getExp->normal float');
            return parseFloat(number);
        //}
    }
}


$(function() {
    
    //This is the setting you are looking for!
    $.mobile.defaultPageTransition = 'none';
    $.mobile.defaultDialogTransition = 'none';
    //I personally use some other settings, such as:
    //$.mobile.page.prototype.options.addBackBtn = true;
    $.mobile.useFastClick  = false; 
    
    /*var activePage = $.mobile.activePage.attr("id");
    if(activePage === "loader") $.mobile.changePage("#home");*/
    
    //START OF SI units link handling (show wikipedia in dialog)
    $("#dialogDetails").bind("pageshow", function() {
        //$('a.ui-btn-left').attr('href', '#home');
        $('#dialog-content').css('height', '');
        var wh = $(window).height() - 80;
        //var ww = $(window).width() - 80;
        $('#dialog-content').css('height', wh + 'px');
        //$('#dialog-content').css('width', ww + 'px');
        $('#wikipedia').attr('height', (wh - 60) + 'px');
    });
    $("#dialogDetails").bind("pagehide", function() {
        $("#wikipedia").attr('src', '');
    });
    // END OF SI units link handling  


    //Configure scroller
    $('#entry').mobiscroll().treelist({
        theme: 'ios',
        display: 'inline',
        mode: 'scroller',
        labels: ['Category', 'Subcategory'],
        inputClass: 'i-txt',
        onChange: function(inst) {
            $("div#home").i18n();
            //$('audio').get(0).play();
            if (inst.indexOf('metatropes') != -1)
                resetConverter();
        }
    });
    $('#entry_dummy').css('display', 'none');
    // ==================


    //Removing empty lines... (buggy)
    $("#metrics,#pososta-auksiseis").each(function() {
        var $this = $(this);
        $this.html($this.html().replace(/&nbsp;/g, ''));
    });
    // ==================
    $('a[href="#home"]').on( "vclick", function( ) {
        $('#entry').mobiscroll('setValue', 'pososta-auksiseis');
        resetInputs();
    });


    //Navigate based on scroll-options
    $('#goButton').on( "vclick", function( ) {
        var selectedMenuItem = $('#entry_dummy').val();
        if (selectedMenuItem === '') {
            $.mobile.navigate('#pososta-auksiseis');
        } else {
            selectedMenuItem = '#' + selectedMenuItem.replace(' ', '-');
            $.mobile.navigate(selectedMenuItem);
        }
    });
    // ==================


    //Hide virtual keypad (general behavior based on enter/go press or focusout)
    /*$('input').on('keyup', function(event) {
     if (event.keyCode === 13) {
     this.blur();
     }
     });*/
    // ==================


    // Global Reset/Lock Fuction
    $('input').on( "vclick", function( ) {
        var status = $(this).parent().attr('class');
        if (status.indexOf('lockedInput') !== -1)
            resetInputs();
    });
    $('.resetButton').on( "vclick", function( ) {
        resetInputs();
    });
    // ==================


    //START OF emvadon-kiklos
    $('#p1-kiklos,#e-kiklos').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1) 
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-kiklos').val();
            var e = $('#e-kiklos').val();
            if (e === '' && p1 !== '') {
                e = Math.PI * (p1 * p1);
                $('#e-kiklos').val(decHandler(e));
                lockInputs();
            }
            else if (e !== '' && p1 === '') {
                p1 = e / Math.PI;
                p1 = Math.sqrt(p1);
                $('#p1-kiklos').val(decHandler(p1));
                lockInputs();
            }
        }
    });
    // END OF emvadon-kiklos


    // START OF emvadon-parallilogrammo 
    $('#p1-parallilogrammo,#p2-parallilogrammo,#e-parallilogrammo').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1) $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-parallilogrammo').val();
            var p2 = $('#p2-parallilogrammo').val();
            var e = $('#e-parallilogrammo').val();
            if (e === '' && p1 !== '' && p2 !== '') {
                e = p1 * p2;
                $('#e-parallilogrammo').val(decHandler(e));
                lockInputs();
            }
            else if (e !== '' && p1 !== '' && p2 === '') {
                p2 = e / p1;
                $('#p2-parallilogrammo').val(decHandler(p2));
                lockInputs();
            }
            else if (e !== '' && p1 === '' && p2 !== '') {
                p1 = e / p2;
                $('#p1-parallilogrammo').val(decHandler(p1));
                lockInputs();
            }
        }
    });
    // END OF emvadon-parallilogrammo


    //START OF emvadon-tetragonou 
    $('#a-tetragono,#e-tetragono').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var a = $('#a-tetragono').val();
            var e = $('#e-tetragono').val();
            if (e === '' && a !== '') {
                e = a * a;
                $('#e-tetragono').val(decHandler(e));
                lockEmvadonTetragonou();
            }
            else if (e !== '' && a === '') {
                a = Math.sqrt(e);
                $('#a-tetragono').val(decHandler(a));
                lockEmvadonTetragonou();
            }
        }
    });
    // END OF emvadon-tetragonou

    // START OF emvadon-trigonou 
    $('#b-trigono,#y-trigono,#e-trigono').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var b = $('#b-trigono').val();
            var y = $('#y-trigono').val();
            var e = $('#e-trigono').val();
            if (e === '' && b !== '' && y !== '') {
                e = (b * y) / 2;
                $('#e-trigono').val(decHandler(e));
                lockInputs();
            }
            else if (e !== '' && b !== '' && y === '') {
                y = (2 * e) / b;
                $('#y-trigono').val(decHandler(y));
                lockInputs();
            }
            else if (e !== '' && b === '' && y !== '') {
                b = (2 * e) / y;
                $('#b-trigono').val(decHandler(b));
                lockInputs();
            }
        }
    });
    // END OF emvadon-trigonou

    // START OF emvadon-trapeziou
    $('#b1-trapezio,#b2-trapezio,#y-trapezio,#e-trapezio').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var b1 = $('#b1-trapezio').val();
            var b2 = $('#b2-trapezio').val();
            var y = $('#y-trapezio').val();
            var e = $('#e-trapezio').val();
            if (e === '' && b1 !== '' && b2 !== '' && y !== '') {
                e = (+b1 + +b2) * y / 2;
                $('#e-trapezio').val(decHandler(e));
                lockInputs();
            }
            else if (e !== '' && b1 !== '' && b2 !== '' && y === '') {
                y = (2 * e) / (+b1 + +b2);
                $('#y-trapezio').val(decHandler(y));
                lockInputs();
            }
            else if (e !== '' && b1 === '' && b2 !== '' && y !== '') {
                b1 = ((2 * e) / y) - +b2;
                $('#b1-trapezio').val(decHandler(b1));
                lockInputs();
            }
            else if (e !== '' && b2 === '' && b1 !== '' && y !== '') {
                b2 = ((2 * e) / y) - +b1;
                $('#b2-trapezio').val(decHandler(b2));
                lockInputs();
            }
        }
    });
    // END OF emvadon-trapeziou


    // START OF ogkos-kyvou 
    $('#a-kyvos,#e-kyvos').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var a = $('#a-kyvos').val();
            var e = $('#e-kyvos').val();
            if (e === '' && a !== '') {
                e = a * a * a;
                $('#e-kyvos').val(decHandler(e));
                lockInputs();
            }
            else if (e !== '' && a === '') {
                a = Math.pow(e, 1 / 3);
                $('#a-kyvos').val(decHandler(a));
                lockInputs();
            }
        }
    });
    // END OF ogkos-kyvou


    // START OF ogkos-parallilepipedou 
    $('#a-paralli,#b-paralli,#c-paralli,#e-paralli').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var a = $('#a-paralli').val();
            var b = $('#b-paralli').val();
            var c = $('#c-paralli').val();
            var e = $('#e-paralli').val();
            if (e === '' && a !== '' && b !== '' && c !== '') {
                e = a * b * c;
                $('#e-paralli').val(decHandler(e));
                lockInputs();
            }
            else if (a === '' && e !== '' && b !== '' && c !== '') {
                a = (e / b) / c;
                $('#a-paralli').val(decHandler(a));
                lockInputs();
            }
            else if (b === '' && a !== '' && e !== '' && c !== '') {
                b = (e / a) / c;
                $('#b-paralli').val(decHandler(b));
                lockInputs();
            }
            else if (c === '' && a !== '' && b !== '' && e !== '') {
                c = (e / b) / a;
                $('#c-paralli').val(decHandler(c));
                lockInputs();
            }
        }
    });
    // END OF ogkos-parallilepipedou


    // START OF ogkos-sfairas
    $('#a-sfaira,#e-sfaira').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var a = $('#a-sfaira').val();
            var e = $('#e-sfaira').val();
            if (e === '' && a !== '') {
                e = Math.PI * (a * a * a) * (4 / 3);
                console.log(e);
                $('#e-sfaira').val(decHandler(e));
                lockInputs();
            } else if (e !== '' && a === '') {
                a = ((3 / 4) * e) / Math.PI;
                a = Math.pow(a, 1 / 3);
                console.log(a);
                $('#a-sfaira').val(decHandler(a));
                lockInputs();
            }
        }
    });
    // END OF ogkos-sfairas


    // START OF ogkos-kylindrou
    $('#p-kylindros,#y-kylindros,#e-kylindros').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p = $('#p-kylindros').val();
            var y = $('#y-kylindros').val();
            var e = $('#e-kylindros').val();
            if (e === '' && p !== '' && y !== '') {
                e = Math.PI * (p * p * y);
                $('#e-kylindros').val(decHandler(e));
                lockInputs();
            }
            else if (p === '' && e !== '' && y !== '') {
                p = e / (Math.PI * y);
                p = Math.sqrt(p);
                $('#p-kylindros').val(decHandler(p));
                lockInputs();
            }
            else if (y === '' && p !== '' && e !== '') {
                y = e / (Math.PI * p * p);
                $('#y-kylindros').val(decHandler(y));
                lockInputs();
            }
        }
    });
    // END OF ogkos-kylindrou


    // START OF ogkos-kvnou
    $('#p-kvnos,#y-kvnos,#e-kvnos').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p = $('#p-kvnos').val();
            var y = $('#y-kvnos').val();
            var e = $('#e-kvnos').val();
            if (e === '' && p !== '' && y !== '') {
                e = (1 / 3) * Math.PI * (p * p * y);
                $('#e-kvnos').val(decHandler(e));
                lockInputs();
            }
            else if (p === '' && e !== '' && y !== '') {
                p = (3 * e) / (Math.PI * y);
                p = Math.sqrt(p);
                $('#p-kvnos').val(decHandler(p));
                lockInputs();
            }
            else if (y === '' && p !== '' && e !== '') {
                y = (3 * e) / (Math.PI * p * p);
                $('#y-kvnos').val(decHandler(y));
                lockInputs();
            }
        }
    });
    // END OF ogkos-kvnou


    // START OF ogkos-pyramidas 
    $('#a-pyramida,#y-pyramida,#e-pyramida').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var a = $('#a-pyramida').val();
            var y = $('#y-pyramida').val();
            var e = $('#e-pyramida').val();
            if (e === '' && a !== '' && y !== '') {
                e = (1 / 3) * a * a * y;
                $('#e-pyramida').val(decHandler(e));
                lockInputs();
            }
            else if (a === '' && e !== '' && y !== '') {
                a = (3 * e) / y;
                a = Math.sqrt(a);
                $('#a-pyramida').val(decHandler(a));
                lockInputs();
            }
            else if (y === '' && a !== '' && e !== '') {
                y = (3 * e) / (a * a);
                $('#y-pyramida').val(decHandler(y));
                lockInputs();
            }
        }
    });
    // END OF ogkos-pyramidas


    // START OF pososta-auksiseis 
    $('#p1-auksiseis,#p2-auksiseis,#a-auksiseis').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-auksiseis').val();
            var p2 = $('#p2-auksiseis').val();
            var a = $('#a-auksiseis').val();
            if (a === '' && p1 !== '' && p2 !== '') {
                a = +p1 + p1 * (p2 / 100);
                $('#a-auksiseis').val(decHandler(a));
                lockInputs();
            }
            else if (a !== '' && p1 !== '' && p2 === '') {
                p2 = ((a - p1) * 100) / p1;
                $('#p2-auksiseis').val(decHandler(p2));
                lockInputs();
            }
            else if (a !== '' && p1 === '' && p2 !== '') {
                p1 = a / (1 + (p2 / 100));
                $('#p1-auksiseis').val(decHandler(p1));
                lockInputs();
            }
        }
    });
    // END OF pososta-auksiseis


    // START OF pososta-meiwseis
    $('#p1-Μeiwseis,#p2-Μeiwseis,#a-Μeiwseis').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-Μeiwseis').val();
            var p2 = $('#p2-Μeiwseis').val();
            var a = $('#a-Μeiwseis').val();
            if (a === '' && p1 !== '' && p2 !== '') {
                a = +p1 - p1 * (p2 / 100);
                $('#a-Μeiwseis').val(decHandler(a));
                lockInputs();
            }
            else if (a !== '' && p1 !== '' && p2 === '') {
                p2 = ((p1 - a) * 100) / p1;
                $('#p2-Μeiwseis').val(decHandler(p2));
                lockInputs();
            }
            else if (a !== '' && p1 === '' && p2 !== '') {
                p1 = a / (1 - (p2 / 100));
                $('#p1-Μeiwseis').val(decHandler(p1));
                lockInputs();
            }
        }
    });
    // END OF pososta-meiwseis


    // START OF pososta-FPA 
    $('#p1-FPA,#p2-FPA,#a-FPA,#t-FPA').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-FPA').val();
            var p2 = $('#p2-FPA').val();
            var a = $('#a-FPA').val();
            var t = $('#t-FPA').val();
            if (a === '' && p1 !== '' && p2 !== '') {
                a = p1 * (p2 / 100);
                t = +p1 + p1 * (p2 / 100);
                $('#a-FPA').val(decHandler(a));
                $('#t-FPA').val(decHandler(t));
                lockInputs();
            }
            else if (a !== '' && p1 !== '' && p2 === '') {
                p2 = (a * 100) / p1;
                t = +p1 + p1 * (p2 / 100);
                $('#p2-FPA').val(decHandler(p2));
                $('#t-FPA').val(decHandler(t));
                lockInputs();
            }
            else if (a !== '' && p1 === '' && p2 !== '') {
                p1 = (a * 100) / p2;
                t = +p1 + p1 * (p2 / 100);
                $('#p1-FPA').val(decHandler(p1));
                $('#t-FPA').val(decHandler(t));
                lockInputs();
            }
            else if (p2 === '' && p1 !== '' && t !== '') {
                p2 = ((+t - p1) / p1) * 100;
                a = p1 * (p2 / 100);
                $('#p2-FPA').val(decHandler(p2));
                $('#a-FPA').val(decHandler(a));
                lockInputs();
            }
            else if (p2 === '' && a !== '' && t !== '') {
                p1 = +t - a;
                p2 = (a * 100) / p1;
                $('#p1-FPA').val(decHandler(p1));
                $('#p2-FPA').val(decHandler(p2));
                lockInputs();
            }
        }
    });
    // END OF pososta-FPA

    // START OF Markup 
    $('#p1-Markup,#p2-Markup,#a-Markup,#t-Markup').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-Markup').val();
            var p2 = $('#p2-Markup').val();
            var a = $('#a-Markup').val();
            var t = $('#t-Markup').val();
            if (a === '' && t === '' && p1 !== '' && p2 !== '') {
                a = (((+p2 - p1) / p1) * 100 * 100) / 100;
                t = (((+p2 - p1) / p2) * 100 * 100) / 100;
                $('#a-Markup').val(decHandler(a));
                $('#t-Markup').val(decHandler(t));
                lockInputs();
            }
            else if (a !== '' && t === '' && p1 === '' && p2 !== '') {
                p1 = +p2 / (a / 100 + 1);
                t = (((+p2 - p1) / p2) * 100 * 100) / 100;
                $('#p1-Markup').val(decHandler(p1));
                $('#t-Markup').val(decHandler(t));
                lockInputs();
            }
            else if (a !== '' && t === '' && p1 !== '' && p2 === '') {
                p2 = (a / 100 + 1) * p1;
                t = (((+p2 - p1) / p2) * 100 * 100) / 100;
                $('#p2-Markup').val(decHandler(p2));
                $('#t-Markup').val(decHandler(t));
                lockInputs();
            }
            else if (a === '' && t !== '' && p1 === '' && p2 !== '') {
                p1 = (1 - (t / 100)) * p2;
                a = (((+p2 - p1) / p1) * 100 * 100) / 100;
                $('#p1-Markup').val(decHandler(p1));
                $('#a-Markup').val(decHandler(a));
                lockInputs();
            }
            else if (a === '' && t !== '' && p1 !== '' && p2 === '') {
                p2 = +p1 / (1 - (t / 100));
                a = (((+p2 - p1) / p1) * 100 * 100) / 100;
                $('#p2-Markup').val(decHandler(p2));
                $('#a-Markup').val(decHandler(a));
                lockInputs();
            }
        }
    });
    // END OF Markup

    // START OF epitokia 
    $('#p1-Epitokia,#p2-Epitokia,#p3-Epitokia,#a-Epitokia').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-Epitokia').val();
            var p2 = $('#p2-Epitokia').val();
            var p3 = $('#p3-Epitokia').val();
            var a = $('#a-Epitokia').val();
            if (a === '' && p1 !== '' && p2 !== '' && p3 !== '') {
                a = (+p2 / 100) + 1;
                a = Math.pow(a, p3);
                a = p1 * a;
                $('#a-Epitokia').val(decHandler(a));
                lockInputs();
            }
            else if (p1 === '' && a !== '' && p2 !== '' && p3 !== '') {
                p1 = (+p2 / 100) + 1;
                p1 = Math.pow(p1, p3);
                p1 = a / p1;
                $('#p1-Epitokia').val(decHandler(p1));
                lockInputs();
            }
            else if (p2 === '' && p1 !== '' && a !== '' && p3 !== '') {
                p2 = Math.pow(a / p1, 1 / p3);
                p2 = (+p2 - 1) * 100;
                $('#p2-Epitokia').val(decHandler(p2));
                lockInputs();
            }
            else if (p3 === '' && p1 !== '' && p2 !== '' && a !== '') {
                t = (+p2 / 100) + 1;
                p3 = Math.log(a / p1) / Math.log(t);
                $('#p3-Epitokia').val(decHandler(p3));
                lockInputs();
            }
        }
    });
    // END OF epitokia


    // START OF DOSEIS 
    $('#p1-Doseis,#p2-Doseis,#p3-Doseis,#a-Doseis').on('change', function(e) {
        var oldVal = $(this).val();
        if(retr_dec(parseFloat(oldVal))>1)
            $(this).val(parseFloat(oldVal).toFixed(2));
        var id = '#' + $(this).attr('id');
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1 = $('#p1-Doseis').val();
            var p2 = $('#p2-Doseis').val();
            var p3 = $('#p3-Doseis').val();
            var a = $('#a-Doseis').val();
            if (a === '' && p1 !== '' && p2 !== '' && p3 !== '') {
                t = (+p2 / 100) + 1;
                t = Math.pow(t, p3);
                a = (p1 * p2 / 100 * t) / (t - 1);
                a = a / 12;
                $('#a-Doseis').val(decHandler(a));
                lockInputs();
            }
        }
    });
    // END OF DOSEIS	


    // ====================================
    //START OF converter
    function resetConverter() {
        $('#p1Mhkos,#p1Varos,#p1Emvadon,#p1Ogkos,#p1Thermokrasia').val('');
        $('#p2Mhkos,#p2Varos,#p2Emvadon,#p2Ogkos,#p2Thermokrasia').html('');
    }

    //Metatropes Mhkos
    $('#p1Mhkos,#m1Mhkos,#m2Mhkos').on('change', function(e) {
        var id = '#p1Mhkos';
        var oldVal = $(id).val();
        //$(id).val(parseFloat(oldVal).toFixed(10));
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1Mhkos = $('#p1Mhkos').val();
            if (p1Mhkos !== '') {
                p1Mhkos = new Big(p1Mhkos); //big.js
                var m1Mhkos = $('#m1Mhkos').val();
                var m2Mhkos = $('#m2Mhkos').val();
                var multiplierSelector = 'conv-to-' + m2Mhkos;
                var multiplier = $('#' + m1Mhkos).attr(multiplierSelector);
                var p2Mhkos = p1Mhkos.times(multiplier); //big.js
                $('#p2Mhkos').html(getExp(p2Mhkos));  
                console.log(p2Mhkos);
            }
            if (p1Mhkos === '')
                $('#p2Mhkos').html('');
        }
    });

    //Metatropes Emvadon
    $('#p1Emvadon,#m1Emvadon,#m2Emvadon').on('change', function(e) {
        var id = '#p1Emvadon';
        var oldVal = $(id).val();
        //$(id).val(parseFloat(oldVal).toFixed(10));
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1Emvadon = $('#p1Emvadon').val();
            if (p1Emvadon !== '') {
                p1Emvadon = new Big(p1Emvadon); //big.js
                var m1Emvadon = $('#m1Emvadon').val();
                var m2Emvadon = $('#m2Emvadon').val();
                var multiplierSelector = 'conv-to-' + m2Emvadon;
                var multiplier = $('#' + m1Emvadon).attr(multiplierSelector);
                var p2Emvadon = p1Emvadon.times(multiplier); //big.js
                $('#p2Emvadon').html(getExp(p2Emvadon));
            }
            if (p1Emvadon === '')
                $('#p2Emvadon').html('');
        }
    });

    //Metatropes Mhkous
    $('#p1Ogkos,#m1Ogkos,#m2Ogkos').on('change', function(e) {
        var id = '#p1Ogkos';
        var oldVal = $(id).val();
        //$(id).val(parseFloat(oldVal).toFixed(10));
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1Ogkos = $('#p1Ogkos').val();
            if (p1Ogkos !== '') {
                p1Ogkos = new Big(p1Ogkos); //big.js
                var m1Ogkos = $('#m1Ogkos').val();
                var m2Ogkos = $('#m2Ogkos').val();
                var multiplierSelector = 'conv-to-' + m2Ogkos;
                var multiplier = $('#' + m1Ogkos).attr(multiplierSelector);
                var p2Ogkos = p1Ogkos.times(multiplier); //big.js
                $('#p2Ogkos').html(getExp(p2Ogkos));
            }
            if (p1Ogkos === '')
                $('#p2Ogkos').html('');
        }
    });

    //Metatropes Varos
    $('#p1Varos,#m1Varos,#m2Varos').on('change', function(e) {
        var id = '#p1Varos';
        var oldVal = $(id).val();
        //$(id).val(parseFloat(oldVal).toFixed(10));
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1Varos = $('#p1Varos').val();
            if (p1Varos !== '') {
                p1Varos = new Big(p1Varos); //big.js
                var m1Varos = $('#m1Varos').val();
                var m2Varos = $('#m2Varos').val();
                var multiplierSelector = 'conv-to-' + m2Varos;
                var multiplier = $('#' + m1Varos).attr(multiplierSelector);
                var p2Varos = p1Varos.times(multiplier); //big.js
                $('#p2Varos').html(getExp(p2Varos));
            }
            if (p1Varos === '')
                $('#p2Varos').html('');
        }
    });

    //Metatropes Thermokrasias
    $('#p1Thermokrasia,#m1Thermokrasia,#m2Thermokrasia').on('change', function(e) {
        var id = '#p1Thermokrasia';
        var oldVal = $(id).val();
        //$(id).val(parseFloat(oldVal).toFixed(10));
        var checkInput = handleInput(id);
        if (checkInput) {
            var p1Thermokrasia = $('#p1Thermokrasia').val();
            if (p1Thermokrasia !== '') {
                p1Thermokrasia = new Big(p1Thermokrasia); //big.js
                var m1Thermokrasia = $('#m1Thermokrasia').val();
                var m2Thermokrasia = $('#m2Thermokrasia').val();
                if (m1Thermokrasia === 'celsium' && m2Thermokrasia === 'kelvin')
                    var p2Thermokrasia = p1Thermokrasia.plus(273.15); //big.js
                else if (m1Thermokrasia === 'celsium' && m2Thermokrasia === 'fahrenheit')
                    var p2Thermokrasia = (p1Thermokrasia.times(1.8)).plus(32); //big.js
                else if (m1Thermokrasia === 'kelvin' && m2Thermokrasia === 'celsium')
                    var p2Thermokrasia = p1Thermokrasia.minus(273.15); //big.js
                else if (m1Thermokrasia === 'kelvin' && m2Thermokrasia === 'fahrenheit')
                    var p2Thermokrasia = ((p1Thermokrasia.minus(273.15)).times(1.8)).plus(32.00); //big.js
                else if (m1Thermokrasia === 'fahrenheit' && m2Thermokrasia === 'celsium')
                    var p2Thermokrasia = (p1Thermokrasia.minus(32)).div(1.8); //big.js
                else if (m1Thermokrasia === 'fahrenheit' && m2Thermokrasia === 'kelvin')
                    var p2Thermokrasia = ((p1Thermokrasia.minus(32)).div(1.8)).plus(273.15); //big.js
                else
                    var p2Thermokrasia = p1Thermokrasia;
                $('#p2Thermokrasia').html(getExp(p2Thermokrasia));
            }
            if (p1Thermokrasia === '')
                $('#p2Thermokrasia').html('');
        }
    });
    // END OF converter
    // ====================================
});	

