var actualImage;
var notificationIcon = window.location.origin+"/images/32.png";
var isImageSelected = false;
var spinSaveImage =
    function (what) {
        if (what == "show") {
            $.mobile.loading("show", {
                text: "Resizing...",
                textVisible: true,
                theme: "b"
            });
        } else {
            $.mobile.loading("hide");
        }
    };
var spinShareImage =
    function (what) {
        if (what == "show") {
            $.mobile.loading("show", {
                text: "Creating Image...",
                textVisible: true,
                theme: "b"
            });
        } else {
            $.mobile.loading("hide");
        }
    };
$(document).ready(function () {

    var saveImageButton = document.getElementById("saveImageButton");

    saveImageButton.addEventListener('click', function () {
        if(!isImageSelected){
            alert("No Image Selected.")
            return;
        }
        spinSaveImage("show");

        var imageHeight = document.getElementById('imageHeight').value == 0 ? 500:document.getElementById('imageHeight').value;
        var imageWidth = document.getElementById('imageWidth').value == 0 ? 500:document.getElementById('imageWidth').value;
        if (document.getElementById('aspectRatio').checked) {
            var aspectRatioResult = calculateAspectRatioFit(actualImage.width, actualImage.height, imageWidth, imageHeight);
            imageHeight = aspectRatioResult.height;
            imageWidth = aspectRatioResult.width;
        }

        var imageCanvas = document.createElement('canvas');
        imageCanvas.height = imageHeight;
        imageCanvas.width = imageWidth;
        var context = imageCanvas.getContext('2d');
        context.drawImage(actualImage, 0, 0, imageWidth, imageHeight);

        imageCanvas.toBlob(function(blob){
            var randomFileName = "ImageResize" + Math.random().toString(36).substr(2, 15) + ".png";

            var sdCard = navigator.getDeviceStorage("sdcard");
            var request = sdCard.delete(randomFileName);

            request.onsuccess = function () {
                savePhotoToSdCard(blob,randomFileName);
                console.log("success and savePhotoToSdCard called");
            };

            request.onerror = function () {
                savePhotoToSdCard(blob,randomFileName);
                alert("File writting error");
            };
        });

    });

    var selectImageButton = document.getElementById("selectImageButton");

    selectImageButton.addEventListener('click', function () {
        var pickImageActivity = new MozActivity({
            name: "pick",
            data: {
                type: ["image/*"]
            }
        });
        pickImageActivity.onsuccess = function () {
           var imageSouce = window.URL.createObjectURL(this.result.blob);
            document.getElementById("mainImage").src = imageSouce;
            actualImage = new Image();
            actualImage.onload = function(){
                isImageSelected = true;
            };
            actualImage.src = imageSouce;
            var shareImageButton = document.getElementById('shareImageButton');
            shareImageButton.style.display = 'none';
        };

        pickImageActivity.onerror = function () {

        };
    });

    var shareImageButton = document.getElementById('shareImageButton');
    shareImageButton.addEventListener('click',function(){
        spinShareImage("show");

        var imageHeight = document.getElementById('imageHeight').value == 0 ? 500:document.getElementById('imageHeight').value;
        var imageWidth = document.getElementById('imageWidth').value == 0 ? 500:document.getElementById('imageWidth').value;
        if (document.getElementById('aspectRatio').checked) {
            var aspectRatioResult = calculateAspectRatioFit(actualImage.width, actualImage.height, imageWidth, imageHeight);
            imageHeight = aspectRatioResult.height;
            imageWidth = aspectRatioResult.width;
        }

        var imageCanvas = document.createElement('canvas');
        imageCanvas.height = imageHeight;
        imageCanvas.width = imageWidth;
        var context = imageCanvas.getContext('2d');
        context.drawImage(actualImage, 0, 0, imageWidth, imageHeight);

        imageCanvas.toBlob(function(blob){
            var a = new MozActivity({
                name: 'share',
                data: {
                    type: 'image/*',
                    number: 1,
                    blobs: [blob],
                    filenames: ['ResizeImage.png']
                }
            });
            a.onsuccess = function() {
                spinShareImage("hide");
                addNotification("Photo Shared");
            };
            a.onerror = function() {
                spinShareImage("hide");
                console.log("Unable to Share Photo.")
            };
        });

    });

    navigator.mozSetMessageHandler('activity', function(activityRequest) {
        if(activityRequest.source.data.blobs[0] == null){
            alert("No Video Selected");
        }
        var imageSouce = window.URL.createObjectURL(activityRequest.source.data.blobs[0]);
        document.getElementById("mainImage").src = imageSouce;
        actualImage = new Image();
        actualImage.onload = function(){
            isImageSelected = true;
        };
        actualImage.src = imageSouce;

    });

});

function calculateAspectRatioFit(srcWidth, srcHeight, maxWidth, maxHeight) {

    var ratio = Math.min(maxWidth / srcWidth, maxHeight / srcHeight);

    return { width: srcWidth * ratio, height: srcHeight * ratio };
}

function savePhotoToSdCard(blob, randomFileName) {

    var sdcard = navigator.getDeviceStorage("sdcard");
    var request = sdcard.addNamed(blob, "ImageResize/"+randomFileName);

    request.onsuccess = function () {
        var name = this.result;
        spinSaveImage("hide");
        addNotification("Photo Saved");
        var shareImageButton = document.getElementById('shareImageButton');
        shareImageButton.style.display = 'block';
    };

    request.onerror = function (e) {
        alert("Unable to Save Photo");
    };
}

function addNotification(notifyText){
    if ("Notification" in window) {
        // Firefox OS 1.1 and higher
        if (Notification.permission !== "denied") {
            Notification.requestPermission(function (permission) {
                if(!("permission" in Notification)) {
                    Notification.permission = permission;
                }
            });
        }

        if (Notification.permission === "granted") {
            new Notification("Image Resize", {
                body : notifyText,
                icon:notificationIcon
            });
        }
    }
    else {
        // Firefox OS 1.0
        var notify = navigator.mozNotification.createNotification(
            "Image Resize",
            notifyText
        );
        notify.show();
    }
}