app = {
	
    initialize: function() {
		document.addEventListener('deviceready', this.onDeviceReady, false);
    },

    onDeviceReady: function() {
		FastClick.attach(document.body);
    }

};

Array.prototype.shuffle = function() {
	var i = this.length;
	while(i){
		var j = Math.floor(Math.random()*i);
		var t = this[--i];
		this[i] = this[j];
		this[j] = t;
	}
	return this;
}

function Question() {
	var mFigures = [ "Triangle", "Square", "Circle", "Heart", "Clover", "Spade", "Diamond", "Star" ];
	var mFiguresJa = ["三角","四角","丸","ハート","クローバー","スペード","ダイヤ","星"];
	var mColors = [ "Pink", "Red", "Orange", "Yellow", "Brown", "Green", "Blue", "Purple", "Gray", "Black", "White" ];
	var mColorsJa = ["ピンク","赤","オレンジ","黄色","茶色","緑","青","紫","灰色","黒","白"];
	var mFigureMax = mFigures.length;
	var mColorMax = mColors.length;
	var mFigureIndex;
	var mColorIndex;

	this.newQuestion = function() {
		mFigureIndex = Math.floor(Math.random() * mFigureMax);
		mColorIndex = Math.floor(Math.random() * mColorMax);
	}
	this.getFigure = function() {
		return mFigures[mFigureIndex];
	}
	this.getColor = function() {
		return mColors[mColorIndex];
	}
	this.getRandomFigureIndex = function() {
		var index;
		do {
			index = Math.floor(Math.random() * mFigureMax);
		} while (index == mFigureIndex);

		return index;
	}
	this.getRandomColorIndex = function() {
		index = Math.floor(Math.random() * mColorMax);

		return index;
	}
	this.getRandomFigure = function() {
		return mFigures[this.getRandomFigureIndex()];
	}
	this.getRandomColor = function() {
		return mColors[this.getRandomColorIndex()];
	}
	this.getJapaneseAnswer = function(color_index, figure_index) {
		return mColorsJa[color_index] + 'の' + mFiguresJa[figure_index];
	}
	this.getAnswer = function() {
		if (mLang == "ja") {
			return this.getJapaneseAnswer(mColorIndex, mFigureIndex);
		}
		return this.getColor() + ' ' + this.getFigure();
	}
	this.getRandomAnswer = function() {
		if (mLang == "ja") {
			var c = this.getRandomColorIndex();
			var f = this.getRandomFigureIndex();
			return this.getJapaneseAnswer(c, f);
		}
		return this.getRandomColor() + ' ' + this.getRandomFigure();
	}
}

var mQuestion = new Question();
var mHitCount;
var mSartTime;
var mPlayTime = 1;
var mLang;

jQuery(document).ready(function () {
	localize();
	$("#start_button").click(startButtonClicked);
	$("#answer_1").click({id : "#answer_1"}, answerClicked);
	$("#answer_2").click({id : "#answer_2"}, answerClicked);
	$("#answer_3").click({id : "#answer_3"}, answerClicked);
	$("#answer_4").click({id : "#answer_4"}, answerClicked);
	$("#replay_button").click(startButtonClicked);
	$("#exit_button").click(exitButtonClicked);
	$("#settings_button").click(settingsButtonClicked);
	$("input[type='radio']").change(saveSettings);
	mLang = navigator.language || navigator.userLanguage;
});


function changeImage() {
	mQuestion.newQuestion();
	var color = mQuestion.getColor();
	var figure = mQuestion.getFigure();

	var src = 'img/' + color + figure + '.png';
	$("#figure_image").attr("src", src);
}

function printQuestion() {
	changeImage();
    $.mobile.changePage("#question", {transition: "slide"});
    setTimeout(printAnswer, 1000);
}

function startButtonClicked() {
    mStartTime = new Date();
	mHitCount = 0;

	printQuestion();
}

function printAnswer() {
    $.mobile.changePage("#answer", {transition: "slide"});

	var answers = [1, 2, 3, 4];
	answers.shuffle();

	var i;
	var iMax = answers.length;
	var answer;
	for (i=0; i<iMax; i++) {
		if (i == 0) {
			answer = mQuestion.getAnswer();
		} else {
			answer = mQuestion.getRandomAnswer();
		}
		$("#answer_" + answers[i]).text(answer);
	}
}

function answerClicked(event) {
	if ($(event.data.id).text() == mQuestion.getAnswer()) {
		mHitCount++;
	}

	var currentTime = new Date();
	if ((currentTime - mStartTime) >= mPlayTime * 60000) {
		gameOver();
	} else {
		printQuestion();
	}
}

function gameOver() {
    $.mobile.changePage("#score", {transition: "slide"});
	$("#score_text").text(mHitCount);
}

function exitButtonClicked() {
	window.close();
}

function settingsButtonClicked() {
	localforage.getItem("Time", function(value) {
		if (value == null) {
			$("#play_time_" + mPlayTime).attr("checked",true).checkboxradio("refresh");
		} else {
			$("#play_time_" + value).attr("checked",true).checkboxradio("refresh");
		}
	});
}

function saveSettings() {
	$("input[name*=play_time]:checked").each(function() {
		mPlayTime = $(this).val();
		localforage.setItem("Time", mPlayTime);
	    $.mobile.changePage("#start", {transition: "slide"});
	});
}

function localize() {
	$("[data-localize]").localize("loc", {skipLanguage:"en"});
}
