	$(document).on("pageshow", function(){	
		// ABFRAGE DES DATEINAMENS
		var full_url = $(location).attr('href');		
		var short_url = full_url.substr(full_url.lastIndexOf('/'),full_url.lastIndexOf('.html'));
		short_url = short_url.substr(1,full_url.lastIndexOf('.html'));
		// ANFANG DATUM AUS XML ABFRAGEN	
		$.ajax({
		  type: 'get',
		  url: 'dateidaten.xml',
		  beforeSend: function() {
			// before send the request, displays a "Loading..." message in the element where the response will be placed
			$('small.filedate span').html('2013');
		  },
		  timeout: 10000,        // sets timeout for the request (10 seconds)
		  error: function(xhr, status, error) { alert('Error: '+ xhr.status+ ' - '+ error); },     // alert a message in case of error
		  dataType: 'xml',
		  success: function(response) {
			$('small.filedate span').html('');        // removes the "loading..." notification from "#resp"	
			// gets and parse each child element in <webpages>
			$(response).find('dateidaten').children().each(function() {
			  // gets the "id", "title", and "url" of current child element
			  var elm = $(this);
			  var id = elm.attr('id');
			  var titel = elm.find('titel').text();
			  var datum = elm.find('datum').text();	
			  // displays data
			  if(titel == short_url){
				$('small.filedate span').html(datum);
				}
			});
		  }
		}); // ENDE DATUM AUS XML ABFRAGEN	
			
		var share_popup_message = '<div data-role="header"><h2>App empfehlen</h2></div>'
	        	+ '<div data-role="controlgroup" data-corners="false" data-theme="f">'
	        	+ '<a data-theme="d" data-role="button" href="#" class="email_share" data-icon="ho-email" data-iconpos="left" data-corners="false" data-shadow="false" data-iconshadow="false">E-Mail</a>'
	        	+ '<a data-theme="d" data-role="button" href="#" class="facebook_share" data-icon="ho-facebook" data-iconpos="left" data-corners="false" data-shadow="false" data-iconshadow="false">Facebook</a>'
	        	+ '<a data-theme="d" data-role="button" href="#" class"twitter_share" data-icon="ho-twitter" data-iconpos="left" data-corners="false" data-shadow="false" data-iconshadow="false">Twitter</a>'
	        	+ '<a data-theme="d" data-role="button" href="https://plus.google.com/share?url=http://www.impfuhr.de/webapp" data-icon="ho-googleplus" data-iconpos="left" data-corners="false" data-shadow="false" data-iconshadow="false">Google+</a>'
	        	+ '</div>';
		$(".share-popup-btn").on( "click", function() {
	       		runtimePopup(share_popup_message, "share_up");
	       	});			
		$('.email_share').click(
			function () {
				email_share();
		});
		$('.facebook_share').click(
			function () {
				facebook_share();
		});		
		$('.twitter_share').click(
			function () {
				twitter_share();
		});
			
		
		$('.bt_refresh').click(
			function () {
				$('.bt_refresh').animate({rotate: '+=720deg'}, 3000);
				setTimeout(function(){location.reload();}, 3000);
		});
		
		$('.exitapp').click(
			function () {
				exitAppPopup();
		});
			
	}); // ENDE $(document).on("pageshow" ..)
	
	function exitAppPopup() {
		var message = 'Sie möchten die Impf-Uhr App wirklich beenden?';
		var confirm_dialog = window.confirm(message);
		if (confirm_dialog == true) { 
			 window.close();
		} 
	}
	
	function runtimePopup(message, shortname) {
   		var closebtn = '<a href="#" data-rel="back" data-role="button" data-theme="a" data-icon="delete" data-iconpos="notext" data-shadow="false" data-iconshadow="false" class="ui-btn-right">Close</a>';
		var popup = '<div data-role="popup" id="popup-' + shortname + '" data-short="' + shortname +'" data-theme="c" data-overlay-theme="a" data-corners="false" data-tolerance="5" class="ui-content impfpopup">' + closebtn + message + '</div>';
		
	    $.mobile.activePage.append( popup ).trigger( "pagecreate" );
		
	    $("#popup-" + shortname).load(function() {
		 	var height = $( this ).height(),
				width = $( this ).width();
			// Set height and width attribute of the image
			$( this ).attr({ "height": height, "width": width }); 
			// Open the popup
			$( "#popup-" + shortname ).popup( "open" );
			// Clear the fallback
			clearTimeout( fallback );
		});
		// Fallback in case the browser doesn't fire a load event
		var fallback = setTimeout(function() {
			$( "#popup-" + shortname ).popup( "open" );
			 var width = $(window).width() -100;
			var height = $(window).height() -100;
			var neg_margin = width / 2 - width;
			$("#popup-" + shortname).css('width', width);
			$("#popup-" + shortname +"-popup").css('left', '48%');
			$("#popup-" + shortname +"-popup").css('top', '50px');
			$("#popup-" + shortname +"-popup").css('margin-left', neg_margin); 
			$("#popup-" + shortname +"-popup").css('max-width', width); 
		}, 100);
	
		// Remove the popup after it has been closed to manage DOM size
		$( document ).on( "popupafterclose", ".ui-popup", function() {
			$( this ).remove();
		});
		
		}//ENDE function runtimePopup
	
		
		// ---------- ANFANG SHARE-TEXTE/LINKS
		 var email_share = function(){
	            var url = "http://www.impfuhr.de/webapp";
	            var share_body = 'Hallo,'
	                +'\nIch habe eine App entdeckt zum Thema Impfen. Welche Impfungen braucht man? Welche bezahlen die Kassen?'
	                +'\nMan kann im Doku-Modul der Uhr auch Impfdaten verwalten.'
	                +'\nAußerdem informiert die App im News-Bereich über aktuelle Themen der Gesundheitsvorsorge.'
	                +'\n\nHier geht es zum kostenlosen Download\niPhone/iPad/Windows Phone/Blackberry/etc.: http://www.impfuhr.de/webapp \nAndroid: '
					+'\nGoogle Play: https://play.google.com/store/apps/details?id=de.sanamedia.impfuhr'					
					+'\nAmazon (Kindle Fire): http://www.amazon.de/Initiative-Pr%C3%A4ventionspartner-Impf-Uhr-3-0/dp/B00EXP3MF8/ref=pd_rhf_se_p_t_3_KJCE';
	            var share_subject = 'App-Tipp: Impfungen auf einen Blick';		
	            var href = "mailto:?subject="+encodeURIComponent(share_subject)+"&body="+encodeURIComponent(share_body);            
	            $("a:contains('E-Mail')").attr('href', function(index,attr){
	                return attr.replace('#', href);
	                });            
	        }
	        var facebook_share = function(){
	            var url = "http://www.impfuhr.de/webapp";
	            var share_title = 'App-Tipp: Impfungen auf einen Blick';
	            var share_body = 'Hallo,'
	                +'\nIch habe eine App entdeckt zum Thema Impfen. Welche Impfungen braucht man? Welche bezahlen die Kassen?'
	                +'\nMan kann im Doku-Modul der Uhr auch Impfdaten verwalten.'
	                +'\nAußerdem informiert die App im News-Bereich über aktuelle Themen der Gesundheitsvorsorge.'
	                +'\n\nHier geht es zum kostenlosen Download\niPhone/iPad/Windows Phone/Blackberry/etc.: http://www.impfuhr.de/webapp \nAndroid: '
					+'\nGoogle Play: https://play.google.com/store/apps/details?id=de.sanamedia.impfuhr'					
					+'\nAmazon (Kindle Fire): http://www.amazon.de/Initiative-Pr%C3%A4ventionspartner-Impf-Uhr-3-0/dp/B00EXP3MF8/ref=pd_rhf_se_p_t_3_KJCE';
	            var href = "http://www.facebook.com/sharer.php?s=100&p[title]="+share_title+"&p[summary]="+share_body+"&p[url]="+url;            
	            $("a:contains('Facebook')").attr('href', function(index,attr){
	                return attr.replace('#', href);
	                });
	        }	
	        var twitter_share = function(){
	            var url = "http://www.impfuhr.de/webapp";
	            var share_title = 'App-Tipp: Impfungen auf einen Blick';
	            var share_body = 'Hallo,'
	                +'\nIch habe eine App entdeckt zum Thema Impfen. Welche Impfungen braucht man? Welche bezahlen die Kassen?'
	                +'\nMan kann im Doku-Modul der Uhr auch Impfdaten verwalten.'
	                +'\nAußerdem informiert die App im News-Bereich über aktuelle Themen der Gesundheitsvorsorge.'
	                +'\n\nHier geht es zum kostenlosen Download\niPhone/iPad/Windows Phone/Blackberry/etc.: http://www.impfuhr.de/webapp \nAndroid: '
					+'\nGoogle Play: https://play.google.com/store/apps/details?id=de.sanamedia.impfuhr'					
					+'\nAmazon (Kindle Fire): http://www.amazon.de/Initiative-Pr%C3%A4ventionspartner-Impf-Uhr-3-0/dp/B00EXP3MF8/ref=pd_rhf_se_p_t_3_KJCE';
	            var href = "https://twitter.com/intent/tweet?&text="+share_body+"&url="+url;            
	            $("a:contains('Twitter')").attr('href', function(index,attr){
	                return attr.replace('#', href);
	                });
	            }
	        var googleplus_share = function (){
	            var url = "http://www.impfuhr.de/webapp";
	            var share_title = 'App-Tipp: Impfungen auf einen Blick';
	            var share_body = 'Hallo,'
	                +'\nIch habe eine App entdeckt zum Thema Impfen. Welche Impfungen braucht man? Welche bezahlen die Kassen?'
	                +'\nMan kann im Doku-Modul der Uhr auch Impfdaten verwalten.'
	                +'\nAußerdem informiert die App im News-Bereich über aktuelle Themen der Gesundheitsvorsorge.'
	                +'\n\nHier geht es zum kostenlosen Download\niPhone/iPad/Windows Phone/Blackberry/etc.: http://www.impfuhr.de/webapp \nAndroid: '
					+'\nGoogle Play: https://play.google.com/store/apps/details?id=de.sanamedia.impfuhr'					
					+'\nAmazon (Kindle Fire): http://www.amazon.de/Initiative-Pr%C3%A4ventionspartner-Impf-Uhr-3-0/dp/B00EXP3MF8/ref=pd_rhf_se_p_t_3_KJCE';
	            var href = "https://plus.google.com/share?hl=de&url="+url+"&title="+share_title;            
	            $("a:contains('Google+')").attr('href', function(index,attr){
	                return attr.replace('#', href);
	                });
	            }	       	        
		// ---------- ENDE--- SHARE-TEXTE/LINKS		
	