$('body').live("swiperight", function(event){
		event.preventDefault();
		history.back(1);
  });

$('#news_detail').on("pageshow", function(){
	$('#newscontent').empty();
	var news_id = sessionStorage.newsid;
	$.mobile.loading('show', {
		text: 'Bitte warten, Seite wird geladen...',
		textVisible: true,
		theme: 'a',
		textonly: false
		});			
					
		var xhr = new XMLHttpRequest({mozSystem: true});
		xhr.open("GET", "http://www.impfuhr.de/json/impfuhr_news.json", true);	
		xhr.onreadystatechange = function () {		    	
			if(xhr.status === 200 && xhr.readyState === 4){
					var obj = jQuery.parseJSON( xhr.response );		
					 $.each(obj.impfuhr.items, function(i,item) { 	
						var title = item.headline;
						var subtitle = item.subheadline;
						var description = item.teaser;
						var content = item.text;
						var pubdate = item.date;
						var creator = item.name;
						var guid = item.alias;
						var imgsrc = item.path;
						var imgalt = item.alt;
						var id = item.id;
						
						var dLM = new Date(1000*pubdate);
						var year = dLM.getFullYear();
						var month = dLM.getMonth()+1;
						var date = dLM.getDate();
						var hours = dLM.getHours();
						var minutes = dLM.getMinutes();
						var seconds = dLM.getSeconds();

						if (date<10) date = "0"+date;
						if (month<10) month = "0"+month;
						if (hours<10) hours = "0"+hours;
						if (minutes<10) minutes = "0"+minutes;
						if (seconds<10) seconds = "0"+seconds;

						var newsdate = date+"."+month+"."+year+" "+hours+":"+minutes+":"+seconds;
												
						var newsimg_src = "";
						var newsimg = "";
						
						if(imgsrc != null){
							newsimg_src = "http://www.praeventionspartner.de/" + imgsrc;
							newsimg = '<img src="'+newsimg_src+'" alt="'+ title +'" title="'+ title 
							+'" id="img_'+id+'" class="newsimg" />';
						}else{							
							newsimg = '<img src="images/content/newsimg_platzhalter.jpg" alt="'+ title 
							+'" title="'+ title +'" id="img_'+id+'" class="newsimg" />';
						}
						
						if(id == news_id){									
							$('<h1 class="title">'+title+'</h1>'+'<small class="pubdate">'
							+newsdate+'</small><br />'+'<small class="creator">von: '
							+creator+'</small><div class="newsimg_div">'+newsimg+'</div><div class="content">'
							+content+'</div>').appendTo('#newscontent');
							}
					 });
					 $.mobile.loading('hide');
			}
		}
		 xhr.onerror = function (e) {
			console.log('XHR ERROR: '+ e.error);
		};
		xhr.send(null);
					
}); /* <- ENDE PAGESHOW */

$(window).on( 'orientationchange', orientationChangeHandler );
function orientationChangeHandler( event ) {
	var width = $(window).width() -30;					
	$('#news_detail img').css('max-width', width);
}

