/** 
 *
 * @author 			Bernd <bernd@shortcutworld.com>
 * @copyright 		Copyright (c) 2006-2012 shortcutworld.com
 * @version 		4.3
 * @mofifiedby 		Bernd
 * @lastmodified	11/15/2012
 */ 

var Shortcuts = {
	run: function () {
		$(document).bind('keyup', 's', Shortcuts.search); 
		
		$(".switchto_text").click(function() {
			Shortcuts.switchAppleSymbols(1);
			$(this).hide().next().show();
		});
		$(".switchto_symbols").click(function() {
			Shortcuts.switchAppleSymbols(0);
			$(this).hide().prev().show();
		});		
		
	},

	search: function () {
		$("#search_box").focus();
	},
	
	switchAppleSymbols: function (switchTo) {
		var shift = new Array ('&#8679;', 'Shift', '⇧', 'shift')
		var command = new Array ('&#8984;', 'Command', '⌘', 'Cmd', 'command', 'cmd', '\u2028');
		var option = new Array ('&#8997;', 'Option','⌥',  'option');
		var control = new Array ('&#8963;', 'Control', '⌃', 'control', 'ctrl', 'CTRL', 'Ctrl');		

		$(".kbd").each(function() {
			var text = $(this).text();

			if (shift.indexOf(text)!=-1) {
				text = shift[switchTo];
				$(this).html(text);
			} else if (command.indexOf(text)!=-1) {
					text = command[switchTo];
					$(this).html(text);
				} else if (option.indexOf(text)!=-1) {
						text = option[switchTo];
						$(this).html(text);
					} else if (control.indexOf(text)!=-1) {
						text = control[switchTo];
						$(this).html(text);
					}
		})
	},
	
}



$(document).ready( function () {
	Shortcuts.run();
});


