var versionCode = 131;

var premades = {};
var currPremade = 1;
var screens = ["playersListScreen", "errorScreen", "playerScreen", "searchScreen"];
var summoner = '';
var matchData = {};
var ids = {
    't1': 0,
    't2': 0
};
var cplayer = {};
var cscreen;
var computer = true;
var selectedRegion;

// player screen variables
var pSummoner = ""; // current summoner
var pSubscreen = 0; // 0 = information, 1 = game history
var pLoading = 0; // 0 = not loading, 1 = loading, 2 = loaded
var pGameHist = {}; // laoded game hist

$.fn.textWidth = function(text, font) {
    if (!$.fn.textWidth.fakeEl) $.fn.textWidth.fakeEl = $('<span>').hide().appendTo(document.body);
    $.fn.textWidth.fakeEl.html(text || this.val() || this.text()).css('font', font || this.css('font'));
    return $.fn.textWidth.fakeEl.width();
};

$(function() {
    FastClick.attach(document.body);
});

function gotoTop() {
    var target = $("body");
 
    //disable touch scroll to kill existing inertial movement
    target.css({
        '-webkit-overflow-scrolling' : 'auto',
        'overflow-y' : 'hidden'
    });
 
    //animate
    target.animate({ scrollTop: 0}, 150, "swing", function(){
 
        //re-enable touch scrolling
        target.css({
            '-webkit-overflow-scrolling' : 'touch',
            'overflow-y' : 'auto'
        });
    })
}

function errInfo() {
    var str = "<br />";
    str += "Date: " + (new Date().toString());
    str += "<br />Summoner: " + summoner;
    return str;
}

function selectRegion(reg) {
    window.localStorage.setItem('region', reg);
    
    selectedRegion = reg;
    $('.region-btn, .region-btn2').each(function() {
        if ($(this).html() == selectedRegion) $(this).addClass('region-btn-selected');
        else $(this).removeClass('region-btn-selected');
    });
}

function getMatchHistory() {
    $.ajax({
        url: "http://intoleague-node.herokuapp.com/history/" + versionCode + "/" + selectedRegion + "/" + summoner,
        dataType: (computer) ? 'jsonp' : 'json',
        cache: false,
        success: function(data){
            $('#div-history').html(Handlebars.templates.history(data));
        },
        error: function(xhr, txt, err) {
            $('#div-history').html("Couldn't load game history." + err);
        }
    });
}

function getHistory() {
    var res = {
        hist: []
    };
    for (var i = 0; i < 5; ++i) {
        var gname = 'game' + i;
        var kn = window.localStorage.getItem(gname);
        if (kn != undefined) res.hist.push(JSON.parse(kn));
    }
    
    res.hist.sort(function(a, b) {
        return a.date < b.date;
    });
    
    return res;
}

function getGameType(data) {
    if (data.gameMode == "ODIN") return "Dominion";
    if (data.gameMode == "ARAM") return "ARAM";
    if (data.gameMode == "FIRSTBLOOD") return "Showdown";
    
    var gt = data.gameType.replace(/_/g, " ");
    return gt.charAt(0).toUpperCase() + gt.slice(1).toLowerCase();
}

function gotoScreen(screen, data) {
    cscreen = screen;
    
    $("#search-btn").css("display", (screen == "playersListScreen" || screen == "errorScreen") ? "inline" : "none");
    $("#match-btn").css("display", (screen == "playerScreen") ? "inline" : "none");  
    
    switch(screen) {
        case "playersListScreen": {
            $("#screen").html(Handlebars.templates.playerlist(data));
            $(".top-bar-title").html(getGameType(data));
            
            premades = {};
            currPremade = 1;
            ids = {
                't1': 0,
                't2': 0
            }
            
            break;
        }
        
        case "playerScreen": {
            $("#screen").html(Handlebars.templates.player(data));
            $(".top-bar-title").html(data.summonerName);  
            pLoading = 0;
            pSubscreen = 0;
            pGameHist = {};
            pSummoner = data.summonerName;
            break;
        }
        
        case "searchScreen": {
            $("#screen").html(Handlebars.templates.search(data));
            $(".top-bar-title").html("intoLeague");  
            
            var lastRegion = window.localStorage.getItem("region");
            selectRegion(lastRegion || "EUW");
            
            $("#summoner").val(summoner); 
            $('.search-btn-disabled').toggleClass('search-btn search-btn-disabled');
            $('.history-btn-disabled').toggleClass('history-btn history-btn-disabled');
            break;
        }
        
        case "errorScreen": {
            getMatchHistory();
            $("#screen").html(Handlebars.templates.error(data));
            $(".top-bar-title").html("Error");  
            break;
        }
    }
    
    gotoTop();
}

function registerHelpers() {
    Handlebars.registerHelper('getPremade', function(tpi) {
        if (tpi == undefined) return "";
        
        if (premades[tpi] != undefined) {
            return premades[tpi];
        } else {
            var premadeClass = 'p' + currPremade;
            premades[tpi] = premadeClass;
            ++currPremade;
            return premadeClass;
        }
    });
    
    Handlebars.registerHelper('leagueImg', function(lg) {
        if (lg == undefined || lg == "") return "unranked";
        return lg.replace(" V", "_5").replace(" IV", "_4").replace(" III", "_3").replace(" II", "_2").replace(" I", "_1");
    });
    
    Handlebars.registerHelper('capitalize', function(str) {
        if (str == undefined || str == "") return "Unranked";
        return str.charAt(0).toUpperCase() + str.slice(1);
    });
    
    Handlebars.registerHelper('errorToString', function(str) {
        if (str == "riot_error") return "No active game found for summoner " + summoner;
        if (str == "unknown_error") return "Unknown error, please try again";
        if (str == "region_not_found") return "Unknown region!";
        if (str == "client_not_connected") return "Our client can't connect to the specified region. Please try again later";
        if (str == "app_error") return "There was an unexpected error. Please report this to contact@intoleague.com with this information: " + errInfo();
    });
    
    Handlebars.registerHelper('setPid', function(team) {
        return ids[team]++;
    });
    
    Handlebars.registerHelper('getChamp', function(id) {
        return champs[id].name;
    });
    
    Handlebars.registerHelper('getDesc', function(id) {
        return champs[id].desc;
    });
    
    Handlebars.registerHelper('divSummonerName', function(summ, lvl) {
        var sz = 12;
        while ($.fn.textWidth(summ + ' (' + lvl +')', sz + 'px roboto') > 110) --sz;
        return '<div class="player-name" style="font-size: '+sz+'px">'+summ+' ('+lvl+')</div>';
    });
    
    Handlebars.registerHelper('winsOrLevel', function(lw, ll, lp, lvl) {
        if ((lw == 0 && lp == 0 && ll == 0) || lw == undefined || lp == undefined || ll == undefined) return "(level " + lvl + ")";
        return "(" + lw + "W/" + ll + "L/" + lp + "LP)";
    });

    Handlebars.registerHelper('getSubType', function(subtype) {
        var res = "UNKNOWN";
        
        if (subtype == "NONE") res = "CUSTOM GAME";
        else if (subtype == "NORMAL") res = "NORMAL GAME";
        else if (subtype == "NORMAL_3x3") res  = "NORMAL 3v3 GAME";
        else if (subtype == "ODIN_UNRANKED") res  = "DOMINION";
        else if (subtype == "ARAM_UNRANKED_5x5") res  = "ARAM";
        else if (subtype == "BOT") res  = "5v5 VS AI";
        else if (subtype == "BOT_3v3") res  = "3v3 VS AI";
        else if (subtype == "RANKED_SOLO_5x5") res  = "RANKED GAME";
        else if (subtype == "RANKED_TEAM_5x5") res  = "RANKED TEAM GAME";
        else if (subtype == "RANKED_TEAM_3x3") res  = "RANKED 3v3 GAME";
        else if (subtype == "ONEFORALL_5x5") res  = "ONE FOR ALL";
        else if (subtype == "FIRSTBLOOD_1x1") res  = "SHOWDOWN 1v1";
        else if (subtype == "FIRSTBLOOD_2x2") res  = "SHOWDOWN 2v2";
        else if (subtype == "SR_6x6") res  = "HEXAKILL";
        else if (subtype == "CAP_5x5") res  = "TEAM BUILDER GAME";

        return res;
    });

    Handlebars.registerHelper('getTimeAgo', function(time) {
        switch (typeof time) {
            case 'number': break;
            case 'string': time = +new Date(time); break;
            case 'object': if (time.constructor === Date) time = time.getTime(); break;
            default: time = +new Date();
        }
        var time_formats = [
            [60, 'seconds', 1], // 60
            [120, '1 minute ago', '1 minute from now'], // 60*2
            [3600, 'minutes', 60], // 60*60, 60
            [7200, '1 hour ago', '1 hour from now'], // 60*60*2
            [86400, 'hours', 3600], // 60*60*24, 60*60
            [172800, 'Yesterday', 'Tomorrow'], // 60*60*24*2
            [604800, 'days', 86400], // 60*60*24*7, 60*60*24
            [1209600, 'Last week', 'Next week'], // 60*60*24*7*4*2
            [2419200, 'weeks', 604800], // 60*60*24*7*4, 60*60*24*7
            [4838400, 'Last month', 'Next month'], // 60*60*24*7*4*2
            [29030400, 'months', 2419200], // 60*60*24*7*4*12, 60*60*24*7*4
            [58060800, 'Last year', 'Next year'], // 60*60*24*7*4*12*2
            [2903040000, 'years', 29030400], // 60*60*24*7*4*12*100, 60*60*24*7*4*12
            [5806080000, 'Last century', 'Next century'], // 60*60*24*7*4*12*100*2
            [58060800000, 'centuries', 2903040000] // 60*60*24*7*4*12*100*20, 60*60*24*7*4*12*100
        ];
        var seconds = (+new Date() - time) / 1000,
            token = 'ago', list_choice = 1;

        if (seconds == 0) {
            return 'Just now'
        }
        if (seconds < 0) {
            seconds = Math.abs(seconds);
            token = 'from now';
            list_choice = 2;
        }
        var i = 0, format;
        while (format = time_formats[i++])
            if (seconds < format[0]) {
                if (typeof format[2] == 'string')
                    return format[list_choice];
                else
                    return Math.floor(seconds / format[2]) + ' ' + format[1] + ' ' + token;
            }
        return time;
    });

    Handlebars.registerHelper('getSpell', function(id) {
        return summonerSpells[id];
    });
}

function registerClicks() {
    // back to search
    $("#search-btn").on('click', function() {
        gotoScreen("searchScreen", getHistory());
    });
    
    // back to match
    $("#match-btn").on('click', function() {
        gotoScreen("playersListScreen", matchData);
    });
    
    $(document).on('click', '.region-btn, .region-btn2', function() {
        selectRegion($(this).html());
    });
    
    $(document).on('click', '.search-btn', function() {
        if (!$('#summoner').val()) navigator.notification.alert("Summoner name cannot be empty!");
        else search($('#summoner').val(), selectedRegion);
    });

    $(document).on('submit', '#frm-summoner', function(e) {
        if (!$('#summoner').val()) navigator.notification.alert("Summoner name cannot be empty!");
        else search($('#summoner').val(), selectedRegion);
        $('#summoner').blur();
        
        e.preventDefault();
    });
    
    $(document).on('click', '.history-btn', function() {
        var info = JSON.parse(window.localStorage.getItem($(this).attr('id')));
        selectRegion(info.region);
        search(info.summoner, info.region);
    });
    
    $(document).on('click', '.player', function() {
        var id = $(this).attr('id');
        var s_id = id.split('-');
        var team = s_id[1];
        var pid = s_id[2];

        var tdata = (team == 't1') ? matchData.teamOne : matchData.teamTwo;
        cplayer = tdata[pid];
        
        gotoScreen("playerScreen", cplayer);
    });
    
    // player profile
    $(document).on('click', '#summ-inf', function() {
        if (pSubscreen != 0) { // if we're not already in this screen
            gotoTop();
            pSubscreen = 0;
            $('.game-history-container').hide();
            $('.player-screen-container').fadeIn(150);

            // remove all active tabs
            $('#player-tabs > div').removeClass('tab-active');
            $('#summ-inf').addClass('tab-active');

            // set the border
            $('#player-tabs-borders > div').removeClass('tab-border-active');
            $('#player-tabs-borders > div:nth-child(1)').addClass('tab-border-active');
        }
    });
    
    $(document).on('click', '#summ-ghist', function() {
        if (pSubscreen != 1) { // if we're not already in this screen
            gotoTop();
            pSubscreen = 1;
            $('.player-screen-container').hide();
            $('.game-history-container').fadeIn(150);

            // remove all active tabs
            $('#player-tabs > div').removeClass('tab-active');
            $('#summ-ghist').addClass('tab-active');

            // set the border
            $('#player-tabs-borders > div').removeClass('tab-border-active');
            $('#player-tabs-borders > div:nth-child(2)').addClass('tab-border-active');

            if (pLoading == 0) {
                pLoading = 1;
                $.ajax({
                    url: "http://intoleague-node.herokuapp.com/history/" + versionCode + "/" + selectedRegion + "/" + pSummoner,
                    dataType: (computer) ? 'jsonp' : 'json',
                    cache: false,
                    success: function(data){
                        pLoading = 2;
                        pGameHist = data;
                        $('.game-history-container').html(Handlebars.templates.history(pGameHist));
                    },
                    error: function(xhr, txt, err) {
                        pLoading = 0;
                        $('.game-history-container').html("Couldn't load game history." + err);
                    }
                });
            } else if (pLoading == 2) {
                $('.game-history-container').html(Handlebars.templates.history(pGameHist));
            }
        }
    });
}

function showAds() {
    if (typeof admob == 'undefined') return;
    
    admob.createBannerView({
        'publisherId': 'ca-app-pub-9966391206032932/5240024571',
        'adSize': admob.AD_SIZE.SMART_BANNER
    }, function() {
        admob.requestAd({
            'isTesting': false,
            'extras': {
                'color_bg': 'AAAAFF',
                'color_bg_top': 'FFFFFF',
                'color_border': 'FFFFFF',
                'color_link': '000080',
                'color_text': '808080',
                'color_url': '008000'
            }
        }, function() {
            console.log("Ad served");
        }, function() {
            console.log("Oops");
        });

        console.log("Error!");
    });
}

function search(summ, region) {
    summoner = summ;
    var added = false;
    var oldest = new Date().getTime();
    var oldestg = '';
    
    $('.search-btn').toggleClass('search-btn search-btn-disabled');
    $('.history-btn').toggleClass('history-btn history-btn-disabled');
    $('#loading').fadeIn(100);
    gotoTop();
    
    for (var i = 0; i < 5; ++i) {
        var gname = 'game' + i;
        var kn = window.localStorage.getItem(gname);
        if (kn == undefined && !added) {
            added = true;
            window.localStorage.setItem(gname, JSON.stringify({
                'summoner': summoner,
                'region': region,
                'date': new Date().getTime(),
                'id': gname
            }));
        } else if (!added) {
            var kni = JSON.parse(kn);
            var csum = kni.summoner;
            var creg = kni.region;
            
            if (kni.date < oldest) {
                oldest = kni.date;
                oldestg = gname;
            }
            
            if (csum == summoner && creg == region) {
                window.localStorage.setItem(gname, JSON.stringify({
                    'summoner': csum,
                    'region': creg,
                    'date': new Date().getTime(),
                    'id': gname
                }));
                
                added = true;
            }
        }
    }
    
    if (!added) {
        window.localStorage.setItem(oldestg, JSON.stringify({
            'summoner': summoner,
            'region': region,
            'date': new Date().getTime(),
            'id': oldestg
        }));
    }
                                        
    $.ajax({
        url: "http://intoleague.herokuapp.com/summoner/" + region + "/" + summoner,
        dataType: (computer) ? 'jsonp' : 'json',
        cache: false,
        success: function(data){
            matchData = data;
            
            if (data.error != undefined && data.error != "pls_wait") gotoScreen("errorScreen", data);
            else if (data.error != undefined && data.error == "pls_wait") setTimeout(function() { search(summ, region) }, 1200);
            else gotoScreen("playersListScreen", data);
        },
        error: function(xhr, txt, err) {
            gotoScreen("errorScreen", {'error': 'app_error'});
        }
    });
}
 
function onBackKeyDown() { 
    if (cscreen == "searchScreen") navigator.app.exitApp();
    if (cscreen == "playersListScreen") gotoScreen("searchScreen", getHistory());
    if (cscreen == "playerScreen") gotoScreen("playersListScreen", matchData);
    if (cscreen == "errorScreen") gotoScreen("searchScreen", getHistory());
    return true;
}

var app = {
    initialize: function() {
        this.bindEvents();
    },

    bindEvents: function() {
        if (navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/)) {
            computer = false;
            document.addEventListener("deviceready", this.onDeviceReady, false);
        } else {
            app.onDeviceReady();
        }
    },

    onDeviceReady: function() {
        showAds();
        registerHelpers();
        registerClicks();
        
        document.addEventListener("backbutton", onBackKeyDown, false);
        
        var d = getHistory();
        gotoScreen("searchScreen", d);
        
        var lastRegion = window.localStorage.getItem("region");
        selectRegion(lastRegion || "EUW");
    }
};