//published unter the terms of the Mozilla Public License (MPL) v2.0

var inv_alpha;
var inv_beta ;
var inv_gamma;

var scale_values;

function on_load(){
  on_resize();
  
  localize();
  
  inv_alpha = localStorage.getItem("inv_alpha");
  if(inv_alpha == null){
    inv_alpha = true;
    localStorage.setItem("inv_alpha",inv_alpha);
  }
  if(inv_alpha == "false")
    inv_alpha = false;
  else
    inv_alpha = true;
  if(inv_alpha == true)
    document.getElementById("inv_alpha").setAttribute("checked", true);
  
  
  
  inv_beta  = localStorage.getItem("inv_beta" );
  if(inv_beta  == null){
    inv_beta  = true;
    localStorage.setItem("inv_beta" ,inv_beta );
  }
  if(inv_beta  == "false")
    inv_beta  = false;
  else
    inv_beta = true;
  if(inv_beta  == true)
    document.getElementById("inv_beta" ).setAttribute("checked", true);
  
  
  
  inv_gamma = localStorage.getItem("inv_gamma");
  if(inv_gamma == null){
    inv_gamma = true;
    localStorage.setItem("inv_gamma",inv_gamma);
  }
  if(inv_gamma == "false")
    inv_gamma = false;
  else
    inv_gamma = true;
  if(inv_gamma == true)
    document.getElementById("inv_gamma").setAttribute("checked", true);
  
  
  scale_values = localStorage.getItem("scale_values");
  if(scale_values == null){
    scale_values = true;
    localStorage.setItem("scale_values",scale_values);
  }
  if(scale_values == "false")
    scale_values = false;
  else
    scale_values = true;
  if(scale_values == true)
    document.getElementById("scale_values").setAttribute("checked", true);
  
  draw_scale_values();
  
}
window.addEventListener("load", on_load);


function on_click_open_settings(){
  document.getElementById("settings")           .setAttribute("class", "settings_visible"  );
  document.getElementById("open_settings_table").setAttribute("class", "settings_invisible");
}
document.getElementById("open_settings").addEventListener("click",on_click_open_settings);

function on_click_close_settings(){
  document.getElementById("settings")           .setAttribute("class", "settings_invisible");
  document.getElementById("open_settings_table").setAttribute("class", "settings_button"   );
  
  inv_alpha = document.getElementById("inv_alpha").checked;
  inv_beta  = document.getElementById("inv_beta" ).checked;
  inv_gamma = document.getElementById("inv_gamma").checked;
  localStorage.setItem("inv_alpha",inv_alpha);
  localStorage.setItem("inv_beta" ,inv_beta );
  localStorage.setItem("inv_gamma",inv_gamma);

  scale_values = document.getElementById("scale_values").checked;
  localStorage.setItem("scale_values",scale_values);
  
  draw_scale_values();
}
document.getElementById("close_settings").addEventListener("click",on_click_close_settings);


function draw_scale_values(){
  if(scale_values){
    document.getElementById("compass_group_inner" ).setAttribute("transform","scale(0.85)");
    document.getElementById("compass_scale_values").setAttribute("class"    ,"compass_scale_values_visible");
  }
  else{
    document.getElementById("compass_group_inner" ).setAttribute("transform","scale(1)");
    document.getElementById("compass_scale_values").setAttribute("class"    ,"compass_scale_values_invisible");
  }
}


function deviceOrientationEvent(eventData) {
  //skew left and right
  var alpha = eventData.alpha;
  if(!inv_alpha)
    alpha *= -1;
  document.getElementById("compass_needle").setAttribute("transform", "rotate("+alpha+")");
  
  //front to back - neg back postive front
  var beta = eventData.beta;
  if(inv_beta)
    beta *= -1;
  
  //roll left positive roll right neg
  var gamma = eventData.gamma;
  if(inv_gamma)
    gamma *= -1;
  
  var hbeta =beta;
  var hgamma=gamma;
  
  if(hbeta > 90)
    hbeta  =  180 - hbeta;
  if(hbeta <-90)
    hbeta  = -180 - hbeta;

  if(hgamma> 90)
    hgamma =  180 - hgamma;
  if(hgamma<-90)
    hgamma = -180 - hgamma;
  
  hbeta *=75/90;
  hgamma*=75/90;
  
  document.getElementById("bubble").setAttribute("transform", "translate("+hgamma+","+hbeta+")");
  
  alpha = Math.round(alpha);
  beta = Math.round(beta);
  gamma = Math.round(gamma);
  
  document.getElementById("val_alpha").textContent = alpha+"°";
  document.getElementById("val_beta" ).textContent = beta +"°";
  document.getElementById("val_gamma").textContent = gamma+"°";
  
  //console.log("alpha = " + alpha + " beta = " + beta + " gamma = " + gamma + " absolute = "+eventData.absolute);
}
window.addEventListener('deviceorientation', deviceOrientationEvent);


/*function deviceMotionEvent(eventData){
    var acc = eventData.accelerationIncludingGravity;
    var x = acc.x;
    var y = acc.y;
    var z = acc.z;
    document.getElementById("acc").innerHTML = "x = "+x+"<br/>y = "+y+"<br/>z = "+z;
}
window.addEventListener('devicemotion', deviceMotionEvent);*/


function geo_success(position) {
  var neg_lat=1;
  if(position.coords.latitude<0)
    neg_lat*-1;
  lon_min=(position.coords.longitude        -Math.floor(position.coords.longitude        ))*60;
  lat_min=(position.coords.latitude *neg_lat-Math.floor(position.coords.latitude *neg_lat))*60;
  lon_sec=Math.floor((lon_min-Math.floor(lon_min))*60);
  lat_sec=Math.floor((lat_min-Math.floor(lat_min))*60);
  lon_min=Math.floor(lon_min);
  lat_min=Math.floor(lat_min);
  
  document.getElementById("val_lon").textContent = Math.floor(position.coords.longitude        )        +"°"+lon_min+"'"+lon_sec+"''";
  document.getElementById("val_lat").textContent = Math.floor(position.coords.latitude *neg_lat)*neg_lat+"°"+lat_min+"'"+lat_sec+"''";
}
function geo_error() {
  document.getElementById("val_lon").textContent = "-";
  document.getElementById("val_lat").textContent = "-";
}
var watchID = navigator.geolocation.watchPosition(geo_success, geo_error, {enableHighAccuracy: true, maximumAge: 30000, timeout: 27000});
