//ajustes generales
document.addEventListener('deviceready', function() {
	FastClick.attach(document.body);
}, false);      
$.mobile.allowCrossDomainPages = true;
$.mobile.defaultPageTransition = 'none';

$.ajaxSetup({
	type: "POST",
	xhr: function(){return new window.XMLHttpRequest(
		{mozSystem: true})
	},
	crossDomain: true,
	async: true,
	beforeSend: function(){block()},
	complete: function(){unblock()},
	error: function(){alert("No se ha podido conectar al servidor")},
});

function block(){
	$('#bloqueador').show();
}
	
function unblock(){
	$('#bloqueador').hide();
}

function isMail(email){
	var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	return regex.test(email);
}

function show_eventos(id, limit, data){
	$(id).empty();
	var n = data.length;
	
	if(n==0) {
		var cad = '<li><a href="#crear"><h3>Aún no hay eventos</h3><p>Crea uno</p></a></li>';
		$(id).append(cad);
		$(id).listview('refresh');
		return;
	}
	
	for(var i=0;i<n;i++){
		var temp = data[i];
		
		var h = temp[7].split(":");
		var dia = new Date(temp[3], (temp[2]-1), temp[1], h[0], h[1], 0);

		if(dia<limit){
			var fin = "Ya empezado";
		}
		else{
			h = dia.getDay(); 
			var fin = dias_semana[h]+", "+temp[1]+" de "+array_meses[(temp[2])];
		}
		
		var cad = '<li class="ui-li-has-thumb" dia="'+fin+'" idev="'+temp[0]+'"><a>';
			if(temp[10]==0){//no hay preview
				cad += '<img src="img/c'+temp[11]+'.jpg"/>';
			}
			else{//si hay preview
				cad += '<div class="ui-li-thumb" style="background-image:url('+"'http://m.ipartyspain.es/previews/preview"+temp[0]+"_thumb.jpg'"+')"></div>';
			}
			cad +='<h2>'+array_categorias[temp[4]]+' <span class="en_rojo">'+temp[5]+'</span></h2><p><strong><span class="en_rojo">'+temp[7]+'</span> '+temp[6]+'</strong></p><p>'+temp[8]+'</p><p class="ui-li-aside"><strong>'+temp[9]+'</strong> personas</p></a></li>';
		$(id).append(cad);
	}
	$(id).listview('refresh');
	
	$('.ui-li-has-thumb').click(function(){
		var x = $(this).attr("idev");
		ver_evento(x);
	})
}

$('#div_preview').on("click", function(){
	$(this).hide();
});






//registro
$('#form_login').submit(function(){
		var lmail = $('#lmail').val();
		var lpass = $('#lpass').val();
        var err = 0;
        $('#form_login .input_err').removeClass("input_err");

        if(lmail == "" || !isMail(lmail)){
            $('#lmail').parent().addClass("input_err");
            err=1;
		}
                            
        if(lpass == ""){
            $('#lpass').parent().addClass("input_err");
            err=1;
        }
		
        if(err==1){
			return false;
        }
        
		var shaObj = new jsSHA(lpass, "TEXT");
		lpass = shaObj.getHash("SHA-512", "HEX");

		$.ajax({
			url: "http://m.ipartyspain.es/phpM/loginFF.php",
			data: {
		   		m: lmail,
		   		p: lpass,
		   		},
			success: function(data){
				var n = data[0];
				switch (n){
					case 1:
						localStorage.user_mail = lmail;
						localStorage.auth = data[1];
						localStorage.esFB = 0;
						$.mobile.navigate("#main");
					  break;
					case 2:
					 alert("Ese mail no existe");
					  $('#lmail').val("");
					  $('#lpass').val("");
					  break;
					case 3:
					 alert("Contraseña incorrecta");
					  $('#lpass').val("");
					  break;
					case 4:
					 alert("Cuenta bloqueada. Intentalo de nuevo en 2 horas");
					  $('#lmail').val("");
					  $('#lpass').val("");
					  break;
					default:
					  alert("Error desconocido");
					  break;
				}
				return false;
			}
		});
		return false;
	})
    
$('#form_registro').submit(function(){
		var err = 0;
		
		$('#form_registro .input_err').removeClass("input_err");

		var jn = $('#rusuario').val();
		var jm = $('#rmail').val();
		var p = $('#rpass').val();
		var p2 = $('#rpass2').val();
		
		if(jn == "" || jn.length<5 || jn.length > 20){
			$('#rusuario').parent().addClass("input_err");
			err = 1;
		}
		
		if(jm == "" || jm.length<5 || jm.length > 50 || !isMail(jm)){
			$('#rmail').parent().addClass("input_err");
			err = 1;
		}
		
		if(p == "" || p2 == "" || p.length<5 || p.length > 20 || p2.length<5 || p2.length > 20 || p2 != p){
			$('#rpass').parent().addClass("input_err");
			$('#rpass2').parent().addClass("input_err");
			err = 1;
		}
		
		if(!$("#rcheck").is(':checked')){
			$('#form_registro .ui-checkbox label').addClass("input_err");
			err = 1;
		}

		if(err == 1){
			return false;
		}
		
		var shaObj = new jsSHA(p, "TEXT");
		var pwd = shaObj.getHash("SHA-512", "HEX");
		
		
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/regFF.php",
			data: { 
		   		u: jn,
		   		m: jm,
		   		p: pwd,
		   		},
			success: function(data, status){
				if(data == -1){
					alert("Ese nombre de usuario ya existe");
				}
				else if(data == -2){
					alert("Esa cuenta de correo ya existe");
				}
				else{
					localStorage.user_mail = jm;
					localStorage.auth = data;
					$.mobile.navigate("#main");
				}
			}
		});
		return false;
	});
    
$('#reg_log').click(function(){
	$('#form_registro').hide();
	$('#form_login').show();
})
	
$('#reg_reg').click(function(){
	$('#form_registro').show();
	$('#form_login').hide();
})

$('#FBlogin_btn').click(function(){
	alert("Proximamente");
	return;
})
    
	

//main
var auto_refresh;
var ultimo = 1;
var geo_options = {
  enableHighAccuracy: false, 
  maximumAge        : 30000, 
  timeout           : 15000
};

function positionOK(pos){
	localStorage.mycx = pos.coords.latitude;
	localStorage.mycy = pos.coords.longitude;
	carga_eventos(ultimo);
}
    
function positionFAIL(error){
   alert("No se ha podido detectar tu ubicación");
   localStorage.mycx = 0;
   localStorage.mycy = 0;
   carga_eventos(ultimo);
}

$("#rango").on("change",function(){
	localStorage.last_rango = $("#rango").val();
	carga_eventos(ultimo);
});

function carga_eventos(id){
	ultimo = id;
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/index_finalv2FF.php",
		data: {
			dia: id,
			cx: localStorage.mycx,
			cy: localStorage.mycy,
			d: localStorage.last_rango,
		},
		success: function(data){
			switch(id){
				case 1:
				  var ahora = new Date();
				  break;
				case 2:
				  var ahora = new Date();
				  ahora= new Date(ahora.getFullYear(), ahora.getMonth(), ahora.getDate()+1, 0,0,0);
				  break;
				case 3:
				  var ahora = new Date();
				   ahora= new Date(ahora.getFullYear(), ahora.getMonth(), ahora.getDate()+2, 0,0,0);
				  break;
			}
			show_eventos('#lista_eventos', ahora, data);
		}
	})
}

$('#sel1').click(function(){
	carga_eventos(1);
})

$('#sel2').click(function(){
	carga_eventos(2);
})

$('#sel3').click(function(){
	carga_eventos(3);
})




//evento
var cargando;

function ver_evento(id){
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/recupera1v2FF.php",
		data: {
			c: id,
			mail: localStorage.user_mail,
			auth: localStorage.auth,
		},
		success: function(data){
			if(data == -1){
				alert("Error al cargar evento");
				return;
			}
			cargando = 1;
			sessionStorage.idevento=id;
			$('#controles_evento').hide();
			$('#btn_denunciar').show();
			$('#e_tit').html("<span class='palface'>"+data[0]+"</span><br><span class='autor'>de "+data[1]+"</span>");
			var cad = parseInt(data[3])+1;
			cad = data[2]+" de "+array_meses[cad]+" de "+ data[4];
			$('#e_dia').text(cad);
			$('#e_dur').text(data[5]+" - "+data[6]);
			$('#e_lug').text(data[7]);
			sessionStorage.cx=data[8];
			sessionStorage.cy=data[9];
			$('#desc').text(data[10]);
			$('#e_np').text(data[11]+" asistentes");
			if(data[12]){
				sessionStorage.haspreview=1;
				$('#ev_preview').css("background-image", "url(http://m.ipartyspain.es/previews/preview"+id+"_thumb.jpg)");
			}
			else{
				sessionStorage.haspreview=0;
				$('#ev_preview').css("background-image", "url(img/c"+data[15]+".jpg)");
			}
			if(data[13]){//es_mio
				$('#controles_evento').show();
				$('#controles_evento2').hide();
				$('#btn_denunciar').hide();
				sessionStorage.nombre=data[0];
				sessionStorage.info=data[10];
				sessionStorage.prov=data[16];
				sessionStorage.fecha=data[4]+"/"+(data[3]+1)+"/"+data[2]+" "+data[5]+":00";
				sessionStorage.dura=data[18];
				sessionStorage.scat=data[17];
				sessionStorage.lugar=data[7];
			}
			else if(data[14]==1){//lo tengo añadido
				$('#flip-select').val(1).flipswitch("refresh");
				$('#controles_evento2').show();
			}
			else{//no tengo añadido
				$('#flip-select').val(0).flipswitch("refresh");
				$('#controles_evento2').show();
			}
			$.mobile.navigate('#evento');
			cargando = 0;	
		}
	});
}

$('#flip-select').flipswitch();

$('#ev_preview').on("click", function(){
	if(sessionStorage.haspreview == 1){
		$('#div_preview').css("background-image","url(http://m.ipartyspain.es/previews/preview"+sessionStorage.idevento+".jpg)");
		$('#div_preview').show();
	}
})

$('#e_lug').click(function(){
	var cad = 'http://maps.google.com/maps?q='+sessionStorage.cx+","+sessionStorage.cy;
	window.open(cad, '_blank', 'location=yes');
})

$('#sh_fb').click(function(){
	alert("Proximamente");
	return;
	var cad = "http://www.ipartyspain.es?ev="+sessionStorage.idevento;
	FB.ui(
	  {
	    method: 'feed',
	    name: $('#e_tit .palface').text(),
	    caption: cad,
	    link: cad,
	    picture: 'http://ipartyspain.es/img/logo_share.png',
	    description: $('#desc').text(),
	  }
	);
})

$('#flip-select').change(function(){
	if(cargando != 1){
		if($(this).val()==1){
			anyadir_evento()
		}
		else{
			desguardar_evento()
		}
	}
});

function anyadir_evento(){
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/add_eventFF.php",
		data: {
			c: sessionStorage.idevento,
			mail: localStorage.user_mail,
			auth: localStorage.auth,
		},
		success: function(data){
			if(data==1){
				var t = $('#e_np').text().split(" ");
				t = parseInt(t[0]);
				t++;
				$('#e_np').text(t+" asistentes");
			}
			else{
				cargando = 1;
				alert("No se ha podido añadir el evento");
				$('#flip-select').val(0).flipswitch("refresh");
				cargando = 0;
			}
		}
	});
}
	
function desguardar_evento(){
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/desguardarFF.php",
		data: {
			c: sessionStorage.idevento,
			mail: localStorage.user_mail,
			auth: localStorage.auth,
		},
		success: function(data){
			if(data==1){
				var t = $('#e_np').text().split(" ");
				t = parseInt(t[0]);
				t--;
				$('#e_np').text(t+" asistentes");
			}
			else{
				cargando = 1;
				alert("No se ha podido desañadir el evento");
				$('#flip-select').val(1).flipswitch("refresh");
				cargando = 0;
			}
		}
	});
}

$('#borrar_evento').click(function(){
	$('#confirmame_borrar').show();
})

$('#confirmo_borrar').click(function(){
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/borrarFF.php",
		data: {
	   		cod: sessionStorage.idevento,
	   		mail: localStorage.user_mail,
			auth: localStorage.auth,
   		},
		success: function(data){
			if(data==1){
				alert("Borrado correctamente");
				history.back();
			}
			else{
				alert("No se ha podido borrar");
			}
			$('#confirmame_borrar').hide();
		}
	});
})

$('#cancelo_borrar').click(function(){
	$('#confirmame_borrar').hide();
})

$('#btn_denunciar').click(function(){
	$('#confirmame_denunciar').show();
})

$('#confirmo_denunciar').click(function(){
	$.ajax({
		url: "http://m.ipartyspain.es/phpM/denunciarFF.php",
		data: {
	   		cod: sessionStorage.idevento,
	   		mail: localStorage.user_mail,
			auth: localStorage.auth,
   		},
		success: function(data){
			if(data==1){
				alert("Denunciado correctamente");
				history.back();
			}
			else{
				alert("No se ha podido denunciar");
			}
			$('#confirmame_denunciar').hide();
		}
	});
})

$('#cancelo_denunciar').click(function(){
	$('#confirmame_denunciar').hide();
})

$('#editar_evento').click(function(){
	editar_clk = 1;
	$.mobile.navigate('#editar');
})








//editar
var editar_clk = 0;
$('#edit_sin_foto').click(function(){
	    $('#ec_has_preview').val(0);
	    $('#ec_preview_mod').val(1);
	    $('#ec_preview').css("background-image", "url('img/no-image.png')");
    })

$('#edit_elige_foto').click(function(){
    navigator.camera.getPicture(onEditCameraSuccess, onCameraFail, {
		saveToPhotoAlbum: false,
	});
})

function onEditCameraSuccess(blobimg){
	$('#ec_has_preview').val(1);
	$('#ec_preview_mod').val(1);
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	var img = new Image;
	
	img.crossOrigin = 'Anonymous';
	img.onload = function(){
        canvas.height = img.height;
        canvas.width = img.width;
        ctx.drawImage(img,0,0);
        var dataURL = canvas.toDataURL('image/jpeg', 0.3);
        unblock();
        $("#ec_preview").css("background-image",'url('+dataURL+')');
        canvas = null;
        img = null;
    };
	img.src=blobimg;
	block();
}

$('#limpiar_editar').click(function(){
	$('#form_editar .input_err').removeClass("input_err");
	$('#ecnombre').val("");
	$('#ecdesc').val("");
	$('#eclugar').val("");
	$("#ec_cx").val("");
	$("#ec_cy").val("");
	$("#ec_prov").val("");
	$('#ec_fecha').val("");
	$('#ec_hora').val("");
	$("#eslider").val("8").slider('refresh');
	$("#eccat").prop('selectedIndex', 0).selectmenu('refresh');
	$('#edit_sin_foto').click();
})

$('#form_editar').submit(function(){
		var err = 0;
		
		$('#form_editar .input_err').removeClass("input_err");
		
		
		var n = $('#ecnombre').val();
		if(n == ""){
			$('#ecnombre').parent().addClass("input_err");
			err = 1;
		}
		
		var d = $('#ecdesc').val();
		if(d == ""){
			err = 1;
			$('#ecdesc').parent().addClass("input_err");
		}
		
		var l = $('#eclugar').val();
		var cxi = $('#ec_cx').val();
		var cyi = $('#ec_cy').val();
		var provi = $('#ec_prov').val();
		
		if(l == "" || cxi == "" || cyi == "" || provi == "" || provi == -1){
			$('#eclugar').parent().addClass("input_err");
			err = 1;
		}
		
		var fi = $('#ec_fecha').val();
		var hi = $('#ec_hora').val();
		
		if(hi == "" || fi == ""){
			err = 1;
			$('#ec_fecha').parent().addClass("input_err");
			$('#ec_hora').parent().addClass("input_err");
		}
		else{
			fi = fi.split("/");
			fi = fi[2]+"/"+fi[1]+"/"+fi[0]+" "+hi+":00";
			if(new Date(fi)<new Date()){
				err = 1;
				$('#ec_fecha').parent().addClass("input_err");
				$('#ec_hora').parent().addClass("input_err");
			}
		}
		
		var cat = $('#eccat').val();
		if(cat == 0){
			err = 1;
			$('#eccat').parent().addClass("input_err");
		}

		if(err == 1){
			return;
		}

		if($('#ec_has_preview').val()==1){
			if($('#ec_preview_mod').val()==0){
				var imagen = "imagen";
			}
			else{
				var imagen = $('#ec_preview').css("background-image");
				//navigator.app.clearCache();
			}
		}
		else{
			var imagen = 0;
		}
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/editarv2FF.php",
			data: {
				mail: localStorage.user_mail,
				auth: localStorage.auth,
		   		nombre: n,
		   		desc: d,
		   		ini: fi,
		   		duracion: $('#eslider').val(),
		   		lugar: l,
		   		cat: cat,
		   		cx: cxi,
		   		cy: cyi,
		   		prov: provi,
		   		img:imagen,
		   		mod:$('#ec_preview_mod').val(),
		   		evento: sessionStorage.idevento
	   		},
			success: function(data){
				if(data==1){
					alert("Evento editado correctamente");
					modo_edicion = 0;
					ver_evento(sessionStorage.idevento);
				}
				else{
					alert("No se ha podido editar");
				}
			}
		});	
		return false;
	});

$('#eclugar').click(function(){
	modo_edicion=1;
	$.mobile.navigate('#mapa');
})





//crear
$('#sin_foto').click(function(){
    $('#c_has_preview').val(0);
    $('#c_preview').css("background-image", "url('img/no-image.png')");
})
    
$('#elige_foto').click(function(){
    navigator.camera.getPicture(onCameraSuccess, onCameraFail, {
		saveToPhotoAlbum: false,
	});
})

function onCameraSuccess(blobimg){
	$('#c_has_preview').val(1);
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	var img = new Image;
	
	img.crossOrigin = 'Anonymous';
	img.onload = function(){
        canvas.height = img.height;
        canvas.width = img.width;
        ctx.drawImage(img,0,0);
        var dataURL = canvas.toDataURL('image/jpeg', 0.3);
        unblock();
        $("#c_preview").css("background-image",'url('+dataURL+')');
        canvas = null;
        img = null;
    };
	img.src=blobimg;
	block();
}

function onCameraFail(){
    alert("No has elegido ninguna foto");
}
		
$('#limpiar_crear').click(function(){
	$('#form_crear .input_err').removeClass("input_err");
	$('#cnombre').val("");
	$('#cdesc').val("");
	$('#clugar').val("");
	$("#c_cx").val("");
	$("#c_cy").val("");
	$("#c_prov").val("");
	$('#c_fecha').val("");
	$('#c_hora').val("");
	$("#slider").val("8").slider('refresh');
	$("#ccat").prop('selectedIndex', 0).selectmenu('refresh');
	$('#sin_foto').click();
});

$('#clugar').click(function(){
	modo_edicion=0;
	$.mobile.navigate('#mapa');
})
    
$('#form_crear').submit(function(){
		var err = 0;
		$('#form_crear .input_err').removeClass("input_err");
		
		var n = $('#cnombre').val();
		if(n == ""){
			$('#cnombre').parent().addClass("input_err");
			err = 1;
		}
		
		var d = $('#cdesc').val();
		if(d == ""){
			err = 1;
			$('#cdesc').parent().addClass("input_err");
		}
		
		var l = $('#clugar').val();
		var cxi = $('#c_cx').val();
		var cyi = $('#c_cy').val();
		var provi = $('#c_prov').val();
		
		if(l == "" || cxi == "" || cyi == "" || provi == "" || provi == -1){
			$('#clugar').parent().addClass("input_err");
			err = 1;
		}
		
		var fi = $('#c_fecha').val();
		var hi = $('#c_hora').val();
		
		if(hi == "" || fi == ""){
			err = 1;
			$('#c_fecha').parent().addClass("input_err");
			$('#c_hora').parent().addClass("input_err");
		}
		else{
			fi = fi.split("/");
			fi = fi[2]+"/"+fi[1]+"/"+fi[0]+" "+hi+":00";
			if(new Date(fi)<new Date()){
				err = 1;
				$('#c_fecha').parent().addClass("input_err");
				$('#c_hora').parent().addClass("input_err");
			}
		}
		
		var cat = $('#ccat').val();
		if(cat == 0){
			err = 1;
			$('#ccat').parent().addClass("input_err");
		}
		
		if(err == 1){
			return false;
		}
		if($('#c_has_preview').val()==1){
			var imagen = $('#c_preview').css("background-image");
		}
		else{
			var imagen = 0;
		}
		
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/crearv2FF.php",
			data: {
				mail: localStorage.user_mail,
				auth: localStorage.auth,
		   		nombre: n,
		   		desc: d,
		   		ini: fi,
		   		duracion: $('#slider').val(),
		   		lugar: l,
		   		cat: cat,
		   		cx: cxi,
		   		cy: cyi,
		   		prov: provi,
		   		img: imagen
	   		},
			success: function(data){
				if(data>0){
					alert("Evento creado correctamente");
					ver_evento(data);
					return false;
				}
				else{
					alert("No se ha podido crear el evento");
				}
			}
		});
		
		return false;
	});


//mapa google
var modo_edicion = 0;

$('#map_text').change(function(){
	var address = $(this).val();
	
	if(address=="" || address.replace(/ /g,'').length == 0){
		return;
	}
	
	var mapIframe = document.getElementById('iframe_map');
	mapIframe.contentWindow.postMessage(address, '*');
});

window.addEventListener('message', mensajedeiframe, false);

function mensajedeiframe(msg){
	if(msg.data == "cancelado"){
		if(modo_edicion==1){
			$('#ec_cx').val("");
			$('#ec_cy').val("");
			$('#ec_prov').val("");
			$('#eclugar').val("");
			$.mobile.navigate("#editar");
		}
		else{
			$('#c_cx').val("");
			$('#c_cy').val("");
			$('#c_prov').val("");
			$('#clugar').val("");
			$.mobile.navigate("#crear");
		}
	}
	else{
		var data = JSON.parse(msg.data);
		if(modo_edicion==1){
			$('#ec_cx').val(data[2]);
			$('#ec_cy').val(data[3]);
			$('#ec_prov').val(data[1]);
			$('#eclugar').val(data[0]);
			$.mobile.navigate("#editar");
		}
		else{
			$('#c_cx').val(data[2]);
			$('#c_cy').val(data[3]);
			$('#c_prov').val(data[1]);
			$('#clugar').val(data[0]);
			$.mobile.navigate("#crear");
		}
	}
	
}


//ajustes
$('#enviar_sug').click(function(){
	var sug = $('#sugerencia').val();
	if(sug == ""){
		$('#sugerencia').parent().addClass("input_err");
	}
	else{
		$('#sugerencia').parent().removeClass("input_err");
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/sugFF.php",
			data: {
				texto: sug,
				mail: localStorage.user_mail,
				auth: localStorage.auth,
		   		},
			success: function(data){
				if(data == 1){
	                alert("Sugerencia enviada");
                    $('#sugerencia').val("");
				}
			}
		})
	}
})

$('#logout').click(function(){
	localStorage.clear();
	$.mobile.navigate("#registro");
})



//mis eventos
var m;
var a;
var arr_lista;
var arr_eventos;

function ini_miseventos(){
	m = new Date().getMonth();
	a = new Date().getFullYear();
	llena_calendario();
}

function llena_calendario(){
	$('#mios_resultados').empty();
	$('#mis_eventos #tabla_calendario .valido .marcado').removeClass("marcado");
	$('#mis_eventos #tabla_calendario .valido .hay_eventos').removeClass('hay_eventos');
	$("#mes_nombre").text(array_meses[(m+1)]+" "+a);
	//pintar casillas
	var inicial = new Date(a, m, 1).getDay();
	if(inicial == 0){
		inicial = 7;
	}
	var ndias = new Date(a, m+1, 0).getDate();
	
	$('#mis_eventos #tabla_calendario .valido td').css("background","transparent");
	$('#mis_eventos #tabla_calendario .valido td').text("");
	
	
	for(i=0;i<ndias;i++){
		cad = "#"+(i+inicial);
		$(cad).text(i+1);
	}
	//pintar casillas
	$.ajax({
			url: "http://m.ipartyspain.es/phpM/guardadosFF.php",
			data: {
		   		mes:m,
		   		anyo:a,
		   		mail: localStorage.user_mail,
				auth: localStorage.auth,
	   		},
			success: function(data){
				var tmp = data[0];
				arr_lista = data[1];
				arr_eventos = data[2];
				
				for (var i=0;i<=ndias;i++){
					var cad = "#"+(i+inicial-1);
					if(tmp[i]==1){//mios
						$(cad).css("background","red");
						$(cad).addClass('hay_eventos');
					}
					else if(tmp[i]==2){//added
						$(cad).css("background","#ccdc00");
						$(cad).addClass('hay_eventos');
					}
					else if(tmp[i]==3){//ambos
						$(cad).css("background","-webkit-gradient(linear,left top,right bottom,color-stop(0.5, #FF0000),color-stop(0.5, #CDDC00))");
						$(cad).addClass('hay_eventos');
					}
				}
			}
		});
}

$('.valido td').click(function(){
	if($(this).hasClass('hay_eventos')){
		$('#tabla_calendario .marcado').removeClass("marcado");
		$(this).addClass("marcado");
		$('#mios_resultados').empty();
		var z = $(this).text();
		
		var n = arr_lista[z].length;
		for(var i = 0;i<n;i++){
			var j = arr_lista[z][i];
			var tmp = arr_eventos[j];
			if(tmp[2]==0){//no es mio, verde
				var cad = '<li><a ver_evento="'+tmp[0]+'"><span class="en_verde">'+tmp[3]+"</span> "+tmp[1]+'</a></li>';
			}
			else{//es mio, rojo
				var cad = '<li><a ver_evento="'+tmp[0]+'"><span class="en_rojo">'+tmp[3]+"</span> "+tmp[1]+'</a></li>';
			}
			$('#mios_resultados').append(cad);
		}
		$('#mios_resultados').listview('refresh');
		
		$('#mios_resultados li a').click(function(){
			var z = $(this).attr("ver_evento");
			ver_evento(z);
		})
		
		
	}
})

$('#mes_mas').click(function(){
	if(m==11){
		m=0;
		a++;
	}
	else m++;
	
	$("#mes_menos").css("visibility","visible");
	llena_calendario();
})

$('#mes_menos').click(function(){
	if(m==0){
		m=11;
		a--;
	}
	else m--;
	
	var cal = new Date(a,m,1);
	var act = new Date();
	act = new Date(act.getFullYear(), act.getMonth(), 1)

	if(cal<=act){
		$("#mes_menos").css("visibility","hidden");
	}

	llena_calendario();
})






//busqueda
$('#form_busqueda').submit(function(){

		$('#form_busqueda .input_err').removeClass("input_err");
		$('#lista_busqueda').empty();
		
		var jf1 = $('#bfecha').val();
		var jf2 = $('#bfecha2').val();

		if(jf1 == "" || jf2 == ""){
			$('#bfecha').parent().addClass("input_err");
			$('#bfecha2').parent().addClass("input_err");
			return false;
		}
		else{
			if(new Date(jf1+" 00:00:00")>new Date(jf2+" 00:00:00")){
				$('#bfecha').parent().addClass("input_err");
				$('#bfecha2').parent().addClass("input_err");
				return false;
			}
		}
		
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/busquedav2FF.php",
			data: { 
		   		n: $('#bnombre').val(),
		   		f1: jf1,
		   		f2: jf2,
		   		cat: $('#bcat').val(),
		   		prv: $('#bprov').val(),
	   		},
			success: function(data){
				show_eventos('#lista_busqueda',new Date(), data);
				var tam_header = $('#busqueda [data-role|=header]').height();
				$('html, body').animate({
					scrollTop: ($("#lista_busqueda").offset().top - tam_header)
				}, 500);
			}
		});
		return false;
	});

$('#form_top5 a').click(function(){
	if($(this).hasClass('btn_hard')){
		return;
	}
	$('#form_top5 .btn_hard').removeClass("btn_hard");
	$(this).addClass("btn_hard");
	var id=$(this).attr("top5");
	$.ajax({
			url: "http://m.ipartyspain.es/phpM/top5v2FF.php",
			data: { 
		   		i: id,
	   		},
			success: function(data){
				show_eventos('#lista_busqueda',new Date, data);
				var tam_header = $('#busqueda [data-role|=header]').height();
				$('html, body').animate({
					scrollTop: ($("#lista_busqueda").offset().top - tam_header)
				}, 500);
			}
		});
	
})
	
function limpiar_busqueda(){
		$('#bnombre').val("");
		$('#bfecha').val("").parent().removeClass("input_err");
		$('#bfecha2').val("").parent().removeClass("input_err");
		$("#bprov").prop('selectedIndex', 0).selectmenu("refresh", true);
		$('#lista_busqueda').empty();
		$('#form_top5 .btn_hard').removeClass("btn_hard");
	}
	
$('#avanzada').click(function(){
	$('#form_busqueda').show();
	$('#form_top5').hide();
})
	
$('#top5').click(function(){
	$('#form_busqueda').hide();
	$('#form_top5').show();
})






$(document).on("pagebeforeshow", "#registro", function(){
	if(localStorage.auth != undefined && localStorage.user_mail != undefined){
		$.ajax({
			url: "http://m.ipartyspain.es/phpM/first_log.php",
			data: {
		   		u: localStorage.user_mail,
		   		t: localStorage.auth,
		   		f: localStorage.esFB,
		   		},
			success: function(data){
				if(data==1989){
					alert("Necesitas actualizar iPartySpain desde Play Store para continuar");
					return;
				}
				else if(data==-1){//sesion incorrecta
					localStorage.clear();
				}
				else if(data==0){//ya estaba la sesion
					$.mobile.navigate("#main");
				}
				else if(data.length == 32){//sesion renovada
					localStorage.auth = data;
					$.mobile.navigate("#main");
				}
			}
		});
	}
});

$(document).on("pageinit", "#main", function(){
	$("#lista_eventos").listview({
        autodividers: true,
		autodividersSelector: function (li) {
	    	var out = li.attr("dia");
	        return out;
	    }
	});
	
	if(localStorage.getItem("last_rango") === null){
		localStorage.last_rango = 3;
	}
	else{
		$("#rango").val(localStorage.last_rango).selectmenu('refresh');
	}
	
	if(localStorage.getItem("mycx") === null || localStorage.getItem("mycy") === null){
		//temporal
		positionOK(5);
		return;
		block();
		navigator.geolocation.getCurrentPosition(positionOK, positionFAIL, geo_options);
	}
	else{
		carga_eventos(1);
	}
});

$(document).on("pagebeforehide", "#main", function(){
	clearInterval(auto_refresh);
});

$(document).on("pagebeforeshow", "#main", function(){
	var x = $('#main #sel'+ultimo).addClass("ui-btn-active");
	auto_refresh = setInterval(function(){navigator.geolocation.getCurrentPosition(positionOK, positionFAIL, geo_options)},300000);
});

$(document).on("pageinit", "#crear", function(){
	$("#slider").change(function() {
		var x = $(this).val();
		$('#slider_out').text(array_slider[x]);
	});
	
	$('#c_fecha').mobiscroll().date({
		theme: 'android-ics',
		minDate: new Date(),
	});
				
	$('#c_hora').mobiscroll().time({
		theme: 'android-ics',
		timeWheels: 'Hii',
		timeFormat: 'H:ii',
		stepMinute: 15,
	});
});

$(document).on("pagebeforeshow", "#ajustes", function(){
	$('#sugerencia').parent().removeClass("input_err");
	$('#sugerencia').val("");
});

$(document).on("pageinit", "#mis_eventos", function(){
	$("#mios_resultados").listview({
        autodividers: true,
		autodividersSelector: function (li) {
	    	var out = li.attr("dia");
	        return out;
	    }
	});
	$('#mes_menos').css("visibility","hidden");
	ini_miseventos();
});

$(document).on("pageinit", "#busqueda", function(){
	$("#lista_busqueda").listview({
        autodividers: true,
		autodividersSelector: function (li) {
	    	var out = li.attr("dia");
	        return out;
	    }
	});
    
    $('#bfecha').mobiscroll().date({
        theme: 'android-ics',
        minDate: new Date(),
        onSelect: function(d, ins){
        	var x = d[3]+d[4]+"/"+d[0]+d[1]+"/"+d[6]+d[7]+d[8]+d[9];
        	x = new Date(x);
	        $('#bfecha2').mobiscroll('option', "minDate", x);
	        if($('#bfecha2').mobiscroll('getDate') < x || $('#bfecha2').val() == ""){
		        $('#bfecha2').val(d);
	        }
        },
    });

    $('#bfecha2').mobiscroll().date({
        theme: 'android-ics',
        minDate: new Date(),
    });

});

$(document).on("pageinit", "#editar", function(){
	$("#eslider").change(function() {
		var x = $(this).val();
		$('#eslider_out').text(array_slider[x]);
	});
	
	$('#ec_fecha').mobiscroll().date({
		theme: 'android-ics',
		minDate: new Date(),
	});
				
	$('#ec_hora').mobiscroll().time({
		theme: 'android-ics',
		timeWheels: 'Hii',
		timeFormat: 'H:ii',
		stepMinute: 15,
	});
});

$(document).on("pagebeforeshow", "#editar", function(){
	if(editar_clk==1){
		editar_clk = 0;
		$('#ecnombre').val(sessionStorage.nombre);
		$('#ecdesc').val(sessionStorage.info);
		$('#eclugar').val(sessionStorage.lugar);
		var x = new Date(sessionStorage.fecha);
		if(x>new Date()){
			$('#ec_fecha').mobiscroll('setDate', x, true);
			$('#ec_hora').mobiscroll('setDate', x, true);
		}
		$("#eslider").val(sessionStorage.dura).slider('refresh');
		$("#eccat").val(sessionStorage.scat).selectmenu('refresh');
		$("#ec_cx").val(sessionStorage.cx);
		$("#ec_cy").val(sessionStorage.cy);
		$("#ec_prov").val(sessionStorage.prov);
		$('#ec_preview_mod').val(0);
		if(sessionStorage.haspreview == 1){
			$('#ec_preview').css("background-image","url(http://m.ipartyspain.es/previews/preview"+sessionStorage.idevento+"_thumb.jpg)");
			$('#ec_has_preview').val(1);
		}
		else{
			$('#ec_preview').css("background-image","url('img/no-image.png')");
			$('#ec_has_preview').val(0);
		}
	}
});

$(document).on("pagebeforeshow", "#mapa", function(){
	$('#iframe_map').attr("src", "http://m.ipartyspain.es/FF/map.html")
});
