﻿//-----------------------------------------------------------------------------
//
// Load all layout templates
//
//-----------------------------------------------------------------------------
"use strict";

var gameprogressPuzzeListStartSize = 10;
var puzzlelistHasBeenResetted = false;
var useTempo = false;
var musicVolume = 0.40;
var soundVolumeFail = 1.00;    
var soundVolumeSuccess = 0.95;    
    
// Listener method
function clickHandlerAnswer(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.processAnswer(e.currentTarget,e.currentTarget.getAttribute('data-answer'));
	}
	else if(e.keyCode == 37 || e.keyCode == 38){   // Left -> previous answer
		if(e.target.id=="answer_img5"){
			$("#answer_img4").focus();
		}
		else if(e.target.id=="answer_img4"){
			$("#answer_img3").focus();
		}
		else if(e.target.id=="answer_img3"){
			$("#answer_img2").focus();
		}
		else if(e.target.id=="answer_img2"){
			$("#answer_img1").focus();
		}
		else if(e.target.id=="answer_img1"){
			$("#gotoPreviousPuzzle").focus();		
//			if($("#answer_img5")!=null){
//				if($("#answer_img5").is(":visible")){
//					$("#answer_img5").focus();
//				}
//				else if($("#answer_img4")!=null){
//					if($("#answer_img4").is(":visible")){
//						$("#answer_img4").focus();
//					}
//					else{
//						$("#answer_img3").focus();
//					}
//				}
//				else{
//					$("#answer_img3").focus();
//				}
//			}
//			else if($("#answer_img4")!=null){
//				if($("#answer_img4").is(":visible")){
//					$("#answer_img4").focus();
//				}
//				else{
//					$("#answer_img3").focus();
//				}
//			}
//			else{
//				$("#answer_img3").focus();
//			}
		}
		if(e.target.id=="answer_txt5"){
			$("#answer_txt4").focus();
		}
		else if(e.target.id=="answer_txt4"){
			$("#answer_txt3").focus();
		}
		else if(e.target.id=="answer_txt3"){
			$("#answer_txt2").focus();
		}
		else if(e.target.id=="answer_txt2"){
			$("#answer_txt1").focus();
		}
		else if(e.target.id=="answer_txt1"){
			$("#gotoPreviousPuzzle").focus();		
//			if($("#answer_txt5")!=null){
//				$("#answer_txt5").focus();
//			}
//			else if($("#answer_txt4")!=null){
//				$("#answer_txt4").focus();
//			}
//			else{
//				$("#answer_txt3").focus();
//			}
		}
	}
	else if(e.keyCode == 39 || e.keyCode == 40){   // Right -> next answer
		if(e.target.id=="answer_img1"){
			$("#answer_img2").focus();
		}
		else if(e.target.id=="answer_img2"){
			$("#answer_img3").focus();
		}
		else if(e.target.id=="answer_img3"){
			if($("#answer_img4")!=null){
				if($("#answer_img4").is(":visible")){
					$("#answer_img4").focus();
				}
				else{
					$("#answer_img1").focus();
				}
			}
			else{
				$("#answer_img1").focus();
			}
		}
		else if(e.target.id=="answer_img4"){
			if($("#answer_img5")!=null){
				if($("#answer_img5").is(":visible")){
					$("#answer_img5").focus();
				}
				else{
					$("#answer_img1").focus();
				}
			}
			else{
				$("#answer_img1").focus();
			}
		}
		else if(e.target.id=="answer_img5"){
			$("#answer_img1").focus();
		}
		else if(e.target.id=="answer_txt1"){
			$("#answer_txt2").focus();
		}
		else if(e.target.id=="answer_txt2"){
			$("#answer_txt3").focus();
		}
		else if(e.target.id=="answer_txt3"){
			if($("#answer_txt4")!=null){
				$("#answer_txt4").focus();
			}
			else{
				$("#answer_txt").focus();
			}
		}
		else if(e.target.id=="answer_txt4"){
			if($("#answer_txt5")!=null){
				$("#answer_txt5").focus();
			}
			else{
				$("#answer_txt1").focus();
			}
		}
		else if(e.target.id=="answer_txt5"){
			$("#answer_txt1").focus();
		}
	}
}

function clickHandlerPuzzleCell(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.gotoPuzzle(e.currentTarget.id);
	}
	else if(e.keyCode == 37){   // Left
		$('#gameprogressShowChartButton').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#resetGameProgressButton').focus();
	}
}

function clickHandlerPuzzleCellLocked(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.showPuzzleLockedInfo();
	}
	else if(e.keyCode == 37){   // Left
		$('#gameprogressShowChartButton').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#resetGameProgressButton').focus();
	}
}

function disableGameAnswers(isDisabled){
	if(!currentpuzzle){
		return;
	}
	if(isDisabled){
        if(currentpuzzle.answerIsText==true){
			$('#answer_txt1').data( 'tabindex', $('#answer_txt1').attr('tabindex') );
			$('#answer_txt1').removeAttr( 'tabindex' );
			$('#answer_txt1').css({'cursor':'default'});
			$('#answer_txt2').data( 'tabindex', $('#answer_txt2').attr('tabindex') );
			$('#answer_txt2').removeAttr( 'tabindex' );
			$('#answer_txt2').css({'cursor':'default'});
			$('#answer_txt3').data( 'tabindex', $('#answer_txt3').attr('tabindex') );
			$('#answer_txt3').removeAttr( 'tabindex' );
			$('#answer_txt3').css({'cursor':'default'});
			$('#answer_txt4').data( 'tabindex', $('#answer_txt4').attr('tabindex') );
			$('#answer_txt4').removeAttr( 'tabindex' );
			$('#answer_txt4').css({'cursor':'default'});
			$('#answer_txt5').data( 'tabindex', $('#answer_txt5').attr('tabindex') );
			$('#answer_txt5').removeAttr( 'tabindex' );
			$('#answer_txt5').css({'cursor':'default'});
        }
        else{
			$('#answer_img1').data( 'tabindex', $('#answer_img1').attr('tabindex') );
			$('#answer_img1').removeAttr( 'tabindex' );
			$('#answer_img2').data( 'tabindex', $('#answer_img2').attr('tabindex') );
			$('#answer_img2').removeAttr( 'tabindex' );
			$('#answer_img3').data( 'tabindex', $('#answer_img3').attr('tabindex') );
			$('#answer_img3').removeAttr( 'tabindex' );
			$('#answer_img4').data( 'tabindex', $('#answer_img4').attr('tabindex') );
			$('#answer_img4').removeAttr( 'tabindex' );
			$('#answer_img5').data( 'tabindex', $('#answer_img5').attr('tabindex') );
			$('#answer_img5').removeAttr( 'tabindex' );			
       	}
	}
	else{
        if(currentpuzzle.answerIsText==true){
          	if( $('#answer_txt1').data('tabindex') ){
		  		$('#answer_txt1').attr( 'tabindex', $('#answer_txt1').data('tabindex') );
		  	}
		  	$('#answer_txt1').css({'cursor':'pointer'});

          	if( $('#answer_txt2').data('tabindex') ){
		  		$('#answer_txt2').attr( 'tabindex', $('#answer_txt2').data('tabindex') );
		  	}
		  	$('#answer_txt2').css({'cursor':'pointer'});

          	if( $('#answer_txt3').data('tabindex') ){
			  	$('#answer_txt3').attr( 'tabindex', $('#answer_txt3').data('tabindex') );
		  	}
		  	$('#answer_txt3').css({'cursor':'pointer'});

          	if( $('#answer_txt4').data('tabindex') ){
			  	$('#answer_txt4').attr( 'tabindex', $('#answer_txt4').data('tabindex') );
		  	}
		  	$('#answer_txt4').css({'cursor':'pointer'});

          	if( $('#answer_txt5').data('tabindex') ){
			  	$('#answer_txt5').attr( 'tabindex', $('#answer_txt5').data('tabindex') );
		  	}
		  	$('#answer_txt5').css({'cursor':'pointer'});

			if(focusStyleOn){
				$('#answer_txt1').addClass('globalFocus');
				$('#answer_txt2').addClass('globalFocus');
				$('#answer_txt3').addClass('globalFocus');		
				$('#answer_txt4').addClass('globalFocus');
				$('#answer_txt5').addClass('globalFocus');
				$('#answer_txt1').removeClass('globalFocusOff');
				$('#answer_txt2').removeClass('globalFocusOff');
				$('#answer_txt3').removeClass('globalFocusOff');		
				$('#answer_txt4').removeClass('globalFocusOff');
				$('#answer_txt5').removeClass('globalFocusOff');		
			}
			else{
				$('#answer_txt1').removeClass('globalFocus');
				$('#answer_txt2').removeClass('globalFocus');
				$('#answer_txt3').removeClass('globalFocus');		
				$('#answer_txt4').removeClass('globalFocus');
				$('#answer_txt5').removeClass('globalFocus');		
				$('#answer_txt1').addClass('globalFocusOff');
				$('#answer_txt2').addClass('globalFocusOff');
				$('#answer_txt3').addClass('globalFocusOff');		
				$('#answer_txt4').addClass('globalFocusOff');
				$('#answer_txt5').addClass('globalFocusOff');
			}
        }
        else{
          	if( $('#answer_img1').data('tabindex') ){
		  		$('#answer_img1').attr( 'tabindex', $('#answer_img1').data('tabindex') );
		  	}
		  	$('#answer_img1').css({'cursor':'pointer'});

          	if( $('#answer_img2').data('tabindex') ){
		  		$('#answer_img2').attr( 'tabindex', $('#answer_img2').data('tabindex') );
		  	}
		  	$('#answer_img2').css({'cursor':'pointer'});

          	if( $('#answer_img3').data('tabindex') ){
			  	$('#answer_img3').attr( 'tabindex', $('#answer_img3').data('tabindex') );
		  	}
		  	$('#answer_img3').css({'cursor':'pointer'});

          	if( $('#answer_img4').data('tabindex') ){
			  	$('#answer_img4').attr( 'tabindex', $('#answer_img4').data('tabindex') );
		  	}
		  	$('#answer_img4').css({'cursor':'pointer'});

          	if( $('#answer_img5').data('tabindex') ){
			  	$('#answer_img5').attr( 'tabindex', $('#answer_img5').data('tabindex') );
		  	}
		  	$('#answer_img5').css({'cursor':'pointer'});
		  	
			if(focusStyleOn){
				$('#answer_img1').addClass('globalFocus');
				$('#answer_img2').addClass('globalFocus');
				$('#answer_img3').addClass('globalFocus');		
				$('#answer_img4').addClass('globalFocus');
				$('#answer_img5').addClass('globalFocus');		
				$('#answer_img1').removeClass('globalFocusOff');
				$('#answer_img2').removeClass('globalFocusOff');
				$('#answer_img3').removeClass('globalFocusOff');		
				$('#answer_img4').removeClass('globalFocusOff');
				$('#answer_img5').removeClass('globalFocusOff');		
			}
			else{
				$('#answer_img1').removeClass('globalFocus');
				$('#answer_img2').removeClass('globalFocus');
				$('#answer_img3').removeClass('globalFocus');		
				$('#answer_img4').removeClass('globalFocus');
				$('#answer_img5').removeClass('globalFocus');		
				$('#answer_img1').addClass('globalFocusOff');
				$('#answer_img2').addClass('globalFocusOff');
				$('#answer_img3').addClass('globalFocusOff');		
				$('#answer_img4').addClass('globalFocusOff');
				$('#answer_img5').addClass('globalFocusOff');
			}
       	}
	}
}

var game = 
{
    startgame: function () {
        if (currentpuzzle_seq_id === 0 || currentpuzzle_seq_id === 9999) {
            if (liteversion) {
                currentpuzzle_seq_id = 0;
            }
            else {
                currentpuzzle_seq_id = 9999;
            }
            this.nextpuzzle();
	    }
	    else{
	        currentpuzzle=puzzles[currentpuzzle_seq_id];
		    if(!currentpuzzle){
	          this.nextpuzzle();	    
		    }
		    else{
		      currentpuzzle.rendered = false;
              this.resetPopin();
		      this.renderpuzzle();
		    }
	    }
    },	

	processAnswer : function(divInstance, resourceId){

	    var self=this;
	    
        if(resourceId==currentpuzzle.solution){
          // Remember failed status
          currentpuzzle.failed_answers = {};
          puzzles[currentpuzzle_seq_id].failed_answers[divInstance.id] = "success";
          this.playAudio("#sound_success", soundVolumeSuccess);
          $('#answersuccess').css("opacity", 0.1);
		  $('#answersuccess').show();
		  var popupTop = $('#currentpuzzle').height() / 2;
		  $('#answersuccess').css("top", popupTop);
          var popupLeft = ($(window).width() - $('#answersuccess').width()) / 2;
          $('#answersuccess').css("left",popupLeft);
          if( answerFailed ){
              self.setPuzzlePlayed( currentpuzzle );        	  
          }
          else{
              self.setPuzzleSolved( currentpuzzle );        	  
          }
          $('#answersuccess').animate({ opacity: 1.0 }, 50, function() {
              $('#answersuccess').animate({ opacity: 0.0 }, 1500, function() { $('#answersuccess').hide(); game.nextpuzzle(); });
           });
          answerFailed=false;
        }
        else{
          // Remember failed status
          puzzles[currentpuzzle_seq_id].failed_answers[divInstance.id] = "fail";
          answerFailed=true;
          self.setPuzzlePlayed( currentpuzzle );
          this.playAudio("#sound_fail", soundVolumeFail);
          $(divInstance).addClass("answerfailed");
		  $('#answerfail').css("opacity",0.1);
		  $('#answerfail').show();
		  var popupTop = $('#currentpuzzle').height() / 2;
          $('#answerfail').css("top",popupTop);
          var popupLeft = ($(window).width() - $('#answerfail').width()) / 2;
          $('#answerfail').css("left", popupLeft);
		  $('#answerfail').animate({ opacity: 1.0 }, 50, function() { 
			  $('#answerfail').animate({ opacity: 0.0 }, 1200, function() { $('#answerfail').hide(); });
		   });
        }
  	    // Save puzzles states to settings parameter
  	    self.savePuzzleState();  
	},
	
	showPuzzleLockedInfo: function(){
		this.playAudio("#sound_fail", soundVolumeFail);
		$('#puzzlelocked').css("opacity",0.1);
		$('#puzzlelocked').show();
		var popupTop = ($(window).height()/2) - $('#puzzlelocked').height()/2;
		$('#puzzlelocked').css("top",popupTop);
		var popupLeft = ($(window).width() - $('#puzzlelocked').outerWidth()) / 2;
		$('#puzzlelocked').css("left", popupLeft);
		$('#puzzlelocked').animate({ opacity: 1.0 }, 350, function() { 
				$('#puzzlelocked').animate({ opacity: 0.0 }, 1200, function() { $('#puzzlelocked').hide(); });
	    	});
	},	
	
	toggleExplanation: function () {
	    var isLandscape = true;
	    if ($(window).width() > $(window).height()) {
	        isLandscape = true;
	    }
	    else {
	        isLandscape = false;
	    }

	    if (!$('#loading').is(":visible") && !$('#launch').is(":visible") && !$('#puzzleshortcomepopin').is(":visible")) {
	        if (!$('#explanation').is(":visible")) {
	    		if ($('#about').is(":visible")) {
	    			$('#about').hide();
	    		}
	        	nonBlockingPostpone( function(){ 
		            var popupTop = 0;
		            if (isLandscape) {
		                popupTop = ($(window).height() - $('#explanation').height()) / 3.80;
		            }
		            else {
		                popupTop = $(window).height() / 3.5;
		            }

		            if ($('#currentpuzzle').height()*1.15 + $('#explanation').height() < $(window).height()) {
	   	                // Sufficient space to show the popover below the puzzle
		                popupTop = $('#currentpuzzle').height() * 1.025;
	    	        }
	        	    $('#explanation').css("top", popupTop);
	            	var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#explanation').width()) / 2;
	            	$('#explanation').css("left", popupLeft);
	            	// Replace placeholder attributes
	            	multilanguage.replaceStringsOfUserinterface(".multilanguageExpl");
	            	$('#explanation').toggle(popinToggleDurationOpen);
		            disableGameAnswers(true);	            
		            $("#expand_sol_img").focus();
	       	}, 500 );   // Postpone call by half second to get $('#launch').height() filled
            }
	        else {
	            $('#explanation').toggle(popinToggleDurationClose);
	            disableGameAnswers(false);
	            $("#expand_sol_img").focus();
            }
	    }
	},
    
	toggleSolution : function(){
	    var popupTop=0;
	    if (!isSolutionExpanded) {
	        // Show solution
	        $('#expl_solution').toggle(500);
	        var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#explanation').width()) / 2;
	        $('#explanation').css("left", popupLeft + 1);
	        isSolutionExpanded = true;
	        // Set image
	        var newSrc = "res/drawable/icon_collapse.png"
	        $("#expand_sol_imgimg").attr('src', newSrc);
	        popupTop=$('#explanation').offset().top;
            popupTop = popupTop - 100;
	        $('#explanation').animate({ top: popupTop+'px' }, 500 );
        }
        else{
	        // Set image
	        var newSrc = "res/drawable/icon_expand.png"
	        $("#expand_sol_imgimg").attr('src', newSrc);
	        // Hide solution
	        $('#expl_solution').toggle(500);
            // Workaround fo background resizing
	        var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#explanation').width()) / 2;
	        $('#explanation').css("left", popupLeft - 1);
	        isSolutionExpanded = false;
	        popupTop=$('#explanation').offset().top;
            popupTop = popupTop + 100;
	        $('#explanation').animate({ top: popupTop+'px' }, 500 );
        }
	},
    
	toggleAudio : function(){
	    var audio=$("#music");
	    if(soundOn===1){
	        soundOn=0;
	    	$("#soundOnOffIcon").attr("src","res/drawable/icon_sound_off.png");
	    	this.fadeOutAudio(audio);
	    }
	    else{
	        soundOn=1;
	    	$("#soundOnOffIcon").attr("src","res/drawable/icon_sound_on.png");
	    	this.fadeInAudio(audio);
	    }
    	// Write to local storage
        settingsHelper.setItem('soundon', soundOn);
	},

	playAudio : function(selector, audioVolume){
	    if(soundOn===1){
	    	$(selector)[0].volume=audioVolume;
			$(selector).trigger("stop");
	        $(selector)[0].currentTime=0; 
			$(selector)[0].play();
		}
		else{
			$(selector).trigger("stop");		
		}
    },

	fadeInAudio : function(audio){
		audio.trigger("stop");
        audio[0].volume=musicVolume; 
        audio[0].currentTime=0;
		audio[0].play();
    },

	fadeOutAudio : function(audio){
		audio.trigger("pause");
    },

    clickHandlerDifficulty : function(e){
    	self=this;
    	if(e.currentTarget.id=="difficulty_easy"){
    		self.setDifficulty(1);    	
    	}
    	else if(e.currentTarget.id=="difficulty_mixed"){
    		self.setDifficulty(2);    	
    	}
    	else if(e.currentTarget.id=="difficulty_hard"){
    		self.setDifficulty(3);
    	}
    },

    setDifficulty : function(diff){
        if(difficulty==diff){
        	return;
        }
        // Remove "selected"
        switch(difficulty){
          case 1: {          // easy
	        $("#difficulty_easy_select").removeClass("selected");
            $("#difficulty_easy_select").addClass("deselected");
	    	$("#difficulty_easy_select").attr("src","res/drawable/selected_off.png");
            break;
          }
          case 2: {          // mixed
            $("#difficulty_mixed_select").removeClass("selected");
            $("#difficulty_mixed_select").addClass("deselected");
	    	$("#difficulty_mixed_select").attr("src","res/drawable/selected_off.png");
            break;
          }
          case 3: {          // hard
            $("#difficulty_hard_select").removeClass("selected");            
            $("#difficulty_hard_select").addClass("deselected");
	    	$("#difficulty_hard_select").attr("src","res/drawable/selected_off.png");
            break;
          }
        }
        // Set "selected"
        switch(diff){
          case 1: {          // easy
	        $("#difficulty_easy_select").removeClass("deselected");
            $("#difficulty_easy_select").addClass("selected");
	    	$("#difficulty_easy_select").attr("src","res/drawable/selected.png");
            break;
          }
          case 2: {          // mixed
            $("#difficulty_mixed_select").removeClass("deselected");
            $("#difficulty_mixed_select").addClass("selected");
	    	$("#difficulty_mixed_select").attr("src","res/drawable/selected.png");
            break;
          }
          case 3: {          // hard
            $("#difficulty_hard_select").removeClass("deselected");            
            $("#difficulty_hard_select").addClass("selected");
	    	$("#difficulty_hard_select").attr("src","res/drawable/selected.png");
            break;
          }
        }
        difficulty=diff;   // Difficulty is a global variable
        // Write puzzle sequence id to local storage
        settingsHelper.setItem('difficulty', difficulty);
    },

    toggleAbout : function(){
        if(!$('#about').is(":visible")){
            var aboutHeight = $('#about').height();
            if(aboutHeight > $(window).height()){     // ToDo -> Workaround for first launch
            	aboutHeight = 0.9*$(window).height();
            }
        	var popupTop = ($(window).height() - aboutHeight) / 2;
        	if ($('#currentpuzzle').height() * 1.05 + $('#about').height() < $(window).height()) {
        	    // Sufficient space to show the popover below the puzzle
        	    popupTop = $('#currentpuzzle').height() * 1.05;
        	}
        	$('#about').css("top", popupTop);
        	var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#about').width()) / 2;
        	$('#about').css("left", popupLeft);
    	    if (hyperlinksDisabled) {
    	    	$('.withHyperlink').hide();      // Show hyperlinks clickable ( like <a> tag )    	    	
    	    }
    	    else{
    	    	$('.withoutHyperlink').hide();   // Show hyperlinks as text (URL, ...)
    	    }
	        $('#about').toggle(popinToggleDurationOpen);
            disableGameAnswers(true);
            $("#close_about_img").focus();
            // Debug info   --- ToDo, hide before delivery
//            var emSize = parseFloat($("body").css("font-size"));
//            $('#debug_info').text( 'window: ' + $(window).width() + 'x' + $(window).height() 
//                                   + ', document: ' + $(window).width() + 'x' + $(window).height() 
//                                   + ', em size: ' + emSize 
//                                   + ', downscale factor: ' + getXLargeFontsizeDownscaleFactor()
//                 );
        }
        else{
	        $('#about').toggle(popinToggleDurationClose);
            disableGameAnswers(false);
        }
        // Visibility of fullversion link
        if (!liteversion) {
            $('#about_appstore_nav').hide();
        }
        else {
            if (appStoreName == APPSTORE_Windows8) {
                $("#about_appstore_nav").click(function () {
                    currentApp.requestAppPurchaseAsync(false);
                });
            }
            else if (appStoreName == APPSTORE_WindowsPhone) {
                // see html body
            }
            else if (appStoreName == APPSTORE_Mozilla) {
				$('#about_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
				$('#about_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
            }	            
 			else if (appStoreName == APPSTORE_Chrome) {
				$('#about_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
				$('#about_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
            }
            else if (appStoreName == APPSTORE_Amazon) {
				$('#about_appstore_nav').click(clickHandlerPurchaseItem);    	    	
            }
            else if (appStoreName == APPSTORE_Tizen) {
                $('#about_appstore_nav').hide();    // Currently no link
            }	            
        }
    },

    toggleGameprogress : function(){
    	
		var isLandscape = true;
		if ($(window).width() > $(window).height()) {
		    isLandscape = true;
		}
		else {
		    isLandscape = false;
		}

	    if (!$('#loading').is(":visible") && !$('#launch').is(":visible") && !$('#puzzleshortcomepopin').is(":visible")) {		
	    	if(!$('#gameprogress').is(":visible")){
	    		if ($('#about').is(":visible")) {
	    			$('#about').hide();
	    		}
                var gpWidth=$(document).width();
                var gpHeight=$(document).height();
                if($(window).width()<gpWidth || $(window).height()<gpHeight){
                	gpWidth=$(window).width();
                	gpHeight=$(window).height();
                };
	    		$('#gameprogress').width(gpWidth);
	    		$('#gameprogress').height(gpHeight);

				var popupTop=0;
                $('#gameprogress').css("top", popupTop);
                var popupLeft = 0;
                $('#gameprogress').css("left", popupLeft);
	    		// Initialize WebGl for charts of game progress (uses canvas)
	    		// -> Assign canvas to global variable "gl"
	    		var gameprogressCanvas = $('#gameprogressCanvas');
                var gameprogressCanvasFrame = $('#gameprogressCanvasFrame');
	    		if(isLandscape){
	    			gameprogressCanvasFrame.height( (3*$(window).height())/5 );        		
	    			gameprogressCanvasFrame.width( gameprogressCanvasFrame.height() );
	    			gameprogressCanvas.height( (3*$(window).height())/5 );        		
	    			gameprogressCanvas.width( gameprogressCanvas.height() );
	    		}
	    		else{
	    			gameprogressCanvasFrame.width( (2*$(window).width())/3 );
	    			gameprogressCanvasFrame.height( gameprogressCanvasFrame.width() );
	    			gameprogressCanvas.width( (2*$(window).width())/3 );
	    			gameprogressCanvas.height( gameprogressCanvas.width() );
	    		}
	    		initGL( gameprogressCanvas );
	    		if(!gl){
        			gameprogressCanvasFrame.remove();
				}
		    	game.updateGameProgress();
		    	$('#gameprogress').toggle(popinToggleDurationOpen);
				var closeButtonLeft = $(window).width() - $('#close_gameprogressFrame').width()*1.3;
	    		$('#close_gameprogressFrame').css("left", closeButtonLeft);

	            if(!$('#puzzleshortcomepopin').is(":visible")){
		            disableGameAnswers(true);
		            disableNavigationAll();
	            }
	            $("#close_gameprogress").focus();
	    	}
	    	else{
		    	$('#gameprogress').toggle(popinToggleDurationClose);
	            disableGameAnswers(false);
	            disableNavigationAll();
	    	}
	    }
    },

    toggleFullVersion : function(){
        if(!$('#fullversion').is(":visible")){
	        var popupTop = ($(window).height() - $('#fullversion').height()) / 2;
    	    $('#fullversion').css("top", popupTop);
        	var popupLeft = ($(window).width() - $('#navigation').width() - $('#fullversion').width()) / 2;
        	$('#fullversion').css("left", popupLeft);
   	    	$('#fullversion').toggle(popinToggleDurationClose);   // "close" is faster than "open"    	
        	$("#fullversionBtn").focus();
        }
        else{
	        $('#fullversion').toggle(popinToggleDurationClose);    	
        }
    },

    switchToFullVersion : function(){
    	liteversion = false;
        settingsHelper.setItem('fullversion', 1);
        currentpuzzle_seq_id = 9999;     // Reset game progress
		allPuzzlesPlayed==0;
        // Show fullversion popover
        this.toggleFullVersion();
    },

    toggleGameprogressConfirm : function(){
        if(!$('#resetGameProgressConfirm').is(":visible")){
        	var popupTop = ($(window).height() - $('#resetGameProgressConfirm').height()) / 2;
            $('#resetGameProgressConfirm').css("top", popupTop);
            var popupLeft = ($(window).width() - $('#resetGameProgressConfirm').outerWidth()) / 2;
       	    $('#resetGameProgressConfirm').css("left", popupLeft);
    	    $('#resetGameProgressConfirm').toggle(popinToggleDurationClose);   // "close" is faster than "open"    	
            $("#resetGameProgressConfirmOkBtn").focus();
        }
        else{
	        $('#resetGameProgressConfirm').toggle(popinToggleDurationClose);    	
        }
    },
    
    setCharttypePieGameprogress : function(){
        if(!$('#progressChart').is(":visible")){
            $('#progressPuzzlelist').toggle(popinToggleDurationClose);
            $('#progressChart').toggle(popinToggleDurationOpenSlow);
        }    	
    },
    
    setCharttypePuzzlelistGameprogress : function(){
        if(!$('#progressPuzzlelist').is(":visible")){
            $('#progressChart').toggle(popinToggleDurationClose);
            $('#progressPuzzlelist').toggle(popinToggleDurationOpenSlow);
        	nonBlockingPostpone( function(){ 
		     	$('#progressDetailSeparatorTop').addClass('boxShadowBottom');
		     	$('#progressDetailSeparatorBottom').addClass('boxShadowTop');
	       	}, popinToggleDurationOpenSlow );
        }
    },
    
    gotoPreviousPuzzle : function(){
//      Activate to test Amazon in-App purchasing    
//		if (appStoreName == APPSTORE_Amazon) {  // ToDo -> remove before publishing !!!!!
//			purchaseItem();                     // ToDo -> remove before publishing !!!!!
//		}                                       // ToDo -> remove before publishing !!!!!
//		else{                                   // ToDo -> remove before publishing !!!!!
//			this.switchToFullVersion();         // ToDo -> remove before publishing !!!!!
//		}                                       // ToDo -> remove before publishing !!!!!
//		return;                                 // ToDo -> remove before publishing !!!!!
        if (previous_seq_id != 77777) {
            currentpuzzle_seq_id = previous_seq_id;
            previous_seq_id = 77777;    // No previous puzzle available
            currentpuzzle = puzzles[currentpuzzle_seq_id];
            answerFailed=false;
            currentpuzzle.rendered = false;
            this.resetPopin();
            this.renderpuzzle();
        }
    },

    gotoPuzzle : function(seq_id){
    	currentpuzzle_seq_id = seq_id;
        previous_seq_id = currentpuzzle_seq_id;    // No previous puzzle available
        currentpuzzle = puzzles[currentpuzzle_seq_id];
        answerFailed=false;
        currentpuzzle.rendered = false;
        this.resetPopin();
        this.renderpuzzle();
    },

    startWithFirstPuzzle : function(){    // method is called by puzzleshortcome and fullversion popover
        $('#puzzleshortcome').hide();   
        $('#fullversion').hide();
        $('#gameprogress').hide();
        this.nextpuzzle();
	},

	nextpuzzle : function( ){
		if( allPuzzlesPlayed==1 ){
			currentpuzzle = game.nextpuzzleData( false );
			if(currentpuzzle==null){
				currentpuzzle = game.nextpuzzleData( false );
	            previous_seq_id = 77777;    // No previous puzzle available
			}
			else{
	    		previous_seq_id = currentpuzzle_seq_id;				
			}
    		currentpuzzle.rendered = false;
    		currentpuzzle_seq_id = currentpuzzle.seq_no;
            this.resetPopin();

            if(keyboardRecentlyUsed){
            	if(!focusStyleOn){
					focusStyleOn = true;
            		updateFocusStyle();
            	}
            }
            else{
            	if(focusStyleOn){
					focusStyleOn = false;
            		updateFocusStyle();
            	}
            }
			keyboardRecentlyUsed = false;

		    this.renderpuzzle();
		}
		else{
			currentpuzzle = game.nextpuzzleData( true );
			if(currentpuzzle==null){   // Try again, there might be unplayed puzzles ahead of current puzzle
				currentpuzzle = game.nextpuzzleData( true );			
				if(currentpuzzle==null){     // All puzzles played
		            previous_seq_id = 77777;    // No previous puzzle available
		            // Remember, all puzzles have been played
		            //  -> do not show 'puzzle shortcome' popover again
		            allPuzzlesPlayed=1;
		            settingsHelper.setItem('allpuzzlesplayed', allPuzzlesPlayed);
		            
		            // Show puzzle-shortcome popover
		            if(liteversion){
		                // Visibility of fullversion link
			            if (appStoreName == APPSTORE_Windows8) {
			                $("#puzzleshortcome_appstore_nav").click(function () {
			                    currentApp.requestAppPurchaseAsync(false);
			                });
			            }
			            else if (appStoreName == APPSTORE_WindowsPhone) {
			                // See html body
			            }
			            else if (appStoreName == APPSTORE_Chrome) {
							$('#puzzleshortcome_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
							$('#puzzleshortcome_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
			            }
			            else if (appStoreName == APPSTORE_Amazon) {
							$('#puzzleshortcome_appstore_nav').click(clickHandlerPurchaseItem);    	    	
							$('#puzzleshortcome_appstore_nav').keydown(clickHandlerPurchaseItem);    	    	
			            }
			            else if (appStoreName == APPSTORE_Mozilla) {
							$('#puzzleshortcome_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
							$('#puzzleshortcome_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
			            }	            
			            else if (appStoreName == APPSTORE_Tizen) {
			                $('#puzzleshortcome_appstore_nav').hide();    // Currently no link
//							$('#puzzleshortcome_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
//							$('#puzzleshortcome_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
			            }
		            }
		            else{
		                // Visibility of fullversion link
				        $('#puzzleshortcome_appstore_nav').hide();
				        // Make sure the launch popover is hidden
				        $('#launch').toggle(popinToggleDurationClose);
		            }

		    		// Header
        			var is_premium=null;   // null -> all puzzles, true -> only premium puzzles (all BUT lite version!!!)
		    		if(liteversion){
		    			is_premium=false;
		    		}
		    		var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
		    		var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
		    		var noNew=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateNew);
		    		var noAll = noPlayed + noSolved + noNew; 
		    		var ratioSolved = noSolved/noAll;
		    		var ratioSolvedUi = 100*(noSolved/noAll);
		    		var ratioPlayed = noPlayed/noAll;
		    		var fractionNew = 100-Math.round(100*ratioSolved)-Math.round(100*ratioPlayed);
		    	    var fractionSolved=Math.round(100*ratioSolved);
		    	    var fractionPlayed=Math.round(100*ratioPlayed);
		            
		    		// Seal icons
		    		if(ratioSolvedUi>10){$('#puzzleshortcome_icon1').attr("src","res/drawable/seal_active.png")}
		    			else{$('#puzzleshortcome_icon1').attr("src","res/drawable/seal_inactive.png")}
		    		if(ratioSolvedUi>30){$('#puzzleshortcome_icon2').attr("src","res/drawable/seal_active.png")}
		    			else{$('#puzzleshortcome_icon2').attr("src","res/drawable/seal_inactive.png")}
		    		if(ratioSolvedUi>50){$('#puzzleshortcome_icon3').attr("src","res/drawable/seal_active.png")}
		    			else{$('#puzzleshortcome_icon3').attr("src","res/drawable/seal_inactive.png")}
		    		if(ratioSolvedUi>70){$('#puzzleshortcome_icon4').attr("src","res/drawable/seal_active.png")}
		    			else{$('#puzzleshortcome_icon4').attr("src","res/drawable/seal_inactive.png")}
		    		if(ratioSolvedUi>90){$('#puzzleshortcome_icon5').attr("src","res/drawable/seal_active.png")}
		    			else{$('#puzzleshortcome_icon5').attr("src","res/drawable/seal_inactive.png")}		

		    		// update placeholder for solved puzzle percentage
		    		multilanguage.replaceStringsOfUserinterface(".multilanguage");
		    		
		            // Show puzzle-shortcome popover
		            var popupTop = ($(window).height() - $('#puzzleshortcome').height()) / 2;
		            if ($('#currentpuzzle').height() * 1.05 + $('#puzzleshortcome').height() < $(window).height()) {
		                // Sufficient space to show the popover below the puzzle
		                popupTop = $('#currentpuzzle').height() * 1.05;
		            }
		        	$('#puzzleshortcome').css("top", popupTop);
		        	var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#puzzleshortcome').width()) / 2;
		        	$('#puzzleshortcome').css("left", popupLeft);
		            $('#puzzleshortcome').show(popinToggleDurationOpen);
		            disableGameAnswers(true);
		            $('#puzzleshortcomeShowGameprogress').focus();
				}
				else{
		    		currentpuzzle.rendered = false;
		    		previous_seq_id = currentpuzzle_seq_id;
		    		currentpuzzle_seq_id = currentpuzzle.seq_no;
		            this.resetPopin();
		            
		            if(keyboardRecentlyUsed){
						focusStyleOn = true;
		           		updateFocusStyle();
		            }
        		    else{
						focusStyleOn = false;
		           		updateFocusStyle();
		            }
					keyboardRecentlyUsed = false;
				    
				    this.renderpuzzle();
				}
			}			
			else{
	    		currentpuzzle.rendered = false;
	    		previous_seq_id = currentpuzzle_seq_id;
	    		currentpuzzle_seq_id = currentpuzzle.seq_no;
	            this.resetPopin();

	            if(keyboardRecentlyUsed){
					focusStyleOn = true;
	           		updateFocusStyle();
        	    }
            	else{
					focusStyleOn = false;
	           		updateFocusStyle();
    	        }
				keyboardRecentlyUsed = false;
			
			    this.renderpuzzle();
			}
			
		}
    },	

	nextpuzzleData : function( onlyNewPuzzles ){
        if(liteversion){
        	// increment counter ( lite version )
		    for(var i=parseInt(currentpuzzle_seq_id)+1;i<=10000;i++){
	          if(i >= 9999){
	            currentpuzzle_seq_id = 0;
	            previous_seq_id = 77777;    // No previous puzzle available
	            return null;
	          }
		      else if(puzzles[i]){
		          if (!puzzles[i].premium && (puzzles[i].difficulty == difficulty || difficulty == 2)
		        		  && ( !onlyNewPuzzles || puzzles[i].state==puzzleStateNew) ) {
		        	  return puzzles[i];
			      }
		      }
		    }
	    }
	    else{
        	// decrement counter ( full version )
		    for(var i=parseInt(currentpuzzle_seq_id)-1;i>=0;i--){
		      if(i <= 0){
		        currentpuzzle_seq_id = 9999;
		        previous_seq_id = 77777;    // No previous puzzle available
		        return null;
		      }
		      else if(puzzles[i]){
		          if ( (puzzles[i].difficulty == difficulty || difficulty == 2)
		        		   && ( !onlyNewPuzzles || puzzles[i].state==puzzleStateNew) ) {
		        	  return puzzles[i];
			      }
		      }
		    }
	    }
    },	

    resetPopin : function(){
		$('#about').hide();
		$('#explanation').hide();
		$('#answersuccess').hide();
		$('#answerfail').hide();
        $('#puzzleshortcome').hide();
        $('#fullversion').hide();
        $('#gameprogress').hide();
        $('#resetGameProgressConfirm').hide();

        // Hide solution and reset icon to "expand"
        if (isSolutionExpanded) {
//            $('#explanation').css("height", $('#explanation').height() - $('#expl_solution').height() - 25);
            $('#expl_solution').toggle(popinToggleDurationClose);   // Hide
            isSolutionExpanded = false;
        }
        // Set image
        var newSrc = "res/drawable/icon_expand.png"
        $("#expand_sol_imgimg").attr('src', newSrc);
    },

	renderpuzzle : function(isResize){
		var self = this;
		var noQuestion = false;
		var isLandscape = true;
		var useDefaultQuestion = false;

		if (!currentpuzzle) {
		    return;
		}

		if ($(window).width() > $(window).height()) {
		    isLandscape = true;
		}
		else {
		    isLandscape = false;
		}

        // Convert question resource id to text (if needed) or add static text
		if(!isResize){
	        if( currentpuzzle.question_description_type){
		        if(puzzleHelper.DESCRIPTION_TYPE_COMPLETE_USEFULLY==currentpuzzle.question_description_type){
		           currentpuzzle.question=multilanguageStrings["premium_content_description_useful"].value;
		           currentpuzzle.question_resId=puzzleHelper.TEXT_premium_content_description_useful;		           
		        }
		        else if(puzzleHelper.DESCRIPTION_TYPE_ANALOGY==currentpuzzle.question_description_type){
		           currentpuzzle.question=multilanguageStrings["premium_content_analogy"].value;
		           currentpuzzle.question_resId=puzzleHelper.TEXT_premium_content_analogy;
		        }
		        else if(puzzleHelper.DESCRIPTION_TYPE_GENERIC==currentpuzzle.question_description_type){
		            if (!currentpuzzle.question_resId) {
		                currentpuzzle.question_resId = currentpuzzle.question;
		            }
		            currentpuzzle.question = multilanguageStrings[currentpuzzle.question_resId].value;
		        }
		        else if(currentpuzzle.is_stringresource){
		            if (!currentpuzzle.question_resId) {
		                currentpuzzle.question_resId = currentpuzzle.question;
		            }
		            currentpuzzle.question = multilanguageStrings[currentpuzzle.question_resId].value;
		        }
		    }	
	        else if(currentpuzzle.pattern==puzzleHelper.PATTERN_OUTSIDER){
		        if(currentpuzzle.is_stringresource){
		            if (!currentpuzzle.question_resId) {
		                currentpuzzle.question_resId = currentpuzzle.question;
		            	currentpuzzle.question = multilanguageStrings[currentpuzzle.question_resId].value;
		            }
		            else{
		            	currentpuzzle.question=multilanguageStrings["outsider_description"].value;
		            	currentpuzzle.question_resId=puzzleHelper.TEXT_outsider_description;		        
		            }
		        }
		        else{
		           currentpuzzle.question=multilanguageStrings["outsider_description"].value;
		           currentpuzzle.question_resId=puzzleHelper.TEXT_outsider_description;		        
		        }
	        }
	        else if(currentpuzzle.pattern==puzzleHelper.PATTERN_OUTSIDER_STRING){
		        if(currentpuzzle.is_stringresource){
		            if( currentpuzzle.question_resId ) {
		                if( currentpuzzle.question_resId.length>0 ){
			                currentpuzzle.question_resId = currentpuzzle.question;
				            currentpuzzle.question = multilanguageStrings[currentpuzzle.question_resId].value;		                
		                }
		                else{
		                	useDefaultQuestion=true;
		                }
		            }
		            else{
	                	useDefaultQuestion=true;
		            }
		        }
		        else{
                	useDefaultQuestion=true;
		        }
		        if(useDefaultQuestion){
	    	       currentpuzzle.question=multilanguageStrings["outsider_description_string"].value;
		           currentpuzzle.question_resId=puzzleHelper.TEXT_outsider_description_string;		        
		        }
	            currentpuzzle.answerIsText=true;   // Needed for "currentpuzzle.is_stringresource=false"
	        }
	        else if(currentpuzzle.pattern==puzzleHelper.PATTERN_OUTSIDER_IMAGE){
	        	currentpuzzle.question=multilanguageStrings["outsider_description_string"].value;
	        	currentpuzzle.question_resId=puzzleHelper.TEXT_outsider_description_string;
	        }
	        else if(currentpuzzle.is_stringresource && !currentpuzzle.question_description_type){
	            if (!currentpuzzle.question_resId || currentpuzzle.question_resId.length==0) {
	                currentpuzzle.question_resId = currentpuzzle.question;
	            }
	            currentpuzzle.question = multilanguageStrings[currentpuzzle.question_resId].value;
	        }

            // Convert line break format
            currentpuzzle.question = currentpuzzle.question.replace("\\n", "<br />");
            currentpuzzle.solution=currentpuzzle.solution.replace("\\n","<br />");

	        // Solution image
		    if(multilanguageStrings["expl_img_"+currentpuzzle.id]){
		      	currentpuzzle.solutionimg = multilanguageStrings["expl_img_"+currentpuzzle.id].value+".png";
	        }
	        

	        // Convert answer resource id to text (if needed) or add static text
	        if( currentpuzzle.is_stringresource
			           && ( currentpuzzle.pattern==puzzleHelper.PATTERN_SERIES_COMPLETE_STRING
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_SERIES_2D_COMPLETE_STRING
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_EXCLUDE_ITEM_MATCH_STRING
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_EXCLUDE_ITEM_NONMATCH_STRING
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_OUTSIDER_STRING
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_ADD_STRING_SEMANTIC
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_ADD_STRING_END_START
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_WORD_COMPLETE
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_PREMIUM_CONTENT
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE
			           || currentpuzzle.pattern==puzzleHelper.PATTERN_SERIES_COMPLETE_STRING
	                )
	          ){
	          if (currentpuzzle.answer_1) {
	              if (!currentpuzzle.answer_1_resId) {
	                  currentpuzzle.answer_1_resId = currentpuzzle.answer_1;
	              }
	              currentpuzzle.answer_1=multilanguageStrings[currentpuzzle.answer_1_resId].value;
	          }
	          if(currentpuzzle.answer_2){
	              if (!currentpuzzle.answer_2_resId) {
	                  currentpuzzle.answer_2_resId = currentpuzzle.answer_2;
	              }
	              currentpuzzle.answer_2 = multilanguageStrings[currentpuzzle.answer_2_resId].value;
	          }
	          if(currentpuzzle.answer_3){
	              if (!currentpuzzle.answer_3_resId) {
	                  currentpuzzle.answer_3_resId = currentpuzzle.answer_3;
	              }
	              currentpuzzle.answer_3=multilanguageStrings[currentpuzzle.answer_3_resId].value;
	          }
	          if (currentpuzzle.answer_4) {
	              if (!currentpuzzle.answer_4_resId) {
	                  currentpuzzle.answer_4_resId = currentpuzzle.answer_4;
	              }
	              currentpuzzle.answer_4=multilanguageStrings[currentpuzzle.answer_4_resId].value;
	          }
	          if(currentpuzzle.answer_5){
	              if (!currentpuzzle.answer_5_resId) {
	                  currentpuzzle.answer_5_resId = currentpuzzle.answer_5;
	              }
	              currentpuzzle.answer_5 = multilanguageStrings[currentpuzzle.answer_5_resId].value;
	          }
	          if (!currentpuzzle.solution_resId) {
	              currentpuzzle.solution_resId = currentpuzzle.solution;
	          }
	          currentpuzzle.solution = multilanguageStrings[currentpuzzle.solution_resId].value;
	          currentpuzzle.answerIsText=true;
	        }
	        else{
	          if( currentpuzzle.pattern==puzzleHelper.PATTERN_SERIES_COMPLETE_STRING ){
	            currentpuzzle.answerIsText=true;
	          }
	        }
			
	        // Add "questionmark" (image or text)
	       	if(!currentpuzzle.answerIsText){
		        if(!currentpuzzle.question_4&&currentpuzzle.question_3){
		        	currentpuzzle.question_4="question_alpha";
		        }
		        if(!currentpuzzle.question_6&&currentpuzzle.question_5){
		        	currentpuzzle.question_6="question_alpha";
		        }
		        if(!currentpuzzle.question_9&&currentpuzzle.question_8){
		        	currentpuzzle.question_9="question_alpha";
		        }
	        }
	        
            // Exaxtly four images
	        if(!currentpuzzle.question_5&&currentpuzzle.question_4){
	            currentpuzzle.question_5 = "question_alpha";
	        }
        }

        // Prevent tempo.js aborts for Chrome
        if(!currentpuzzle.question) currentpuzzle.question="";
        if(!currentpuzzle.question_1) currentpuzzle.question_1="";
        if(!currentpuzzle.question_2) currentpuzzle.question_2="";
        if(!currentpuzzle.question_3) currentpuzzle.question_3="";
        if(!currentpuzzle.question_4) currentpuzzle.question_4="";
        if(!currentpuzzle.question_5) currentpuzzle.question_5="";
        if(!currentpuzzle.question_6) currentpuzzle.question_6="";
        if(!currentpuzzle.question_7) currentpuzzle.question_7="";
        if(!currentpuzzle.question_8) currentpuzzle.question_8="";
        if(!currentpuzzle.answer_1) currentpuzzle.answer_1="";
        if(!currentpuzzle.answer_2) currentpuzzle.answer_2="";
        if(!currentpuzzle.answer_3) currentpuzzle.answer_3="";
        if(!currentpuzzle.answer_4) currentpuzzle.answer_4="";
        if(!currentpuzzle.answer_5) currentpuzzle.answer_5="";

	    // Append puzzle template to DOM
        var templateId = $(currentpuzzle).attr('template_id');
        if (!isLandscape) {
            templateId = templateId + "_portrait";
        }
        var puzzleId = $(currentpuzzle).attr('seq_no');
        if( useTempo ){
        	try {
				$('#launch').hide( popinToggleDurationClose );
		        var puzzleObj = $(jQuery.parseHTML(layoutTemplates[templateId]));              
        		puzzleObj.prop("id",puzzleId);
            	Tempo.prepare(puzzleObj).render(currentpuzzle);
            	$('#currentpuzzle').empty();
            	$('#currentpuzzle').append(puzzleObj);
        	}
        	catch (err) {
            	$('#currentpuzzle').append(JSON.stringify(currentpuzzle));
            	$('#currentpuzzle').append(err.message);
            	console.error(err);
        	}
        }
        else{
			$('#launch').hide( popinToggleDurationClose );
	        var puzzleHtml = layoutTemplates[templateId];
	        puzzleHtml = game.replaceTemplatePlaceholders( puzzleHtml, currentpuzzle );              
//	        var puzzleObj = $(puzzleHtml);
	        var puzzleObj = $(jQuery.parseHTML(puzzleHtml));
       		puzzleObj.prop("id",puzzleId);
           	$('#currentpuzzle').empty();
           	$('#currentpuzzle').append(puzzleObj);
        }

        if (!currentpuzzle.question || currentpuzzle.question.length == 0) {
    	  $('.description').hide();
        }
        else {
            // Decrease font size for very long texts 
            if (currentpuzzle.question.length > 120) {
                if (isLandscape) {
                    $('.description_txt').addClass("description_font_xsmaller");
                }
                else {
                    $('.description_txt').addClass("description_font_xsmaller_portrait");
                }
            }
            else if (currentpuzzle.question.length > 60) {
                if (isLandscape) {
                    $('.description_txt').addClass("description_font_smaller");
                }
                else {
                    $('.description_txt').addClass("description_font_smaller_portrait");
                }
            }
            else {
                if (isLandscape) {
                    $('.description_txt').addClass("description_font");
                }
                else {
                    $('.description_txt').addClass("description_font_portrait");
                }
            }
        }

        if(!currentpuzzle.answer_3 || currentpuzzle.answer_3==""){
        	if(currentpuzzle.answerIsText){
        		$('#question_txt3').hide();
        	}
        	else{
        		$('#question_img3').hide();
        	}
        }
        
        if(!currentpuzzle.answer_4 || currentpuzzle.answer_4==""){
        	if(currentpuzzle.answerIsText){
        		$('#answer_txt4').hide();
        	}
        	else{
        		$('#answer_img4').hide();
        	}
        }
        
        if(!currentpuzzle.answer_5 || currentpuzzle.answer_5==""){
        	if(currentpuzzle.answerIsText){
        		$('#answer_txt5').hide();
        	}
        	else{
        		$('#answer_img5').hide();
        	}
        }
        
        if(currentpuzzle.answerIsText==true){
    	  $('.answer_img').hide();
		  $('#answer_txt1').click(clickHandlerAnswer);
		  $('#answer_txt1').keydown(clickHandlerAnswer);
		  $('#answer_txt2').click(clickHandlerAnswer);
		  $('#answer_txt2').keydown(clickHandlerAnswer);
		  $('#answer_txt3').click(clickHandlerAnswer);
		  $('#answer_txt3').keydown(clickHandlerAnswer);
		  $('#answer_txt4').click(clickHandlerAnswer);
		  $('#answer_txt4').keydown(clickHandlerAnswer);
		  $('#answer_txt5').click(clickHandlerAnswer);
		  $('#answer_txt5').keydown(clickHandlerAnswer);
       	  $('#answer_txt1').focus();
        }
        else{
       	  $('.answer_txt').hide();          
		  $('#answer_img1').click(clickHandlerAnswer);
		  $('#answer_img1').keydown(clickHandlerAnswer);
		  $('#answer_img2').click(clickHandlerAnswer);
		  $('#answer_img2').keydown(clickHandlerAnswer);
		  $('#answer_img3').click(clickHandlerAnswer);
		  $('#answer_img3').keydown(clickHandlerAnswer);
		  $('#answer_img4').click(clickHandlerAnswer);
		  $('#answer_img4').keydown(clickHandlerAnswer);
		  $('#answer_img5').click(clickHandlerAnswer);
		  $('#answer_img5').keydown(clickHandlerAnswer);
       	  $('#answer_img1').focus();
       	}
        disableGameAnswers(false);

        if (!currentpuzzle.question_1 || currentpuzzle.question_1==""){
    	  $('.question').hide();
    	  $('#separator').hide();
        }

	    // No image in the center of a 3x3 grid (eight images)
        if (currentpuzzle.question_5 && currentpuzzle.question_5 == "empty") {
            if (currentpuzzle.answerIsText) {
                $('#question_txt5').css({ opacity: 0.0 });
            }
            else {
                $('#question_img5').css({ opacity: 0.0 });
            }
        }

        var navigationWidth = Math.min( $('#aboutShowHide').width(), $('#aboutShowHide').height() );
        var emSize = parseFloat($("body").css("font-size")) ;
        $("#navigation").width( navigationWidth + 0.75 * emSize * getXLargeFontsizeDownscaleFactor() );
        var puzzleFrameMaxWidth = $(window).width() - $('#gotoPreviousPuzzle').width() - 1.50 * emSize;
        $("#currentpuzzle").width(puzzleFrameMaxWidth);
        var puzzleFrameWidth = puzzleFrameMaxWidth;
        var ww = $(window).width();
	    var wh = $(window).height();

	    if (isLandscape) {
            // No adjustion needed
        }
	    else {
	        if ($(window).height() < $(window).width() * 1.02) {
	            puzzleFrameWidth = puzzleFrameWidth * 0.5;
	        }
	        else if ($(window).height() < $(window).width() * 1.05) {
	            puzzleFrameWidth = puzzleFrameWidth * 0.6;
	        }
	        else if ($(window).height() < $(window).width() * 1.1) {
	                puzzleFrameWidth = puzzleFrameWidth * 0.7;
	        }
            else if ($(window).height() < $(window).width() * 1.15) {
	                puzzleFrameWidth = puzzleFrameWidth * 0.8;
	        }
        }

	    $('.description').width(puzzleFrameMaxWidth);
        if(currentpuzzle.answerIsText==true){    // For text answers use full width
	        $('.tl_question_and_answer').width(puzzleFrameMaxWidth);   
    	    $('.tl_question_and_answer_wo_bgr').width(puzzleFrameMaxWidth);
	        $('.answer_portrait').width(puzzleFrameMaxWidth);
        }
        else{
	        $('.tl_question_and_answer').width(puzzleFrameWidth);
    	    $('.tl_question_and_answer_wo_bgr').width(puzzleFrameWidth);
	        $('.answer_portrait').width(puzzleFrameWidth);
        }
        $('.question_portrait').width(puzzleFrameWidth);
        $('.question_landscape').width(puzzleFrameWidth);
        $('.answer_landscape').width(puzzleFrameWidth);
        $('.question').width(puzzleFrameWidth);
        $('.answer').width(puzzleFrameWidth);

	    // Answer images
        var imageWidthAnswer = puzzleFrameWidth / 6.50;
        if (!isLandscape) {
            // Increase width
            imageWidthAnswer = imageWidthAnswer * 1.80;
        }

        if ( currentpuzzle.pattern==puzzleHelper.PATTERN_PREMIUM_CONTENT
		     || currentpuzzle.pattern == puzzleHelper.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE) {
            // Large question-image at the top
            var imageWidthQuestion;
            if (isLandscape) {
                imageWidthQuestion = puzzleFrameWidth * 0.4;
	                        	
                if ($(window).width() > $(window).height() * 5.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.20;
                    imageWidthAnswer = imageWidthAnswer * 0.20;
                }
                else if ($(window).width() > $(window).height() * 4.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.30;
                    imageWidthAnswer = imageWidthAnswer * 0.30;
                }
                else if ($(window).width() > $(window).height() * 3.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.40;
                    imageWidthAnswer = imageWidthAnswer * 0.40;
                }
                else if ($(window).width() > $(window).height() * 2.5) {
                    imageWidthQuestion = imageWidthQuestion * 0.50;
                    imageWidthAnswer = imageWidthAnswer * 0.50;
                }
                else if ($(window).width() > $(window).height() * 2.25) {
                    imageWidthQuestion = imageWidthQuestion * 0.60;
                    imageWidthAnswer = imageWidthAnswer * 0.60;
                }
                else if ($(window).width() > $(window).height() * 2.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.80;
                    imageWidthAnswer = imageWidthAnswer * 0.80;
                }
                else if ($(window).width() > $(window).height() * 1.85) {
                    imageWidthQuestion = imageWidthQuestion * 0.90;
                    imageWidthAnswer = imageWidthAnswer * 0.90;
                }
                else if ($(window).width() > $(window).height() * 1.75) {
                    imageWidthQuestion = imageWidthQuestion * 0.95;
                    imageWidthAnswer = imageWidthAnswer * 0.95;
                }
                // Shrink question image, if question text is extremely long
                if (currentpuzzle.question) {
                    if (currentpuzzle.question.length > 90) {
                        imageWidthQuestion = imageWidthQuestion * 0.70;
                    }
                    else if (currentpuzzle.question.length > 45) {
                        imageWidthQuestion = imageWidthQuestion * 0.81;
                    }
                }
            }
            else {   // Portrait exp. : 604x400
                if ($(window).height() < $(window).width() * 1.1) {
                    imageWidthAnswer = imageWidthAnswer * 0.45;
                }
                else if ($(window).height() < $(window).width() * 1.15) {
                    imageWidthAnswer = imageWidthAnswer * 0.50;
                }
                else if ($(window).height() < $(window).width() * 1.25) {
                    imageWidthAnswer = imageWidthAnswer * 0.60;
                }
                else if ($(window).height() < $(window).width() * 1.35) {
                    imageWidthAnswer = imageWidthAnswer * 0.65;
                }
                else if ($(window).height() < $(window).width() * 1.45) {
                    imageWidthAnswer = imageWidthAnswer * 0.75;
                }
                else if ($(window).height() < $(window).width() * 1.55) {    
                    imageWidthAnswer = imageWidthAnswer * 0.85;
                }

                imageWidthQuestion = puzzleFrameWidth * 0.95;
	            // Check if image is too wide
    	        if (imageWidthQuestion > puzzleFrameMaxWidth) {
        	        imageWidthQuestion = puzzleFrameMaxWidth*0.88;
            	}
                if (currentpuzzle.question) {
                    if (currentpuzzle.question.length > 60) {
                        imageWidthQuestion = puzzleFrameWidth * 0.65;
                    }
                }

                if ($(window).height() > $(window).width() * 3.00) {
                    imageWidthQuestion = imageWidthQuestion * 2.10;
                }
                else if ($(window).height() > $(window).width() * 2.50) {
                    imageWidthQuestion = imageWidthQuestion * 1.90;
                }
                else if ($(window).height() > $(window).width() * 2.00) {
                    imageWidthQuestion = imageWidthQuestion * 1.20;
                }
                else if ($(window).height() > $(window).width() * 1.85) {
                    imageWidthQuestion = imageWidthQuestion * 1.00;
                }
                else if ($(window).height() > $(window).width() * 1.70) {
                    imageWidthQuestion = imageWidthQuestion * 0.93;
                }
                else if ($(window).height() > $(window).width() * 1.50) {
                    imageWidthQuestion = imageWidthQuestion * 0.85;
                }
                else if ($(window).height() > $(window).width() * 1.25) {
                    imageWidthQuestion = imageWidthQuestion * 0.7;
                }
                else if ($(window).height() > $(window).width() * 1.20) {
                    imageWidthQuestion = imageWidthQuestion * 0.65;
                }
                else if ($(window).height() > $(window).width() * 1.17) {
                    imageWidthQuestion = imageWidthQuestion * 0.6;
                }
                else if ($(window).height() > $(window).width() * 1.1) {
                    imageWidthQuestion = imageWidthQuestion * 0.55;
                }
                else if ($(window).height() > $(window).width() * 1.05) {
                    imageWidthQuestion = imageWidthQuestion * 0.5;
                }
            }
            
            // Display/resolution examples:
            //  - Sharp TV via Google TV -> 1064x524
            //  - HVGA, i.e. Keon/Geeksphone -> 480×320
//            if (!isLandscape) {   // Portrait but quite wide ( HVGA, i.e. Keon/Geeksphone )
//            	if (imageWidthQuestion > $(window).height()/2) {
//            		imageWidthQuestion = $(window).height()/2;
//            	}
//            }
        }
        else {
            // Small question-images at the top
            var imageWidthQuestion = puzzleFrameWidth / 6.50;
            var imageWidthAnswer = puzzleFrameWidth / 6.50;
            if (!isLandscape) {   // Portrait
                imageWidthQuestion = imageWidthQuestion * 1.70;
                imageWidthAnswer = imageWidthAnswer * 1.70;
                if ($(window).height() < $(window).width() * 1.45) {    // close to square
                    imageWidthQuestion = imageWidthQuestion * 0.80;
                    imageWidthAnswer = imageWidthAnswer * 0.80;
                }
            }
            else {
                if ($(window).width() > $(window).height() * 5.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.20;
                    imageWidthAnswer = imageWidthAnswer * 0.20;
                }
                else if ($(window).width() > $(window).height() * 4.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.30;
                    imageWidthAnswer = imageWidthAnswer * 0.30;
                }
                else if ($(window).width() > $(window).height() * 3.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.40;
                    imageWidthAnswer = imageWidthAnswer * 0.40;
                }
                else if ($(window).width() > $(window).height() * 2.5) {
                    imageWidthQuestion = imageWidthQuestion * 0.60;
                    imageWidthAnswer = imageWidthAnswer * 0.60;
                }
                else if ($(window).width() > $(window).height() * 2.25) {
                    imageWidthQuestion = imageWidthQuestion * 0.60;
                    imageWidthAnswer = imageWidthAnswer * 0.60;
                }
                else if ($(window).width() > $(window).height() * 2.0) {
                    imageWidthQuestion = imageWidthQuestion * 0.80;
                    imageWidthAnswer = imageWidthAnswer * 0.80;
                }
            }
        }

		// Compensate size measure "em", as i.e. TV sets adjust base font size
		imageWidthQuestion = imageWidthQuestion * getXLargeFontsizeDownscaleFactor();
		imageWidthAnswer = imageWidthAnswer * getXLargeFontsizeDownscaleFactor();

        var questionImgLargePadding = $('.question_img_large').innerWidth()-$('.question_img_large').width();
		questionImgLargePadding=0; 
        $('.question_img_large img').width(imageWidthQuestion-questionImgLargePadding);
        $('.question_img_large img').height(imageWidthQuestion-questionImgLargePadding);
        $('.question_img_large img').css("border", "none");
        $('.question_img_large').width(imageWidthQuestion);
        $('.question_img_large').height(imageWidthQuestion);
        var questionImgPadding = $('.question_img').innerWidth()-$('.question_img').width();
		questionImgPadding=0;
        $('.question_img img').width(imageWidthQuestion-questionImgPadding);
        $('.question_img img').height(imageWidthQuestion-questionImgPadding);
        $('.question_img img').css("border", "none");
        $('.question_img').width(imageWidthQuestion);
        $('.question_img').height(imageWidthQuestion);
       	nonBlockingPostpone( function(){         
	        var sepHeight = $('.qa_col').innerHeight()-10;
	        $('.verticalseparatorPuzzle').height( sepHeight );
	        var sepWidth = $('.qa_row_wa_background').innerWidth()-10;
	        $('.horizontalseparatorPuzzle').width( sepWidth );
	    },100);
        var answerImgPadding = $('.answer_img').innerWidth()-$('.answer_img').width();
		answerImgPadding=0;
        $('.answer_img img').width(imageWidthAnswer-answerImgPadding);
        $('.answer_img img').height(imageWidthAnswer-answerImgPadding);
        $('.answer_img img').css("border", "none");
        $('.answer_img').width(imageWidthAnswer);
        $('.answer_img').height(imageWidthAnswer);
        $('.answer_img').focus( function(){ 
									if(focusStyleOn){
        								$(this).data( 'paddingOld', $(this).css('padding') )
        								$(this).data( 'marginOld', $(this).css('margin') )
        								$(this).animate(
					    					{ 
    										  padding: "-=10",
    										  margin: "+=10",
    										},  
  											500, 
  											function() {
		        								$(this).animate(
							    					{ 
		    										  padding: "+=10",
		    										  margin: "-=10",
    												},  
  													200, 
  													function() {
														// completed
		  											}
  												);
  											}
  										);
  									}    //  focusStyleOn
        						}
        					);
        $('.answer_img').blur( function(){ $(this).stop();
									if(focusStyleOn){
	        								$(this).css( 'padding', $(this).data('paddingOld') );
    	    								$(this).css( 'margin', $(this).data('marginOld') );
    	    							}
        							} );

	    // Replace placeholder attributes
        if ($('#explanation').is(":visible")) {
            multilanguage.replaceStringsOfUserinterface(".multilanguageExpl");
        }

	    // Apply failed-status to answer images
        $.each(currentpuzzle.failed_answers, function (id, val) {
            if (val == "fail") {
                var answerIdSelector = "#" + id
                $(answerIdSelector).addClass("answerfailed");
            }
        });

        if (isLandscape) {
			nonBlockingPostpone( function(){ 
				// Scroll up to make sure top of page is visible
				// 	-> i.e. needed for Safari on IPod after rotation change
				window.scrollTo(0,0); 
			}, 100);
		}

        currentpuzzle.rendered=true;

        // Write puzzle sequence id to local storage
        settingsHelper.setItem('seq_id', currentpuzzle_seq_id);
	},

	getPuzzleByIndex: function(idx){
    	var numberOfPuzzles=game.getNumberOfPuzzles(null,puzzleHelper.DIFFICULTY_MIXED,null);

		if(idx == null || puzzles==null || idx >= numberOfPuzzles ){
			return null;
		}		
		var i=1;
		for(var pzidx in puzzles){
			if(i==idx){
				return puzzles[pzidx];
			}
			else{
				i++;
			}
		}
		return null;
	},

	updatePuzzleList: function(){
		var plist = $("#progressPuzzlelistUl");
		var len = $("#progressPuzzlelistUl div").length;
		
		nonBlocking( function(){ 
	   		var plWidth=$(window).width()*0.95;
       		var plPadding=$('#gameprogressShowPuzzlelist').height( )/2;
   			var plHeight=$(window).height()
		   				- 1.1*$('#gameprogressShowPuzzlelist').height( )
   						- 2*$('.verticalSpace_xsmall').height( )
   						- $('#progressDetailSeparatorBottom').height( )
   						- $('#progressDetailSeparatorTop').height( )
   						- $('#resetGameProgress').height( )
   						- 3*plPadding;
   			$('#progressDetailSeparatorTop').width( plWidth );
   			$('#progressDetailSeparatorBottom').width( plWidth );
   			$('#progressPuzzlelist').width( plWidth );
   			$('#progressPuzzlelist').height( plHeight );
   			$('#progressPuzzlelistUl').width( plWidth );
   			$('#progressPuzzlelistUl').height( plHeight );
			// Make sure, linebreaks are working for Firefox 
   			game.updateListItemRightWidth();
		});

		if(len==0){    // take care, equals 1, if <UL> tag has no children!!!
			// Add first gameprogressPuzzeListStartSize puzzles to list
			var puzzleCell = game.getPuzzleListItem(null,false,1);
			plist.prepend( puzzleCell );
			for(var m=2;m<=gameprogressPuzzeListStartSize;m++){
				var puzzleCell = game.getPuzzleListItem(null,false,m);
				plist.append( puzzleCell );
			}
		}
		else{
			// Update puzzle status
			$('div.puzzleListItemFrame').each( function(i,e){   // i=index, e=element
				var puzzleOfCell = puzzles[e.id];
		    	var leftDivId = 'puzzleListItemStatus_' + e.id;
				var itemLeftStatus = $('#'+leftDivId);
		    	// Status    	
		        if(puzzleOfCell.state==puzzleStateNew){
		        	if(liteversion && puzzleOfCell.premium){
						itemLeftStatus.removeClass('gameprogressStatusColorRight');
						itemLeftStatus.removeClass('gameprogressStatusColorWrong');
						itemLeftStatus.removeClass('gameprogressStatusColorUnplayed');
						itemLeftStatus.addClass('gameprogressStatusColorLocked');
		        		itemLeftStatus.attr("data-mlresourceids","locked");
		        		itemLeftStatus.html( multilanguageStrings['locked'].value );	
		        	}
		        	else{
						itemLeftStatus.removeClass('gameprogressStatusColorLocked');
						itemLeftStatus.removeClass('gameprogressStatusColorRight');
						itemLeftStatus.removeClass('gameprogressStatusColorWrong');
						itemLeftStatus.addClass('gameprogressStatusColorUnplayed');
		        		itemLeftStatus.attr("data-mlresourceids","unplayed");
		        		itemLeftStatus.html( multilanguageStrings['unplayed'].value );	
		        	}
		        }
		        else if(puzzleOfCell.state==puzzleStatePlayed){
					itemLeftStatus.removeClass('gameprogressStatusColorLocked');
					itemLeftStatus.removeClass('gameprogressStatusColorRight');
					itemLeftStatus.removeClass('gameprogressStatusColorUnplayed');
					itemLeftStatus.addClass('gameprogressStatusColorWrong');
	        		itemLeftStatus.attr("data-mlresourceids","wrong");
	        		itemLeftStatus.html( multilanguageStrings['wrong'].value );	
		        }
		        else if(puzzleOfCell.state==puzzleStateSolved){
					itemLeftStatus.removeClass('gameprogressStatusColorLocked');
					itemLeftStatus.removeClass('gameprogressStatusColorWrong');
					itemLeftStatus.removeClass('gameprogressStatusColorUnplayed');
					itemLeftStatus.addClass('gameprogressStatusColorRight');
	        		itemLeftStatus.attr("data-mlresourceids","right");
	        		itemLeftStatus.html( multilanguageStrings['right'].value );	
		        }
		      				
			});
		}
	},

	puzzlelistResetted: function(){
		if(puzzlelistHasBeenResetted){
			puzzlelistHasBeenResetted=false;
			return true;
		}
		return false;
	},
	
	resetPuzzlelist: function(){
		var plist = $('div#progressPuzzlelistUl')
		plist.empty();
		puzzlelistHasBeenResetted=true;
	},
	
    getPuzzleListItem: function(i, asHtmlString, explicitIndexI){
  	    var newline=" <br />  - ";
    	var puzzleIndex;
    	var question="";
    	var questionImage;
    	var index_offset_q=0;
   	    var resIdFilled=false;
    	
    	if(puzzles==null){ return null}
    	if(puzzles.length==0){ return null}
    	
    	var numberOfPuzzles=game.getNumberOfPuzzles(null,puzzleHelper.DIFFICULTY_MIXED,null);
    	
    	if(explicitIndexI!=null && explicitIndexI>0){
    		puzzleIndex = explicitIndexI;
    	}
    	else{
        	if(i>=0){
        		puzzleIndex = (i+gameprogressPuzzeListStartSize) % numberOfPuzzles;
        	}
        	else{
        		puzzleIndex = puzzles.length - (-1*i) % numberOfPuzzles;    		
        	}    		
    	}
    	
    	// Puzzle to be added to list
    	var puzzleForCell=game.getPuzzleByIndex( puzzleIndex );
    	
    	// Get question text
        if( puzzleForCell.is_stringresource ){
        	switch(puzzleForCell.pattern){
            	case puzzleHelper.PATTERN_SERIES_COMPLETE_STRING:{
		            if( puzzleForCell.question != null && puzzleForCell.question.length>0 ){
		            	if(puzzleForCell.question_resId!=null){
			            	question = puzzleForCell.question; 
		            	}
		            	else{
			            	question = multilanguageStrings[puzzleForCell.question].value; 
		            	}
		            }
		            else{
		            	question = multilanguageStrings[puzzleHelper.TEXT_outsider_description_string].value; 
		            }
		            break;
            	}

            	case puzzleHelper.PATTERN_OUTSIDER_STRING:{
		            if( puzzleForCell.question != null && puzzleForCell.question.length > 0){
		            	if(puzzleForCell.question_resId!=null){
			            	question = puzzleForCell.question;
		            	}
		            	else{
		            		question = multilanguageStrings[puzzleForCell.question].value; 
		            	}
		            }
		            else{
		            	question = multilanguageStrings[puzzleHelper.TEXT_outsider_description_string].value; 
		            }
		            break;
            	}

            	case puzzleHelper.PATTERN_SERIES_COMPLETE_IMAGE:{
            		if(puzzleForCell.question_description_type==puzzleHelper.DESCRIPTION_TYPE_GENERIC){ 
            			index_offset_q += 1;
		                switch(puzzleForCell.question_description_type){
			                case puzzleHelper.DESCRIPTION_TYPE_GENERIC: {
				            	if(puzzleForCell.question_resId!=null){
					            	question = puzzleForCell.question;
				            	}
				            	else{
				                	question = multilanguageStrings[puzzleForCell.question].value; 
				            	}
			                  break;
			                }
			                default:{
					            if( puzzleForCell.question_1 != null && puzzleForCell.question_1.length>0 ){
					            	if(puzzleForCell.question_resId!=null){
						            	question = puzzleForCell.question;
					            	}
					            	else{
					            		question = multilanguageStrings[puzzleForCell.question].value; 
					            	}
						        }
						        else{
						        	question = ""; 
						        }			                	
			                }
		                }
	            	}
            		else{
    		            if( puzzleForCell.question_1 != null && puzzleForCell.question_1.length>0 ){
			            	if(puzzleForCell.question_resId!=null){
				            	question = puzzleForCell.question;
			            	}
			            	else{
			            		question = multilanguageStrings[puzzleForCell.question].value; 
			            	}
        		        }
        		        else{
        		        	question = act.getText(puzzleHelper.TEXT_complete_series).toString(); 
        		        }	            			
            		}
            		break;
            	}

            	case puzzleHelper.PATTERN_OUTSIDER_IMAGE:{
            		if(puzzleForCell.question_description_type==puzzleHelper.DESCRIPTION_TYPE_GENERIC){ 
            			index_offset_q += 1;
		                switch(puzzleForCell.question_description_type){
			                case puzzleHelper.DESCRIPTION_TYPE_GENERIC: {
				            	if(puzzleForCell.question_resId!=null){
					            	question = puzzleForCell.question;
				            	}
				            	else{
				            		question = multilanguageStrings[puzzleForCell.question].value; 
				            	}
			                  break;
			                }
			                default:{
					            if( puzzleForCell.question_1 != null && puzzleForCell.question_1.length>0 ){
					            	if(puzzleForCell.question_resId!=null){
						            	question = puzzleForCell.question;
					            	}
					            	else{
					            		question = multilanguageStrings[puzzleForCell.question].value; 
					            	}
						        }
						        else{
						        	question = ""; 
						        }			                	
			                }
		                }
	            	}
            		break;
            	}
            	
            	case puzzleHelper.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE:{
            		switch(puzzleForCell.question_description_type){
	  	              	case puzzleHelper.DESCRIPTION_TYPE_COMPLETE_USEFULLY: {
	  	              		question = act.getText(puzzleHelper.TEXT_premium_content_description_useful).toString();
	  	              	    break;
	  	              	}	  	              	
	  	                case puzzleHelper.DESCRIPTION_TYPE_ANALOGY: {
	  	                	question = act.getText(puzzleHelper.TEXT_premium_content_analogy).toString();
		  	                break;
		  	            }
		  	            case puzzleHelper.DESCRIPTION_TYPE_GENERIC: {
		  	                index_offset_q = 1;
			            	if(puzzleForCell.question_resId!=null){
				            	question = puzzleForCell.question;
			            	}
			            	else{
			            		question = multilanguageStrings[puzzleForCell.question].value; 
			            	}
		  	                break;
		  	            }	            		
            		}
            	}
            	break;
        	}
        }

        // Get preview image or apply special multiline text logic
	    switch(puzzleForCell.pattern){
	      case puzzleHelper.PATTERN_SERIES_COMPLETE_STRING:{
	    	  if(puzzleForCell.question==null || puzzleForCell.question.length==0){
	              question = puzzleForCell.question_1;		    		  
	    	  }
	    	  // Special logic to show text answers 1-5
	          if( puzzleForCell.is_stringresource ){
	              if(puzzleForCell.answer_1_resId!=null){
		        	  resIdFilled=true;
		          	  question = question + newline + puzzleForCell.answer_1;
		          	  question = question + newline + puzzleForCell.answer_2;	            	  	            	  
	              }
	              else{
		          	  question = question + newline + multilanguageStrings[puzzleForCell.answer_1].value;
		          	  question = question + newline + multilanguageStrings[puzzleForCell.answer_2].value;	            	  
	              }
	        	  if(puzzleForCell.answer_3 != null){
		        	  if(resIdFilled){
		        		  question = question + newline + puzzleForCell.answer_3;
		        	  }
		        	  else{
		        		  question = question + newline + multilanguageStrings[puzzleForCell.answer_3].value;		        		  
		        	  }
	        	  }
	        	  if(puzzleForCell.answer_4 != null){
		        	  if(resIdFilled){
		        		  question = question + newline + puzzleForCell.answer_4;
		        	  }
		        	  else{
		        		  question = question + newline + multilanguageStrings[puzzleForCell.answer_4].value;		        		  
		        	  }
	        	  }
	        	  if(puzzleForCell.answer_5 != null){
		        	  if(resIdFilled){
		        		  question = question + newline + puzzleForCell.answer_5;
		        	  }
		        	  else{
		        		  question = question + newline + multilanguageStrings[puzzleForCell.answer_5].value;		        		  
		        	  }
	              }
	          }
	          else{
	        	  question = puzzleForCell.question;
	        	  question = question + newline + puzzleForCell.answer_1;
	        	  question = question + newline + puzzleForCell.answer_2;
	        	  if(puzzleForCell.answer_3 != null){
	        		  question = question + newline + puzzleForCell.answer_3;
	        	  }
	        	  if(puzzleForCell.answer_4 != null){
	        		  question = question + newline + puzzleForCell.answer_4;
	        	  }
	        	  if(puzzleForCell.answer_5 != null){
	        		  question = question + newline + puzzleForCell.answer_5;
	              }
	          }
	          break;
	      }	              
	      case puzzleHelper.PATTERN_SERIES_COMPLETE_IMAGE:{
	    	  if(question.length==0){
		            if(puzzleForCell.question_description_type==puzzleHelper.DESCRIPTION_TYPE_GENERIC){ 
			              index_offset_q = 1;
			              switch(puzzleForCell.question_description_type){
			                case puzzleHelper.DESCRIPTION_TYPE_GENERIC: {
				            	if(puzzleForCell.question_resId!=null){
					            	question = puzzleForCell.question;
				            	}
				            	else{
				            		question = multilanguageStrings[puzzleForCell.question].value; 
				            	}
			                }
			              };
		            }	
		            else{
	                	question = multilanguageStrings[puzzleHelper.TEXT_complete_series].value; 
		            }
	    	  }
	    	  if(index_offset_q>0){
		    	  questionImage=puzzleForCell.question_1;	    		  
	    	  }
	    	  else{
	              if( puzzleForCell.question != null && puzzleForCell.question.length>0 ){
	            	  questionImage=puzzleForCell.question;
	              }
	              else{
	            	  questionImage=puzzleForCell.question_1;	            	  
	              }
	    	  }
	          break;
	      }
	      case puzzleHelper.PATTERN_OUTSIDER_STRING:{
	    	  if(question.length==0){
	              if( puzzleForCell.question != null && puzzleForCell.question.length>0 ){
	            	  if(puzzleForCell.question_resId!=null){
		            	  question = puzzleForCell.question; 	            		  	            		  
	            	  }
	            	  else{
		            	  question = multilanguageStrings[puzzleForCell.question].value; 	            		  
	            	  }
		          }
		          else{
	               	question = multilanguageStrings[puzzleHelper.TEXT_outsider_description_string].value; 
		          }
	    	  }
	    	  // Special logic to show text answers 1-5
	          if( puzzleForCell.is_stringresource ){
	              if(puzzleForCell.answer_1_resId!=null){
		        	  resIdFilled=true;
		          	  question = question + newline + puzzleForCell.answer_1;
		          	  question = question + newline + puzzleForCell.answer_2;	            	  	            	  
	              }
	              else{
		          	  question = question + newline + multilanguageStrings[puzzleForCell.answer_1].value;
		          	  question = question + newline + multilanguageStrings[puzzleForCell.answer_2].value;	            	  
	              }
		          if(puzzleForCell.answer_3 != null){
		        	  if(resIdFilled){
			        	  question = question + newline + puzzleForCell.answer_3;		        		  
		        	  }
		        	  else{
			        	  question = question + newline + multilanguageStrings[puzzleForCell.answer_3].value;		        		  
		        	  }
	              }
		          if(puzzleForCell.answer_4 != null){
		        	  if(resIdFilled){
			        	  question = question + newline + puzzleForCell.answer_4;		        		  
		        	  }
		        	  else{
			        	  question = question + newline + multilanguageStrings[puzzleForCell.answer_4].value;		        		  
		        	  }
	              }
		          if(puzzleForCell.answer_5 != null){
		        	  if(resIdFilled){
			        	  question = question + newline + puzzleForCell.answer_5;		        		  
		        	  }
		        	  else{
			        	  question = question + newline + multilanguageStrings[puzzleForCell.answer_5].value;		        		  
		        	  }
		          }
	          }
	          else{
	        	  question = question + newline + puzzleForCell.answer_1;
	        	  question = question + newline + puzzleForCell.answer_2;
		          if(puzzleForCell.answer_3 != null){
	        		  question = question + newline + puzzleForCell.answer_3;
	        	  }
		          if(puzzleForCell.answer_4 != null){
		        	  question = question + newline + puzzleForCell.answer_4;
	        	  }
		          if(puzzleForCell.answer_5 != null){
		        	  question = question + newline + puzzleForCell.answer_5;
	              }
	          }
	          break;
	      }
	      case puzzleHelper.PATTERN_OUTSIDER_IMAGE:{
        	  questionImage=puzzleForCell.answer_1;
              if( puzzleForCell.question_1 != null && puzzleForCell.question_1.length>0 ){
		    	  if(question.length==0){
		    		  question = multilanguageStrings[puzzleForCell.question_1].value;
		    	  }
		      }
		      else{
		    	  if(question.length==0){
		    		  question = multilanguageStrings[puzzleHelper.TEXT_outsider_description_string].value; 
		    	  }
		      }
		      break;
	      }
	      
	      case puzzleHelper.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE:{
	    	  
	            if(puzzleForCell.question_description_type == puzzleHelper.DESCRIPTION_TYPE_GENERIC){
		              // index 0 is used for the generic question description (text)
	            	  questionImage=puzzleForCell.question_1;
		            }
		            else{
	            	  questionImage=puzzleForCell.question_1;
		        }
				
				if(question.length==0){
		            switch(puzzleForCell.question_description_type){
		              case puzzleHelper.DESCRIPTION_TYPE_COMPLETE_USEFULLY: {
				    	if(question.length==0){
			    		    question = multilanguageStrings[puzzleHelper.TEXT_premium_content_description_useful].value; 
				        }
		                break;
		              }
		              case puzzleHelper.DESCRIPTION_TYPE_ANALOGY: {
				    	if(question.length==0){
			    		    question = multilanguageStrings[puzzleHelper.TEXT_premium_content_analogy].value; 
				        }
		                break;
		              }
		              case puzzleHelper.DESCRIPTION_TYPE_GENERIC: {
		                index_offset_q = 1;
			    	    if(question.length==0){
			            	if(puzzleForCell.question_resId!=null){
				            	question = puzzleForCell.question;
			            	}
			            	else{
			            		question = multilanguageStrings[puzzleForCell.question].value;
			            	}
			            }
		                break;
		              }
		            };
		    	}
		        break;
	      }
	    }
    	    	
    	// Render into html element
    	var puzzleCellHtml;
    	if(questionImage != null){
        	puzzleCellHtml = layoutTemplates['puzzle_list_cell'];
        }
        else{
        	puzzleCellHtml = layoutTemplates['puzzle_list_cell_wo_image'];        
        }            
        var puzzleId = puzzleForCell.seq_no;
        puzzleCellHtml=puzzleCellHtml.replace('---id---',puzzleId);
        puzzleCellHtml=puzzleCellHtml.replace('---tabindex---',5300+i);
        var puzzleItemId = 'puzzleListItemId_' + puzzleId;
    	puzzleCellHtml=puzzleCellHtml.replace('---puzzleListItemId---',puzzleItemId);
    	var statusDivId = 'puzzleListItemStatus_' + puzzleId;
    	puzzleCellHtml=puzzleCellHtml.replace('---puzzleListItemStatus---',statusDivId);
    	var leftDivId = 'puzzleListItemLeft_' + puzzleId;
    	puzzleCellHtml=puzzleCellHtml.replace('---puzzleListItemLeftId---',leftDivId);
    	var middleDivId = 'puzzleListItemMiddle_' + puzzleId;
       	if(questionImage != null){
    		puzzleCellHtml=puzzleCellHtml.replace('---puzzleListItemMiddleId---',middleDivId);
    	}
    	var rightDivId = 'puzzleListItemRight_' + puzzleId;
    	puzzleCellHtml=puzzleCellHtml.replace('---puzzleListItemRightId---',rightDivId);
        // Status    	
        if(puzzleForCell.state==puzzleStateNew){
        	if(liteversion && puzzleForCell.premium){
            	puzzleCellHtml=puzzleCellHtml.replace('---gameprogressStatusColor---','gameprogressStatusColorLocked');
            	puzzleCellHtml=puzzleCellHtml.replace('---status---','locked');
            	puzzleCellHtml=puzzleCellHtml.replace('---statusText---',multilanguageStrings['locked'].value);        		
        	}
        	else{
            	puzzleCellHtml=puzzleCellHtml.replace('---gameprogressStatusColor---','gameprogressStatusColorUnplayed');
            	puzzleCellHtml=puzzleCellHtml.replace('---status---','unplayed');
            	puzzleCellHtml=puzzleCellHtml.replace('---statusText---',multilanguageStrings['unplayed'].value);        		
        	}
        }
        else if(puzzleForCell.state==puzzleStatePlayed){
        	puzzleCellHtml=puzzleCellHtml.replace('---gameprogressStatusColor---','gameprogressStatusColorWrong');
        	puzzleCellHtml=puzzleCellHtml.replace('---status---','wrong');
        	puzzleCellHtml=puzzleCellHtml.replace('---statusText---',multilanguageStrings['wrong'].value);
        }
        else if(puzzleForCell.state==puzzleStateSolved){
        	puzzleCellHtml=puzzleCellHtml.replace('---gameprogressStatusColor---','gameprogressStatusColorRight');
        	puzzleCellHtml=puzzleCellHtml.replace('---status---','right');
        	puzzleCellHtml=puzzleCellHtml.replace('---statusText---',multilanguageStrings['right'].value);
        }
        
        // Difficulty
        if(puzzleForCell.difficulty==1){
        	puzzleCellHtml=puzzleCellHtml.replace('---difficulty---','difficulty_easy');        	
        	puzzleCellHtml=puzzleCellHtml.replace('---difficultyText---',multilanguageStrings['difficulty_easy'].value);
        }
        else if(puzzleForCell.difficulty==3){
        	puzzleCellHtml=puzzleCellHtml.replace('---difficulty---','difficulty_hard');        	        	
        	puzzleCellHtml=puzzleCellHtml.replace('---difficultyText---',multilanguageStrings['difficulty_hard'].value);
        }
        
        // Description
         question = question.replace("\\n", "<br />");
    	puzzleCellHtml=puzzleCellHtml.replace('---descriptionText---',question);
        
    	// Question Image
    	if(questionImage != null){
        	puzzleCellHtml=puzzleCellHtml.replace('---cssClassPuzzleListItemRight---','puzzleListItemRight');
        	puzzleCellHtml=puzzleCellHtml.replace('---dataIsWide---','false');
        	puzzleCellHtml=puzzleCellHtml.replace('---questionImg---',questionImage);        	    	
        	puzzleCellHtml=puzzleCellHtml.replace('---questionImgAlt---',questionImage);            
    	}
    	else{
        	puzzleCellHtml=puzzleCellHtml.replace('---cssClassPuzzleListItemRight---','puzzleListItemRightWide');
        	puzzleCellHtml=puzzleCellHtml.replace('---dataIsWide---','true');
    	}
    	
    	if(asHtmlString){
    		return puzzleCellHtml;
    	}
    	else{
        	// Add click handler
        	var puzzleCellObj = $(puzzleCellHtml);
        	if(liteversion && puzzleForCell.premium){   // Puzzle is locked (puzzle available for full version only!!!)
        		puzzleCellObj.click(clickHandlerPuzzleCellLocked);
        		puzzleCellObj.keydown(clickHandlerPuzzleCellLocked);
        		puzzleCellObj.addClass("puzzleIsLocked");
        	}
        	else{
            	puzzleCellObj.click(clickHandlerPuzzleCell);    		
            	puzzleCellObj.keydown(clickHandlerPuzzleCell);    		
        	}        	

	        puzzleCellObj.focus( function(){ 
        								$(this).data( 'paddingOld', $(this).css('padding') )
        								$(this).data( 'marginOld', $(this).css('margin') )
        								$(this).animate(
					    					{ 
    										  padding: "-=10",
    										  margin: "+=10",
    										},  
  											500, 
  											function() {
		        								$(this).animate(
							    					{ 
		    										  padding: "+=10",
		    										  margin: "-=10",
    												},  
  													200, 
  													function() {
														// completed
		  											}
  												);
  											}
  										);
        						}
        					);
    	    puzzleCellObj.blur( function(){ $(this).stop();
        								$(this).css( 'padding', $(this).data('paddingOld') );
        								$(this).css( 'margin', $(this).data('marginOld') );
        							} );

        	return puzzleCellObj;    	
    	}
    	
    },
	
    savePuzzleState: function(){
		// Save puzzles states to settings parameter
        settingsHelper.setItem('puzzlestates', serializePuzzleStates());
	},
	
	setPuzzleSolved: function(cpz){
	    if(puzzles!=null){
    		for(var pzidx in puzzles){
    			var pz=puzzles[pzidx];
				if(cpz.id==pz.id){
					pz.state = puzzleStateSolved;
				}
			}
	    }
	},
		
	setPuzzlePlayed: function(cpz){
	    if(puzzles!=null){
    		for(var pzidx in puzzles){
    			var pz=puzzles[pzidx];
				if(cpz.id==pz.id){
					pz.state = puzzleStatePlayed;
				}
			}
	    }
	},
		
	updateGameProgress: function(){
	    var isLandscape = true;	    
	    if ($(window).width() > $(window).height()) {
	        isLandscape = true;
	    }
	    else {
	        isLandscape = false;
	    }
		
		// Header
		multilanguage.replaceStringsOfUserinterface(".multilanguage");

    	// Legend
		var is_premium=null;   // null -> all puzzles, true -> only premium puzzles (all BUT lite version!!!)
		if(liteversion){
			is_premium=false;
		}
		var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
		var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
		var noNew=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateNew);
		var noAll = noPlayed + noSolved + noNew; 
		var ratioSolved = noSolved/noAll;
		var ratioSolvedUi = 100*(noSolved/noAll);
		var ratioPlayed = noPlayed/noAll;
		var fractionNew = 100-Math.round(100*ratioSolved)-Math.round(100*ratioPlayed);
	    var fractionSolved=Math.round(100*ratioSolved);
	    var fractionPlayed=Math.round(100*ratioPlayed);

		// Seal icons
		if(ratioSolvedUi>10){$('#gameprogress_icon1').attr("src","res/drawable/seal_active.png")}
			else{$('#gameprogress_icon1').attr("src","res/drawable/seal_inactive.png")}
		if(ratioSolvedUi>30){$('#gameprogress_icon2').attr("src","res/drawable/seal_active.png")}
			else{$('#gameprogress_icon2').attr("src","res/drawable/seal_inactive.png")}
		if(ratioSolvedUi>50){$('#gameprogress_icon3').attr("src","res/drawable/seal_active.png")}
			else{$('#gameprogress_icon3').attr("src","res/drawable/seal_inactive.png")}
		if(ratioSolvedUi>70){$('#gameprogress_icon4').attr("src","res/drawable/seal_active.png")}
			else{$('#gameprogress_icon4').attr("src","res/drawable/seal_inactive.png")}
		if(ratioSolvedUi>90){$('#gameprogress_icon5').attr("src","res/drawable/seal_active.png")}
			else{$('#gameprogress_icon5').attr("src","res/drawable/seal_inactive.png")}		

		// Legend
    	$('#gameprogressLegend_rightValue').text( fractionSolved+"%");
    	$('#gameprogressLegend_wrongValue').text( fractionPlayed+"%");
    	$('#gameprogressLegend_unplayedValue').text( fractionNew+"%");
		
		// Chart
		if (gl) {
			initShaders();
			initBuffers( ratioPlayed, ratioPlayed+ratioSolved);
			gl.enable(gl.DEPTH_TEST);
			tick();
		}
		else{
			var gameprogressCanvas = $('#gameprogressCanvas');
			gameprogressCanvas.width('0px');
			// Update bar chart ( legend )
	    	game.updateBarchartLegendSize( fractionSolved, fractionPlayed, fractionNew );		
		}
		
		// Puzzle list
    	game.updatePuzzleList();				
	},

    updateListItemRightWidth: function(){
		// Make sure, linebreaks are working for Firefox 
		$('.puzzleListItemRight').width( game.getListItemRightWidth(false) );
		$('.puzzleListItemRightWide').width( game.getListItemRightWidth(true) );
	},

    getListItemRightWidth: function( isWide ){
   		var plWidth=$(window).width()*0.95;
	    if ($(window).width() > $(window).height()) {
	    	// Landscape
	    	if(isWide){
				return plWidth*0.80;
	    	}
	    	else{
				return plWidth*0.70;
	    	}
   		}
   		else {
   			// Portrait
	    	if(isWide){
				return plWidth*0.75;
	    	}
	    	else{
				return plWidth*0.50;
	    	}
   		}
	},

	updateBarchartLegendSize: function(fractionSolved, fractionPlayed, fractionNew){		
	    var isLandscape = true;	    
	    if ($(window).width() > $(window).height()) {
	        isLandscape = true;
			var ww=$(window).width()*0.50;
	    }
	    else {
	        isLandscape = false;
			var ww=$(window).width()*0.65;
	    }

	    // Hide canvas
		if(fractionSolved==0){
			$('#gameprogressLegend_right').width( 2 );			
		}
		else{
			$('#gameprogressLegend_right').width( Math.round( (fractionSolved*ww)/100) );			
		}
		if(fractionPlayed==0){
			$('#gameprogressLegend_wrong').width( 2 );			
		}
		else{
			$('#gameprogressLegend_wrong').width( Math.round( (fractionPlayed*ww)/100) );			
		}
		if(fractionNew==0){
			$('#gameprogressLegend_unplayed').width( 2 );			
		}
		else{
			$('#gameprogressLegend_unplayed').width( Math.round( (fractionNew*ww)/100) );			
		}
		if(isLandscape){
			var hh=$(window).height()*0.15;
			$('#gameprogressLegend_right').height(hh);        		
			$('#gameprogressLegend_wrong').height(hh);        		
			$('#gameprogressLegend_unplayed').height(hh);        		
		}
		else{
			var hh=$(window).width()*0.15;
			$('#gameprogressLegend_right').height(hh);        		        		
			$('#gameprogressLegend_wrong').height(hh);        		        		
			$('#gameprogressLegend_unplayed').height(hh);        		        		
		}
	},
	
	resetGameprogress: function(){
	    if(puzzles!=null){
    		for(var pzidx in puzzles){
    			var pz=puzzles[pzidx];
				pz.state = puzzleStateNew;
			}
	    }
  	    // Save puzzles states to settings parameter
  	    game.savePuzzleState();  
  	    
	    // Initialize sequence number
	    if(liteversion){
	    	currentpuzzle_seq_id=0;
	    }
	    else{
	    	currentpuzzle_seq_id=9999;
	    }
	    previous_seq_id=77777;   // No previous puzzle available
        // Write puzzle sequence id to local storage
        settingsHelper.setItem('seq_id', currentpuzzle_seq_id);

        // Show puzzle-shortcome popover again
        allPuzzlesPlayed=0;
        settingsHelper.setItem('allpuzzlesplayed', allPuzzlesPlayed);
        
        // Update game progress popover
  	    game.updateGameProgress();
  	    // Reset the "Answer Failed" styling of the answer DIVs
  	    game.resetAnswerFailed();
	},
	
	resetAnswerFailed: function(){
		if(currentpuzzle){    // Robustness
	        if(currentpuzzle.answerIsText==true){
    	    	$('#answer_txt1').removeClass("answerfailed");
  			  	$('#answer_txt2').removeClass("answerfailed");
  		  		$('#answer_txt3').removeClass("answerfailed");
	  		  	$('#answer_txt4').removeClass("answerfailed");
  			  	$('#answer_txt5').removeClass("answerfailed");
        	}
	        else{
    	    	$('#answer_img1').removeClass("answerfailed");
        		$('#answer_img2').removeClass("answerfailed");
        		$('#answer_img3').removeClass("answerfailed");
	        	$('#answer_img4').removeClass("answerfailed");
    	    	$('#answer_img5').removeClass("answerfailed");
        	}
        }
	},
	
	getNumberOfPuzzles: function(is_premium, difficulty, state){
		var count=0;
		if(puzzles==null){
			return null;
		}
		if(puzzles.length==0){
			return null;
		}
		for(var pzidx in puzzles){
			var pz=puzzles[pzidx];
	        if( difficulty == puzzleHelper.DIFFICULTY_MIXED || pz.difficulty == difficulty ){
		        if( ( is_premium == null || pz.premium == is_premium)
		        	  && ( state == null || pz.state == state ) ){
		        	count++;
		        }
		    }
	    }
	    return count;
	},
	
    replaceTemplatePlaceholders: function(puzzleHtml, currentpuzzle){

        var prefix = '" data-src="';    
        var resourcePath = 'res/drawable/';    
        var prefixPlus = prefix+resourcePath;    
        puzzleHtml = puzzleHtml.replace('{{question}}',currentpuzzle.question);

        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_1}}',resourcePath+currentpuzzle.question_1);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_2}}',resourcePath+currentpuzzle.question_2);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_3}}',resourcePath+currentpuzzle.question_3);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_4}}',resourcePath+currentpuzzle.question_4);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_5}}',resourcePath+currentpuzzle.question_5);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_6}}',resourcePath+currentpuzzle.question_6);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_7}}',resourcePath+currentpuzzle.question_7);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_8}}',resourcePath+currentpuzzle.question_8);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{question_9}}',resourcePath+currentpuzzle.question_9);

        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{answer_1}}',resourcePath+currentpuzzle.answer_1);
        puzzleHtml = puzzleHtml.replace('{{answer_1}}',currentpuzzle.answer_1);
        puzzleHtml = puzzleHtml.replace('{{answer_1}}',currentpuzzle.answer_1);
        puzzleHtml = puzzleHtml.replace('{{answer_1}}',currentpuzzle.answer_1);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{answer_2}}',resourcePath+currentpuzzle.answer_2);
        puzzleHtml = puzzleHtml.replace('{{answer_2}}',currentpuzzle.answer_2);
        puzzleHtml = puzzleHtml.replace('{{answer_2}}',currentpuzzle.answer_2);
        puzzleHtml = puzzleHtml.replace('{{answer_2}}',currentpuzzle.answer_2);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{answer_3}}',resourcePath+currentpuzzle.answer_3);
        puzzleHtml = puzzleHtml.replace('{{answer_3}}',currentpuzzle.answer_3);
        puzzleHtml = puzzleHtml.replace('{{answer_3}}',currentpuzzle.answer_3);
        puzzleHtml = puzzleHtml.replace('{{answer_3}}',currentpuzzle.answer_3);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{answer_4}}',resourcePath+currentpuzzle.answer_4);
        puzzleHtml = puzzleHtml.replace('{{answer_4}}',currentpuzzle.answer_4);
        puzzleHtml = puzzleHtml.replace('{{answer_4}}',currentpuzzle.answer_4);
        puzzleHtml = puzzleHtml.replace('{{answer_4}}',currentpuzzle.answer_4);
        puzzleHtml = puzzleHtml.replace(prefixPlus+'{{answer_5}}',resourcePath+currentpuzzle.answer_5);
        puzzleHtml = puzzleHtml.replace('{{answer_5}}',currentpuzzle.answer_5);
        puzzleHtml = puzzleHtml.replace('{{answer_5}}',currentpuzzle.answer_5);
        puzzleHtml = puzzleHtml.replace('{{answer_5}}',currentpuzzle.answer_5);
        
        puzzleHtml = puzzleHtml.replace('<div data-template-fallback>Sorry, JavaScript required!</div>','');

		return puzzleHtml;
    }              

}