﻿//-----------------------------------------------------------------------------
//
// Load all layout templates
//
//-----------------------------------------------------------------------------
"use strict";

var multilanguageStrings=[];

var multilanguage = 
{
	nextLanguage : function(){
	    if($("#languageSelect").attr("src")=="res/drawable/flag_english_icon.png"){
	    	$("#languageSelect").attr("src","res/drawable/flag_german_icon.png");
	    	this.setLanguage("de-de");
	    }
	    else{
	    	$("#languageSelect").attr("src","res/drawable/flag_english_icon.png");
	    	this.setLanguage("en-en");
	    }
	    multilanguageStrings=[];
        this.loadUserinterfaceStrings();
	    this.loadContentStrings();
	    game.resetPuzzlelist();
	},

	setLanguage : function(language){
    	if (language.length>=2) {
		  languageCode = (language.substring(0,2)).toLowerCase();
		}
		
		if(languageCode!=="de" && languageCode!=="en"){   // Currently only English and German are supported
		  languageCode="en";
		}
    	// Write to local storage
        settingsHelper.setItem('languagecode', languageCode);
    },

	loadUserinterfaceStrings : 
	  function(){
	    var self=this;
	  
		if(languageCode!=="en"){
	      var filepath = "res/values"+"-"+languageCode;
	    }
	    else{
	      var filepath = "res/values";
	    }
	    filepath += "/ui_strings.xml";

        // Prefill loading-string
   		if(languageCode=="de"){
   			$("#loadingText").text("Lädt...");
//			multilanguageStrings["loading")] = {name:loading,value:"Lädt..."};
   		} 
   		else if(languageCode=="en"){   // Currently only English and German are supported
//			multilanguageStrings["loading")] = {name:loading,value:"Loading..."};
   			$("#loadingText").text("Loading...");
		}
        
        // Load texts
		$.get(filepath,{},
		  function(strgs){
			try {
			    var resources=(($(strgs).find('resources')))[0];
			    if(!resources){ resources=$(strgs)[2]};     // Fallback for Chrome Web Apps
			    if(!resources){ resources=$(strgs)[1]};     // Fallback for Chrome Web Apps
			    if(!resources){ resources=$(strgs)[0]};     // Fallback for Chrome Web Apps
				$(resources).find('string').each(
				  function(i,strg){
			        multilanguageStrings[$(strg).attr("name")] = {name:  $(strg).attr("name"),
			                                                      value: self.removeEscape($(strg).text())};
			      });
			    self.replaceStringsOfUserinterface(".multilanguage");
			}
			catch (err){
				console.error(err);
			}			
		});
	},
	
	removeEscape : 
	  function(str){
	    var self=this;
	  	str = str.replace(/\\'/g,"'");	  	
	  	str = str.replace(/\\"/g,'"');
	  	str = str.replace(/\\n/g,'<br>');

	  	return str;
	},
	
	replaceStringsOfUserinterface : 
	  function(selectorStr){
	    var self=this;
		$(selectorStr).each(
			function(i,element){
			    var mlresourceids = $(element).attr("data-mlresourceids");
			    if($(element).attr("data-mlresourceids")==="expl_{!{id}!}"){
			    	if(currentpuzzle){
			    	   mlresourceids = "expl_"+currentpuzzle.id;
			    	   if(currentpuzzle.solutionimg.length>0){
			    	   	  $("#exp_img_picture").attr("src","res/drawable/"+currentpuzzle.solutionimg);
			    	   	  $("#exp_img").show();
			    	   }
			    	   else{
			    	   	  $("#exp_img").hide();
			    	   }
			    	}
			    }
			    else if($(element).attr("data-mlresourceids")==="hint_{!{id}!}"){
			    	if(currentpuzzle){
			    		mlresourceids = "hint_"+currentpuzzle.id;
			    	}
			    }
			    if(multilanguageStrings[mlresourceids]){
				    if($(element).attr("data-mlattributes")==="text"){
	        			var is_premium=null;   // null -> all puzzles, true -> only premium puzzles (all BUT lite version!!!)
			    		if(liteversion){
			    			is_premium=false;
			    		}
				    	var textValue = multilanguageStrings[mlresourceids].value;
				    	if( textValue.indexOf("no_solved") > 0 ){
					    	var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
					    	var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
					    	var noNew=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateNew);
					    	if(noPlayed!=null&&noSolved!=null&&noNew!=null){
					        	var noAll = noPlayed + noSolved + noNew; 
					    		var ratioSolved = noSolved/noAll;
					    		textValue=textValue.replace( "no_solved", Math.round(ratioSolved*100) );					    		
					    	}
				    	}
				    	if( textValue.indexOf("no_played") > 0 ){
					    	var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
					    	var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
					    	if(noPlayed!=null&&noSolved!=null){
					    		var noPlayedTotal = noPlayed+noSolved; 
					    		textValue=textValue.replace( "no_played", noPlayedTotal );					    		
					    	}
				    	}
				    	if( textValue.indexOf("no_all") > 0 ){
					    	var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
					    	var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
					    	var noNew=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateNew);
					    	if(noPlayed!=null&&noSolved!=null&&noNew!=null){
					        	var noAll = noPlayed + noSolved + noNew; 
					    		textValue=textValue.replace( "no_all", noAll );
					    	}
				    	}
				    	if( textValue.indexOf("no_puzzles_unlocked_all") > 0 ){
					    	var no_puzzles_unlocked_all=game.getNumberOfPuzzles(is_premium,puzzleHelper.DIFFICULTY_MIXED,null);
					    	if(no_puzzles_unlocked_all==null){
					    		if(liteversion){
									no_puzzles_unlocked_all = 42;
								}
								else{
									no_puzzles_unlocked_all = 239;
								}
					    	}
				    		textValue=textValue.replace( "no_puzzles_unlocked_all", no_puzzles_unlocked_all );					    	
				    	}
				    	if( textValue.indexOf("no_puzzles_all_fullversion") > 0 ){
					    	var no_puzzles_all_fullversion=game.getNumberOfPuzzles(null,puzzleHelper.DIFFICULTY_MIXED,null);
					    	if(no_puzzles_all_fullversion==null){
								no_puzzles_all_fullversion = 239;
					    	}
				    		textValue=textValue.replace( "no_puzzles_all_fullversion", no_puzzles_all_fullversion );
				    	}
				    	if( textValue.indexOf("no_puzzles_delta_fullversion") > 0 ){
					    	var no_puzzles_delta_fullversion=game.getNumberOfPuzzles(true,puzzleHelper.DIFFICULTY_MIXED,null);
					    	if(no_puzzles_delta_fullversion==null){
					    		no_puzzles_delta_fullversion=197;
					    	}
				    		textValue=textValue.replace( "no_puzzles_delta_fullversion", no_puzzles_delta_fullversion );
				    	}
					    $(element).html(textValue);	
				    }
				    else{
				    	$(element).attr($(element).attr("data-mlattributes"),
				    	                multilanguageStrings[mlresourceids].value);
				    }
			    }
			});        
    },
    
	loadContentStrings : 
	  function(){
	    var self=this;
		if(languageCode!=="de" && languageCode!=="en"){
		  languageCode="en";
		}
		
		if(languageCode!=="en"){
	      var filepath = "res/values"+"-"+languageCode;
	    }
	    else{
	      var filepath = "res/values";
	    }
	    filepath += "/strings.xml";

		$.get(filepath,{},
		  function(strgs){
			try {
			    var resources=(($(strgs).find('resources')))[0];
			    if(!resources){ resources=$(strgs)[2]};    // Fallback for Chrome Web Apps
			    if(!resources){ resources=$(strgs)[1]};    // Fallback for Chrome Web Apps
			    if(!resources){ resources=$(strgs)[0]};    // Fallback for Chrome Web Apps
				$(resources).find('string').each(
				  function(i,strg){
			        multilanguageStrings[$(strg).attr("name")] = {name:  $(strg).attr("name"),
			                                                      value: self.removeEscape($(strg).text())};
			      });
			    if(game){     // Do not render puzzle, if game has not been started yet
			        game.renderpuzzle();
			        game.updatePuzzleList();
			    }
			}
			catch (err){
				console.error(err);
			}			
		});
	}
}
