var fullVersionSkuName = "iqfitfunhtml.unlockFullversion";   // SKU of in-app item

function purchaseItem() {
    amzn_wa.IAP.purchaseItem(fullVersionSkuName);
	// Make sure Amazon payment service div is on top
	$('#AmazonServicesPurchaseItem').css("z-index",8000);
	$('#AmazonServicesPurchaseItem').css("position","absolute");
}

function handleReceipt(receipt) {
    if (receipt.sku == fullVersionSkuName) {
        if(liteversion){
        	game.switchToFullVersion();
        }
    }
}

function initialize_Amazon_API() {
//    amzn_wa.enableApiTester(amzn_wa_tester);    // ToDo, inactivate before shipping --- Only for testing
    
    if (amzn_wa.IAP == null) {
        console.log("Amazon In-App-Purchasing only works with Apps from the Appstore");
    } else {
    	amzn_wa.IAP.registerObserver({
            'onSdkAvailable': function(resp) {
                if (resp.isSandboxMode) {
                    alert("Running in test mode (Amazon App Store, in-app payment)");                        
                }
                
                amzn_wa.IAP.getPurchaseUpdates(amzn_wa.IAP.Offset.BEGINNING);
            },
            
            'onGetUserIdResponse': function(resp) {},
            
            'onItemDataResponse': function(data) {},
            
            'onPurchaseResponse': function(data) {
                if (data.purchaseRequestStatus == amzn_wa.IAP.PurchaseStatus.SUCCESSFUL) {
                    handleReceipt(data.receipt);
                }
            },
            
            'onPurchaseUpdatesResponse': function(data) { 
                for (var i = 0; i < data.receipts.length; i++) {
                    handleReceipt(data.receipts[i]);
                }
            }
    	});
    }
}

$(function() {
    initialize_Amazon_API();        
});