﻿var puzzleStateNew = 0;
var puzzleStatePlayed = 1;
var puzzleStateSolved = 2;

$( window ).load(function() {
    var isLandscape = true;
    if ($(window).width() > $(window).height()) {
        isLandscape = true;
    }
    else {
	    isLandscape = false;
    }
    if (isLandscape) {
		nonBlockingPostpone( function(){ 
			// Scroll up to make sure top of page is visible
			// 	-> i.e. needed for Safari on IPod after rotation change
			window.scrollTo(0,0); 
		}, 100);
	}
});

// Resize body / gameboard
//$("html").css("height",$(window).height());
//$("html").css("width",$(window).width());
$("html").css("height",$(document).height());
$("html").css("width",$(document).width());

//$("body").css("height",$(window).height());
//$("body").css("width",$(window).width());
//$("body").addClass("bodyGradient");
$("body").css("height",$(document).height());
$("body").css("width",$(document).width());
$("body").addClass("bodyGradient");

//$("gameboard").css("height",$(window).height());
//$("gameboard").css("width",$(window).width());
$("gameboard").css("height",$(document).height());
$("gameboard").css("width",$(document).width());
			
// Show loading popin
nonBlockingPostpone( function(){ 
	$('#loading').css("z-index",1000);
    var popupTop = ($(window).height() - $('#loading').height()) * 0.4;                    
    popupTop = Math.round(popupTop);
	$('#loading').css("top", popupTop);
	var popupLeft = ($(window).width() - 3*$('#loading').width()) / 2;  // "..." is shorter than multi langu text
	$('#loading').css("left", popupLeft);
	$('#loading').show();
}, 100);   // Postpone call by half second to get $('#loading').height() filled

// Open url in browser (Tizen only)
//function launchUrl( url ){
//	var target=url;
//	var appControl = new tizen.ApplicationControl("http://tizen.org/appcontrol/operation/view", target);
//	tizen.application.launchAppControl(appControl,
//		null,
//		function(){
//			console.log("browser opened");
//		},
//		function(e) {
//			console.log("browser error: " + e.message);
//		}
//	);        	
//}

// Listener methods
function clickHandlerDifficulty(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.clickHandlerDifficulty(e);
	}
	else if(e.keyCode == 38){  // Up
    	if(e.currentTarget.id=="difficulty_mixed"){
	    	if($('#launch_appstore_nav').is(":visible")){
				$('#launch_appstore_nav').focus();
			}
			else{
				$('#gamestart_btn').focus();			
			}
    	}
    	else if(e.currentTarget.id=="difficulty_hard"){
			$('#difficulty_mixed').focus();
    	}
    	else if(e.currentTarget.id=="difficulty_easy"){
			$('#difficulty_hard').focus();
    	}
	}
	else if(e.keyCode == 40){  // Down
    	if(e.currentTarget.id=="difficulty_mixed"){
			$('#difficulty_hard').focus();
    	}
    	else if(e.currentTarget.id=="difficulty_hard"){
			$('#difficulty_easy').focus();
    	}
    	else if(e.currentTarget.id=="difficulty_easy"){
			$('#gamestart_btn').focus();
    	}
	}
}
function clickHandlerGamestart(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		disableNavigation(false);
        if(keyboardRecentlyUsed){
          	if(!focusStyleOn){
				focusStyleOn = true;
           		updateFocusStyle();
           	}
        }
        else{
           	if(focusStyleOn){
				focusStyleOn = false;
           		updateFocusStyle();
           	}
        }
		keyboardRecentlyUsed = false;
		game.startgame();
	}
	else if(e.keyCode == 38){  // Up
		$('#difficulty_easy').focus();
	}
	else if(e.keyCode == 40){  // Down
    	if($('#launch_appstore_nav').is(":visible")){
			$('#launch_appstore_nav').focus();
		}
		else{
			$('#difficulty_mixed').focus();
		}
	}
}
function clickHandlerGotoPreviousPuzzle(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.gotoPreviousPuzzle();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#aboutShowHide').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#explanationShowHide').focus();
	}
}

function clickHandlerToggleExplanation(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleExplanation();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#gotoPreviousPuzzle').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#soundOnOff').focus();
	}
}

function clickHandlerCloseExplanation(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleExplanation();
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 37){   // Left
		$('#expand_sol_img').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#expand_sol_img').focus();
	}
	else if(e.keyCode == 38){  // Up
		$('#expand_sol_img').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#expand_sol_img').focus();
	}
}

function clickHandlerToggleSolution(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleSolution();
	}
	else if(e.keyCode == 37){   // Left
		$('#close_expl_img').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#close_expl_img').focus();
	}
	else if(e.keyCode == 38){  // Up
	    if($('#expl_solution').is(":visible")){
			game.toggleSolution();
		}
		else{
			$('#close_expl_img').focus();
		}
	}
	else if(e.keyCode == 40){  // Down
	    if($('#expl_solution').is(":visible")){
			$('#close_expl_img').focus();
		}
		else{
			game.toggleSolution();
		}
	}
}

function clickHandlerToggleAudio(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleAudio();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#explanationShowHide').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#language').focus();
	}
}

function clickHandlerNextLanguage(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		multilanguage.nextLanguage();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#soundOnOff').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#gameprogressShowHide').focus();
	}
}

function clickHandlerToggleGameprogress(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleGameprogress();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#language').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#aboutShowHide').focus();
	}
}

function clickHandlerPuzzleShortcomeToggleGameprogress(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleGameprogress();
	}
	else if(e.keyCode == 38){  // Up
		$('#puzzleshortcomeContinue').focus();
	}
	else if(e.keyCode == 40){  // Down
	    if($('#puzzleshortcome_appstore_nav').is(":visible")){
			$('#puzzleshortcome_appstore_nav').focus();
		}
		else{
			$('#puzzleshortcomeContinue').focus();
		}
	}
}

function clickHandlerCloseAbout(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleAbout();
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#freesoundKantouth').focus();
	}
	else if(e.keyCode == 40){  // Down
    	if($('#about_appstore_nav').is(":visible")){
			$('#about_appstore_nav').focus();
		}
		else{
			$('#melodyloops').focus();
		}
	}
}

function clickHandlerMelodyloopsAbout(e){
	if(e.keyCode == 38){  // Up
    	if($('#about_appstore_nav').is(":visible")){
			$('#about_appstore_nav').focus();
		}
		else{
			$('#close_about_img').focus();
		}
	}
	else if(e.keyCode == 40){  // Down
		$('#freesound').focus();
	}
}

function clickHandlerFreesoundAbout(e){
	if(e.keyCode == 38){  // Up
		$('#melodyloops').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#freesoundGrunz').focus();
	}
}

function clickHandlerFreesoundGrunzAbout(e){
	if(e.keyCode == 38){  // Up
		$('#freesound').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#freesoundJoedeshon').focus();
	}
}

function clickHandlerFreesoundJoedeshonAbout(e){
	if(e.keyCode == 38){  // Up
		$('#freesoundGrunz').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#freesoundKantouth').focus();
	}
}

function clickHandlerFreesoundKantouthAbout(e){
	if(e.keyCode == 38){  // Up
		$('#freesoundJoedeshon').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#close_about_img').focus();
	}
}

function clickHandlerToggleAbout(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.toggleAbout();
	}
	else if(e.keyCode == 39){   // Right
		setFocusToFirstAnswer();	
	}
	else if(e.keyCode == 38){  // Up
		$('#gameprogressShowHide').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#gotoPreviousPuzzle').focus();
	}
}

function clickHandlerCloseGameprogress(e){
    if(!$('#resetGameProgressConfirm').is(":visible")){
		if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
    		game.toggleGameprogress();
    		if (!$('#puzzleshortcome').is(":visible")){
    			if(puzzles[currentpuzzle_seq_id]==null){
    				// Update current puzzle after gameprogress reset
    				game.nextpuzzle();		
    			}
	    		else{
					setFocusToFirstAnswer();	    		
    			}
    		}
    		else{
				setFocusToFirstAnswer();	    		
    		}
    	}
		else if(e.keyCode == 38){  // Up
			$('#resetGameProgressButton').focus();
		}
		else if(e.keyCode == 40 || e.keyCode == 37){  // Down or Left
			$('#gameprogressShowPuzzlelistButton').focus();
		}
    }
}
function clickHandlerShowCharttypePuzzlelistGameprogress(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
	    if(!$('#resetGameProgressConfirm').is(":visible")){
    		game.setCharttypePuzzlelistGameprogress();
	    }
    }
	else if(e.keyCode == 39 || e.keyCode == 38){  // Right or Up
		$('#close_gameprogress').focus();
	}
	else if(e.keyCode == 40){  // Down
		$('#gameprogressShowChartButton').focus();
	}
}
function clickHandlerShowCharttypePieGameprogress(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
    	if(!$('#resetGameProgressConfirm').is(":visible")){
	     	$('#progressDetailSeparatorTop').removeClass('boxShadowBottom');
	     	$('#progressDetailSeparatorBottom').removeClass('boxShadowTop');
    		game.setCharttypePieGameprogress();	
    	}
	}
	else if(e.keyCode == 38){  // Up
		$('#gameprogressShowPuzzlelistButton').focus();
	}
	else if(e.keyCode == 40){  // Down
    	if($('#progressPuzzlelistUl').is(":visible")){
			$('#progressPuzzlelistUl').focus();
    	}
    	else{
			$('#resetGameProgressButton').focus();
    	}
	}
}
function clickHandlerPuzzlelist(e){
	if(e.keyCode == 37){   // Left
		$('#gameprogressShowChartButton').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#resetGameProgressButton').focus();
	}
}
function clickHandlerResetGameprogress(e){
	// Show confirm popover
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
    	if(!$('#resetGameProgressConfirm').is(":visible")){
    		game.toggleGameprogressConfirm();	
    	}
    }
	else if(e.keyCode == 38){  // Up
    	if($('#progressPuzzlelistUl').is(":visible")){
			$('#progressPuzzlelistUl').focus();
    	}
    	else{
			$('#gameprogressShowChartButton').focus();
    	}
	}
	else if(e.keyCode == 40){  // Down
		$('#close_gameprogress').focus();
	}
}
function clickHandlerResetGameprogressConfirmOk(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		game.resetGameprogress();
		// Close confirm popover
		game.toggleGameprogressConfirm();
	}
	else if(e.keyCode == 37){   // Left
		$('#resetGameProgressConfirmCancelBtn').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#resetGameProgressConfirmCancelBtn').focus();
	}
}
function clickHandlerResetGameprogressConfirmCancel(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		// Close confirm popover
		game.toggleGameprogressConfirm();
		$('#resetGameProgressButton').focus();		
	}
	else if(e.keyCode == 37){   // Left
		$('#resetGameProgressConfirmOkBtn').focus();
	}
	else if(e.keyCode == 39){   // Right
		$('#resetGameProgressConfirmOkBtn').focus();
	}
}
function clickHandlerStartWithFirstPuzzle(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
        if($('#fullversion').is(":visible")){
	        game.toggleFullVersion();
	    }
		game.startWithFirstPuzzle();
	}
	else if(e.keyCode == 38){  // Up
    	if(e.currentTarget.id=="puzzleshortcomeContinue"){
   	    	if($('#puzzleshortcome_appstore_nav').is(":visible")){
				$('#puzzleshortcome_appstore_nav').focus();
			}
			else{
				$('#puzzleshortcomeShowGameprogress').focus();			
			}
		}
	}
	else if(e.keyCode == 40){  // Down
    	if(e.currentTarget.id=="puzzleshortcomeContinue"){
			$('#puzzleshortcomeShowGameprogress').focus();
		}
	}
}
function clickHandlerAppstoreNavigation(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		// open paid app in new window
		if (appStoreName == APPSTORE_Mozilla) {
			window.open('https://marketplace.firefox.com/search/?q=iq-fitfun');
//			window.open('https://marketplace.firefox.com/search/?q=brain');
//			window.open('https://marketplace.firefox.com/app/iq-fitfun-lite');
		}
		else if (appStoreName == APPSTORE_Chrome) {
			window.open('https://chrome.google.com/webstore/detail/iq-fitfun/mbkbemfpfgmdklbchinhicafhhgbjgai');
		}
		else if (appStoreName == APPSTORE_Amazon) {
			if(languageCode=="de"){
				window.open('http://www.amazon.de/dp/B0078TN2WY/ref=cm_sw_su_dp');
			}
			else{
				window.open('http://www.amazon.com/dp/B0078TN2WY/ref=cm_sw_su_dp');
			}
		}
		else if (appStoreName == APPSTORE_Tizen) {
//			window.open('');     -> to be added later
		}
	}
	else if(e.keyCode == 38){  // Up
    	if(e.currentTarget.id=="launch_appstore_nav"){
			$('#gamestart_btn').focus();
		}
    	else if(e.currentTarget.id=="about_appstore_nav"){
			$('#close_about_img').focus();
		}
    	else if(e.currentTarget.id=="puzzleshortcome_appstore_nav"){
			$('#puzzleshortcomeShowGameprogress').focus();
		}
	}
	else if(e.keyCode == 40){  // Down
    	if(e.currentTarget.id=="launch_appstore_nav"){
			$('#difficulty_mixed').focus();
		}
    	else if(e.currentTarget.id=="about_appstore_nav"){
			$('#melodyloops').focus();
		}
    	else if(e.currentTarget.id=="puzzleshortcome_appstore_nav"){
			$('#puzzleshortcomeContinue').focus();
		}
	}
}
function clickHandlerPurchaseItem(e){
	if(e.type == "click" || e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
		if (appStoreName == APPSTORE_Mozilla) {
			// Currently no in app payment
		}
		else if (appStoreName == APPSTORE_Chrome) {
			// Currently no in app payment
		}
		else if (appStoreName == APPSTORE_Amazon) {
			purchaseItem();
		}
		else if (appStoreName == APPSTORE_Tizen) {
			// Currently no in app payment
		}
	}
	else if(e.keyCode == 38){  // Up
    	if(e.currentTarget.id=="launch_appstore_nav"){
			$('#gamestart_btn').focus();
		}
    	else if(e.currentTarget.id=="about_appstore_nav"){
			$('#close_about_img').focus();
		}
    	else if(e.currentTarget.id=="puzzleshortcome_appstore_nav"){
			$('#puzzleshortcomeShowGameprogress').focus();
		}
	}
	else if(e.keyCode == 40){  // Down
    	if(e.currentTarget.id=="launch_appstore_nav"){
			$('#difficulty_mixed').focus();
		}
    	else if(e.currentTarget.id=="about_appstore_nav"){
			$('#melodyloops').focus();
		}
    	else if(e.currentTarget.id=="puzzleshortcome_appstore_nav"){
			$('#puzzleshortcomeContinue').focus();
		}
	}
}


function serializePuzzleStates(){
	var puzzleStates = {};
	var i = 0;
	for(var pzidx in puzzles){
		var pz=puzzles[pzidx];
    	puzzleStates[pz.id]=pz.state;
    	i++;
    }
    return JSON.stringify(puzzleStates);
}

function deSerializePuzzleStates( puzzlestatesStr ){
	if(puzzlestatesStr != null){
		var puzzleStates = JSON.parse( puzzlestatesStr );
		for(var stateId in puzzleStates){
    		for(var pzidx in puzzles){
    			var pz=puzzles[pzidx];
				if(pz.id==stateId){
					pz.state = puzzleStates[stateId];
				}
			}
		}
	}
}

function escapePressed(){
	if ($('#explanation').is(":visible")){
		game.toggleExplanation();
		setFocusToFirstAnswer();	
	}
	else if ($('#about').is(":visible")){
		game.toggleAbout();
		setFocusToFirstAnswer();
	}
	else if ($('#gameprogress').is(":visible")){
   		game.toggleGameprogress();
		setFocusToFirstAnswer();	    		
	}
	else if ($('#puzzleshortcome').is(":visible")){
        if($('#fullversion').is(":visible")){
	        game.toggleFullVersion();
	    }
		game.startWithFirstPuzzle();
	}
}

function evaluateKeyboardUsage(e){
	if( e.keyCode == 9     // tab
		|| e.keyCode == 37  // left	   
		|| e.keyCode == 38  // up	   
		|| e.keyCode == 39  // right
		|| e.keyCode == 40  // down
		|| e.keyCode == 13  // enter
		|| e.keyCode == 32  // spacebar 
		|| e.keyCode == 27  // Escape
		|| e.keyCode == 112 // F1
	){
		keyboardRecentlyUsed = true;
		if(!focusStyleOn){
			focusStyleOn = true;
			updateFocusStyle();
		}
	}
}

// Download content (puzzle meta data)
$.ajax({
		type: "GET",
		url: "res/raw/puzzle_data.xml",
		dataType: "xml",
		success: function(xml){
			puzzles = [];
			try {
				$(xml).find('puzzle').each(
				  function(i,puzzle){
//		            if(!liteversion || ($(puzzle).attr('premium')!="true")){
				        var questions = [];
						$(puzzle).find('question').each(function(j,question){
							questions.push($(question).text());
						});
	    			    var answers = [];
						$(puzzle).find('answer').each(function(k,answer){
							answers.push($(answer).text());
						});
						var puzzleObj={seq_no:                    parseInt($(puzzle).attr('seq_no')),
						               id:                        $(puzzle).attr('id'),
						               pattern:                   parseInt($(puzzle).attr('pattern')),
						               template_id:               puzzleHelper.getLayoutTemplateId( parseInt($(puzzle).attr('pattern')), parseInt($(puzzle).attr('layout_type')) ),
						               layout_type:               parseInt($(puzzle).attr('layout_type')),
						               premium:                   ($(puzzle).attr('premium')=="true"),
						               difficulty:                parseInt($(puzzle).attr('difficulty')),
						               question:                  $(puzzle).attr('question'),
						               question_resId:            null,
						               question_1:                (function(){if(questions.length>0)return questions[0]})(),
						               question_2:                (function(){if(questions.length>1)return questions[1]})(),
						               question_3:                (function(){if(questions.length>2)return questions[2]})(),
						               question_4:                (function(){if(questions.length>3)return questions[3]})(),
						               question_5:                (function(){if(questions.length>4)return questions[4]})(),
						               question_6:                (function(){if(questions.length>5)return questions[5]})(),
						               question_7:                (function(){if(questions.length>6)return questions[6]})(),
						               question_8:                (function(){if(questions.length>7)return questions[7]})(),
						               answer_1:                  (function(){if(answers.length>0)return answers[0]})(),
                                       answer_1_resId:            null,
                                       answer_2:                  (function(){if(answers.length>1)return answers[1]})(),
                                       answer_2_resId:            null,
                                       answer_3:                  (function(){if(answers.length>2)return answers[2]})(),
                                       answer_3_resId:            null,
                                       answer_4:                  (function(){if(answers.length>3)return answers[3]})(),
                                       answer_4_resId:            null,
                                       answer_5:                  (function(){if(answers.length>4)return answers[4]})(),
                                       answer_5_resId:            null,
                                       answerIsText:              false,   // filled via game.js from resource
						               solution:                  $(puzzle).attr('solution'),
						               solutionimg:               "",      // filled via game.js from resource
						               is_stringresource:         ($(puzzle).attr('is_stringresource')=="true"),
						               question_description_type: parseInt($(puzzle).attr('question_description_type')),
						               failed_answers:            {},
						               state:                     puzzleStateNew,
						               rendered: false    // to be flagged after rendering, to be resetted at "game.nextpuzzle"
	                                  };
	                    puzzles[puzzleObj.seq_no]=puzzleObj;
//                    }
				  }
				);
				// Restore puzzle state (played, solved)
				deSerializePuzzleStates( settingsHelper.getItem("puzzlestates") );
				// Hide loading popin
                // Display launch popin                
	        	$('#launch').css("z-index",1000);
	        	$('#launch').css("opacity",0.0);
	        	$('#launch').show();
	        	nonBlockingPostpone( function(){ 
               	    var popupTop = ($(window).height() - $('#launch').height()) / 2;                    
    	            popupTop = Math.round(popupTop);
	    	    	$('#launch').css("top", popupTop);
    	    		var popupLeft = $('#navigation').width()/2 + ($(window).width() - $('#navigation').width() - $('#launch').width()) / 2;
		        	$('#launch').css("left", popupLeft);	        	
		        	$('#launch').css("opacity",1.0);
		        	$('#launch').show(popinToggleDurationOpen);
					$('#loading').hide();
		       	}, 500 );   // Postpone call by half second to get $('#launch').height() filled
                // Visibility of fullversion link
	        	if (!liteversion) {
	        	    $('#launch_appstore_nav').hide();
	        	}
	        	else {
	        	    if (appStoreName == APPSTORE_Windows8) {
	        	        $("#launch_appstore_nav").click(function () {
        	            	currentApp.requestAppPurchaseAsync(false);
	        	        });
	        	        $("#launch_appstore_nav").keydown(function () {
							if(e.keyCode == 13 || e.keyCode == 32){   // Enter or Spacebar
	        	            	currentApp.requestAppPurchaseAsync(false);
	        	            }
	        	        });
	        	    }
	        	    else if (appStoreName == APPSTORE_WindowsPhone) {
	        	        // see html body
	        	    }
	        	    else if (appStoreName == APPSTORE_Mozilla) {
						$('#launch_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Chrome) {
						$('#launch_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Amazon) {
						$('#launch_appstore_nav').click(clickHandlerPurchaseItem);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerPurchaseItem);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Tizen) {
		        	    $('#launch_appstore_nav').hide();    // Currently no link
	        	    }
                };
                
  				$('html').keypress(function(e){
  				
												evaluateKeyboardUsage(e);

												if(e.keyCode == 112){    // F1 = Help
											        if (!$('#explanation').is(":visible")) {
														clickHandlerToggleExplanation(e);
													}
												}
												else if(e.keyCode == 27){    // Escape
													escapePressed();
												}
												else if(e.keyCode == 27){    // Escape
													escapePressed();
												}
								  });
  				$('html').keydown(function(e){

												evaluateKeyboardUsage(e);

												if(e.keyCode == 112){    // F1 = Help
											        if (!$('#explanation').is(":visible")) {
														clickHandlerToggleExplanation(e);
													}
												}
												else if(e.keyCode == 27){    // Escape
													escapePressed();
												}
								  });
                
				$('#difficulty_easy').click(clickHandlerDifficulty);
				$('#difficulty_easy').keydown(clickHandlerDifficulty);
				$('#difficulty_mixed').click(clickHandlerDifficulty);
				$('#difficulty_mixed').keydown(clickHandlerDifficulty);
				$('#difficulty_hard').click(clickHandlerDifficulty);
				$('#difficulty_hard').keydown(clickHandlerDifficulty);
				$('#gamestart_btn').click(clickHandlerGamestart);
				$('#gamestart_btn').keydown(clickHandlerGamestart);
				$('#gotoPreviousPuzzle').click(clickHandlerGotoPreviousPuzzle);
			    $('#gotoPreviousPuzzle').keydown(clickHandlerGotoPreviousPuzzle);
				$('#explanationShowHide').click(clickHandlerToggleExplanation);
				$('#explanationShowHide').keydown(clickHandlerToggleExplanation);
				$('#close_expl_img').click(clickHandlerCloseExplanation);
				$('#close_expl_img').keydown(clickHandlerCloseExplanation);
				$('#expand_sol_img').click(clickHandlerToggleSolution);
				$('#expand_sol_img').keydown(clickHandlerToggleSolution);
				$('#soundOnOff').click(clickHandlerToggleAudio);
				$('#soundOnOff').keydown(clickHandlerToggleAudio);
				$('#language').click(clickHandlerNextLanguage);
				$('#language').keydown(clickHandlerNextLanguage);
				$('#aboutShowHide').click(clickHandlerToggleAbout);
				$('#aboutShowHide').keydown(clickHandlerToggleAbout);
				$('#close_about').click(clickHandlerCloseAbout);
				$('#close_about').keydown(clickHandlerCloseAbout);
				$('#melodyloops').keydown(clickHandlerMelodyloopsAbout);
				$('#freesound').keydown(clickHandlerFreesoundAbout);
				$('#freesoundGrunz').keydown(clickHandlerFreesoundGrunzAbout);
				$('#freesoundJoedeshon').keydown(clickHandlerFreesoundJoedeshonAbout);
				$('#freesoundKantouth').keydown(clickHandlerFreesoundKantouthAbout);
				$('#gameprogressShowHide').click(clickHandlerToggleGameprogress);
				$('#gameprogressShowHide').keydown(clickHandlerToggleGameprogress);
				$('#close_gameprogress').click(clickHandlerCloseGameprogress);
				$('#close_gameprogress').keydown(clickHandlerCloseGameprogress);
				$('#gameprogressShowPuzzlelist').click(clickHandlerShowCharttypePuzzlelistGameprogress);
				$('#gameprogressShowPuzzlelist').keydown(clickHandlerShowCharttypePuzzlelistGameprogress);
				$('#gameprogressShowChart').click(clickHandlerShowCharttypePieGameprogress);
				$('#gameprogressShowChart').keydown(clickHandlerShowCharttypePieGameprogress);
				$('#progressPuzzlelistUl').click(clickHandlerPuzzlelist);
				$('#progressPuzzlelistUl').keydown(clickHandlerPuzzlelist);
				$('#resetGameProgress').click(clickHandlerResetGameprogress);
				$('#resetGameProgress').keydown(clickHandlerResetGameprogress);
				$('#resetGameProgressConfirmOkBtn').click(clickHandlerResetGameprogressConfirmOk);
				$('#resetGameProgressConfirmOkBtn').keydown(clickHandlerResetGameprogressConfirmOk);
				$('#resetGameProgressConfirmCancelBtn').click(clickHandlerResetGameprogressConfirmCancel);
				$('#resetGameProgressConfirmCancelBtn').keydown(clickHandlerResetGameprogressConfirmCancel);
				
				$('#fullversion_image').click(clickHandlerStartWithFirstPuzzle);
				$('#fullversion_image').keydown(clickHandlerStartWithFirstPuzzle);
				$('#puzzleshortcomeShowGameprogress').click(clickHandlerPuzzleShortcomeToggleGameprogress);
				$('#puzzleshortcomeShowGameprogress').keydown(clickHandlerPuzzleShortcomeToggleGameprogress);
				$('#puzzleshortcomeContinue').click(clickHandlerStartWithFirstPuzzle);
				$('#puzzleshortcomeContinue').keydown(clickHandlerStartWithFirstPuzzle);
				
//              See https://github.com/fredwu/jquery-endless-scroll/blob/master/README.md
//              -> not working if enscroll is active				
				$('div#progressPuzzlelistUl').endlessScroll({
					fireOnce: false,
					fireDelay: false,
					insertBefore: "div.puzzleListItemFrame:first",
					insertAfter: "div.puzzleListItemFrame:last",
					resetCounter: function(){
						return game.puzzlelistResetted();
					},
					content: function(i) {
						var puzzleCell = game.getPuzzleListItem(i,false,false);
						if(puzzleCell!=null){
							var last_puzzleCell = $("div.puzzleListItemFrame:last");
							var plist = $("#progressPuzzlelistUl");
							last_puzzleCell.after( puzzleCell );
							var itemRightId = "puzzleListItemRight_"+puzzleCell.attr("id");
							if($("#"+itemRightId).data('iswide')){
								$("#"+itemRightId).width( game.getListItemRightWidth(true) );
							}
							else{
								$("#"+itemRightId).width( game.getListItemRightWidth(false) );
							}
						}
						else{
							return '<p>No puzzle available</p>';
						}
						return "<div class='dummy'></div>";
					},
//				    callback: function(i) {
//			        }
				});

//              See http://enscrollplugin.com/
//				-> not working if endlessScroll is active
//				$('div#progressPuzzlelistUl').enscroll();				
				
//	        	$('#launch').show(popinToggleDurationOpen);
				disableNavigation(true);
				$('#gamestart_btn').focus();
			}
			catch (err){
				console.error(err.message);
			}
        }
});