﻿var APPSTORE_Windows8 = "Windows8";
var APPSTORE_WindowsPhone = "WindowsPhone";
var APPSTORE_Chrome = "Chrome";
var APPSTORE_Mozilla = "Mozilla";
var APPSTORE_Tizen = "Tizen";
var APPSTORE_Ubuntu = "Ubuntu";
var APPSTORE_Amazon = "Amazon";
var liteversion = false;   // Full or Lite version
var appStoreName=APPSTORE_Mozilla;   // Appstore: Windows8, WindowsPhone, Chrome, Mozilla, Amazon, Tizen, Ubuntu
var hyperlinksDisabled=false;
var puzzles = [];
var currentpuzzle_seq_id = 0;
var previous_seq_id = 77777;   // Initial
var currentpuzzle = null;
var answerFailed = false;
var isSolutionExpanded = false;
var puzzleHelper = new Puzzlehelper();
var settingsHelper = new Settingshelper(); 
var languageCode="en";
var soundOn=0;
var difficulty=2;   // Mixed
var allPuzzlesPlayed=0;
var popinToggleDurationOpen = 400;
var popinToggleDurationOpenSlow = 1500;
var popinToggleDurationClose = 450;
var keyboardRecentlyUsed = false;
var focusStyleOn = true;

$("html").css("height",$(window).height());
$("html").css("width",$(window).width());

$("body").css("height",$(window).height());
$("body").css("width",$(window).width());

$("gameboard").css("height",$(window).height());
$("gameboard").css("width",$(window).width());

$('#loading').hide();
$('#loading').removeClass("popupInvisible");

$('#launch').hide();
$('#launch').removeClass("popupInvisible");

$('#about').hide();
$('#about').removeClass("popupInvisible");

$('#gameprogress').hide();
$('#gameprogress').removeClass("popupInvisible");

$('#resetGameProgressConfirm').hide();
$('#resetGameProgressConfirm').removeClass("popupInvisible");

$('#explanation').hide();
$('#explanation').removeClass("popupInvisible");
$('#expl_solution').hide();

$('#answersuccess').hide();
$('#answersuccess').removeClass("popupInvisible");

$('#answerfail').hide();
$('#answerfail').removeClass("popupInvisible");

$('#puzzlelocked').hide();
$('#puzzlelocked').removeClass("popupInvisible");

$('#puzzleshortcome').hide();
$('#puzzleshortcome').removeClass("popupInvisible");

$('#fullversion').hide();
$('#fullversion').removeClass("popupInvisible");

$('#progressPuzzlelist').hide();   // Make sure the puzzle list is hidden by default ( chart will be shown )

$.fn.extend({ 
        disableSelection : function() { 
                this.each(function() { 
                        this.onselectstart = function() { return false; }; 
                        this.unselectable = "on"; 
                        $(this).css('user-select', 'none'); 
                        $(this).css('-moz-user-select', 'none'); 
                        $(this).css('-webkit-user-select', 'none'); 
                }); 
        } 
});

if (appStoreName == APPSTORE_Tizen) {
	hyperlinksDisabled=true;   // Show text (URL, ...) instead
}
else{
	hyperlinksDisabled=false;  // Show as hyperlink () same as <a> tag )	
}

// if (!Modernizr.localstorage) {
//	alert('Update yout browser, use a html5 compatible browser: http://html5test.com/results/desktop.html');
// }

// Run code async
function nonBlocking(func) {
     setTimeout(func, 5);
}

// Run code async and delayed
function nonBlockingPostpone(func,millyseconds) {
     setTimeout(func, millyseconds);
}

// Some devices like Google TV decide to set a XXL font size by default
function getXLargeFontsizeDownscaleFactor() {
    var emSize = parseFloat($("body").css("font-size")) ;
	var cssFontSize = emSize;
    var maxWidthHeight = $(window).width();
    if( $(window).height() < maxWidthHeight ){
    	maxWidthHeight = $(window).height();
    }

    if( maxWidthHeight >= 3001) {
		cssFontSize = 40;
	}
    else if( maxWidthHeight >= 2701) {
		cssFontSize = 36;
	}
    else if( maxWidthHeight >= 2401) {
		cssFontSize = 35;
	}
    else if( maxWidthHeight >= 2201) {
		cssFontSize = 34;
	}
    else if( maxWidthHeight >= 1951) {
		cssFontSize = 33;
	}
    else if( maxWidthHeight >= 1681) {
		cssFontSize = 32;
	}
    else if( maxWidthHeight >= 1441) {
		cssFontSize = 31;
	}
    else if( maxWidthHeight >= 1361) {
		cssFontSize = 30;
	}
    else if( maxWidthHeight >= 1251) {
		cssFontSize = 28;
	}
    else if( maxWidthHeight >= 1151) {
		cssFontSize = 26;
	}
    else if( maxWidthHeight >= 1023) {
		cssFontSize = 24;
	}
    else if( maxWidthHeight >= 901) {
		cssFontSize = 22;
	}
    else if( maxWidthHeight >= 831) {
		cssFontSize = 21;
	}
    else if( maxWidthHeight >= 768) {
		cssFontSize = 20;
	}
    else if( maxWidthHeight >= 700) {
		cssFontSize = 19;
	}
    else if( maxWidthHeight >= 651) {
		cssFontSize = 18;
	}
    else if( maxWidthHeight >= 601) {
		cssFontSize = 17;
	}
    else if( maxWidthHeight >= 541) {
		cssFontSize = 16;
	}
    else if( maxWidthHeight >= 481) {
		cssFontSize = 15;
	}
    else if( maxWidthHeight >= 421) {
		cssFontSize = 13;
	}
    else if( maxWidthHeight >= 361) {
		cssFontSize = 11;
	}
    else if( maxWidthHeight >= 1) {
		cssFontSize = 10;
	}
	else{
		// return value will be 1
	}
	var downscaleFactor = cssFontSize/emSize;
	if(downscaleFactor<1){
		downscaleFactor = (1+downscaleFactor)*0.5;   // exact factor is too extreme for image/frame downsizing  
	}
	return downscaleFactor;
}

function disableNavigationAll(isDisabled){
	disableNavigation(isDisabled);
	if(isDisabled){
		$('#soundOnOff').data( 'tabindex', $('#soundOnOff').attr('tabindex') );
		$('#soundOnOff').removeAttr( 'tabindex' );
		$('#soundOnOff').css({'cursor':'default'});
		$('#language').data( 'tabindex', $('#language').attr('tabindex') );
		$('#language').removeAttr( 'tabindex' );
		$('#language').css({'cursor':'default'});
		$('#aboutShowHide').data( 'tabindex', $('#aboutShowHide').attr('tabindex') );
		$('#aboutShowHide').removeAttr( 'tabindex' );
		$('#aboutShowHide').css({'cursor':'default'});
	}
	else{
		$('#soundOnOff').attr( 'tabindex', $('#soundOnOff').data('tabindex') );
		$('#soundOnOff').css({'cursor':'pointer'});
		$('language').attr( 'tabindex', $('#language').data('tabindex') );
		$('language').css({'cursor':'pointer'});
		$('aboutShowHide').attr( 'tabindex', $('#aboutShowHide').data('tabindex') );
		$('aboutShowHide').css({'cursor':'pointer'});
		if(focusStyleOn){
			$('#soundOnOff').addClass('globalFocus');
			$('#language').addClass('globalFocus');
			$('#aboutShowHide').addClass('globalFocus');		
			$('#soundOnOff').removeClass('globalFocusOff');
			$('#language').removeClass('globalFocusOff');
			$('#aboutShowHide').removeClass('globalFocusOff');		
		}
		else{
			$('#soundOnOff').removeClass('globalFocus');
			$('#language').removeClass('globalFocus');
			$('#aboutShowHide').removeClass('globalFocus');		
			$('#soundOnOff').addClass('globalFocusOff');
			$('#language').addClass('globalFocusOff');
			$('#aboutShowHide').addClass('globalFocusOff');		
		}
	}
}

function disableNavigation(isDisabled){
	if(isDisabled){
		$('#gotoPreviousPuzzle').data( 'tabindex', $('#gotoPreviousPuzzle').attr('tabindex') );
		$('#explanationShowHide').data( 'tabindex', $('#explanationShowHide').attr('tabindex') );
		$('#gameprogressShowHide').data( 'tabindex', $('#gameprogressShowHide').attr('tabindex') );
		$('#gotoPreviousPuzzle').removeAttr( 'tabindex' );
		$('#explanationShowHide').removeAttr( 'tabindex' );
		$('#gameprogressShowHide').removeAttr( 'tabindex' );
		$('#gotoPreviousPuzzle').css({'cursor':'default'});
		$('#explanationShowHide').css({'cursor':'default'});
		$('#gameprogressShowHide').css({'cursor':'default'});
	}
	else{
		$('#gotoPreviousPuzzle').attr( 'tabindex', $('#gotoPreviousPuzzle').data('tabindex') );
		$('#explanationShowHide').attr( 'tabindex', $('#explanationShowHide').data('tabindex') );
		$('#gameprogressShowHide').attr( 'tabindex', $('#gameprogressShowHide').data('tabindex') );
		$('#gotoPreviousPuzzle').css({'cursor':'pointer'});
		$('#explanationShowHide').css({'cursor':'pointer'});
		$('#gameprogressShowHide').css({'cursor':'pointer'});
		if(focusStyleOn){
			$('#gotoPreviousPuzzle').addClass('globalFocus');
			$('#explanationShowHide').addClass('globalFocus');
			$('#gameprogressShowHide').addClass('globalFocus');		
			$('#gotoPreviousPuzzle').removeClass('globalFocusOff');
			$('#explanationShowHide').removeClass('globalFocusOff');
			$('#gameprogressShowHide').removeClass('globalFocusOff');		
		}
		else{
			$('#gotoPreviousPuzzle').removeClass('globalFocus');
			$('#explanationShowHide').removeClass('globalFocus');
			$('#gameprogressShowHide').removeClass('globalFocus');		
			$('#gotoPreviousPuzzle').addClass('globalFocusOff');
			$('#explanationShowHide').addClass('globalFocusOff');
			$('#gameprogressShowHide').addClass('globalFocusOff');		
		}
	}
}

function setFocusToFirstAnswer(){
	if(currentpuzzle){
    	if(currentpuzzle.answerIsText==true){
			$('#answer_txt1').focus();
        }
        else{
			$('#answer_img1').focus();
       	}
	}
}

function updateFocusStyle(){
	if(focusStyleOn){
		// Navigation
		$('#soundOnOff').removeClass('globalFocusOff');
		$('#language').removeClass('globalFocusOff');
		$('#aboutShowHide').removeClass('globalFocusOff');		
		$('#gotoPreviousPuzzle').removeClass('globalFocusOff');
		$('#explanationShowHide').removeClass('globalFocusOff');
		$('#gameprogressShowHide').removeClass('globalFocusOff');		
		$('#soundOnOff').addClass('globalFocus');
		$('#language').addClass('globalFocus');
		$('#aboutShowHide').addClass('globalFocus');		
		$('#gotoPreviousPuzzle').addClass('globalFocus');
		$('#explanationShowHide').addClass('globalFocus');
		$('#gameprogressShowHide').addClass('globalFocus');	

		// Popovers	
		$('#close_expl_img').removeClass('globalFocusOff');
		$('#expand_sol_img').removeClass('globalFocusOff');
		$('#close_about_img').removeClass('globalFocusOff');
		$('#close_gameprogress').removeClass('globalFocusOff');
		$('#puzzleshortcomeShowGameprogress').removeClass('globalFocusOff');
		$('#puzzleshortcome_appstore_nav').removeClass('globalFocusOff');
		$('#puzzleshortcomeContinue').removeClass('globalFocusOff');
		$('#about_appstore_nav').removeClass('globalFocusOff');
		$('#melodyloops').removeClass('globalFocusOff');
		$('#freesound').removeClass('globalFocusOff');
		$('#freesoundGrunz').removeClass('globalFocusOff');
		$('#freesoundJoedeshon').removeClass('globalFocusOff');
		$('#freesoundKantouth').removeClass('globalFocusOff');
		$('#gameprogressShowPuzzlelistButton').removeClass('globalFocusOff');
		$('#gameprogressShowChartButton').removeClass('globalFocusOff');
		$('#progressPuzzlelistUl').removeClass('globalFocusOff');
		$('#resetGameProgressButton').removeClass('globalFocusOff');
		$('#resetGameProgressConfirmOkBtn').removeClass('globalFocusOff');
		$('#resetGameProgressConfirmCancelBtn').removeClass('globalFocusOff');
		$('#close_expl_img').addClass('globalFocus');
		$('#expand_sol_img').addClass('globalFocus');
		$('#close_about_img').addClass('globalFocus');
		$('#close_gameprogress').addClass('globalFocus');
		$('#puzzleshortcomeShowGameprogress').addClass('globalFocus');
		$('#puzzleshortcome_appstore_nav').addClass('globalFocus');
		$('#puzzleshortcomeContinue').addClass('globalFocus');
		$('#fullversionBtn').addClass('globalFocus');
		$('#fullversionBtn').addClass('globalFocus');
		$('#about_appstore_nav').addClass('globalFocus');
		$('#melodyloops').addClass('globalFocus');
		$('#freesound').addClass('globalFocus');
		$('#freesoundGrunz').addClass('globalFocus');
		$('#freesoundJoedeshon').addClass('globalFocus');
		$('#freesoundKantouth').addClass('globalFocus');
		$('#gameprogressShowPuzzlelistButton').addClass('globalFocus');
		$('#gameprogressShowChartButton').addClass('globalFocus');
		$('#progressPuzzlelistUl').addClass('globalFocus');
		$('#resetGameProgressButton').addClass('globalFocus');
		$('#resetGameProgressConfirmOkBtn').addClass('globalFocus');
		$('#resetGameProgressConfirmCancelBtn').addClass('globalFocus');
		
		// Puzzle
        if(currentpuzzle){
        	if(currentpuzzle.answerIsText==true){
				$('#answer_txt1').addClass('globalFocus');
				$('#answer_txt2').addClass('globalFocus');
				$('#answer_txt3').addClass('globalFocus');		
				$('#answer_txt4').addClass('globalFocus');
				$('#answer_txt5').addClass('globalFocus');
				$('#answer_txt1').removeClass('globalFocusOff');
				$('#answer_txt2').removeClass('globalFocusOff');
				$('#answer_txt3').removeClass('globalFocusOff');		
				$('#answer_txt4').removeClass('globalFocusOff');
				$('#answer_txt5').removeClass('globalFocusOff');		
        	}
        	else{
				$('#answer_img1').addClass('globalFocus');
				$('#answer_img2').addClass('globalFocus');
				$('#answer_img3').addClass('globalFocus');		
				$('#answer_img4').addClass('globalFocus');
				$('#answer_img5').addClass('globalFocus');		
				$('#answer_img1').removeClass('globalFocusOff');
				$('#answer_img2').removeClass('globalFocusOff');
				$('#answer_img3').removeClass('globalFocusOff');		
				$('#answer_img4').removeClass('globalFocusOff');
				$('#answer_img5').removeClass('globalFocusOff');		
       		}
       	}
	}
	else{
		// Navigation
		$('#soundOnOff').removeClass('globalFocus');
		$('#language').removeClass('globalFocus');
		$('#aboutShowHide').removeClass('globalFocus');		
		$('#gotoPreviousPuzzle').removeClass('globalFocus');
		$('#explanationShowHide').removeClass('globalFocus');
		$('#gameprogressShowHide').removeClass('globalFocus');		
		$('#soundOnOff').addClass('globalFocusOff');
		$('#language').addClass('globalFocusOff');
		$('#aboutShowHide').addClass('globalFocusOff');		
		$('#gotoPreviousPuzzle').addClass('globalFocusOff');
		$('#explanationShowHide').addClass('globalFocusOff');
		$('#gameprogressShowHide').addClass('globalFocusOff');
		
		// Popovers	
		$('#close_expl_img').removeClass('globalFocus');
		$('#expand_sol_img').removeClass('globalFocus');
		$('#close_about_img').removeClass('globalFocus');
		$('#close_gameprogress').removeClass('globalFocus');
		$('#puzzleshortcomeShowGameprogress').removeClass('globalFocus');
		$('#puzzleshortcome_appstore_nav').removeClass('globalFocus');
		$('#puzzleshortcomeContinue').removeClass('globalFocus');
		$('#fullversionBtn').removeClass('globalFocus');
		$('#about_appstore_nav').removeClass('globalFocus');
		$('#melodyloops').removeClass('globalFocus');
		$('#freesound').removeClass('globalFocus');
		$('#freesoundGrunz').removeClass('globalFocus');
		$('#freesoundJoedeshon').removeClass('globalFocus');
		$('#freesoundKantouth').removeClass('globalFocus');
		$('#gameprogressShowPuzzlelistButton').removeClass('globalFocus');
		$('#gameprogressShowChartButton').removeClass('globalFocus');
		$('#progressPuzzlelistUl').removeClass('globalFocus');
		$('#resetGameProgressButton').removeClass('globalFocus');
		$('#resetGameProgressConfirmOkBtn').removeClass('globalFocus');
		$('#resetGameProgressConfirmCancelBtn').removeClass('globalFocus');
		$('#close_expl_img').addClass('globalFocusOff');
		$('#expand_sol_img').addClass('globalFocusOff');
		$('#close_about_img').addClass('globalFocusOff');
		$('#close_gameprogress').addClass('globalFocusOff');
		$('#puzzleshortcomeShowGameprogress').addClass('globalFocusOff');
		$('#puzzleshortcome_appstore_nav').addClass('globalFocusOff');
		$('#puzzleshortcomeContinue').addClass('globalFocusOff');
		$('#fullversionBtn').addClass('globalFocusOff');
		$('#about_appstore_nav').addClass('globalFocusOff');
		$('#melodyloops').addClass('globalFocusOff');
		$('#freesound').addClass('globalFocusOff');
		$('#freesoundGrunz').addClass('globalFocusOff');
		$('#freesoundJoedeshon').addClass('globalFocusOff');
		$('#freesoundKantouth').addClass('globalFocusOff');
		$('#gameprogressShowPuzzlelistButton').addClass('globalFocusOff');
		$('#gameprogressShowChartButton').addClass('globalFocusOff');
		$('#progressPuzzlelistUl').addClass('globalFocusOff');
		$('#resetGameProgressButton').addClass('globalFocusOff');
		$('#resetGameProgressConfirmOkBtn').addClass('globalFocusOff');
		$('#resetGameProgressConfirmCancelBtn').addClass('globalFocusOff');
		
		// Puzzle
        if(currentpuzzle){
        	if(currentpuzzle.answerIsText==true){
				$('#answer_txt1').removeClass('globalFocus');
				$('#answer_txt2').removeClass('globalFocus');
				$('#answer_txt3').removeClass('globalFocus');		
				$('#answer_txt4').removeClass('globalFocus');
				$('#answer_txt5').removeClass('globalFocus');		
				$('#answer_txt1').addClass('globalFocusOff');
				$('#answer_txt2').addClass('globalFocusOff');
				$('#answer_txt3').addClass('globalFocusOff');		
				$('#answer_txt4').addClass('globalFocusOff');
				$('#answer_txt5').addClass('globalFocusOff');
			}
			else{
				$('#answer_img1').removeClass('globalFocus');
				$('#answer_img2').removeClass('globalFocus');
				$('#answer_img3').removeClass('globalFocus');		
				$('#answer_img4').removeClass('globalFocus');
				$('#answer_img5').removeClass('globalFocus');		
				$('#answer_img1').addClass('globalFocusOff');
				$('#answer_img2').addClass('globalFocusOff');
				$('#answer_img3').addClass('globalFocusOff');		
				$('#answer_img4').addClass('globalFocusOff');
				$('#answer_img5').addClass('globalFocusOff');
			}
		}
	}
}

// Full version
if (appStoreName == APPSTORE_Amazon){
    fullVersionOn = parseInt(settingsHelper.getItem('fullversion'));
    if (!fullVersionOn) {
    	liteversion=true;
    }
    else if (fullVersionOn === 1) {
    	liteversion=false;
    }
    else {
    	liteversion=true;
    }
}

// Preferences
var seq_id = settingsHelper.getItem('seq_id');
if (liteversion) {
        if (seq_id) {
            currentpuzzle_seq_id = parseInt(seq_id);
        }
        else {
            // currentpuzzle_seq_id will be set at game.js;
        }
}
else {
        if (seq_id) {
            currentpuzzle_seq_id = parseInt(seq_id);
        }
        else {
            // currentpuzzle_seq_id will be set at game.js;
        }
}

// All puzzles played ( needed to skip puzzle shortcome popover, when already showed )
allPuzzlesPlayed=settingsHelper.getItem('allpuzzlesplayed');
if(!allPuzzlesPlayed){
	allPuzzlesPlayed=0;
}

// Sound on/off
    soundOn = parseInt(settingsHelper.getItem('soundon'));
    if (!soundOn) {
        soundOn = 0;
    }
    if (soundOn === 0) {   // Adjust icon
        $("#soundOnOffIcon").attr("src", "res/drawable/icon_sound_off.png");
        audio = $("#music").trigger("stop");
    }
    else {
        $("#soundOnOffIcon").attr("src", "res/drawable/icon_sound_on.png");
        audio = $("#music").trigger("play");
    }

// Language
    languageCode = settingsHelper.getItem('languagecode');
    if (!languageCode) {
        languageCode = "en";
    }
    if (languageCode === "en") {   // Adjust icon
        $("#languageSelect").attr("src", "res/drawable/flag_english_icon.png");
    }
    else if (languageCode === "de") {
        $("#languageSelect").attr("src", "res/drawable/flag_german_icon.png");
    }

// Difficulty
    var diff = settingsHelper.getItem('difficulty');
    if (diff) {
        difficulty = parseInt(diff);  // 2 = Mixed
    }
    else {
        difficulty = 2;
    }
    switch (difficulty) {    // Adjust icon
        case 1: {          // Easy
            $("#difficulty_easy_select").addClass("selected");
            $("#difficulty_easy_select").removeClass("deselected");
            $("#difficulty_easy_select").attr("src", "res/drawable/selected.png");
            break;
        }
        case 2: {          // Mixed
            $("#difficulty_mixed_select").addClass("selected");
            $("#difficulty_mixed_select").removeClass("deselected");
            $("#difficulty_mixed_select").attr("src", "res/drawable/selected.png");
            break;
        }
        case 3: {          // Hard
            $("#difficulty_hard_select").addClass("selected");
            $("#difficulty_hard_select").removeClass("deselected");
            $("#difficulty_hard_select").attr("src", "res/drawable/selected.png");
            break;
        }
    }

    $(window).resize(function () {
        if(game!=null){     // Resize only if game has already been loaded
            var isLandscape = true;
            if ($(window).width() > $(window).height()) {
                isLandscape = true;
            }
            else {
                isLandscape = false;
            }

			// Resize body / gameboard
			$("html").css("height",$(window).height());
			$("html").css("width",$(window).width());
			$("body").css("height",$(window).height());
			$("body").css("width",$(window).width());

            // Resize puzzle
            if (currentpuzzle) {     // Resize of puzzle only needed if puzzle is displayed (game started)
                if(currentpuzzle.rendered){
                    game.renderpuzzle(true);   // Value 'true' means resize-mode (no string/resouce conversion of currentpuzzle)
                }
            }
            // Resize launch popover
            if ($('#launch').is(":visible")) {
                // display launch popin
                $('#launch').css("z-index", 1000);
                var popupTop = ($(window).height() - $('#launch').height()) / 2;                    
	        	$('#launch').css("top", popupTop);
        		var popupLeft = $('#navigation').width()/2 + ($(window).width() - $('#navigation').width() - $('#launch').width()) / 2;
	        	$('#launch').css("left", popupLeft);
                // Visibility of fullversion link
                if (!liteversion) {
                    $('#launch_appstore_nav').hide();
                }
                else {
                    if (appStoreName == APPSTORE_Windows8) {
                        $("#launch_appstore_nav").click(function () {
                            currentApp.requestAppPurchaseAsync(false);
                        });
                    }
                    else if (appStoreName == APPSTORE_WindowsPhone) {
                        // see html body
                    }
	        	    else if (appStoreName == APPSTORE_Mozilla) {
						$('#launch_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Amazon) {
						$('#launch_appstore_nav').click(clickHandlerPurchaseItem);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerPurchaseItem);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Chrome) {
						$('#launch_appstore_nav').click(clickHandlerAppstoreNavigation);    	    	
						$('#launch_appstore_nav').keydown(clickHandlerAppstoreNavigation);    	    	
	        	    }
	        	    else if (appStoreName == APPSTORE_Tizen) {
	                    $('#launch_appstore_nav').hide();   // Currently no link
	        	    }
                }
            }
            // Resize explanation popover
            if ($('#explanation').is(":visible")) {
	            var popupTop = 0;
	            if (isLandscape) {
	                popupTop = ($(window).height() - $('#explanation').height()) / 3.80;
	            }
	            else {
	                popupTop = $(window).height() / 3.5;
	            }

	            if ($('#currentpuzzle').height()*1.15 + $('#explanation').height() < $(window).height()) {
                    // Sufficient space to show the popover below the puzzle
	                popupTop = $('#currentpuzzle').height() * 1.025;
	            }

	            $('#explanation').css("top", popupTop);
	            var popupLeft = ($(window).width() - $('.gotoPreviousPuzzle').width() - $('#explanation').width()) / 2;
	            $('#explanation').css("left", popupLeft);
            }
            // Resize about popover
            if ($('#about').is(":visible")) {
                var popupTop = ($(window).height() - $('#about').height()) / 2;
                $('#about').css("top", popupTop);
                var popupLeft = ($(window).width() - $('#navigation').width() - $('#about').width()) / 2;
                $('#about').css("left", popupLeft);
            }
            // Resize confirm popover
            if ($('#resetGameProgressConfirm').is(":visible")) {
                var popupTop = ($(window).height() - $('#resetGameProgressConfirm').height()) / 2;
                $('#resetGameProgressConfirm').css("top", popupTop);    
                var popupLeft = ($(window).width() - $('#resetGameProgressConfirm').outerWidth()) / 2;
        	    $('#resetGameProgressConfirm').css("left", popupLeft);
            }
            // Resize gameprogress popover
            if ($('#gameprogress').is(":visible")) {
                var gpWidth=$(document).width();
                var gpHeight=$(document).height();
                if($(window).width()<gpWidth || $(window).height()<gpHeight){
                	gpWidth=$(window).width();
                	gpHeight=$(window).height();
                };
	    		$('#gameprogress').width(gpWidth);
	    		$('#gameprogress').height(gpHeight);

				var closeButtonLeft = $(window).width() - $('#close_gameprogressFrame').width()*1.2;
	    		$('#close_gameprogressFrame').css("left", closeButtonLeft);

				var popupTop=0;
                $('#gameprogress').css("top", popupTop);
                var popupLeft = 0;
                $('#gameprogress').css("left", popupLeft);
                // Resize canvas
                var gameprogressCanvasFrame = $('#gameprogressCanvasFrame');
            	var gameprogressCanvas = $('#gameprogressCanvas');
        		if(gl){
        			if(isLandscape){
        				gameprogressCanvasFrame.height( (3*$(window).height())/5 );        		
                		gameprogressCanvasFrame.width( gameprogressCanvasFrame.height() );            			
        				gameprogressCanvas.height( (3*$(window).height())/5 );        		
                		gameprogressCanvas.width( gameprogressCanvas.height() );            			
        			}
        			else{
        				gameprogressCanvasFrame.width( (2*$(window).width())/3 );
        				gameprogressCanvasFrame.height( gameprogressCanvasFrame.width() );
        				gameprogressCanvas.width( (2*$(window).width())/3 );
        				gameprogressCanvas.height( gameprogressCanvas.width() );
        			}                
        		}
        		else{
        			gameprogressCanvasFrame.remove();
        	    	// Legend
        			var is_premium=null;   // null -> all puzzles, true -> only premium puzzles (all BUT lite version!!!)
        			if(liteversion){
        				is_premium=false;
        			}
        			var noPlayed=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStatePlayed);
        			var noSolved=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateSolved);
        			var noNew=game.getNumberOfPuzzles(is_premium, difficulty, puzzleStateNew);
        			var noAll = noPlayed + noSolved + noNew; 
        			var ratioSolved = noSolved/noAll;
        			var ratioSolvedUi = 100*(noSolved/noAll);
        			var ratioPlayed = noPlayed/noAll;
        			var fractionNew = 100-Math.round(100*ratioSolved)-Math.round(100*ratioPlayed);
        		    var fractionSolved=Math.round(100*ratioSolved);
        		    var fractionPlayed=Math.round(100*ratioPlayed);
        			// Update bar chart ( legend )
        	    	game.updateBarchartLegendSize( fractionSolved, fractionPlayed, fractionNew );		
        		}
        		// Puzzle list
				nonBlocking( function(){ 
        			var plWidth=$(window).width()*0.95;
		       		var plPadding=$('#gameprogressShowPuzzlelist').height( )/2;
		   			var plHeight=$(window).height()
		   				- 1.1*$('#gameprogressShowPuzzlelist').height( )
   						- 2*$('.verticalSpace_xsmall').height( )
   						- $('#progressDetailSeparatorBottom').height( )
   						- $('#progressDetailSeparatorTop').height( )
   						- $('#resetGameProgress').height( )
   						- 3*plPadding;
		   			$('#progressDetailSeparatorTop').width( plWidth );
   					$('#progressDetailSeparatorBottom').width( plWidth );
        			$('#progressPuzzlelist').width( plWidth );
        			$('#progressPuzzlelist').height( plHeight );
        			$('#progressPuzzlelistUl').width( plWidth );
        			$('#progressPuzzlelistUl').height( plHeight );
					// Make sure, linebreaks are working for Firefox 
        			game.updateListItemRightWidth();
				});
            }
            // Resize puzzle-shortcome popover
            if ($('#puzzleshortcome').is(":visible")) {
                var popupTop = ($(window).height() - $('#puzzleshortcome').height()) / 2;
                $('#puzzleshortcome').css("top", popupTop);
                var popupLeft = ($(window).width() - $('#navigation').width() - $('#puzzleshortcome').width()) / 2;
                $('#puzzleshortcome').css("left", popupLeft);
            }
            // Loading popover
            if ($('#loading').is(":visible")) {
                var popupTop = ($(window).height() - $('#answersuccess').height()) / 3;
                $('#loading').css("top", popupTop);
                var popupLeft = ($(window).width() - $('#navigation').width() - $('#answersuccess').width()) / 2;
                $('#loading').css("left", popupLeft);
            }
            // Resize fullversion popover
            if ($('#fullversion').is(":visible")) {
                var popupTop = ($(window).height() - $('#fullversion').height()) / 2;
                $('#fullversion').css("top", popupTop);
                var popupLeft = ($(window).width() - $('#navigation').width() - $('#fullversion').width()) / 2;
                $('#fullversion').css("left", popupLeft);
            }
        }
});
