﻿function Puzzlehelper()
{
  var self=this;
  
//  self.COLOR_LONGTEXT        = "#FFdddddd";
//  self.COLOR_ANSWERTEXT      = "#FF4D4DFF";
//  self.COLOR_BUTTONTEXT      = "#FF6d71ea";
//  self.COLOR_MAIN_BACKGROUND = "#FFfdd0da";
//  self.COLOR_SEPERATOR       = "#FFdddddd";
//  self.COLOR_SUCCESS_TEXT    = "#FF999999";

  self.PATTERN_SERIES_COMPLETE_STRING         = 10;
  self.PATTERN_SERIES_COMPLETE_IMAGE          = 20;
  self.PATTERN_OUTSIDER                       = 25;
  self.PATTERN_OUTSIDER_STRING                = 30;
  self.PATTERN_OUTSIDER_IMAGE                 = 40;
  self.PATTERN_PREMIUM_CONTENT                = 45;
  self.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE = 50;

  self.PATTERN_SERIES_LIST_COMPLETE_IMAGE     = 60;
  self.PATTERN_SERIES_2D_COMPLETE_STRING      = 70;
  
  self.PATTERN_EXCLUDE_ITEM_MATCH_STRING      = 80;
  self.PATTERN_EXCLUDE_ITEM_NONMATCH_STRING   = 90;
  
  self.PATTERN_ADD_STRING_SEMANTIC            = 100;
  self.PATTERN_ADD_STRING_END_START           = 110;
  
  self.PATTERN_WORD_COMPLETE                  = 120;
  
  self.PATTERN_A_TO_B_LIKE_C_TO_X             = 130;
  
  self.PATTERN_ANY                            = 9999;

  self.LAYOUT_TYPE_LONG_ANSWER_STRING         = 10;
  self.LAYOUT_TYPE_WIDE_ANSWER_IMAGE          = 20;
  self.LAYOUT_TYPE_XWIDE_ANSWER_IMAGE         = 21;
  
  self.LAYOUT_TYPE_IMAGE_8q_4a                = 30;
  self.LAYOUT_TYPE_IMAGE_6q_4a                = 40;
  self.LAYOUT_TYPE_IMAGE_4q_3a                = 50;

  self.DIFFICULTY_EASY     = 1;
  self.DIFFICULTY_MIXED    = 2;
  self.DIFFICULTY_HARD     = 3;
  
  self.DESCRIPTION_TYPE_COMPLETE_USEFULLY = 10;
  self.DESCRIPTION_TYPE_ANALOGY           = 20;
  self.DESCRIPTION_TYPE_GENERIC           = 30;

  self.TEXT_outsider_description_string="outsider_description_string";
  self.TEXT_complete_series="complete_series";
  self.TEXT_premium_content_description_useful="premium_content_description_useful";
  self.TEXT_premium_content_analogy="premium_content_analogy";
  
  self.id =0;
  self.seq_no = 0;
  self.pattern = 0;  
  self.layoutType = 0;  
  self.premium = false;
  self.difficultyLevel = 0;
  self.question_description_type = 0;
  self.is_stringresource = false;
  self.played = false;
  self.solved = false;
  self.width_height_factor=0;
}

// Constants
Puzzlehelper.prototype.DESCRIPTION_TYPE_COMPLETE_USEFULLY = function(){return this.DESCRIPTION_TYPE_COMPLETE_USEFULLY};  
Puzzlehelper.prototype.DESCRIPTION_TYPE_ANALOGY = function(){return this.DESCRIPTION_TYPE_ANALOGY}; 
Puzzlehelper.prototype.DESCRIPTION_TYPE_GENERIC = function(){return this.DESCRIPTION_TYPE_GENERIC};  

// Get resource id based on layout pattern
Puzzlehelper.prototype.getLayoutTemplateId = function(pattern, layout_type){
   
   var patternId = "";
   
   switch(pattern){
     case this.PATTERN_SERIES_COMPLETE_STRING:
       patternId = "complete_string";
       break;
     case this.PATTERN_SERIES_COMPLETE_IMAGE:
	   if (layout_type == this.LAYOUT_TYPE_IMAGE_8q_4a){
	   	  patternId="complete_image_8q_4a";
	   }
	   else if (layout_type == this.LAYOUT_TYPE_IMAGE_6q_4a){
	   	  patternId="complete_image_6q_4a";
	   }
	   else if (layout_type == this.LAYOUT_TYPE_IMAGE_4q_3a){
	   	  patternId="complete_image_4q_3a";	   
	   }
	   else{
          patternId="complete_image";
      }
       break;
     case this.PATTERN_OUTSIDER:
       patternId="outsider_string";
       break;
     case this.PATTERN_OUTSIDER_STRING:
       patternId="outsider_string";
       break;
     case this.PATTERN_OUTSIDER_IMAGE:
       patternId="outsider_image";
       break;
     case this.PATTERN_PREMIUM_CONTENT_COMPLETE_IMAGE:
       patternId="premium_content_image";
       break;
   }
   return patternId;
};
