
// Functions to change between pages
function changeToPage(page){
  document.querySelector(page).className = 'current';
  document.querySelector('[data-position="current"]').className = 'left'; 
};
function backFromPage(page){
  document.querySelector(page).className = 'right';
  document.querySelector('[data-position="current"]').className = 'current';
};

var expresionesLoaded = false;

$(document).ready(function(){

  //Make sure the internet connection in the first time open to load the database correctly
  if (!navigator.onLine && localStorage.getItem("exists") === null) {
    // console.log("0");
    alert('¡Necesita conectarse a internet para cargar la base de datos! Por favor, cierre la aplicación totalmente y conéctese a internet.');
  } else if(!navigator.onLine){
    // console.log("1");
    initializeDB();
    alert('Para disfrutar de todas las opciones de la aplicación necesita conexión a internet. Por favor, conéctese a internet antes de iniciar la aplicación.');
  // } else if (navigator.onLine && localStorage.getItem("exists") === "true"){
  //   initializeDB();
  //   console.log("2");
  // } else if (navigator.onLine && localStorage.getItem("exists") === null){
  //   console.log("3");
  //   localStorage.setItem("exists","true");
  //   initializeDB();
  //   $("#alertMessage").show();
  // }

  } else if(navigator.onLine){
    if(localStorage.getItem("exists") === null){
      // console.log("3");
      localStorage.setItem("exists","true");
      initializeDB();
      $("#alertMessage").show();
    } else {
      initializeDB();
      // console.log("2");
    }
  }

  //Change to Categorias Page and back Home
  $('#btn-categorias').click(function(){
    changeToPage('#categorias');
  });
  $('#btn-categorias-back').click(function(){
    backFromPage('#categorias');
  });

  // Load images for relative categorie
  $(document).on('click','img.selectingCategoria',function(e) {
    changeToPage('#categoriaChoosed');
    $('#categoriaTitle').html(this.id);
    loadAllImagesFromCategoria(this.id);
    playText(this.id,"es");
  });
  // Back from subcategoria page to Categorias Page
  $('#btn-categoria-back').click(function(){
    backFromPage('#categoriaChoosed');
    $('#listImagesFromCategoria').empty();
  });

  // Play sound when some icon is pulsed
  $(document).on('click','img.imageOn',function(e) {
      //console.log(this.id); 
      playText(this.id,"es");
  });

  // Change to Expresiones view and back Home
  $('#btn-expresiones').click(function(){
    changeToPage('#expresiones');
    if (expresionesLoaded === false){ 
      loadAllExpressionsInDom(); 
      expresionesLoaded = true;
    }

  });
  $('#btn-expresiones-back').click(function(){
    backFromPage('#expresiones');
    $("#expressionsTitle").show();
    $("#searchForm").hide();
  });

  // Change to Hablar page and back Home
  $('#btn-hablar').click(function(){
    changeToPage('#hablar');
  });
  $('#btn-hablar-back').click(function(){
    backFromPage('#hablar');
  });

  // Change to expressiones view and filter
  $("#searchHome").click(function(){
    changeToPage('#expresiones');
    $("#expressionsTitle").hide();
    $("#searchForm").show();
    $("").focus();
  });

  // Show and hide filter in Expresiones View
  $("#btnExpresionesSearch").click(function(){
       $("#expressionsTitle,#searchForm").toggle();
  });

  // Search Filter in list
   $("#searchBar").focus(function(){
    $("#searchBar").searchFilter('#ulExpresionesList');
  });
  // Play some expression pulsed
  $("ul").click(function(e) {
    //console.log(e.target.text);// 
    //console.log($(this).attr('id')); 
    playText(e.target.text,"es");
  });

    // Play text from textarea
  $("#btnPlay").click(function(){
    //console.log($("#talkText").val());
    playText($("#talkText").val(),"es");
  });

  // Swipe right or left to say sí or no respectively in everypage
  $('.content').hammer().on("swiperight", function(event) {
    playText("sí","es");
  });
  $('.content').hammer().on("swipeleft", function(event) {
    playText("no","es");
  });

  // Accept alert about loading data and show Tutorial
  $('#btnAlert').click(function(){
    $('#alertMessage').hide();
    $('#tutorial').show();
  });

  // Hide tutorial
  $('#tutorial').click(function(){
    $('#tutorial').hide();
  });


});   