var db;
// Iniciamos la BD
function initializeDB() {

	var expressionsUrlFromServerJSON = 'https://googledrive.com/host/0B0xyeyl64_UVNnR2Xzl3Vl9QYk0/db.json';
	// var expressionsUrlFromLocalJSON = "";
	var imageNamesFromServerJSON = 'https://googledrive.com/host/0B0xyeyl64_UVNnR2Xzl3Vl9QYk0/imageNames.json';
	// var imagesNamesFromLocalJSON = "";
	var imagesArray = [];
	var imagesJSONLoadedCorrectly = false;
	var	expressionsJSONLoadedCorrectly = false;

	// function deleteDB(){
	  // var request = indexedDB.deleteDatabase("ispeakDB");
	  // request.onsuccess = function(e){
	  // 	console.log("Eliminada db");
	  // }
	  // request.onerror = function(e){
	  // 	console.log("Error eliminando");
	  // }
	// }
	  

	//Open the DB (name DB, version DB)
	var request = indexedDB.open("ispeakDB",1);

	//Update every database 
	request.onupgradeneeded = function (e) {
		//alert("Espera unos segundos mientras se carga la base de datos...");

		
		db = e.target.result;
		// console.log("Updating DB");
		//Check if they already exist 
		if(db.objectStoreNames.contains('expressions')) {
			db.deleteObjectStore('expressions');
		}
		if(db.objectStoreNames.contains('images')) {
			db.deleteObjectStore('images');
		}
		
		//Object Store for expressions
		var expressionsStore = db.createObjectStore('expressions', {keyPath: 'id' , autoIncrement: true});
		 // console.log("Expressions Store has been created");

		//Object Store for images
		var imagesStore = db.createObjectStore('images', {keyPath: "name"});
		// console.log("Images");

		// setTimeout(addExpressionsFromJSONToDB,800);
		// getImageNamesFromJSON();
		// setTimeout(getImagesFromServer,1500);
		addExpressionsFromJSONToDB();
		getImageNamesFromJSON();
		// setTimeout(getImagesFromServer,1700);

		var readyToGetImages = setInterval( function() {
			if  (imagesJSONLoadedCorrectly === true){
				getImagesFromServer();
				clearInterval(readyToGetImages);
			} 
			console.log("Repitiendo");
		},400);
	};
	
	//Manage the handlers
	request.onsuccess = function (e){
		db = e.target.result; //request.result;
		//console.log(db);

		//Delay to show expressions after loading db
		console.log("Cargado..");
		//getAnExpression();
		// loadDatabases();
	};
	
	request.onerror = function (e) {
		console.log(e.target.errorCode); 
		errorAlert();
	};	
	
	request.onblocked = function (e){
		console.log("Bloqueado");
	};


	//-----------------------SAVING EXPRESSIONS---------------------------
	//Saving server JSON File to DB
	function addExpressionsFromJSONToDB(){
		// Do to check if not conexion, load from local
		$.getJSON('https://googledrive.com/host/0B0xyeyl64_UVNnR2Xzl3Vl9QYk0/db.json', function(dbJSON){
			
			var transaction = db.transaction(["expressions"], "readwrite");
			var expressionsStore = transaction.objectStore('expressions');
			var request;

			 for (var i = 0; i < dbJSON.expressions.length; i++) {
				request = expressionsStore.put(dbJSON.expressions[i]);
				// console.log(dbJSON.expressions[i]);
				request.onerror = function(e){
					console.log("Error añadiendo expresiones en" + dbJSON.expressions[i]);
					errorAlert();
				}
			};
			request.onsuccess = function(e){
				 // console.log("Expresiones añadidas");
				 expressionsJSONLoadedCorrectly = true;
			}
		});
	};

	// function getAnExpressionsMin(){
	// 	db.transaction("expressions").objectStore("expressions").get(1).onsuccess = function (e){
	// 		console.log(request.result.version);
	// 	}
	// };
	

	//--------------------------SAVING IMAGES------------------------------------
	//Getting the images JSON file to get every image-url
	function getImageNamesFromJSON(){
		//Getting all the image names from JSON file into array
		$.getJSON(imageNamesFromServerJSON, function(dbJSON){
			for (var i = 0; i < dbJSON.images.length; i++) {
				imagesArray[i] = dbJSON.images[i];
				   //console.log(imagesArray[i]);
			}
			if(dbJSON != null){
				// console.log(" images json terminado");
				imagesJSONLoadedCorrectly = true;
			} else{
				errorAlert();
			}
		});
		 // console.log("imagenes localizadas");
	};

	// Getting all the images from server
	function getImagesFromServer(){

		//Url without image name
		//It just changes the final name at url
		var urlWithoutName = 'https://googledrive.com/host/0B0xyeyl64_UVNTNSbkJOQUtwdzQ/'
		var j = 0; 
		for (var i = 0; i < imagesArray.length; i++) {
			
			var blob;
			
			//Building the final image url
			url = urlWithoutName + imagesArray[i].name + ".png";
			// console.log("url:"+url);
			var name = imagesArray[i].name;
			var tag = imagesArray[i].tag;
			 // console.log("nameeeeee"+name);
			 // console.log("tag"+tag);
			xhrRequest(url,name,tag);
		};
		
		// console.log("Imagenes guardadas");
	};

	//Doing the XMLHttpRequest to server image
	function xhrRequest(url,name,tag){
		// console.log("xhrRequest on");
		var xhr = new XMLHttpRequest({ mozSystem: true});
		xhr.open('GET', url);
		xhr.responseType = 'blob';
		xhr.onload = function(e){
			//console.log(j+"inside");
			  // console.log("name en onload:"+name);
			  // console.log("tag en onload:"+tag);
			if (xhr.status == 200) {
				blob = xhr.response;
				 // console.log(blob);
				//setTimeout(function (){ addImageToDB(blob,name) },1000);
				addImageToDB(blob,name,tag);
			}else{
				console.log("Error accediendo xhr:"+name);
				errorAlert();
			}
		}
		xhr.send();
	};	

	//Adding an image to DB
	//Modify to add mp3 to another object store
	function addImageToDB(blob,name,tag){
		// console.log("Añadiendo  imagen to dB");
		var transaction = db.transaction (["images"] ,"readwrite");
		var imagesStore = transaction.objectStore('images');	

		var object = { name: name, blob: blob, tag: tag};
		// console.log(object);
		var request = imagesStore.put(object);

		request.onsuccess = function(e){
			// console.log("Imagen añadida");
			if(name === "Yate"){
				$('#btnAlert').show();
			}
		}
		request.onerror = function(e){
			console.log("Error añadiendo image");
			errorAlert();	
		}	
	};

	function errorAlert(){
	$('#alertMessage').hide();
	alert("Se ha producido un error cargando la base de datos. Por favor, cierre la aplicación totalmente, asegure su conexión a internet e iniciela de nuevo");
	};
	//------------------------------ Favoritos --------------------------
};//initializeDB


//------------------------------ Load Data into Dom --------------------------

// Expressions Object Store => { id, text}
	//Load all the expression from DB into app (Expresiones)
function loadAllExpressionsInDom(){
	var objectStore = db.transaction("expressions").objectStore("expressions");

	objectStore.openCursor().onsuccess = function (e){
		var cursor = e.target.result;
		// console.log(cursor);
		if (cursor) {
			// console.log(cursor.value.id);
			// var aux = "<a href=\"#\">" + cursor.value.text + "</a>";
			// var aux2 = "<li \" class=\"expressionPulsed\" id=\"" + cursor.value.id + "\" >" + aux + "</li>";
			// $("#ulExpresionesList").append(aux2);

			var link = $(document.createElement('a')).attr({
				 'href':'#'
			});
			link.html(cursor.value.text);
			var aux= $(document.createElement('li')).attr({
				 'id':cursor.value.id,
				 'class':'expressionPulsed'
			});
			aux.html(link);					
			$("#ulExpresionesList").append(aux);
			cursor.continue();
		}
	}
	 // console.log("Expresiones mostradas");
};
//Show all the images within DB to app
function loadAllImagesInDom(){

	 // console.log("Show images on");
	var objectStore = db.transaction("images").objectStore("images");

	objectStore.openCursor().onsuccess = function (e){
		var cursor = e.target.result;
		 // console.log(cursor);
		if (cursor) {
			// console.log(cursor.value.id);

			// Key = blob name
			var imageName = cursor.key;
            // console.log("imageName" + imageName);

			// Image blob
			var imageFile = cursor.value.blob;
			
            // Create and revoke ObjectURL
            var imageURL = window.URL.createObjectURL(imageFile);
			
			// Set image
            var aux= $(document.createElement('img')).attr({
				 'id':imageName,
				 'src':imageURL,
				 'class':'imageOn'
			});
			var image = $(document.createElement('a')).attr({
				 'href':'#'
			});
			image.html(aux);					
			$("#categoriasList").append(image);

            // Revoking ObjectURL
            URL.revokeObjectURL(imageURL);

			cursor.continue();
		}
	}
	objectStore.openCursor().onerror = function(e){
		// console.log("Errorrrrrr");
		// console.log(e.target.result);
	}
};	

// Load All Images From relative Categoria in DOM
function loadAllImagesFromCategoria(categoria){

	// console.log("Show images on");
	var objectStore = db.transaction("images").objectStore("images");

	objectStore.openCursor().onsuccess = function (e){
		var cursor = e.target.result;
		 // console.log(cursor.value.tag);
		 // console.log(categoria);
		if (cursor) {
			// console.log(cursor.value.tag);
			if(cursor.value.tag === categoria){
			// Key = blob name
			var imageName = cursor.key;
             // console.log("imageName" + imageName);

			// Image blob
			var imageFile = cursor.value.blob;
			 // console.log(imageFile);

            // Create and revoke ObjectURL
            var imageURL = window.URL.createObjectURL(imageFile);
			
			// Set image
            var aux= $(document.createElement('img')).attr({
				 'id':imageName,
				 'src':imageURL,
				 'class':'imageOn',
				 'width':'64px',
				 'height':'64px'
			});
			var image = $(document.createElement('a')).attr({
				 'href':'#'
			});
			image.append(aux);
			var li = $(document.createElement('li'));
			li.append(image);
			li.append(imageName);
			$("#listImagesFromCategoria").append(li);

            // Revoking ObjectURL
            URL.revokeObjectURL(imageURL);
        	}

			cursor.continue();
		}
	}
	objectStore.openCursor().onerror = function(e){
		// console.log("Errorrrrrr");
		// console.log(e.target.result);
	}
};	
