window.addEventListener('DOMContentLoaded', function() {
	'use strict';

	var apiURL = 'http://www.ratp.fr/itineraires/fr/ratp/recherche-avancee?start={start}&end={end}&is_date_start=1&date={date}&time%5Bhour%5D={hour}&time%5Bminute%5D={minute}&mode=all&route_type=1&avoid=';
	var suggestURL = 'http://ratp-prod2.onyourmap.com/oym?f=gac&cb=jQuery1111010534001597351339_1450017300556&key=RATP12RHF592GJDRJGRDKGL52&Referer=http%3A%2F%2Fwww.ratp.fr&batch=%257C&charset=UTF-8&profile=ratp&comp=';
	var errorMsg = document.getElementById('error');
	var searchInput = document.getElementById('term');
	var results = document.getElementById('results');
	var request = null;
	var suggestRequest = null;
	var translate = navigator.mozL10n.get;
	var form = document.querySelector('form');
	var currentDate = null;

	form.addEventListener('submit', function(e) {
			e.preventDefault();
			search();
	}, false);

	Array.from(document.querySelectorAll('[data-toggle]')).forEach(function(element) {
		element.addEventListener('click', function() {
			switch (this.getAttribute('data-toggle')) {
				case 'map':
					window.open('map.html', 'Map')
				break;
				case 'history':
					window.open('history.html', 'History')
				break;
				case 'reverse':
					var el0 = document.querySelector('input[data-name="'+this.getAttribute('data-input-first')+'"]');
					var el1 = document.querySelector('input[data-name="'+this.getAttribute('data-input-second')+'"]');

					var value0 = el0.value;
					el0.value = el1.value;
					el1.value = value0;
			}
		});
	});

	Array.from(document.querySelectorAll('select[data-name]')).forEach(function(element) {
		element.addEventListener('change', function() {
			var input = document.querySelector('input[data-name="'+this.getAttribute('data-name')+'"]');
			input.value = this.value;

			this.hidden = true;
		});
	});

	Array.from(document.querySelectorAll('[data-clear]')).forEach(function(element) {
		element.addEventListener('click', function() {
			var input = document.querySelector('input[data-name="'+this.getAttribute('data-clear')+'"]').value='';
		});
	});

	Array.from(document.querySelectorAll('[data-toggle-focus]')).forEach(function(element) {
		element.addEventListener('click', function() {
			if(suggestRequest && suggestRequest.abort) {
				suggestRequest.abort();
			}

			var select = document.querySelector('select[data-name="'+this.getAttribute('data-toggle-focus')+'"]');
			var value = document.querySelector('input[data-name="'+this.getAttribute('data-toggle-focus')+'"]').value;

			suggestRequest = new XMLHttpRequest({ mozSystem: true });
			suggestRequest.open('get', suggestURL+encodeURIComponent(value), true);
			suggestRequest.responseType = 'text';

			suggestRequest.addEventListener('load', function() {
				var suggestions = JSON.parse(suggestRequest.response.replace('jQuery1111010534001597351339_1450017300556(', '').replace(');', ''));
				if (!suggestions.suggests || suggestions.suggests.length <= 0) {
					select.hidden = false;
					select.focus();
					return;
				}
				select.hidden = false;

				while (select.firstChild) {
					select.removeChild(select.firstChild);
				}
				var element = document.createElement('option');
				select.appendChild(element);

				suggestions.suggests.forEach(function(suggestion) {
					var element = document.createElement('option');
					element.innerHTML = suggestion.address;
					select.appendChild(element);
				});

				select.focus();
			});

			suggestRequest.send();

		}, false);
	});

	//navigator.mozL10n.once(search);

	function search() {
		if(request && request.abort) {
			request.abort();
		}

		currentDate = new Date();

		results.textContent = translate('searching');
		results.hidden = false;
		errorMsg.hidden = true;

		// var term = searchInput.value;
		// if(term.length === 0) {
		// 	term = searchInput.placeholder;
		// }

		var url = apiURL;
		url = url.replace('{start}', encodeURIComponent(document.querySelector('input[data-name="depart"]').value));
		url = url.replace('{end}', encodeURIComponent(document.querySelector('input[data-name="arrivee"]').value));
		url = url.replace('{date}', encodeURIComponent(currentDate.getDate()+'/'+currentDate.getMonth()+'/'+currentDate.getFullYear()));
		url = url.replace('{hour}', encodeURIComponent(currentDate.getHours()));
		url = url.replace('{minute}', encodeURIComponent(currentDate.getMinutes()));

		request = new XMLHttpRequest({ mozSystem: true });

		request.open('get', url, true);
		request.responseType = 'document';

		request.addEventListener('error', onRequestError);
		request.addEventListener('load', onRequestLoad);

		request.send();
	}
	function onRequestError() {
		var errorMessage = request.error;
			if(!errorMessage) {
				errorMessage = translate('searching_error');
			}
			showError(errorMessage);
	}
	function onRequestLoad() {
		if (request.response.querySelector('#feuille')) {
			var response = request.response.querySelector('#feuille').innerHTML;
			results.innerHTML = response;

			localStorage.setItem(Date.now(), JSON.stringify({
				depart: document.querySelector('input[data-name="depart"]').value,
				arrivee: document.querySelector('input[data-name="arrivee"]').value,
				date: currentDate.toJSON(),
				html: response
			}));
		} else {
			results.innerHTML = 'Error.';
		}
		results.hidden = false;
	}
	function showError(text) {
		errorMsg.textContent = text;
		errorMsg.hidden = false;
		results.hidden = true;
	}
});