window.addEventListener('DOMContentLoaded', function() {
	'use strict';

	var template = document.querySelector('[data-template="historyItem"]');
	var currentTemplate = '';

	Object.keys(window.localStorage).forEach(function(item) {
		item = JSON.parse(window.localStorage[item]);
		currentTemplate = template.cloneNode(true);
		currentTemplate.querySelector('[data-info="depart"]').innerHTML = item.depart;
		currentTemplate.querySelector('[data-info="arrivee"]').innerHTML = item.arrivee;
		currentTemplate.querySelector('[data-info="date"]').innerHTML = item.date;
		currentTemplate.querySelector('[data-info="results"]').innerHTML = item.html;
		currentTemplate.hidden = false;
		document.body.appendChild(currentTemplate);
	});
});