// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {

  // We'll ask the browser to use strict code to help us catch errors earlier.
  // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
  'use strict';
  
  
  var usertext = document.getElementsByTagName('input');
  //console.log('first log');

  $('button').on('click', function(){
    $('#results').empty();
    var source = $('input').val(),
        api_key = 'trnsl.1.1.20141003T194407Z.72e673516055e9c3.1e668269e52acc265af616383335677d816e136d',
        content = 'hej',
        url = 'https://translate.yandex.net/api/v1.5/tr.json/translate?key='+api_key+'&lang=sv-en&text='+ source;
    
    //console.log(url);      
    //console.log('click log');

    var request = new XMLHttpRequest({mozSystem: true});
    
    request.open('GET', url, true);
    //request.responseType = '';
    request.setRequestHeader("Content-type","application/x-www-form-urlencoded");
    request.onload = function () {
      //console.log(url);
      if (request.status >= 200 && request.status < 400) {
          // Success!
          var data = JSON.parse(request.response);
          //console.log(data.text[0]);
          $('#results').append(data.text[0]);
      } else {
          // We reached our target server, but it returned an error
          console.log("server error");
      }
    };

    request.onerror = function () {
        // There was a connection error of some sort
        console.log("connection error");
    };
    request.send(source);
    
  });
  
  var translate = navigator.mozL10n.get;

  // We want to wait until the localisations library has loaded all the strings.
  // So we'll tell it to let us know once it's ready.
  navigator.mozL10n.once(start);

  // ---

  function start() {

    var message = document.getElementById('message');

    // We're using textContent because inserting content from external sources into your page using innerHTML can be dangerous.
    // https://developer.mozilla.org/Web/API/Element.innerHTML#Security_considerations
    //message.textContent = translate('message');

  }

});
