﻿/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicitly call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        var parentElement = document.getElementById(id);
        var listeningElement = parentElement.querySelector('.listening');
        var receivedElement = parentElement.querySelector('.received');

        listeningElement.setAttribute('style', 'display:none;');
        receivedElement.setAttribute('style', 'display:block;');

        console.log('Received Event: ' + id);
    }
};


var informacion =
	{
	"lunes": 
		[
			{
			  "horaInicio":1130,
			  "horaFin":1200,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:30</p><p class=\"hora\"><span>&gt;&gt;</span> 12:00</p>",
			  "html":"<p class=\"titulo\">Acto oficial de Apertura</p><p>UNIVERSIDAD DE VIGO</p><p>Mesa Presidencial:</p><p>Reitor de la \"Universidade de Vigo\", D. Salustiano Mato de la Iglesia</p>"
			  },
			  {
			  "horaInicio":1200,
			  "horaFin":1230,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:00</p><p class=\"hora\"><span>&gt;&gt;</span> 12:30</p>",
			  "html":"<p class=\"titulo\">Evolución de las tecnologías de control en plantas de celulosa</p><p>ENCE</p><p>D. Antonio Casal (Director Centro de Operaciones)</p>"
			  },
			  {
			  "horaInicio":1230,
			  "horaFin":1300,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:30</p><p class=\"hora\"><span>&gt;&gt;</span> 13:00</p>",
			  "html":"<p class=\"titulo\">Robots aéreos interaccionando físicamente con el entorno</p><p>UNIVERSIDAD DE SEVILLA</p><p>D. Aníbal Ollero (Catedrático Universidad)</p>"
			  
			  },
			  {
			  "horaInicio":1300,
			  "horaFin":1330,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 13:00</p><p class=\"hora\"><span>&gt;&gt;</span> 13:30</p>",
			  "html":"<p class=\"titulo\">Google Glass y wearable technologies en el sector industrial</p><p>ITGLAS AND WEAR TECHNOLOGIES</p><p>D. Jordi Boza (CEO)</p>"
			  },
			  {
			  "horaInicio":1600,
			  "horaFin":1710,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 16:00</p><p class=\"hora\"><span>&gt;&gt;</span> 17:10</p>",
			  "html":"<p class=\"titulo\">Integrated Drive Systems</p><p>SIEMENS</p><p>D. José Prado (Responsable Drive Technology)</p>"
			  },
			  {
			  "horaInicio":1710,
			  "horaFin":1820,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 17:10</p><p class=\"hora\"><span>&gt;&gt;</span> 18:20</p>",
			  "html":"<p class=\"titulo\">Tecnologí­a industrial para aplicaciones Motion</p><p>ABB</p><p>D. Jordi Santisteve (Product Manager - Motion Application)</p>"
			  },
			  {
			  "horaInicio":1820,
			  "horaFin":1850,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:20</p><p class=\"hora\"><span>&gt;&gt;</span> 18:50</p>",
			  "html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			  },
			  {
			  "horaInicio":1850,
			  "horaFin":2000,
			  "horario":"<p>LUNES</p><p>3/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:50</p><p class=\"hora\"><span>&gt;&gt;</span> 20:00</p>",
			  "html":"<p class=\"titulo\">Plataformas industriales para un mundo Smart</p><p>WONDERWARE</p><p>D. Joan Pallás (Sales Engineering)</p>"
			  }
		],
	"martes":
		[
			{
				"horaInicio":930,
				"horaFin":1000,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 09:30</p><p class=\"hora\"><span>&gt;&gt;</span> 10:00</p>",
				"html":"<p class=\"titulo\">Robot cooperativo enfocado en habilitación naval</p><p>AIMEN</p><p>D. Félix Vidal (Coordinador grupo de robótica y control)</p>"
			},
			{
				"horaInicio":1000,
				"horaFin":1120,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 10:00</p><p class=\"hora\"><span>&gt;&gt;</span> 11:20</p>",
				"html":"<p class=\"titulo\">Soluciones avanzadas para el control de procesos por lotes</p><p>ROCKWELL AUTOMATION</p><p>D. Luis Navarra (Ingeniero comercial - industria de proceso)</p>"
			},
			{
				"horaInicio":1120,
				"horaFin":1140,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:10</p><p class=\"hora\"><span>&gt;&gt;</span> 11:40</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1140,
				"horaFin":1250,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:40</p><p class=\"hora\"><span>&gt;&gt;</span> 12:50</p>",
				"html":"<p class=\"titulo\">Mejora de los procesos industriales mediante tecnología BigData</p><p>SOLIDQ</p><p>D. Antonio Soto (Global COO)</p>"
			},
			{
				"horaInicio":1250,
				"horaFin":1400,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:50</p><p class=\"hora\"><span>&gt;&gt;</span> 14:00</p>",
				"html":"<p class=\"titulo\">Robot, proyecto de integración</p><p>KUKA</p><p>D. David Alonso (Delegado comercial - zona Noroeste, KUKA) y D. Cástor González (Director comercial, UNIMATE ROBÓTICA)</p>"
			},
			{
				"horaInicio":1600,
				"horaFin":1710,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 13:25</p><p class=\"hora\"><span>&gt;&gt;</span> 14:00</p>",
				"html":"<p class=\"titulo\">Eficiencia energética con sistemas de electrónica de potencia</p><p>WEG</p><p>D. Javier de la Morena (Responsable de grandes cuentas)</p>"
			},
			{
				"horaInicio":1710,
				"horaFin":1820,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 17:10</p><p class=\"hora\"><span>&gt;&gt;</span> 18:20</p>",
				"html":"<p class=\"titulo\">SIMATIC S7-1500 + TIA Portal</p><p>SIEMENS</p><p>D. Alberto Penalba (Técnico especialista en productos SIMATIC)</p>"
			},
			{
				"horaInicio":1820,
				"horaFin":1850,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:20</p><p class=\"hora\"><span>&gt;&gt;</span> 18:50</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1850,
				"horaFin":2000,
				"horario":"<p>MARTES</p><p>4/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:50</p><p class=\"hora\"><span>&gt;&gt;</span> 20:00</p>",
				"html":"<p class=\"titulo\">Open Core Engineering</p><p>BOSCH REXTROTH</p><p>D. Michael Krause (Business Development Automation)</p>"
			}
		],
		"miercoles":
		[	
			{
				"horaInicio":930,
				"horaFin":1000,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 09:30</p><p class=\"hora\"><span>&gt;&gt;</span> 10:00</p>",
				"html":"<p class=\"titulo\">Mecanizado de cordones de Soldadura Robotizado</p><p>CTAG</p><p>D. Víctor Alonso (Coordinador ÿrea Procesos de Fabricación)</p>"
			},		
			{
				"horaInicio":1000,
				"horaFin":1110,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 10:00</p><p class=\"hora\"><span>&gt;&gt;</span> 11:10</p>",
				"html":"<p class=\"titulo\">Autómatas y protocolos industriales</p><p>PHOENIX CONTACT</p><p>D. Carlos Manuel Fernández (Responsable Solution Engineering División CIS - Soluciones Industriales y de Control)</p>"
			},
			{
				"horaInicio":1110,
				"horaFin":1140,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:10</p><p class=\"hora\"><span>&gt;&gt;</span> 11:40</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1140,
				"horaFin":1250,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:40</p><p class=\"hora\"><span>&gt;&gt;</span> 12:50</p>",
				"html":"<p class=\"titulo\">Nueva tecnología OPC UA: SDK Servidor OPC-UA embebido de MatrikonOPC</p><p>MATRIKONOPC</p><p>D. Fabian Brener (Business Manager)</p>"
			},
			{
				"horaInicio":1250,
				"horaFin":1400,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:50</p><p class=\"hora\"><span>&gt;&gt;</span> 14:00</p>",
				"html":"<p class=\"titulo\">Soluciones de control Preventa en aplicaciones de seguridad según los requisitos de la EN ISO 13849. Nuevo Controlador modular XPS-MCM</p><p>SCHNEIDER ELECTRIC</p><p>D. Daniel Lara (Machine Safety Product Manager)</p>"
			},
			{
				"horaInicio":1600,
				"horaFin":1710,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 16:00</p><p class=\"hora\"><span>&gt;&gt;</span> 17:10</p>",
				"html":"<p class=\"titulo\">Nuevas tendencias en automatización de maquinaria</p><p>ROCKWELL AUTOMATION</p><p>D. Sergio López (Ingeniero comercial - Arquitectura Integrada)</p>"
			},
			{
				"horaInicio":1710,
				"horaFin":1830,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 17:10</p><p class=\"hora\"><span>&gt;&gt;</span> 18:30</p>",
				"html":"<p class=\"titulo\">Plataforma de automatización flexible y escalable</p><p>SCHNEIDER ELECTRIC</p><p>D. David Saltiveri (OEM Automation Business Industry)</p>"
			},
			{
				"horaInicio":1830,
				"horaFin":1850,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:30</p><p class=\"hora\"><span>&gt;&gt;</span> 18:50</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1850,
				"horaFin":2000,
				"horario":"<p>MIÉRCOLES</p><p>5/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:50</p><p class=\"hora\"><span>&gt;&gt;</span> 20:00</p>",
				"html":"<p class=\"titulo\">Comunicaciones industriales seguras con OPC UA</p><p>LOGITEK</p><p>D. Héctor García (Industrial Communications Manager)</p>"
			}
		],
		"jueves":
		[
			{
				"horaInicio":1000,
				"horaFin":1110,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 10:00</p><p class=\"hora\"><span>&gt;&gt;</span> 11:10</p>",
				"html":"<p class=\"titulo\">Control avanzado de procesos. Sistemas de monitorización de emisiones</p><p>ROCKWELL AUTOMATION</p><p>D. José Manuel Pozo (Responsable soluciones - Sistemas de Información)</p>"
			},
			{
				"horaInicio":1110,
				"horaFin":1140,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:10</p><p class=\"hora\"><span>&gt;&gt;</span> 11:40</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1140,
				"horaFin":1250,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:40</p><p class=\"hora\"><span>&gt;&gt;</span> 12:50</p>",
				"html":"<p class=\"titulo\">Pick & Place 2.0 | Nuevos Algoritmos Omron de Segunda Generación</p><p>OMRON</p><p>D. Fernando Vaquerizo (Servos, Motion Control & Robots Product Marketing Manager)</p>"
			},
			{
				"horaInicio":1250,
				"horaFin":1400,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:50</p><p class=\"hora\"><span>&gt;&gt;</span> 14:00</p>",
				"html":"<p class=\"titulo\">XTS, eXtended Transport System, el software sustituye al sistema mecánico con mayor funcionalidad y flexibilidad</p><p>BECKHOFF</p><p>D. Lluís Moreno (Responsable de Producto)</p>"
			},
			{
				"horaInicio":1600,
				"horaFin":1710,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 16:00</p><p class=\"hora\"><span>&gt;&gt;</span> 17:10</p>",
				"html":"<p class=\"titulo\">Soluciones software para la rápida configuración de un entorno productivo RFID</p><p>HARTING</p><p>D. Jan Regtmeier (Product Manager RDID Readers)</p>"
			},
			{
				"horaInicio":1710,
				"horaFin":1740,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 17:10</p><p class=\"hora\"><span>&gt;&gt;</span> 17:40</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1740,
				"horaFin":1850,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 17:40</p><p class=\"hora\"><span>&gt;&gt;</span> 18:50</p>",
				"html":"<p class=\"titulo\">OPC-UA as enabler for IoT (Internet of Things) and Industry 4.0: Status and roadmap</p><p>OPC FOUNDATION</p><p>D. Stefan Hoppe (President OPC Europe)</p>"
			},
			{
				"horaInicio":1850,
				"horaFin":2000,
				"horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 18:50</p><p class=\"hora\"><span>&gt;&gt;</span> 20:00</p>",
				"html":"<p class=\"titulo\">Smart Factories</p><p>UNIVERSITY OF BATH</p><p>D. Stephen T. Newmann (Professor)</p>"
			}
		],
		"viernes":
		[
			{
				"horaInicio":1000,
				"horaFin":1030,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 10:00</p><p class=\"hora\"><span>&gt;&gt;</span> 10:30</p>",
				"html":"<p class=\"titulo\">ISA (International Society of Automation): Punto de encuentro de la Comunidad de Automatización</p><p>ISA Sección Española (Colabora)</p><p>Dª. Raquel Mateos (Presidenta)</p>"
			},
			{
				"horaInicio":1030,
				"horaFin":1100,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 10:30</p><p class=\"hora\"><span>&gt;&gt;</span> 11:00</p>",
				"html":"<p class=\"titulo\">Control de versiones Git aplicado a la automatización</p><p>BASE2</p><p>D. David Pérez (Director técnico)</p>"
			},
			{
				"horaInicio":1100,
				"horaFin":1120,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:00</p><p class=\"hora\"><span>&gt;&gt;</span> 11:20</p>",
				"html":"<p class=\"titulo\">Pausa</p><p>Pausa</p>"
			},
			{
				"horaInicio":1120,
				"horaFin":1240,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 11:20</p><p class=\"hora\"><span>&gt;&gt;</span> 12:40</p>",
				"html":"<p class=\"titulo\">La gestión óptima del ciclo de vida de un variador de velocidad</p><p>ABB</p><p>D. Luis Miguel Taverner (Services Manager Drives and Controls)</p>"
			},
			{
				"horaInicio":1240,
				"horaFin":1310,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:40</p><p class=\"hora\"><span>&gt;&gt;</span> 13:10</p>",
				"html":"<p class=\"titulo\">Propuestas estratégicas para el futuro de la automática</p><p>CEA (Comité Español de la Automática)</p><p>D. Joseba Quevedo (Presidente)</p>"
			},
			{
				"horaInicio":1310,
				"horaFin":1340,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 13:10</p><p class=\"hora\"><span>&gt;&gt;</span> 13:40</p>",
				"html":"<p class=\"titulo\">Automatización y electrificación de la nueva EDAR de Lagares (Vigo)</p><p>MACRAUT</p><p>D. Antonio Malvido (Engineering Manager)</p>"
			},
			{
				"horaInicio":1345,
				"horaFin":1500,
				"horario":"<p>VIERNES</p><p>7/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 13:45</p>",
				"html":"<p class=\"titulo\">Acto oficial de Clausura</p><p>UNIVERSIDAD DE VIGO</p><p>Mesa Presidencial:</p><p>Reitor de la “Universidade de Vigo?, D. Salustiano Mato de la Iglesia</p>"
			}
		]
	};
// ---------------------------------------------------------------------------
// Inicializacion
// ---------------------------------------------------------------------------

// Wait for PhoneGap to load
//
document.addEventListener("deviceready", onDeviceReady, false);
var platform = "";
var gaPlugin;
var height;

// PhoneGap is ready
function onDeviceReady() {
    console.log("onDeviceReady");
    
    // Obtenemos la plataforma sobre la que se esta ejecutando la aplicacion
    platform = device.platform;
    console.log("onDeviceReady - Plataforma: " + platform);

    gaPlugin = window.plugins.gaPlugin; 
	gaPlugin.init(nativePluginConfigResultHandler, nativePluginConfigErrorHandler, "UA-54151007-1", 10);
	
	if (isLocalStorageNameSupported()){
		localStorage.setItem('informacion', JSON.stringify(informacion));	
		localStorage.setItem('programaLunes', JSON.stringify(informacion.lunes));
		localStorage.setItem('programaMartes', JSON.stringify(informacion.martes));
		localStorage.setItem('programaMiercoles', JSON.stringify(informacion.miercoles));
		localStorage.setItem('programaJueves', JSON.stringify(informacion.jueves));
		localStorage.setItem('programaViernes', JSON.stringify(informacion.viernes));
    }
    width = $(window).width();
    height = $(window).height();
}

// ---------------------------------------------------------------------------
// Localizacion
// ---------------------------------------------------------------------------

function abreMaps(){
    openLinkInExternalBrowser('http://goo.gl/T2jD43');
}

// ---------------------------------------------------------------------------
// OnPageBeforeShow
// ---------------------------------------------------------------------------
$(document).on('pagebeforeshow', "#index", function (event, data) {
               console.log("pagebeforeshow - index");
			   trackPage("index"); 
           });

$(document).on('pagebeforeshow', "#programaAhora", function (event, data) {
               console.log("pagebeforeshow - programaAhora");
			   trackPage("programaAhora");
               obtenerProgramaAhora();
           });
              
$(document).on('pagebeforeshow', "#programa", function (event, data) {
			console.log("pagebeforeshow - programa");
			var dia = getUrlVars()["dia"];
			var diaSemana;
			    
			console.log("Valor parametro dia: " + dia);		    			    
			    
			switch(dia) {
				case "1":
					diaSemana = "programaLunes";
					console.log("Dia de la semana: " + diaSemana);
					break;
				case "2":
					diaSemana = "programaMartes";
					console.log("Dia de la semana: " + diaSemana);
					break;
				case "3":
					diaSemana = "programaMiercoles";
					console.log("Dia de la semana: " + diaSemana);
					break;
				case "4":
					diaSemana = "programaJueves";
					console.log("Dia de la semana: " + diaSemana);
					break;
				case "5":
					diaSemana = "programaViernes";        		
					console.log("Dia de la semana: " + diaSemana);
					break;
			}
			console.log("Dia final de la semana: " + diaSemana);
			
			obtenerProgramaPorDia(dia, diaSemana);
			trackPage(diaSemana);
		});              

$(document).on('pagebeforeshow', "#hashtag", function (event, data) {
               console.log("pagebeforeshow - hashtag");
			   trackPage("hashtag");
               });

$(document).on('pagebeforeshow', "#acercaDe", function (event, data) {
               console.log("pagebeforeshow - acercaDe");
			   trackPage("acercaDe");
           });


$(document).on('pagebeforeshow', "#localizacion", function (event, data) {
               console.log("pagebeforeshow - localizacion");
			   trackPage("localizacion");
               
               $('#map_canvas').height(height);
			   
               $('#map_canvas').gmap().bind('init', function(ev, map) {
                                            $('#map_canvas').
                                                gmap('addMarker', {'position': '42.237629, -8.722082', 'bounds': true, 'icon':'img/abaposicion.png'}).
                                                    click(function() {
                                                          $('#map_canvas').gmap('openInfoWindow', {'content':
                                                                                '<div id="siteNotice">'+
                                                                                '</div>'+
                                                                                '<img src="img/abaposicion.png" style="float:left;margin-right:15px;margin-bottom:90px;"/>'+
                                                                                '<strong><span style="color:#00bdff;">JAI 2014</span></strong></br>'+
                                                                                '<div id="bodyContent">'+
                                                                                '<p>Auditorio del Centro Social AFUNDACIÓN</p>'+
                                                                                '<p>C/ Policarpo Sanz, 24-26</p>'+
                                                                                '<p>2ª Planta - Vigo</p>'+
                                                                                '<p><input type="button" onclick="abreMaps();" value="Ver en GoogleMaps"/></p>'+
                                                                                '</div>'+
                                                                                '</div>'}, this);
                                                          });
                                            $('#map_canvas').gmap('option', 'zoom', 16);
                                            });
           });

$(document).on('pageshow',"#localizacion",function(){
               $('#map_canvas').gmap('refresh');
           });

// ---------------------------------------------------------------------------               
// Google analytics
// ---------------------------------------------------------------------------
function trackPage(trackPage) {
	console.log("trackPage: " + trackPage);

	if (platform != "") {
		if (gaPlugin === undefined) {
			console.log("No se ha inicializado Google Analytics. Intentamos el método tradicional");
			_gaq.push(['_trackPageview', trackPage]);
		} else {
			console.log("Hay plataforma y plugin correctos. Utilizamos el plugin");
			gaPlugin.trackPage(nativePluginResultHandler, nativePluginErrorHandler, trackPage);
		}	
	} else {
		console.log("No tiene plataforma, estamos en la web");
		_gaq.push(['_trackPageview', trackPage]);
	}
//	_gaq.push(['_trackPageview', trackPage]);
}

function nativePluginConfigResultHandler (result) {
	console.log('nativePluginConfigResultHandler: ' + result);
	
    console.log("nativePluginConfigResultHandler - GoogleAnalytics configurado");    
	trackPage("index");	
}

function nativePluginConfigErrorHandler (error) {
	console.log('nativePluginConfigErrorHandler: ' + error);
}

function nativePluginResultHandler (result) {
	console.log('nativePluginResultHandler: ' + result);
}
        
function nativePluginErrorHandler (error) {
	console.log('nativePluginErrorHandler: ' + error);
}

// ---------------------------------------------------------------------------               
// Programa ahora
// ---------------------------------------------------------------------------
function obtenerProgramaAhora() {	
	var connection;
	var network = navigator.network;
	if (network !== undefined) {
		connection = network.connection;
	}

	if (connection !== undefined && connection.type === Connection.NONE) {
		console.log("No tengo conexion. No puedo hacer la peticion.");
		informacion = JSON.parse(localStorage.getItem('informacion'));
		mostrarEventoActual();
	} else {
		var url = "http://abamobile.com/jai2014/json/programa.php?jsoncallback=?";
		console.log("Solicitamos datos a " + url);
		$.getJSON( url, { })
			.done(function(data) {   
				console.log("DATOS RECIBIDOS: " + data);
				informacion = data.items;
				if (isLocalStorageNameSupported()){
					localStorage.setItem('informacion', JSON.stringify(informacion));
				}	
				mostrarEventoActual();
				}
			);	
	}
}

function mostrarEventoActual() {
    console.log("Vamos a cargar los datos del programa");
    var totalDias = 4;
    var ahoraMismo = "";
    var siguiente = "";

	// Fecha actual
    var fechaActual = new Date();
    var mesActual = fechaActual.getMonth()+1;
    var diaActual = fechaActual.getDate();
	var minutosAux = fechaActual.getMinutes() +"";
	if (minutosAux.length <2) {
		minutosAux = "0" + minutosAux;
	}	
	var horaActual = fechaActual.getHours() + "" + minutosAux;
	
	// Variables para pruebas
	//mesActual = 11;
    //diaActual = 5;
	//horaActual = 1945;
    
    if (fechaActual.getFullYear() != 2014 || mesActual > 11 || (mesActual == 11 && diaActual >7)) {
    	console.log("El evento ya acabo. Mostramos finalizado");
        jQuery("#mensajeAviso").parent().show();
        jQuery("#mensajeAviso").html("El evento ya ha finalizado. Esperamos verte en la próxima edición. Muchas gracias por tu participación.");
        return;
    }
    
    if (mesActual < 11 || (mesActual == 11 && diaActual<3) ) {
            console.log("Todavia no ha comenzado. Mostramos no comenzado");
            jQuery("#mensajeAviso").parent().show();
            jQuery("#mensajeAviso").html("El evento aún no ha comenzado, tendrá lugar entre los días 3 y 7 de Noviembre.");
            return;
    }
    
	console.log("Estamos en el dia y el mes correcto. Buscamos que mostrar");
	var diaCongreso = obtenerDia(diaActual);
	
	var hoy;
	var maniana;
	
	switch(diaActual) {
    	case 3:
			diaCongreso = 0;
			
			hoy = informacion.lunes;
			maniana = informacion.martes;			
			break;
		case 4:
			diaCongreso = 1;
			
			hoy = informacion.martes;
			maniana = informacion.miercoles;
			break;
		case 5:
	    	diaCongreso = 2;

			hoy = informacion.miercoles;
			maniana = informacion.jueves;	    	
        	break;
		case 6:
	    	diaCongreso = 3;

			hoy = informacion.jueves;
			maniana = informacion.viernes;	    	
			break;
		case 7:
			diaCongreso = 4;
			
			hoy = informacion.viernes;			
			break;
	}
	
	console.log("Es el dia de congreso: " + diaCongreso);
	console.log("Ya tengo el día de hoy y de maniana. Comprobamos los eventos a mostrar");
	
	if (horaActual < hoy[0].horaInicio) {
		console.log("Es demasiado pronto, todavia no hay ningun evento");		
		siguiente = hoy[0];
	} else {
		if (horaActual > hoy[hoy.length-1].horaInicio) {
			console.log("Es demasiado tarde, ya acabo por hoy. Miramos si hay que mostrar algo del dia siguiente");			
			if (diaCongreso < totalDias) {
				siguiente = maniana[0];
			}
		} else {
			for (j=0; j<hoy.length; j++) {
				if (horaActual > hoy[j].horaInicio && horaActual < hoy[j].horaFin) {
					console.log("Encontrado evento actual");
					ahoraMismo = hoy[j];
					if (j < hoy.length-1) {
						console.log("Encontrado evento siguiente dentro del mismo dia");
						siguiente = hoy[j+1];
					} else {
						console.log("Encontrado evento siguiente maniana");
						if (diaCongreso < totalDias) {
							siguiente = maniana[0];
						}
					}
					j = hoy.length;
				} else {
					if (horaActual < hoy[j].horaInicio) {
						console.log("Aun es demasiado pronto");
						// Ahora mismo no hay nada
						if (j < hoy.length-1) {
							//El siguiente es el siguiente programa del dia
							console.log("Encontrado evento siguiente hoy");
							siguiente = hoy[j+1];
						} else {
							//El siguiente será el primero del dí­a siguiente
							console.log("Encontrado evento siguiente el primero de maniana");
							if (diaCongreso < totalDias) {
								siguiente = maniana[0];
							}
						}
						j = hoy.length;
					}
				}
			}
		}
	}
    
    
    if (ahoraMismo == "" && siguiente == "") {
    	console.log("No hay ni evento actual ni siguiente, asi que es que acabo");
        jQuery("#mensajeAviso").parent().show();
        jQuery("#mensajeAviso").html("El evento ya ha finalizado. Esperamos verte en la próxima edición. Muchas gracias por tu participación.");
    } else {    
        if (ahoraMismo != "") {
        	console.log("Mostramos evento actual");
            jQuery("#ahoraMismoInfo").parent().show();
            jQuery("#pAhoraMismo").show();
            jQuery("#ahoraMismoInfo").html(ahoraMismo.html);
            jQuery("#ahoraMismoHorario").html(ahoraMismo.horario);
        } else {
        	console.log("Ahora no hay nada, pero mostramos lo siguiente");
            jQuery("#mensajeAviso").parent().show();
            jQuery("#mensajeAviso").html("Ahora mismo no se está impartiendo ninguna conferencia. Puede ver a continuación la próxima conferencia");
        }
        
        if (siguiente != "") {
        	console.log("Mostramos evento siguiente");
            jQuery("#siguienteInfo").parent().show();
            jQuery("#pSiguiente").show();
            jQuery("#siguienteInfo").html(siguiente.html);
            jQuery("#siguienteHorario").html(siguiente.horario);
        }
    }
}

// ---------------------------------------------------------------------------               
// Programa
// ---------------------------------------------------------------------------
function obtenerProgramaPorDia(dia, diaSemana) {
	var programa;
	
	var connection;
	var network = navigator.network;
	if (network !== undefined) {
		connection = network.connection;
	}
	
	if (connection !== undefined && connection.type === Connection.NONE) {
		console.log("No tengo conexion. No puedo hacer la peticion.");
		programa = JSON.parse(localStorage.getItem(diaSemana));						
		mostrarPrograma(programa);
	} else {
		var url = "http://abamobile.com/jai2014/json/dia.php?dia="+ dia + "&jsoncallback=?";
		console.log("Solicitamos datos a " + url);
		
		$.getJSON( url, { })
			.done(function(data) {   
				console.log("DATOS RECIBIDOS: " + data);
				
				programa = data;
				if (isLocalStorageNameSupported()){
					localStorage.setItem(diaSemana, JSON.stringify(programa));	
				}
				mostrarPrograma(programa);
				}
			);	
	}
}

function mostrarPrograma(programa) {

	
	for (var i = 0; i < programa.length; i++) {
	
		//  "horario":"<p>JUEVES</p><p>6/11/14</p><p class=\"hora salto\"><span>&lt;&lt;</span> 12:50</p><p class=\"hora\"><span>&gt;&gt;</span> 14:00</p>",
  		//  "html":"<p class=\"titulo\">XTS, eXtended Transport System, el software sustituye al sistema mecánico con mayor funcionalidad y flexibilidad</p><p>BECKHOFF</p><p>D. Lluí­s Moreno (Responsable de Producto)</p>"	
	
	
		
	
	    var item = programa[i];
		
    	var horario = item.horario;
    	var html = item.html;    	
    
    	if (horario !== undefined && html !== undefined) {	
			horario = "<div class=\"horario\">" + horario + "</div>";		
			html = "<div class=\"datos\">" + html + "</div>"
									
			var fila = "<div class=\"fila\">" + horario + html + "</div>";
			//console.log(fila);
			
			$( "#programaDia" ).append(fila);					
		}	
		
	}	
}


// ---------------------------------------------------------------------------               
// Utilidades
// ---------------------------------------------------------------------------
/**
 * Carga una url en el navegador del dispositivo
 */
function openLinkInExternalBrowser(link) {
    if (platform != "") {
        console.log("openLinkInExternalBrowser - Plataforma:" + platform);
        if (platform == "Android") {
           navigator.app.loadUrl(link, { openExternal:true }); 
        } else {
		   window.open(link, '_system');
        }
    } else {
		window.open(link, '_system');		
	}
}

/**
* Obtiene los pares clave/valor de los parametros de la url cargada
*/
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi,    
    function(m,key,value) {
      vars[key] = value;
    });
    return vars;
  }
  
/**
Valida si localstorage esta disponible. En safari + navegacion privada el localstorage setitem da una excepcion
*/  
 function isLocalStorageNameSupported() 
{
    var testKey = 'test', storage = window.sessionStorage;
    try 
    {
        storage.setItem(testKey, '1');
        storage.removeItem(testKey);
        return localStorageName in win && win[localStorageName];
    } 
    catch (error) 
    {
        return false;
    }
}