/*!
 * FirEBook v1.0
 * http://www.carlissongaldino.com.br/
 *
 * Copyright 2014 Cárlisson Galdino
 * Released under the MIT license
 *
 */
 window.addEvent("domready", function() {
	$("splash").setStyle("padding-top", Math.floor((document.getSize().y - 256) /2));
	
	var storage_key = "bookmarked-chapter";
	var wsize = document.getSize();
	
	var bookmarked_chapter =  localStorage.getItem(storage_key) || -1;
	
	var _ = function(str) {
		if (document.lang) {
			return document.lang[str] || str;
		} else {
			return str;
		}
	};
	
	var bmlink = new Element("a", {"id": "bookmark-link"}).appendText("");

	var bookmarkDialog = {
		menu: new Element("menu", {"id": "bmd-menu"}),
		goto: new Element("a", {"style": "display: none"}).appendText(_("Go specified page")),
		mark: new Element("a").appendText(_("Bookmark this page")),
		cancel: new Element("a").appendText(_("Cancel")),
		linkClass: "bm-add",
		show: function() {
			this.menu.fade("in");
		},
		hide: function() {
			this.menu.fade("out");
		},
		updateLink: function() {
			if (bookmarked_chapter == -1) {
				if ((this.linkClass == "bm-blank") || (this.linkClass == "bm-this")) {
					$("bookmark-link").removeClass(this.linkClass);				
				}
				this.linkClass = "bm-add";
			} else if (bookmarked_chapter == chapter) {
				if ((this.linkClass == "bm-blank") || (this.linkClass=="bm-add")) {
					$("bookmark-link").removeClass(this.linkClass);
				}
				this.linkClass = "bm-this";
			} else {
				if ((this.linkClass == "bm-this") || (this.linkClass=="bm-add")) {
					$("bookmark-link").removeClass(this.linkClass);
				}
				this.linkClass = "bm-blank";
			}
			$("bookmark-link").addClass(this.linkClass);
		},
		initiate: function() {
			this.goto.addEvent("click", function() {
				open_chapter_link(bookmarked_chapter);
				this.highlight("#1E90FF");
				bookmarkDialog.hide();
				bookmarkDialog.updateLink();
			});
			this.mark.addEvent("click", function() {
				bookmarked_chapter = chapter;
				localStorage.setItem(storage_key, chapter);
				this.highlight("#1E90FF");
				bookmarkDialog.hide();
				bookmarkDialog.updateLink();
			});
			this.cancel.addEvent("click", function() {
				this.highlight("#1E90FF");
				bookmarkDialog.hide();
			});
			this.menu.setStyle("width", wsize.x-10);
			this.menu.setStyle("height", wsize.y-10);
			this.menu.adopt(this.goto);
			this.menu.adopt(this.mark);
			this.menu.adopt(this.cancel);
			
			$("main-body").adopt(this.menu);
			this.menu.fade("out");
		},
		run: function() {
			if ((bookmarked_chapter >= 0) && (bookmarked_chapter != chapter)) {
				var p = arts[bookmarked_chapter].getElement("header h2").get("text");
				this.goto.set("text", _("Go to: ") + p);
				this.goto.setStyle("display", "block");
			} else {
				this.goto.setStyle("display", "none");				
			}
			this.menu.setStyle("display", "block");
			this.show();
		}
	};
	bookmarkDialog.initiate();
	bmlink.addClass(bookmarkDialog.linkClass);
		
	var change_font_size = function(inc) {
		var actual = $$("html").getStyle("font-size")[0].replace("px", "").toFloat();
		console.log(actual);
		if (inc) {
			if (actual < 30) {
				$$("html").setStyle("font-size", (actual + 1) + "px");
			} else {
				$$("article").highlight("#FF8D32");
			}
		} else {
			if (actual > 7) {
				$$("html").setStyle("font-size", (actual - 1) + "px");				
			} else {
				$$("article").highlight("#FF8D32");
			}
		}
	};
			
	var myFx = {
		fx1: new Fx.Tween('main-body', {
			property: 'left'	
		}),
		fx2: new Fx.Tween('main-header', {
		property: 'left'
		}),
		width: $$("aside").getStyle("width")[0].replace("px", "").toInt(),
		start: function(v1, v2) {
			this.fx1.start(v1, v2);
			this.fx2.start(v1, v2);
		},
		show: function() {
			this.start(0, this.width);
		},
		hide: function() {
			this.start(this.width, 0);
		}
	};
	var chapter = -1;
	var menulink = new Element("a", {"id": "main-menu-link"}).appendText("");
	var aside_visible = false;
		
	var show_hide_menu = function() {
		if (aside_visible) {
			myFx.hide();
			$$("article").removeEvent("click", only_hide_menu);
		} else {
			myFx.show();
			$$("article").addEvent("click", only_hide_menu);
		}
		aside_visible = ! aside_visible;
	};

	var only_hide_menu = function() {
		if (aside_visible) {
			show_hide_menu();
		}
	};
  
	var open_chapter = function(ch) {
		if (chapter >= 0) {
			arts[chapter].setStyle("display", "none");
			$("menu-link-" + chapter).removeClass("actual");
		}
		chapter = ch;
		bookmarkDialog.updateLink();
		arts[chapter].setStyle("display", "inline");
		$("menu-link-" + chapter).addClass("actual");
		/*("body").scrollTo(0, 0); AKI*/
	};
  
	var open_chapter_link = function(ch) {
		if (aside_visible) {
			this.highlight("#9C3B00");
		}
		only_hide_menu();
		open_chapter((ch >= 0) ? ch : this.getProperty("for"));
	};
	
	var change_chapter = function(next) {
		if (next) {
			if (chapter < arts.length - 1) {
				open_chapter(chapter.toInt() + 1);
			}
		} else {
			if (chapter > 0) {
				open_chapter(chapter.toInt() - 1);
			}
		}
	};
				
	menulink.addEvent("click", show_hide_menu); 
   
	bmlink.addEvent("click", function() {
		bookmarkDialog.run();
	});
	/*
	var fontplus = new Element("a", {"id": "font-plus"}).appendText("");
	fontplus.addEvent("click", function() {
		change_font_size(true);
	});
	var fontminus = new Element("a", {"id": "font-minus"}).appendText("");
	fontminus.addEvent("click", function() {
		change_font_size();
	});*/
	
	$("main-header").grab(menulink, "top");
	/*$("main-header").grab(fontminus, "top");
	$("main-header").grab(fontplus, "top");*/
	$("main-header").adopt(bmlink);

	var arts = $$("article");
	$$("aside").adopt(new Element("ul", {"id": "main-menu"}));
	for (var i = 0; i< arts.length; i++) {
		var tit = arts[i].getElement("header h2").get("text");
		var ali = new Element("a", {"id": "menu-link-" + i, "for": i}).appendText(tit);
		ali.addEvent("click", open_chapter_link);
		$("main-menu").adopt(new Element("li").adopt(ali));
		
		var uft = new Element("ul");
		if (i > 0) {
			var pli = new Element("li").appendText(_("previous"));
			pli.addEvent("click", function() {
				change_chapter();
			});
			uft.adopt(pli);
		};
		if (i < arts.length - 1) {
			var nli = new Element("li").appendText(_("next"));
			nli.addEvent("click", function() {
				change_chapter(true);
			});
			uft.adopt(nli);
		}

		arts[i].setStyle("height", (document.getSize().y - $("main-header").getSize().y));
		arts[i].setStyle("top", $("main-header").getSize().y);
		arts[i].adopt(new Element("footer").adopt(uft));
	}
   			
   	$$("aside h2").set("text", _("Content"));
	open_chapter((bookmarked_chapter >= 0) ? bookmarked_chapter : 0);

	setTimeout(function() {
		$("splash").fade("out");
	}, 2000);
});
