/*! jewelrymaven 2014-09-18 */
window.JMaven = {
    data: {
        necklaces: [ {
            id: "1",
            name: "Broadcollar Bib 1",
            img: "broadcollar_bib_1.png",
            descr: "Covers the actual neckline. Draws much attention to itself and the shoulder area. Visually re-enforces horizontal width, so makes shoulders look broader. Wear tops with solid colors, not patterns, so they don't compete with this showpiece.",
            style: "top: 99px; left: 48px;"
        }, {
            id: "7",
            name: "Choker 1",
            img: "choker_1.png",
            descr: "Fits snug around base if neck. Looks best on thin necks. Can be worn with most necklines except cowl and turtlenecks. Looks sexy peaking out from behind shirts with collars.",
            style: "top: 97px; left: 45px;"
        }, {
            id: "3",
            name: "Choker Multi Strand",
            img: "choker_multi_strand.png",
            descr: "Fits tightly around neck, close to chin. Looks best on thin necks. Can be worn with most necklines except cowl and turtlenecks.",
            style: "top: 95px; left: 47px;"
        }, {
            id: "2",
            name: "Collar 2",
            img: "collar_2.png",
            descr: "Fits tightly around neck, close to chin. Looks best on thin, long necks. Can be worn with most necklines except cowl and turtlenecks.",
            style: "top: 91px; left: 46px;"
        }, {
            id: "23",
            name: "Costume Bold Ovals",
            img: "costume_bold_ovals.png",
            descr: "Large, bold stones garner a lot of attention. Looks best against solid colored fabric or bare skin.",
            style: "top: 95px; left: 45px;"
        }, {
            id: "5",
            name: "Costume Goth Victorian",
            img: "costume_goth_victorian.png",
            descr: "Elegant and sexy, works best with wide open necklines that show lots of skin.",
            style: "top: 96px; left: 40px;"
        }, {
            id: "24",
            name: "Costume Leafy Splendor",
            img: "costume_leafy_splendor.png",
            descr: "Feminine and sexy, works best with wide open necklines that show lots of skin.",
            style: "top: 96px; left: 48px;"
        }, {
            id: "21",
            name: "Lariat",
            img: "lariat.png",
            descr: "The long, elegant length draws attention vertically, elongating the torso. Looks great with turtle, cowl, and other necklines that are busy near the throat.",
            style: "top: 97px; left: 50px;"
        }, {
            id: "14",
            name: "Matinee Multi-Strand Chunky",
            img: "matinee_multi_chunky.png",
            descr: "Large, chunky beads make the neck/throat a focal point. Looks best against solid colored fabric or bare skin.",
            style: "top: 95px; left: 44px;"
        }, {
            id: "20",
            name: "Multi Length Pendants",
            img: "multi-length_pendants.png",
            descr: "Long, elegant, varying lengths draw attention vertically, elongating the torso. Looks great with just about any neckline including turtle and cowl.",
            style: "top: 97px; left: 47px;"
        }, {
            id: "18",
            name: "Opera 3-Strand Thick",
            img: "opera_3strand_thick.png",
            descr: "This elegant style (representing either chains or strands of beads) elevates an ensemble. Be aware that attention is drawn to the chest area.",
            style: "top: 97px; left: 50px;"
        }, {
            id: "17",
            name: "Opera 3-Strand Thin",
            img: "opera_3strand_thin.png",
            descr: "This elegant style (representing either chains or strands of beads) elevates an ensemble. Be aware that attention is drawn to the chest area.",
            style: "top: 97px; left: 53px;"
        }, {
            id: "4",
            name: "Opera Chunky 1",
            img: "opera_length_chunky_1.png",
            descr: "Versatile style works for casual or evening. Because of its length, it draws attention to the bustline.",
            style: "top: 98px; left: 45px;"
        }, {
            id: "16",
            name: "Opera Pendant 1",
            img: "opera_pendant_01.png",
            descr: "A refined, elongating look perfect for all kinds of necklines. Attention will be drawn to the focal bead.",
            style: "top: 96px; left: 52px;"
        }, {
            id: "15",
            name: "Opera Tassel",
            img: "opera_tassle.png",
            descr: "A refined, elongating look perfect for all kinds of necklines. Attention will be drawn to the tassel.",
            style: "top: 99px; left: 47px;"
        }, {
            id: "13",
            name: "Princess 3-Strand Thick",
            img: "princess_3strand_thick.png",
            descr: "Hangs just on and over the collarbones, this complements many necklines, including v-necks, v-deep plunging, square, scoop, Queen Ann, cowl and turtlenecks.",
            style: "top: 98px; left: 50px;"
        }, {
            id: "12",
            name: "Princess 3-Strand Thin",
            img: "princess_3strand_thin.png",
            descr: "Hangs just on and over the collarbones, this complements many necklines, including v-necks, v-deep plunging, square, scoop, Queen Ann, cowl and turtlenecks.",
            style: "top: 98px; left: 52px;"
        }, {
            id: "10",
            name: "Princess Chunky 1",
            img: "princess_chunky_01.png",
            descr: "Dense and visually heavy, this creates a strong focal point. Complements many necklines. Looks best on thinner necks.",
            style: "top: 94px; left: 46px;"
        }, {
            id: "11",
            name: "Princess Chunky 2",
            img: "princess_chunky_02.png",
            descr: "Length hangs just on or over the collarbones, this complements many necklines, including v-necks, v-deep plunging, square, scoop, Queen Ann, cowl, and turtlenecks.",
            style: "top: 97px; left: 49px;"
        }, {
            id: "9",
            name: "Princess Pendant 2",
            img: "princess_pendant_02.png",
            descr: "The V-shape created by this silhouette complements V-necklines beautifully. Be careful that the pendant portion doesn't lay directly on the intersection of skin and fabric.",
            style: "left: 49px; top: 95px;"
        }, {
            id: "19",
            name: "Rope Pendant 1",
            img: "rope_pendant_01.png",
            descr: "The versatile rope necklace necklace dresses up any ensemble. The long, elegant length draws attention vertically, elongating the torso.",
            style: "left: 50px; top: 97px;"
        }, {
            id: "25",
            name: "Rope Tassle 1",
            img: "rope_tassel_01.png",
            descr: "The versatile rope necklace necklace dresses up any ensemble. The long, elegant length draws attention vertically, elongating the torso.",
            style: "left: 50px; top: 98px;"
        } ],
        necklines: [ {
            id: "13",
            name: "Bandeau",
            img: "bandeau.png",
            descr: 'Bandeau makes a glorious canvas of skin perfect for almost any necklace imaginable, especially wide thick bibs and all strands that end above the neckline. Be aware of the strong horizontal created by the the fabric. Make sure the end of the necklace falls at least 2" (5cm) above or below where fabric meets skin.'
        }, {
            id: "6",
            name: "Bateau",
            img: "bateau.png",
            descr: 'Think "contrast" when designing for these elegant necklines. Counter the strong horizontal line with strong verticals or soft curves. Create vertical interest. This neckline  draws attention to large shoulders and bustline.<br><br>Because this neckline draws attention to large shoulders and bustline, avoid overemphasizing the horizontal.<br><br>Avoid a length that ends right at the collar.'
        }, {
            id: "8",
            name: "Cowl",
            img: "cowl.png",
            descr: "Long necklaces and multi-strands hanging from beneath the cowl creates and elegant, flattering look. Cowls are perfect for bold and dramatic styles like long necklaces made of big link chains or chunky strands.<br><br>\r\nDon't place jewelry on top of the cowl: it flattens the cowl and looks sloppy.<br><br>\r\nAvoid short necklaces or chokers which the cowl partially obscures.<br><br>\r\nDon't wear necklaces touching or too close to the cowl: this creates bulk."
        }, {
            id: "1",
            name: "Jewel",
            img: "jewel.png",
            descr: "Works with most necklace styles as long as necklace falls below the curve of neckline, or fully covers the curve, creating its own neckline. Fill the chest area with jewelry!<br><br>Avoid shapes that fall directly on and compete with the curve of the neckline."
        }, {
            id: "5",
            name: "Queen Ann",
            img: "queen_ann.png",
            descr: "These necklines are  beautifully feminine. Most necklace shapes work as long as they don't obscure the silhouette of the neckline. Choose a necklace that doesn't touch the bottom of the neckline.<br><br>Avoid overpowering or obscuring the elegant, feminine shape of the neckline with a necklace too dramatic or busy.<br><br>Be mindful that the shapes created by exposed skin are not confusing or distracting."
        }, {
            id: "7",
            name: "Sabrina",
            img: "sabrina.png",
            descr: "Create vertical interest with strong verticals to counter the horizontal emphasis. Or use soft curves to soften the effect of the horizontal. This elegant, neckline emphasizes large shoulders and bustline."
        }, {
            id: "4",
            name: "Scoop",
            img: "scoop.png",
            descr: "The scoop--or round--neckline is easy to wear necklaces with because it flatters any neck and leaves room for most necklace shapes. The best look is to mirror the shape of the neckline and softly frame the neck.<br><br>Be mindful of proportions: avoid too much space between sides of neckline and necklace.<br><br>Avoid a pendant that sits on the neckline.<br><br>Avoid heavy pendants that pull the necklace into a V-shape."
        }, {
            id: "11",
            name: "Shirt Collar 1",
            img: "shirt_collar_1.png",
            descr: "This shirt collar strongly resembles a man's shirt. Short necklaces worn inside the collar are the only style visible. They can be chunky, bold, or delicate, whichever you prefer. A delicate short chain with small pendant creates a contrast to the masculine lines of the shirt.<br><br>\r\nDon't wear necklaces over the open collar: this looks cumbersome and messy."
        }, {
            id: "12",
            name: "Shirt Collar 2",
            img: "shirt_collar_2.png",
            descr: "This is a woman's styled shirt collar. Short necklaces which are visible inside the collar work beautifully. So do long lariat styles, as long as they hang flat enough to look elegant, not awkward. Wear the collar as open as possible for a sexy look. Choose necklaces that don't compete with the activity of the collar."
        }, {
            id: "3",
            name: "Square",
            img: "square.png",
            descr: "Fill the space the square neckline affords with layered chains, horizontal styles, and bibs. If you want to soften the angles use curves and organic shapes. For an edgier look, emphasize the angles by wearing geometric shapes.<br><br>Avoid overwhelming or obscuring the shape of the neckline.<br><br>Be mindful that the shapes created by exposed skin are not confusing or distracting."
        }, {
            id: "10",
            name: "Sweetheart",
            img: "sweetheart.png",
            descr: "Most necklace shapes work beautifully with the sweetheart neckline, as long as they don't obscure its elegant, feminine shape. Keep the length of the necklace above the neckline, not touching it or laying on it.<br><br>\r\nIf you're wearing dramatic or busy jewelry, keep it at least 1\" above from the neckline.<br><br>\r\nBe aware of the visual shapes created by exposed skin: make sure they're not distracting or awkwardly inelegant.\r\n"
        }, {
            id: "9",
            name: "Turtleneck",
            img: "turtle.png",
            descr: 'Wear jewelry that hangs 2" or lower than the turtleneck, filling the chest area. Soften the abrupt horizontal of the turtleneck with long necklaces that create vertical movement.<br><br>\r\nAvoid short chains and pendants: they produce a tight, choked look.\r\n'
        }, {
            id: "14",
            name: "V-Deep",
            img: "V-deep.png",
            descr: "V-Deep is a plunging V-neck usually seen in evening wear. It exposes lots of skin and cleavage. What do you want to accentuate, the cleavage area or the neck. Your answer will determine what kind of necklace to wear and how it will be. Choker, princess, and matinee lengths draw attention towards the face. Opera and rope lengths rivets attention between the breasts. Your choice!"
        }, {
            id: "2",
            name: "V-Neck",
            img: "V-neck.png",
            descr: "Flatters the neck/chest area and supports most necklace styles: follow the V shape, don't compete with it.<br><br>Avoid chokers that draw attention up and create an odd gap between neckline and necklace, making the neck appear thicker.<br><br>If you echo the V-shape, avoid doing so directly along the neckline. Allow an inch (2.5 cm) between necklace and neckline."
        } ],
        ratings: [ {
            id: "0",
            rating: "0",
            comment: "Fashion Citation"
        }, {
            id: "1",
            rating: "1",
            comment: "I wouldn't if I were you"
        }, {
            id: "2",
            rating: "2",
            comment: "You can do better"
        }, {
            id: "3",
            rating: "3",
            comment: "Passable"
        }, {
            id: "4",
            rating: "4",
            comment: "Lookin' good!"
        }, {
            id: "5",
            rating: "5",
            comment: "Wear it now!"
        } ],
        xref: [ {
            id: "1",
            necklace_id: "1",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "3",
            necklace_id: "1",
            neckline_id: "2",
            rating_id: "1",
            comment: ""
        }, {
            id: "5",
            necklace_id: "1",
            neckline_id: "3",
            rating_id: "4",
            comment: ""
        }, {
            id: "15",
            necklace_id: "1",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "23",
            necklace_id: "1",
            neckline_id: "5",
            rating_id: "4",
            comment: ""
        }, {
            id: "2",
            necklace_id: "1",
            neckline_id: "6",
            rating_id: "4",
            comment: ""
        }, {
            id: "4",
            necklace_id: "1",
            neckline_id: "7",
            rating_id: "4",
            comment: ""
        }, {
            id: "6",
            necklace_id: "1",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "7",
            necklace_id: "1",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "8",
            necklace_id: "1",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "9",
            necklace_id: "1",
            neckline_id: "11",
            rating_id: "0",
            comment: ""
        }, {
            id: "10",
            necklace_id: "1",
            neckline_id: "12",
            rating_id: "1",
            comment: ""
        }, {
            id: "289",
            necklace_id: "1",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "290",
            necklace_id: "1",
            neckline_id: "14",
            rating_id: "2",
            comment: ""
        }, {
            id: "24",
            necklace_id: "2",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "25",
            necklace_id: "2",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "30",
            necklace_id: "2",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "31",
            necklace_id: "2",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "33",
            necklace_id: "2",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "26",
            necklace_id: "2",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "27",
            necklace_id: "2",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "28",
            necklace_id: "2",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "29",
            necklace_id: "2",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "32",
            necklace_id: "2",
            neckline_id: "10",
            rating_id: "5",
            comment: ""
        }, {
            id: "34",
            necklace_id: "2",
            neckline_id: "11",
            rating_id: "0",
            comment: ""
        }, {
            id: "35",
            necklace_id: "2",
            neckline_id: "12",
            rating_id: "3",
            comment: "when tucked under collar"
        }, {
            id: "295",
            necklace_id: "2",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "296",
            necklace_id: "2",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "36",
            necklace_id: "3",
            neckline_id: "1",
            rating_id: "1",
            comment: ""
        }, {
            id: "37",
            necklace_id: "3",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "38",
            necklace_id: "3",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "39",
            necklace_id: "3",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "40",
            necklace_id: "3",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "41",
            necklace_id: "3",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "42",
            necklace_id: "3",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "43",
            necklace_id: "3",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "44",
            necklace_id: "3",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "45",
            necklace_id: "3",
            neckline_id: "10",
            rating_id: "5",
            comment: ""
        }, {
            id: "46",
            necklace_id: "3",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "47",
            necklace_id: "3",
            neckline_id: "12",
            rating_id: "3",
            comment: "when tucked under collar"
        }, {
            id: "293",
            necklace_id: "3",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "294",
            necklace_id: "3",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "48",
            necklace_id: "4",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "49",
            necklace_id: "4",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "50",
            necklace_id: "4",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "51",
            necklace_id: "4",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "52",
            necklace_id: "4",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "53",
            necklace_id: "4",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "54",
            necklace_id: "4",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "55",
            necklace_id: "4",
            neckline_id: "8",
            rating_id: "4",
            comment: ""
        }, {
            id: "56",
            necklace_id: "4",
            neckline_id: "9",
            rating_id: "4",
            comment: ""
        }, {
            id: "57",
            necklace_id: "4",
            neckline_id: "10",
            rating_id: "2",
            comment: ""
        }, {
            id: "58",
            necklace_id: "4",
            neckline_id: "11",
            rating_id: "2",
            comment: ""
        }, {
            id: "59",
            necklace_id: "4",
            neckline_id: "12",
            rating_id: "4",
            comment: "when worn outside collar"
        }, {
            id: "60",
            necklace_id: "5",
            neckline_id: "1",
            rating_id: "3",
            comment: ""
        }, {
            id: "61",
            necklace_id: "5",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "62",
            necklace_id: "5",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "63",
            necklace_id: "5",
            neckline_id: "4",
            rating_id: "4",
            comment: ""
        }, {
            id: "64",
            necklace_id: "5",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "65",
            necklace_id: "5",
            neckline_id: "6",
            rating_id: "2",
            comment: ""
        }, {
            id: "66",
            necklace_id: "5",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "67",
            necklace_id: "5",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "68",
            necklace_id: "5",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "69",
            necklace_id: "5",
            neckline_id: "10",
            rating_id: "3",
            comment: ""
        }, {
            id: "70",
            necklace_id: "5",
            neckline_id: "11",
            rating_id: "0",
            comment: ""
        }, {
            id: "71",
            necklace_id: "5",
            neckline_id: "12",
            rating_id: "0",
            comment: ""
        }, {
            id: "299",
            necklace_id: "5",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "300",
            necklace_id: "5",
            neckline_id: "14",
            rating_id: "4",
            comment: ""
        }, {
            id: "72",
            necklace_id: "6",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "73",
            necklace_id: "6",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "74",
            necklace_id: "6",
            neckline_id: "3",
            rating_id: "4",
            comment: ""
        }, {
            id: "75",
            necklace_id: "6",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "76",
            necklace_id: "6",
            neckline_id: "5",
            rating_id: "4",
            comment: ""
        }, {
            id: "77",
            necklace_id: "6",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "78",
            necklace_id: "6",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "79",
            necklace_id: "6",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "80",
            necklace_id: "6",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "81",
            necklace_id: "6",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "82",
            necklace_id: "6",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "83",
            necklace_id: "6",
            neckline_id: "12",
            rating_id: "5",
            comment: ""
        }, {
            id: "84",
            necklace_id: "7",
            neckline_id: "1",
            rating_id: "4",
            comment: ""
        }, {
            id: "85",
            necklace_id: "7",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "86",
            necklace_id: "7",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "87",
            necklace_id: "7",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "88",
            necklace_id: "7",
            neckline_id: "5",
            rating_id: "4",
            comment: ""
        }, {
            id: "89",
            necklace_id: "7",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "90",
            necklace_id: "7",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "91",
            necklace_id: "7",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "92",
            necklace_id: "7",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "93",
            necklace_id: "7",
            neckline_id: "10",
            rating_id: "5",
            comment: ""
        }, {
            id: "94",
            necklace_id: "7",
            neckline_id: "11",
            rating_id: "3",
            comment: ""
        }, {
            id: "95",
            necklace_id: "7",
            neckline_id: "12",
            rating_id: "5",
            comment: "when tucked under collar"
        }, {
            id: "291",
            necklace_id: "7",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "292",
            necklace_id: "7",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "96",
            necklace_id: "8",
            neckline_id: "1",
            rating_id: "1",
            comment: ""
        }, {
            id: "97",
            necklace_id: "8",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "98",
            necklace_id: "8",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "99",
            necklace_id: "8",
            neckline_id: "4",
            rating_id: "3",
            comment: ""
        }, {
            id: "100",
            necklace_id: "8",
            neckline_id: "5",
            rating_id: "3",
            comment: ""
        }, {
            id: "101",
            necklace_id: "8",
            neckline_id: "6",
            rating_id: "1",
            comment: ""
        }, {
            id: "102",
            necklace_id: "8",
            neckline_id: "7",
            rating_id: "1",
            comment: ""
        }, {
            id: "103",
            necklace_id: "8",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "104",
            necklace_id: "8",
            neckline_id: "9",
            rating_id: "2",
            comment: ""
        }, {
            id: "105",
            necklace_id: "8",
            neckline_id: "10",
            rating_id: "3",
            comment: ""
        }, {
            id: "106",
            necklace_id: "8",
            neckline_id: "11",
            rating_id: "3",
            comment: ""
        }, {
            id: "107",
            necklace_id: "8",
            neckline_id: "12",
            rating_id: "2",
            comment: ""
        }, {
            id: "108",
            necklace_id: "9",
            neckline_id: "1",
            rating_id: "3",
            comment: ""
        }, {
            id: "109",
            necklace_id: "9",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "110",
            necklace_id: "9",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "111",
            necklace_id: "9",
            neckline_id: "4",
            rating_id: "0",
            comment: ""
        }, {
            id: "112",
            necklace_id: "9",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "113",
            necklace_id: "9",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "114",
            necklace_id: "9",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "115",
            necklace_id: "9",
            neckline_id: "8",
            rating_id: "1",
            comment: ""
        }, {
            id: "116",
            necklace_id: "9",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "117",
            necklace_id: "9",
            neckline_id: "10",
            rating_id: "1",
            comment: ""
        }, {
            id: "118",
            necklace_id: "9",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "119",
            necklace_id: "9",
            neckline_id: "12",
            rating_id: "1",
            comment: ""
        }, {
            id: "120",
            necklace_id: "10",
            neckline_id: "1",
            rating_id: "2",
            comment: ""
        }, {
            id: "121",
            necklace_id: "10",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "122",
            necklace_id: "10",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "123",
            necklace_id: "10",
            neckline_id: "4",
            rating_id: "3",
            comment: ""
        }, {
            id: "124",
            necklace_id: "10",
            neckline_id: "5",
            rating_id: "3",
            comment: ""
        }, {
            id: "125",
            necklace_id: "10",
            neckline_id: "6",
            rating_id: "1",
            comment: ""
        }, {
            id: "126",
            necklace_id: "10",
            neckline_id: "7",
            rating_id: "1",
            comment: ""
        }, {
            id: "127",
            necklace_id: "10",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "128",
            necklace_id: "10",
            neckline_id: "9",
            rating_id: "2",
            comment: ""
        }, {
            id: "129",
            necklace_id: "10",
            neckline_id: "10",
            rating_id: "3",
            comment: ""
        }, {
            id: "130",
            necklace_id: "10",
            neckline_id: "11",
            rating_id: "5",
            comment: ""
        }, {
            id: "131",
            necklace_id: "10",
            neckline_id: "12",
            rating_id: "3",
            comment: ""
        }, {
            id: "132",
            necklace_id: "11",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "133",
            necklace_id: "11",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "134",
            necklace_id: "11",
            neckline_id: "3",
            rating_id: "4",
            comment: ""
        }, {
            id: "135",
            necklace_id: "11",
            neckline_id: "4",
            rating_id: "4",
            comment: ""
        }, {
            id: "136",
            necklace_id: "11",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "137",
            necklace_id: "11",
            neckline_id: "6",
            rating_id: "4",
            comment: ""
        }, {
            id: "138",
            necklace_id: "11",
            neckline_id: "7",
            rating_id: "4",
            comment: ""
        }, {
            id: "139",
            necklace_id: "11",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "140",
            necklace_id: "11",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "141",
            necklace_id: "11",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "142",
            necklace_id: "11",
            neckline_id: "12",
            rating_id: "1",
            comment: ""
        }, {
            id: "143",
            necklace_id: "12",
            neckline_id: "1",
            rating_id: "1",
            comment: ""
        }, {
            id: "144",
            necklace_id: "12",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "145",
            necklace_id: "12",
            neckline_id: "3",
            rating_id: "1",
            comment: ""
        }, {
            id: "146",
            necklace_id: "12",
            neckline_id: "4",
            rating_id: "3",
            comment: ""
        }, {
            id: "147",
            necklace_id: "12",
            neckline_id: "5",
            rating_id: "3",
            comment: ""
        }, {
            id: "148",
            necklace_id: "12",
            neckline_id: "6",
            rating_id: "1",
            comment: ""
        }, {
            id: "149",
            necklace_id: "12",
            neckline_id: "7",
            rating_id: "1",
            comment: ""
        }, {
            id: "150",
            necklace_id: "12",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "151",
            necklace_id: "12",
            neckline_id: "9",
            rating_id: "2",
            comment: ""
        }, {
            id: "152",
            necklace_id: "12",
            neckline_id: "10",
            rating_id: "3",
            comment: ""
        }, {
            id: "153",
            necklace_id: "12",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "154",
            necklace_id: "12",
            neckline_id: "12",
            rating_id: "1",
            comment: ""
        }, {
            id: "155",
            necklace_id: "13",
            neckline_id: "1",
            rating_id: "3",
            comment: ""
        }, {
            id: "156",
            necklace_id: "13",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "157",
            necklace_id: "13",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "158",
            necklace_id: "13",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "159",
            necklace_id: "13",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "160",
            necklace_id: "13",
            neckline_id: "6",
            rating_id: "4",
            comment: ""
        }, {
            id: "161",
            necklace_id: "13",
            neckline_id: "7",
            rating_id: "4",
            comment: ""
        }, {
            id: "162",
            necklace_id: "13",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "163",
            necklace_id: "13",
            neckline_id: "9",
            rating_id: "3",
            comment: ""
        }, {
            id: "164",
            necklace_id: "13",
            neckline_id: "10",
            rating_id: "5",
            comment: ""
        }, {
            id: "165",
            necklace_id: "13",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "166",
            necklace_id: "13",
            neckline_id: "12",
            rating_id: "1",
            comment: ""
        }, {
            id: "167",
            necklace_id: "14",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "168",
            necklace_id: "14",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "169",
            necklace_id: "14",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "170",
            necklace_id: "14",
            neckline_id: "4",
            rating_id: "4",
            comment: ""
        }, {
            id: "171",
            necklace_id: "14",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "172",
            necklace_id: "14",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "173",
            necklace_id: "14",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "174",
            necklace_id: "14",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "175",
            necklace_id: "14",
            neckline_id: "9",
            rating_id: "5",
            comment: "when tucked under collar"
        }, {
            id: "176",
            necklace_id: "14",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "177",
            necklace_id: "14",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "178",
            necklace_id: "14",
            neckline_id: "12",
            rating_id: "0",
            comment: ""
        }, {
            id: "317",
            necklace_id: "14",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "318",
            necklace_id: "14",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "179",
            necklace_id: "15",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "180",
            necklace_id: "15",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "181",
            necklace_id: "15",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "182",
            necklace_id: "15",
            neckline_id: "4",
            rating_id: "4",
            comment: ""
        }, {
            id: "183",
            necklace_id: "15",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "184",
            necklace_id: "15",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "185",
            necklace_id: "15",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "186",
            necklace_id: "15",
            neckline_id: "8",
            rating_id: "5",
            comment: "when tucked under cowl"
        }, {
            id: "187",
            necklace_id: "15",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "188",
            necklace_id: "15",
            neckline_id: "10",
            rating_id: "5",
            comment: ""
        }, {
            id: "189",
            necklace_id: "15",
            neckline_id: "11",
            rating_id: "5",
            comment: ""
        }, {
            id: "190",
            necklace_id: "15",
            neckline_id: "12",
            rating_id: "5",
            comment: ""
        }, {
            id: "193",
            necklace_id: "16",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "194",
            necklace_id: "16",
            neckline_id: "2",
            rating_id: "4",
            comment: ""
        }, {
            id: "195",
            necklace_id: "16",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "196",
            necklace_id: "16",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "197",
            necklace_id: "16",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "198",
            necklace_id: "16",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "199",
            necklace_id: "16",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "200",
            necklace_id: "16",
            neckline_id: "8",
            rating_id: "4",
            comment: ""
        }, {
            id: "201",
            necklace_id: "16",
            neckline_id: "9",
            rating_id: "4",
            comment: ""
        }, {
            id: "202",
            necklace_id: "16",
            neckline_id: "10",
            rating_id: "2",
            comment: ""
        }, {
            id: "203",
            necklace_id: "16",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "204",
            necklace_id: "16",
            neckline_id: "12",
            rating_id: "5",
            comment: ""
        }, {
            id: "205",
            necklace_id: "17",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "206",
            necklace_id: "17",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "207",
            necklace_id: "17",
            neckline_id: "3",
            rating_id: "4",
            comment: ""
        }, {
            id: "208",
            necklace_id: "17",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "209",
            necklace_id: "17",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "210",
            necklace_id: "17",
            neckline_id: "6",
            rating_id: "4",
            comment: ""
        }, {
            id: "211",
            necklace_id: "17",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "212",
            necklace_id: "17",
            neckline_id: "8",
            rating_id: "4",
            comment: ""
        }, {
            id: "213",
            necklace_id: "17",
            neckline_id: "9",
            rating_id: "4",
            comment: ""
        }, {
            id: "214",
            necklace_id: "17",
            neckline_id: "10",
            rating_id: "1",
            comment: ""
        }, {
            id: "215",
            necklace_id: "17",
            neckline_id: "11",
            rating_id: "3",
            comment: ""
        }, {
            id: "216",
            necklace_id: "17",
            neckline_id: "12",
            rating_id: "4",
            comment: "when tucked under collar"
        }, {
            id: "321",
            necklace_id: "17",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "322",
            necklace_id: "17",
            neckline_id: "14",
            rating_id: "2",
            comment: ""
        }, {
            id: "217",
            necklace_id: "18",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "218",
            necklace_id: "18",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "219",
            necklace_id: "18",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "220",
            necklace_id: "18",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "221",
            necklace_id: "18",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "222",
            necklace_id: "18",
            neckline_id: "6",
            rating_id: "4",
            comment: ""
        }, {
            id: "223",
            necklace_id: "18",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "224",
            necklace_id: "18",
            neckline_id: "8",
            rating_id: "1",
            comment: ""
        }, {
            id: "225",
            necklace_id: "18",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "226",
            necklace_id: "18",
            neckline_id: "10",
            rating_id: "1",
            comment: ""
        }, {
            id: "227",
            necklace_id: "18",
            neckline_id: "11",
            rating_id: "4",
            comment: "when tucked under collar"
        }, {
            id: "228",
            necklace_id: "18",
            neckline_id: "12",
            rating_id: "4",
            comment: "when tucked under collar"
        }, {
            id: "229",
            necklace_id: "19",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "230",
            necklace_id: "19",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "231",
            necklace_id: "19",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "232",
            necklace_id: "19",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "233",
            necklace_id: "19",
            neckline_id: "5",
            rating_id: "1",
            comment: ""
        }, {
            id: "234",
            necklace_id: "19",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "235",
            necklace_id: "19",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "236",
            necklace_id: "19",
            neckline_id: "8",
            rating_id: "5",
            comment: ""
        }, {
            id: "237",
            necklace_id: "19",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "238",
            necklace_id: "19",
            neckline_id: "10",
            rating_id: "1",
            comment: ""
        }, {
            id: "239",
            necklace_id: "19",
            neckline_id: "11",
            rating_id: "3",
            comment: ""
        }, {
            id: "240",
            necklace_id: "19",
            neckline_id: "12",
            rating_id: "4",
            comment: "when worn outside collar"
        }, {
            id: "241",
            necklace_id: "20",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "242",
            necklace_id: "20",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "243",
            necklace_id: "20",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "244",
            necklace_id: "20",
            neckline_id: "4",
            rating_id: "4",
            comment: ""
        }, {
            id: "245",
            necklace_id: "20",
            neckline_id: "5",
            rating_id: "2",
            comment: ""
        }, {
            id: "246",
            necklace_id: "20",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "247",
            necklace_id: "20",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "248",
            necklace_id: "20",
            neckline_id: "8",
            rating_id: "5",
            comment: "when tucked under cowl"
        }, {
            id: "249",
            necklace_id: "20",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "250",
            necklace_id: "20",
            neckline_id: "10",
            rating_id: "3",
            comment: ""
        }, {
            id: "251",
            necklace_id: "20",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "252",
            necklace_id: "20",
            neckline_id: "12",
            rating_id: "3",
            comment: ""
        }, {
            id: "319",
            necklace_id: "20",
            neckline_id: "13",
            rating_id: "4",
            comment: ""
        }, {
            id: "320",
            necklace_id: "20",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "253",
            necklace_id: "21",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "254",
            necklace_id: "21",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "255",
            necklace_id: "21",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "256",
            necklace_id: "21",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "257",
            necklace_id: "21",
            neckline_id: "5",
            rating_id: "3",
            comment: ""
        }, {
            id: "258",
            necklace_id: "21",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "259",
            necklace_id: "21",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "260",
            necklace_id: "21",
            neckline_id: "8",
            rating_id: "5",
            comment: "when tucked under cowl"
        }, {
            id: "261",
            necklace_id: "21",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "262",
            necklace_id: "21",
            neckline_id: "10",
            rating_id: "2",
            comment: ""
        }, {
            id: "263",
            necklace_id: "21",
            neckline_id: "11",
            rating_id: "3",
            comment: ""
        }, {
            id: "264",
            necklace_id: "21",
            neckline_id: "12",
            rating_id: "5",
            comment: ""
        }, {
            id: "315",
            necklace_id: "21",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "316",
            necklace_id: "21",
            neckline_id: "14",
            rating_id: "2",
            comment: ""
        }, {
            id: "265",
            necklace_id: "22",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "266",
            necklace_id: "22",
            neckline_id: "2",
            rating_id: "5",
            comment: ""
        }, {
            id: "267",
            necklace_id: "22",
            neckline_id: "3",
            rating_id: "3",
            comment: ""
        }, {
            id: "268",
            necklace_id: "22",
            neckline_id: "4",
            rating_id: "5",
            comment: ""
        }, {
            id: "269",
            necklace_id: "22",
            neckline_id: "5",
            rating_id: "4",
            comment: ""
        }, {
            id: "270",
            necklace_id: "22",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "271",
            necklace_id: "22",
            neckline_id: "7",
            rating_id: "5",
            comment: ""
        }, {
            id: "272",
            necklace_id: "22",
            neckline_id: "8",
            rating_id: "5",
            comment: ""
        }, {
            id: "273",
            necklace_id: "22",
            neckline_id: "9",
            rating_id: "5",
            comment: ""
        }, {
            id: "274",
            necklace_id: "22",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "275",
            necklace_id: "22",
            neckline_id: "11",
            rating_id: "1",
            comment: ""
        }, {
            id: "276",
            necklace_id: "22",
            neckline_id: "12",
            rating_id: "5",
            comment: ""
        }, {
            id: "277",
            necklace_id: "23",
            neckline_id: "1",
            rating_id: "3",
            comment: ""
        }, {
            id: "278",
            necklace_id: "23",
            neckline_id: "2",
            rating_id: "3",
            comment: ""
        }, {
            id: "279",
            necklace_id: "23",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "280",
            necklace_id: "23",
            neckline_id: "4",
            rating_id: "2",
            comment: ""
        }, {
            id: "281",
            necklace_id: "23",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "282",
            necklace_id: "23",
            neckline_id: "6",
            rating_id: "3",
            comment: ""
        }, {
            id: "283",
            necklace_id: "23",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "284",
            necklace_id: "23",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "285",
            necklace_id: "23",
            neckline_id: "9",
            rating_id: "1",
            comment: ""
        }, {
            id: "286",
            necklace_id: "23",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "287",
            necklace_id: "23",
            neckline_id: "11",
            rating_id: "0",
            comment: ""
        }, {
            id: "288",
            necklace_id: "23",
            neckline_id: "12",
            rating_id: "0",
            comment: ""
        }, {
            id: "297",
            necklace_id: "23",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "298",
            necklace_id: "23",
            neckline_id: "14",
            rating_id: "5",
            comment: ""
        }, {
            id: "304",
            necklace_id: "24",
            neckline_id: "1",
            rating_id: "5",
            comment: ""
        }, {
            id: "314",
            necklace_id: "24",
            neckline_id: "2",
            rating_id: "1",
            comment: ""
        }, {
            id: "310",
            necklace_id: "24",
            neckline_id: "3",
            rating_id: "5",
            comment: ""
        }, {
            id: "307",
            necklace_id: "24",
            neckline_id: "4",
            rating_id: "2",
            comment: ""
        }, {
            id: "305",
            necklace_id: "24",
            neckline_id: "5",
            rating_id: "5",
            comment: ""
        }, {
            id: "302",
            necklace_id: "24",
            neckline_id: "6",
            rating_id: "5",
            comment: ""
        }, {
            id: "306",
            necklace_id: "24",
            neckline_id: "7",
            rating_id: "3",
            comment: ""
        }, {
            id: "303",
            necklace_id: "24",
            neckline_id: "8",
            rating_id: "0",
            comment: ""
        }, {
            id: "312",
            necklace_id: "24",
            neckline_id: "9",
            rating_id: "0",
            comment: ""
        }, {
            id: "311",
            necklace_id: "24",
            neckline_id: "10",
            rating_id: "4",
            comment: ""
        }, {
            id: "308",
            necklace_id: "24",
            neckline_id: "11",
            rating_id: "0",
            comment: ""
        }, {
            id: "309",
            necklace_id: "24",
            neckline_id: "12",
            rating_id: "2",
            comment: ""
        }, {
            id: "301",
            necklace_id: "24",
            neckline_id: "13",
            rating_id: "5",
            comment: ""
        }, {
            id: "313",
            necklace_id: "24",
            neckline_id: "14",
            rating_id: "3",
            comment: ""
        } ]
    },
    getNecklace: function(index) {
        return this.data.necklaces[index];
    },
    getItem: function(collection, id) {
        for (var i = 0; i < collection.length; i++) {
            if (collection[i].id === id) {
                return collection[i];
                break;
            }
        }
    },
    getRating: function(necklace_id, neckline_id) {
        for (var i = 0; i < this.data.xref.length; i++) {
            if (this.data.xref[i].necklace_id == necklace_id && this.data.xref[i].neckline_id == neckline_id) {
                return this.data.ratings[this.data.xref[i].rating_id];
            }
        }
    },
    getRatingHtml: function(necklace_id, neckline_id) {
        var ratingObj = this.getRating(necklace_id, neckline_id);
        if (ratingObj === undefined) {
            return "<p>ERROR: Rating undefined</p>";
        }
        var html = "<p>Rating:<br>";
        if (ratingObj.rating < 1) {
            html += '<img src="img/ratings/citation.png">';
        } else {
            for (var r = 0; r < ratingObj.rating; r++) {
                html += '<img src="img/ratings/rating.png">';
            }
        }
        html += "</p>";
        html += "<p>";
        html += ratingObj.comment;
        html += "</p>";
        return html;
    },
    getWardrobe: function() {
        var wardrobe = localStorage.getItem("wardrobe");
        if (wardrobe !== null) {
            wardrobe = JSON.parse(wardrobe);
        } else {
            wardrobe = {
                necklaces: [],
                necklines: []
            };
        }
        return wardrobe;
    },
    isInWardrobe: function(id, arrayName) {
        var wardrobe = JMaven.getWardrobe();
        var items = wardrobe[arrayName];
        if (items.indexOf(id) === -1) {
            return false;
        } else {
            return true;
        }
    },
    save: function(name, obj) {
        var jsonStr = JSON.stringify(obj);
        localStorage.setItem(name, jsonStr);
    },
    buildDropdowns: function(wardrobeOnly) {
        var wardrobe;
        if (wardrobeOnly) {
            wardrobe = JMaven.getWardrobe();
        }
        var buildIt = function(dropdown, arrayName) {
            $(dropdown).html("");
            var optionStr = "<option></option>";
            $.each(JMaven.data[arrayName], function(index, item) {
                if (wardrobeOnly) {
                    if (JMaven.isInWardrobe(item.id, arrayName)) {
                        $(dropdown).append($(optionStr).attr("value", item.id).text(item.name));
                    }
                } else {
                    $(dropdown).append($(optionStr).attr("value", item.id).text(item.name));
                }
            });
        };
        buildIt("#necklace-select", "necklaces");
        buildIt("#neckline-select", "necklines");
    }
};

this["JewelryMaven"] = this["JewelryMaven"] || {};

this["JewelryMaven"]["templates"] = this["JewelryMaven"]["templates"] || {};

this["JewelryMaven"]["templates"]["necklaces"] = Handlebars.template(function(Handlebars, depth0, helpers, partials, data) {
    this.compilerInfo = [ 4, ">= 1.0.0" ];
    helpers = this.merge(helpers, Handlebars.helpers);
    data = data || {};
    var buffer = "", stack1, functionType = "function", escapeExpression = this.escapeExpression, self = this;
    function program1(depth0, data) {
        var buffer = "", stack1, helper;
        buffer += '\n<li>\n	<a href="#necklace-detail" data-id="';
        if (helper = helpers.id) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.id;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + '">\n		<img src="img/necklaces/';
        if (helper = helpers.img) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.img;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + '">\n		<h3>';
        if (helper = helpers.name) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.name;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + "</h3>\n		<p>";
        if (helper = helpers.descr) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.descr;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + "</p>\n	</a>\n</li>\n";
        return buffer;
    }
    stack1 = helpers.each.call(depth0, depth0 && depth0.necklaces, {
        hash: {},
        inverse: self.noop,
        fn: self.program(1, program1, data),
        data: data
    });
    if (stack1 || stack1 === 0) {
        buffer += stack1;
    }
    buffer += "\n";
    return buffer;
});

this["JewelryMaven"]["templates"]["necklines"] = Handlebars.template(function(Handlebars, depth0, helpers, partials, data) {
    this.compilerInfo = [ 4, ">= 1.0.0" ];
    helpers = this.merge(helpers, Handlebars.helpers);
    data = data || {};
    var buffer = "", stack1, functionType = "function", escapeExpression = this.escapeExpression, self = this;
    function program1(depth0, data) {
        var buffer = "", stack1, helper;
        buffer += '\n<li>\n	<a href="#neckline-detail" data-id="';
        if (helper = helpers.id) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.id;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + '">\n		<img src="img/necklines/';
        if (helper = helpers.img) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.img;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + '">\n		<h3>';
        if (helper = helpers.name) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.name;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + "</h3>\n		<p>";
        if (helper = helpers.descr) {
            stack1 = helper.call(depth0, {
                hash: {},
                data: data
            });
        } else {
            helper = depth0 && depth0.descr;
            stack1 = typeof helper === functionType ? helper.call(depth0, {
                hash: {},
                data: data
            }) : helper;
        }
        buffer += escapeExpression(stack1) + "</p>\n	</a>\n</li>\n";
        return buffer;
    }
    stack1 = helpers.each.call(depth0, depth0 && depth0.necklines, {
        hash: {},
        inverse: self.noop,
        fn: self.program(1, program1, data),
        data: data
    });
    if (stack1 || stack1 === 0) {
        buffer += stack1;
    }
    buffer += "\n";
    return buffer;
});

$("#combine").bind("pageinit", function() {
    $("select").change(function() {
        var necklace_id = $("select#necklace-select").val();
        var neckline_id = $("select#neckline-select").val();
        if (necklace_id != "0" && neckline_id != "0") {
            var necklace = JMaven.getItem(JMaven.data.necklaces, necklace_id);
            var img = $("#combine .mannequin img");
            img.attr("src", "img/necklaces/" + necklace.img);
            if (typeof necklace.style !== "undefined") {
                img.attr("style", necklace.style);
            } else {
                img.attr("style", "");
            }
            var neckline = JMaven.getItem(JMaven.data.necklines, neckline_id);
            var mannequin = $("#combine .mannequin");
            mannequin.attr("style", "background-image: url(img/necklines/" + neckline.img + ");");
            $(".rating").html(JMaven.getRatingHtml(necklace_id, neckline_id));
        }
    });
});

$("#combine").bind("pagebeforeshow", function() {
    if ($("#items-select").val() === "all") {
        JMaven.buildDropdowns(false);
    } else {
        JMaven.buildDropdowns(true);
    }
});

$("#items-select").change(function(event) {
    if (this.value === "all") {
        JMaven.buildDropdowns(false);
    } else {
        JMaven.buildDropdowns(true);
    }
});

$(".back-btn").click(function(e) {
    history.go(-1);
    e.preventDefault();
});

$("#wardrobe").bind("pagebeforeshow", function() {
    var wardrobe = JMaven.getWardrobe();
    var necklaces = wardrobe.necklaces;
    var necklines = wardrobe.necklines;
    var necklacesUl = $("#wardrobe-necklaces");
    var necklinesUl = $("#wardrobe-necklines");
    necklacesUl.html("");
    necklinesUl.html("");
    if (necklaces.length > 0) {
        $.each(necklaces, function(index, necklace_id) {
            var necklace = JMaven.getItem(JMaven.data.necklaces, necklace_id);
            necklacesUl.append('<li><a href="#necklace-detail" data-id="' + necklace.id + '"><img src="img/necklaces/' + necklace.img + '"><h3>' + necklace.name + "</h3><p>" + necklace.descr + "</p></a></li>");
        });
    } else {
        necklacesUl.append("<li>There are no necklaces in your wardrobe</li>");
    }
    if (necklines.length > 0) {
        $.each(necklines, function(index, neckline_id) {
            var neckline = JMaven.getItem(JMaven.data.necklines, neckline_id);
            var descr = neckline.descr;
            var length = 50;
            var breakpoint = descr.toLowerCase().indexOf("<br>");
            if (breakpoint > -1) {
                length = breakpoint;
            }
            descr = descr.substring(0, length);
            necklinesUl.append('<li><a href="#neckline-detail" data-id="' + neckline.id + '"><img src="img/necklines/' + neckline.img + '"><h3>' + neckline.name + "</h3><p>" + descr + "</p></a></li>");
        });
    } else {
        necklinesUl.append("<li>There are no necklines in your wardrobe</li>");
    }
});

$("#wardrobe").bind("pagebeforeshow", function() {
    $("#wardrobe-necklaces").listview("refresh");
    $("#wardrobe-necklines").listview("refresh");
});

(function() {
    var necklacesHtml = JewelryMaven.templates.necklaces(JMaven.data);
    $("#necklace-list").html(necklacesHtml);
    var necklinesHtml = JewelryMaven.templates.necklines(JMaven.data);
    $("#neckline-list").html(necklinesHtml);
    $(".necklace-list").on("click", "a", function(event) {
        var id = $(this).attr("data-id");
        var item = JMaven.getItem(JMaven.data.necklaces, id);
        var wardrobe = JMaven.getWardrobe();
        var addToWardrobeBtn = $("#necklace-detail .addToWardrobeBtn");
        var removeFromWardrobeBtn = $("#necklace-detail .removeFromWardrobeBtn");
        if (JMaven.isInWardrobe(id, "necklaces")) {
            addToWardrobeBtn.hide();
            removeFromWardrobeBtn.show();
        } else {
            addToWardrobeBtn.show();
            removeFromWardrobeBtn.hide();
        }
        $("input[name=wardrobeItemNum]").val(item.id);
        $("input[name=wardrobeItemType]").val("necklace");
        $(".name").html(item.name);
        $("img.necklace").attr("src", "img/necklaces/" + item.img);
        if (typeof item.descr !== "undefined") {
            $(".description").html(item.descr);
        } else {
            $(".description").html("");
        }
        if (typeof item.style != "undefined") {
            $("img.necklace").attr("style", item.style);
        } else {
            $("img.necklace").attr("style", "");
        }
    });
    $(".neckline-list").on("click", "a", function(event) {
        var id = $(this).attr("data-id");
        var item = JMaven.getItem(JMaven.data.necklines, id);
        var wardrobe = JMaven.getWardrobe();
        var addToWardrobeBtn = $("#neckline-detail .addToWardrobeBtn");
        var removeFromWardrobeBtn = $("#neckline-detail .removeFromWardrobeBtn");
        if (JMaven.isInWardrobe(id, "necklines")) {
            addToWardrobeBtn.hide();
            removeFromWardrobeBtn.show();
        } else {
            addToWardrobeBtn.show();
            removeFromWardrobeBtn.hide();
        }
        $("input[name=wardrobeItemNum]").val(item.id);
        $("input[name=wardrobeItemType]").val("neckline");
        $(".name").html(item.name);
        $("img.neckline").attr("src", "img/necklines/" + item.img);
        if (typeof item.descr !== "undefined") {
            $(".description").html(item.descr);
        } else {
            $(".description").html("");
        }
    });
    $("form[name=wardrobeForm]").submit(function(event) {
        var id = $("input[name=wardrobeItemNum]").val();
        var type = $("input[name=wardrobeItemType]").val();
        var typePlural = type + "s";
        var wardrobe = JMaven.getWardrobe();
        var items = wardrobe[typePlural];
        var addToWardrobeBtn = $("#" + type + "-detail .addToWardrobeBtn");
        var removeFromWardrobeBtn = $("#" + type + "-detail .removeFromWardrobeBtn");
        if (!JMaven.isInWardrobe(id, typePlural)) {
            items.push(id);
            addToWardrobeBtn.hide();
            removeFromWardrobeBtn.show();
        } else {
            items.splice(items.indexOf(id), 1);
            addToWardrobeBtn.show();
            removeFromWardrobeBtn.hide();
        }
        JMaven.save("wardrobe", wardrobe);
        event.preventDefault();
        return false;
    });
})();

$(document).on("mobileinit", function() {
    $.extend($.mobile, {
        defaultPageTransition: "slide"
    });
});