﻿

//Verificar si el navegador es compatible
var database;
window.indexedDB = window.indexedDB || window.msIndexedDB;
window.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
window.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;
if (!window.indexedDB) {
    console.log("no es compatible");
}

// Inicializar
function init() {

    // Abre la base de datos o crea	
    var request = window.indexedDB.open("BaseDatos", 1);

    //Si falla entra aqui
    request.onerror = function (event) {
        console.log(event);
        alert("Hubo un error al abrir la base de datos");
    };

    //Si todo es ok, entra aqui
    request.onsuccess = function (event) {
        database = request.result;
        //Aqui la funcion que carga los datos...

        ListarPuntuacion();
    };

    //onupgradeneeded se llama cuando cambia la versión db
    request.onupgradeneeded = function (event) {
        //creamos la versión nueva de las 2 tablas
        var db = event.target.result;
        var objectTabla = db.createObjectStore("puntuacion", { keyPath: "id", autoIncrement: true });


    };


}

function ListarPuntuacion() {

 if (database != null) {

        var lista = "";
		darray = [];
        var objectTabla = database.transaction("puntuacion").objectStore("puntuacion");


        objectTabla.openCursor().onsuccess = function (event) {



            var cursor = event.target.result;
            if (cursor) {

                darray.push(cursor.value);
                cursor.continue();

            }
            else {


                var p = darray.sort(function (a, b) {
                    var x = a.puntos > b.puntos ? -1 : 1;
                    return x;
                });



                var mytable = "<table cellpadding=\"5\" width=\"100%\"  cellspacing=\"0\"><tbody><tr class=col2>";
                var numRegistro = p.length;
                if (numRegistro > 20) {
                    numRegistro = 20;
                }
                for (i = 0; i < numRegistro; i++) {
				
				 var pais = p[i].pais;
				 pais = pais.replace("-","");
				 pais = pais.toLowerCase();
                    var urlimg = "img/banderas/" +pais+ ".png";
                    mytable += "<td class=rank>" + parseInt(i + 1) + "</td>";
                    mytable += "<td><img src=" + urlimg + " width=20 height=15 /></td>";
                    mytable += "<td>" + p[i].nombre + "</td>";
                    mytable += "<td>" + p[i].porcentaje + "%</td>";
                    mytable += "<td class=rank>" + p[i].puntos + "</td>";




                    if (i % 2 == 1) {
                        mytable += "</tr><tr class=col2>";
                    } else {
                        mytable += "</tr><tr class=col1>";
                    }
                }

                var tituloOffline = "<h2 class=rank>Ranking local</h2>";

                mytable += "</tr></tbody></table>";

                $("#PantallaRanking").append(tituloOffline + mytable);


            }

        };


    } else {
        alert("Error al cargar los datos offline");
    }
}

function descendingCompare(a,b) {
    if (a.puntos == b.puntos)
        return 0;
    else if (a.puntos < b.puntos)
        return 1;
    else
        return -1;
}

//window.addEventListener("DOMContentLoaded", init, false);
init();