
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define

define(function (require) {
	var $ = require('jquery');
	// Need to verify receipts? This library is included by default.
	// https://github.com/mozilla/receiptverifier
	require('receiptverifier');
	// Want to install the app locally? This library hooks up the
	// installation button. See <button class="install-btn"> in
	// index.html
	require('./install-button');

	// Write your app here.

	function Point(x, y) {
		this.x = x;
		this.y = y;
	}
	Point.prototype.add = function (anotherPoint) {
		return new Point(this.x + anotherPoint.x, this.y + anotherPoint.y);
	};
	Point.prototype.isEqualTo = function (anotherPoint) {
		return this.x === anotherPoint.x && this.y === anotherPoint.y;
	};

	function Player(tipo, char) {
		this.tipo = tipo || 'human';
		if (!char) {
			throw new Error('Char do player não informado');
		}
		this.char = char;
	}
	Player.prototype.jogar = function (linha, coluna, grid) {
		function jogarNo1roVagoDoMatch(match) {
			if (match.line !== undefined) {
				return new Point(match.line, match.content.indexOf('_'));
			}
			if (match.col !== undefined) {
				return new Point(match.content.indexOf('_'), match.col);
			}
			if (match.diagonal !== undefined) {
				if (match.diagonal == 0) {
					return new Point(match.content.indexOf('_'), match.content.indexOf('_'));
				} else if (match.diagonal == 1) {
					return new Point(match.content.indexOf('_'), (match.content.length - 1) - match.content.indexOf('_'));
				}
			}
		}
		function checkMatchEVago(num, char) {
			return (grid.check4FirstMatch(num, char, '_'));
		}
		if (this.tipo == 'human') {
			return new Point(linha, coluna);
		} else {
			//TODO HACK FEIO P/ USAR O CHAR DO RIVAL
			var charRival = this.char == 'x' ? 'o' : 'x',
				result;
			result = checkMatchEVago(2, charRival);
			if (result) return jogarNo1roVagoDoMatch(result);
			result = checkMatchEVago(2, this.char);
			if (result) return jogarNo1roVagoDoMatch(result);
			result = checkMatchEVago(1, this.char);
			if (result) return jogarNo1roVagoDoMatch(result);
			result = grid.checkSpaces();
			return result[Math.floor(Math.random() * result.length)];
		}
	};

	function Grid(dado) {
		this.data = new Array(3);
		for (var i = 0; i < this.data.length; i++) {
			this.data[i] = [dado, dado, dado];
		}
	}
	Grid.prototype.inserirDado = function (dado, local) {
		var erro;
		if (this.data[local.x][local.y].char) {
			erro = new Error('Ja foi marcado esse local');
			erro.silence = true;
			throw erro;
		}
		this.data[local.x][local.y] = dado;
	};
	Grid.prototype.checkLine = function (line) {
		var result = '';
		for (var i = 0; i < this.data[line].length; i++) {
			result += this.data[line][i].char ? this.data[line][i].char : '_';
		}
		return result;
	};
	Grid.prototype.checkCol = function (col) {
		var result = '';
		for (var i = 0; i < this.data.length; i++) {
			result += this.data[i][col].char ? this.data[i][col].char : '_';
		}
		return result;
	};
	Grid.prototype.checkDiagonal = function (diagonal) {
		var result = '';
		if (diagonal == 0) {
			for (var i = 0; i < this.data.length; i++) {
				result += this.data[i][i].char ? this.data[i][i].char : '_';
			}
		} else if (diagonal == 1){
			for (var i = 0, j = (this.data.length-1); i < this.data.length; i++, j--) {
					result += this.data[i][j].char ? this.data[i][j].char : '_';
			}
		}
		return result;
	};

	Grid.prototype.check4FirstMatch = function (number, char, char2) {
		var result,
				regex = new RegExp(char, 'g');
		for (var i = 0; i < this.data.length; i++) {
			if (char2 && !this.checkLine(i).match(new RegExp(char2, 'g'))) continue;
			result = this.checkLine(i).match(regex);
			if (result && result.length == number) {
				return {line: i, content: this.checkLine(i)};
			}
		}
		for (var i = 0; i < this.data[0].length; i++) {
			if (char2 && !this.checkCol(i).match(new RegExp(char2, 'g'))) continue;
			result = this.checkCol(i).match(regex);
			if (result && result.length == number) {
				return {col: i, content: this.checkCol(i)};
			}
		}
		for (var i = 0; i < 2; i++) {
			if (char2 && !this.checkDiagonal(i).match(new RegExp(char2, 'g'))) continue;
			result = this.checkDiagonal(i).match(regex);
			if (result && result.length == number) {
					return {diagonal: i, content: this.checkDiagonal(i)};
			}
		}
		return false;
	};
	Grid.prototype.checkSpaces = function () {
		var result = [];
		for (var x = 0; x < this.data.length; x++) {
			for (var y = 0; y < this.data.length; y++) {
				if (!this.data[x][y].char) {
					result.push(new Point(x, y));
				}			
			}
		}
		return result;
	};

	function Jogada(char) {
		if (!char) {
			this.char = char;
		} else {
			this.char = char;
			this.representacao = '<strong class="' + this.char + '">' + this.char + '</strong>';
		} 
	}
	
	function Manager() {
		this.players = new Array();
		this.grid = new Grid();
		this.chars = ['x', 'o'];
		this.historico = '';
	}
	Manager.prototype.criarPlayer = function (tipo, char) {
		var novoPlayer;
		if (this.players.length == 1) {
			//TODO nas coxas esse código de mudar o char!
			char = (this.players[0].char == this.chars[0]) ? this.chars[1] : this.chars[0];
			novoPlayer = new Player(tipo, char);
		} else if (this.players.length == 0) {
			novoPlayer = new Player(tipo, char);
		} else {
			throw new Error ('Já existem 2 jogadores');
		}
		this.players[this.players.length] = novoPlayer;		
		return novoPlayer;
	};

	Manager.prototype.criarGrid = function () {
		this.grid = new Grid(new Jogada());
	};

	Manager.prototype.criarJogada = function (player) {
		return new Jogada(player.char);
	};

	Manager.prototype.registrarJogada = function (posicao) {
		var that = this, jogador1,	jogador2,	linha, coluna, pontoJogada;
		if (this.historico.length > 0) {
			jogador1 = this.historico[this.historico.length-1] != this.players[0].char ? this.players[0] : this.players[1];
			jogador2 = this.historico[this.historico.length-1] == this.players[0].char ? this.players[0] : this.players[1];   
		} else {
			jogador1 = this.players[0];
			jogador2 = this.players[1]; 
		}
		function realizarJogada(jogador) {
			if (jogador.tipo == 'human') {
				linha = posicao[0],
				coluna = posicao[1];
				pontoJogada = jogador.jogar(linha, coluna, that.grid);
			} else {
				var pontoJogada = jogador2.jogar(null, null, that.grid);
				linha = pontoJogada.x;
				coluna = pontoJogada.y;
				posicao = '' + pontoJogada.x + pontoJogada.y;
			}
			that.grid.inserirDado(that.criarJogada(jogador), pontoJogada) ;
			that.historico += jogador.char;
			if (document.getElementById(posicao))
				document.getElementById(posicao).innerHTML = that.grid.data[linha][coluna].representacao;
		}
		try {
			if (that.verifVitoria() || that.verifEmpate()) throw new Error('Jogo finalizado');
			realizarJogada(jogador1);
			if (that.verifVitoria()) {
				alert('Vitoria do: ' + jogador1.char);
			} else if (that.verifEmpate()) {
				alert('Empate!');
			} else if (jogador2.tipo != 'human') {
				realizarJogada(jogador2);
				if (that.verifVitoria()) {
					alert('Vitoria do: ' + jogador2.char);
				} else if (that.verifEmpate()) {
					alert('Empate!');
				}
			}	
		} catch (error) {
			if (!error.silence)	alert(error.message);
		};
	};
	Manager.prototype.verifVitoria = function () {
		for (var i = 0; i < this.chars.length; i++) {
			result = this.grid.check4FirstMatch(3, this.chars[i]);
			if (result) return result;
		}
		return false;
	};
	Manager.prototype.verifEmpate = function () {
		var result = this.grid.checkSpaces().length == 0 ? true : false; 
		return result;
	};
	Manager.prototype.criarJogo = function (players) {
		var that = this;
		this.players = new Array(),
		this.historico = '';
		this.criarGrid(new Jogada());
		this.criarPlayer('human', 'x');
		if (players == 1) {
			this.criarPlayer('cpu');	
		} else {
			this.criarPlayer(null);	
		}
		for (var i = 0; i < 3; i++) {
			for (var j = 0; j < 3; j++) {//FAZENDO ZERAR CONTEÚDO VISUAL DO JOGO COM CRIAR
				document.getElementById(String(i) + String(j)).innerHTML = '&nbsp;';
				$('#' + String(i) + String(j)).off( "click" );
				$('#' + String(i) + String(j)).click(function(event) {
					that.registrarJogada(this.id);
				});
			 	/*document.getElementById(String(i) + String(j)).addEventListener('click', function(event) {
					that.registrarJogada(this.id);
				});*/
		 	}
		}
	};

	//LÓGICA DO JOGO (QUE GOSTARIA DE TER ISOLADO DO CÓDIGO DO JOGO DA VELHA EM SI)
 		var manager = new Manager();
 		document.getElementById('game').style.display = "none";
 		document.getElementById('novoJogo').addEventListener('click', function(event) {
			document.getElementById('start').style.display = "";
			document.getElementById('game').style.display = "none";
		});
		document.getElementById('1').addEventListener('click', function(event) {
			manager.criarJogo(1);
			document.getElementById('start').style.display = "none";
			document.getElementById('game').style.display = "";
		});
		document.getElementById('2').addEventListener('click', function(event) {
			manager.criarJogo(2);
			document.getElementById('start').style.display = "none";
			document.getElementById('game').style.display = "";
		});
});

