//Pasta de imagens
var IMG_PATH   = "images/";

var imgVirada          = new Image();    // O fundo do card
var imgArrIniciarParar = new Array(4);   // Botão de iniciar ou parar o jogo
var estJogo            = true;           // Estado do jogo 
var cardSelec1         = -1;             // 1º card selecionado
var cardSelec2         = -1;             // 2º card selecionado
var estCard            = false;          // Estado do card

 var IMG_INICIAR, IMG_PARAR;
 var IMG_OFFSET, IMG_MODE, imgArrCampos, numImagens, nSumImagens, IMG_HIT;
 
 function carregarImgCards(numPares, nImageMode)
 {
   numImagens = numPares;
   imgArrCampos = new Array(numImagens * 2);
   nSumImagens  = numImagens * 2 + 4 + 4 + 11;
   IMG_MODE = nImageMode;
   IMG_HIT   = 33 + numImagens * 2;
     
   if(document.images)
   {
     imgVirada.src  = IMG_PATH + "card.png";

     for(var i = 0; i < numImagens; i++)
     {
       if(IMG_MODE == 1)
       {
         imgArrCampos[i * 2] = new Image();
         imgArrCampos[i * 2].src = IMG_PATH + "pic" + (i + 1) + "a.jpg";
         imgArrCampos[i * 2 + 1] = new Image();
         imgArrCampos[i * 2 + 1].src = IMG_PATH + "pic" + (i + 1) + "b.jpg";
       }
       else
       {
         IMG_MODE = 0;
         imgArrCampos[i * 2] = new Image();
         imgArrCampos[i * 2].src = IMG_PATH + "pic" + (i + 1) + ".jpg";
         imgArrCampos[i * 2 + 1] = new Image();
         imgArrCampos[i * 2 + 1].src = IMG_PATH + "pic" + (i + 1) + ".jpg";
       }
     }
    
     nLevel = 4;
	 numAcertos = 0;
     buscarPrimImg();
     limparCampos();
	 setTimeout("checkLoading()", 1000);
     
     embaralharCards();
     limparCampos();
	 cardSelec1 = -1;
     cardSelec2 = -1; 
	 numAcertos = 0;
     estJogo = true;
     estCard = false;
   }   
 }

 function embaralharCards()
 {
   if(document.images)
   {
     var j = Math.floor(new Date().getSeconds() * Math.random() + 60);
     for(var i = 0; i < j; i++)
     {
       n1 = Math.round(Math.random() * (numImagens * 2 - 1));
       n2 = Math.round(Math.random() * (numImagens * 2 - 1));
       img = imgArrCampos[n1];
       imgArrCampos[n1] = imgArrCampos[n2];
       imgArrCampos[n2] = img;
     } 
   }
 }
 
 function startGame()
 {
   if(document.images)
   {
     if(!estJogo)
     {
       embaralharCards();
       limparCampos();
       cardSelec1 = -1;
       cardSelec2 = -1;    
       numAcertos =  0;
       estJogo = true;
       estCard = false;
     }
   }
 }
  
 function stopGame()
 {
   if(document.images)
   {
     if(estJogo)
     {
       estJogo = false;
     }
   }
   return;
 }
 
  function limparCampos()
 {
   if(document.images)
   {
     for(var i = 0; i < numImagens * 2; i++)
     {
       document.images[i + IMG_OFFSET].src = imgVirada.src;
     }
   }
 }
 
 function mostrarCard(numImagem)
 {
   if(document.images)
   {
     if(estJogo && !estCard)
     {
       if(cardSelec1 == -1 || cardSelec2 == -1)
       {
         if(document.images[numImagem + IMG_OFFSET].src == imgVirada.src)
         {
           document.images[numImagem + IMG_OFFSET].src = imgArrCampos[numImagem].src;
           if(cardSelec1 == -1)
           {
             cardSelec1 = numImagem;
           }
           else
           {
             cardSelec2 = numImagem;
           }
         }
       }
       
       if(cardSelec1 != -1 && cardSelec2 != -1)
       {
         var pic1 = document.images[cardSelec1 + IMG_OFFSET].src;
         var len1 = pic1.length;
         var pic2 = document.images[cardSelec2 + IMG_OFFSET].src;
         var len2 = pic2.length;
         if(pic1.substr(0, len1 - IMG_MODE - 4) == pic2.substr(0, len2 - IMG_MODE - 4))
         {
           numAcertos = numAcertos + 1;
           cardSelec1 = -1;
           cardSelec2 = -1;
 
           if(numAcertos == numImagens)
           {
			 document.images[cardSelec2 + IMG_OFFSET].src = imgArrCampos[numImagem].src;
             alert("Você terminou. Parabéns!");
             stopGame();
			 startGame();
           }
         }
         else
         {
           estCard = true;
           setTimeout("limparCard()", 1000);
         }
       }
     }
     else
     {
       if(!estJogo)
       {
         alert("Recarregue o jogo!");
       }
     }
   }
 }
 
  function limparCard()
 {
   document.images[cardSelec1 + IMG_OFFSET].src = imgVirada.src;
   document.images[cardSelec2 + IMG_OFFSET].src = imgVirada.src;
   cardSelec1 = -1;
   cardSelec2 = -1;
   estCard = false;
  }
 
  function buscarPrimImg()
 {
   for(var i = 0; i < document.images.length; i++)
   {
     if(document.images[i].name == "memory_id")
     {
       IMG_OFFSET = i + 1;
       break;
     }
   }
 }
 
  function limparCard()
 {
   document.images[cardSelec1 + IMG_OFFSET].src = imgVirada.src;
   document.images[cardSelec2 + IMG_OFFSET].src = imgVirada.src;
   cardSelec1 = -1;
   cardSelec2 = -1;
   estCard = false;
  }
  
   function countLoadedImages()
 {
   var nCompleted = 0;
   for(var i = 0; i < 2 * numImagens; i++)
   {
     if(imgArrCampos[i].complete)
     {
       nCompleted++;
     }
   }
   return nCompleted;
 }


function checkLoading()
{
  var nLoaded = countLoadedImages();
  if(nLoaded < nSumImagens)
  {
    document.images[IMG_OFFSET - 1].width = 456 - (456 / nSumImagens * nLoaded);
    document.images[IMG_OFFSET - 1].width = 456 - (456 / nSumImagens * nLoaded);
    window.status = "" + nLoaded + " de " + nSumImagens + " figuras carregadas.";
    setTimeout("checkLoading()", 250);
  }
  else
  {
    document.images[IMG_OFFSET - 1].src = IMG_PATH + "blank.gif"; 
    document.images[IMG_OFFSET - 1].width = 5;
    window.status = "Carregadas!";
  }
}
  