'use strict';
/*
 * Jorte Settings
 */
var jorteConfig = (function() {

    function get(key) {
        return localStorage.getItem(key);
    }

    function getInt(key, def) {
        var v = localStorage.getItem(key);
        return null !== v ? parseInt(v) : def;
    }

    function getBool(key, def) {
        var v = localStorage.getItem(key);
        return null !== v ? v === 'true' : def;
    }

    function getJSON(key, def) {
        var v = localStorage.getItem(key);
        return null !== v ? JSON.parse(v) : def;
    }

    function set(key, value) {
        return localStorage.setItem(key, value);
    }

    function setJSON(key, value) {
        return localStorage.setItem(key, JSON.stringify(value));
    }

    function remove(key) {
        return localStorage.removeItem(key);
    }

    var TIME_ZONE = null;
    try {
        var tz = jstz.determine();
        TIME_ZONE = tz.name();
        console.log("The local time zone is " + TIME_ZONE);
    } catch (e) {
        console.log('App init error ' + e.message);
    }
    return {
        TIME_ZONE: TIME_ZONE,
        SCREEN_WIDTH: $(window).width(),
        APP_ICON: 'style/icons/icon-128x128.png',
        PICKER_COLORS: ['#000000', '#d96666', '#e67399', '#b373b3', '#8C66D9', '#668CB3', '#668CD9', '#59BFB3', '#BFBF4D', '#F2A640'],
        jorteCalendar: 'jorteCalendar',
        jorteTaskList: 'jorteTaskList',
        googleCalendar: 'googleCalendar',
        googleTaskList: 'googleTaskList',
        JORTE: {
            sync_droid2web_URL: "https://jorte.net/servlet/calendar/sync/droid2web",
            current_sync_version_URL: "https://jorte.net/servlet/calendar/sync/version/current",
            sync_web2droid_URL: "https://jorte.net/servlet/calendar/sync/web2droid",
            SERVER_URL: 'https://jorte.net/',
            LOGIN_URL: 'certify/servlet/CertifyPasswordServlet',
            JORTE_MIN_VALUE: '-9223372036854775808',
            JORTE_MAX_VALUE: '9223372036854775807',
            JORTE_APPLICATION_CODE: 'jorte-droid',
            appVersion: '1.1.0'
        },
        JORTE_THEME: {title_color: ['#323232', '#ffffff', '#781E1E', '#1E1E78', '#781E1E', '#406050', '#602000']},
        COLORS: {
            completed: "#808080",
            red: "#FF0000", //For important, holiday and provider===200
            eventDefault: "#000000",
            taskDefault: "#3050C0",
            eventDefaultWhite: '#ffffff' //For black theme
        },
        /* Google Map */
        GMAP: {
            geocodeApi: "http://maps.googleapis.com/maps/api/geocode/json?address=",
            sensor: "&sensor=false",
            mapUrl: "https://www.google.co.in/maps/place/"
        },
        /* Google API */
        GAPI: {
            clientId: '227690920701-sahntaf0qsupfhg34kgvbb2cpoo96m0v.apps.googleusercontent.com',
            clientSecret: '6J7rIEcPQg11k0Hq4_CuQzmg',
            redirectUri: 'https://oauth.gaiamobile.org/authenticated'
        },
        NATIONAL_HOLIDAY: {
            API_URL: 'http://holiday.jorte.net/user/holidays/'
        },
        //First install : set default values
        init: function() {
            set('currentTheme',1);
            set('defaultReminder', 10);
            set('displayTask', true);
            set('defaultCalendar', 1);
            set('currentEventDispOrder', 0);
            set('currentEventToShow', 2);
            set('currentDispCompletedEvt', 1);
            set('numFont', -1);
            set('monthFont', -1);
            set('textFont', -1);
        },
        //App update : update default values with new value if exist
        updateInit: function() {
            set('currentTheme',this.getCurrentTheme());
            set('defaultReminder', this.getDefaultReminder());
            set('displayTask', this.getDisplayTask());
            set('defaultCalendar', this.getDefaultCalendar());
            set('currentEventDispOrder', this.getEventDispOrder());
            set('currentEventToShow', this.getEventToShow());
            set('currentDispCompletedEvt', this.getDispCompletedEvent());
            set('numFont', this.getNumberFont());
            set('monthFont', this.getMonthFont());
            set('textFont', this.getTextFont());
        },
        getNumberFont: function() {
            return getInt('numFont');
        },
        setNumberFont: function(v) {
            set('numFont', v);
        },
        getMonthFont: function() {
            return getInt('monthFont');
        },
        setMonthFont: function(v) {
            set('monthFont', v);
        },
        getTextFont: function() {
            return getInt('textFont');
        },
        setTextFont: function(v) {
            set('textFont', v);
        },
        getCurrentTheme: function() {
            return get('currentTheme');
        },
        setCurrentTheme: function(v) {
            set('currentTheme', v);
        },
        getEventDispOrder: function() {
            return getInt('currentEventDispOrder', 0);
        },
        setEventDispOrder: function(v) {
            set('currentEventDispOrder', v);
        },
        getEventToShow: function() {
            return getInt('currentEventToShow', 2);
        },
        setEventToShow: function(v) {
            set('currentEventToShow', v);
        },
        getDispCompletedEvent: function() {
            return getInt('currentDispCompletedEvt', 1);
        },
        setDispCompletedEvent: function(v) {
            set('currentDispCompletedEvt', v);
        },
        getDefaultView: function() {
            return getInt('defaultView', 1);
        },
        setDefaultView: function(v) {
            set('defaultView', v);
        },
        getDefaultCalendar: function() {
            return getInt('defaultCalendar', 1);
        },
        setDefaultCalendar: function(v) {
            set('defaultCalendar', v);
        },
        getDefaultReminder: function() {
            return get('defaultReminder', null);
        },
        setDefaultReminder: function(v) {
            set('defaultReminder', v);
        },
        getDisplayTask: function() {
            return getBool('displayTask', true);
        },
        setDisplayTask: function(v) {
            set('displayTask', v);
        },
        getHideCompletedTask: function() {
            return getBool('hideCompletedTask', false);
        },
        setHideCompletedTask: function(v) {
            set('hideCompletedTask', v);
        },
        getShowWeekNumber: function() {
            return getBool('showWeekNumber', false);
        },
        setShowWeekNumber: function(v) {
            set('showWeekNumber', v);
        },
        getJorteCalendarEnabled: function() {
            return getBool('jorteCalendarEnabled', true);
        },
        setJorteCalendarEnabled: function(v) {
            set('jorteCalendarEnabled', v);
        },
        getGoogleCalendarEnabled: function() {
            return getBool('googleCalendarEnabled', false);
        },
        setGoogleCalendarEnabled: function(v) {
            set('googleCalendarEnabled', v);
        },
        getNationalHolidaysEnabled: function() {
            return getBool('nationalHolidaysEnabled', true);
        },
        setNationalHolidaysEnabled: function(v) {
            set('nationalHolidaysEnabled', v);
        },
        //Start month view
        getMonthSettings: function() {
            return getJSON('monthSettings', {dispTaskMemo: 1, dispImpEvent: 1, reverseBar: false, fontSize: 100, iconSize: 2});
        },
        setMonthSettings: function(v) {
            setJSON('monthSettings', v);
        },
        getFirstDayOfMonth: function() {
            return getInt('firstDayOfMonth', 0);
        },
        setFirstDayOfMonth: function(v) {
            set('firstDayOfMonth', v);
        },
        //End month view

        //Start week view
        getWeekSettings: function() {
            return getJSON('weekSettings', {dispTaskMemo: 1, dispImpEvent: 1, reverseBar: false, fontSize: 100, iconSize: 2});
        },
        setWeekSettings: function(v) {
            setJSON('weekSettings', v);
        },
        getFirstDayOfWeek: function() {
            return getInt('firstDayOfWeek', 0);
        },
        setFirstDayOfWeek: function(v) {
            set('firstDayOfWeek', v);
        },
        //End week view

        getSingleTapDisplay: function() {
            return getBool('singleTapDisplay', false);
        },
        setSingleTapDisplay: function(v) {
            set('singleTapDisplay', v);
        },
        getStoredIcons: function() {
            return getJSON('storedIcons', []);
        },
        setStoredIcons: function(v) {
            setJSON('storedIcons', v);
        },
        setMapUrl: function() {
            var mapUrl = "https://www.google.co.in/maps/place/";
            return mapUrl;
        },
        getEventCalendarCID: function() {
            return get("eventCalendarCID");
        },
        setEventCalendarCID: function(v) {
            set("eventCalendarCID", v);
        },
        getEventCalendarSearchId: function() {
            return get("eventCalendarSearchId");
        },
        setEventCalendarSearchId: function(v) {
            set("eventCalendarSearchId", v);
        },
        getEventCalendarSearchKeyWord: function() {
            return get("eventCalendarSearchKeyWord");
        },
        setEventCalendarSearchKeyWord: function(v) {
            set("eventCalendarSearchKeyWord", v);
        },
        getEventCalendarSearchOrderBy: function() {
            return getInt("eventCalendarSearchOrderBy", 0);
        },
        setEventCalendarSearchOrderBy: function(v) {
            set("eventCalendarSearchOrderBy", v);
        },
        getPublicDeviceId: function() {
            return get("publicDeviceId");
        },
        setPublicDeviceId: function(v) {
            set("publicDeviceId", v);
        },
        getJorteAccount: function() {
            return getJSON('jorteAccount');
        },
        setJorteAccount: function(v) {
            setJSON('jorteAccount', v);
        },
        removeJorteAccount: function() {
            remove('jorteAccount');
        },
        getJorteSync: function() {
            return getJSON('jorteSync');
        },
        setJorteSync: function(v) {
            setJSON('jorteSync', v);
        },
        getJorteSyncVersion: function() {
            return get("SYNC_VERSION");
        },
        setJorteSyncVersion: function(v) {
            set("SYNC_VERSION", v);
        },
        getGoogleAccount: function() {
            return getJSON('googleAccount');
        },
        setGoogleAccount: function(v) {
            setJSON('googleAccount', v);
        },
        removeGoogleAccount: function() {
            remove('googleAccount');
        },
        getGoogleAccountLastSyncDate: function() {
            return get("googleAccountLastSyncDate");
        },
        setGoogleAccountLastSyncDate: function(v) {
            set("googleAccountLastSyncDate", v);
        },
        removeGoogleAccountLastSyncDate: function() {
            remove('googleAccountLastSyncDate');
        },
        getJorteCalendarAutoSync: function() {
            return getInt("jorteCalendarAutoSync");
        },
        setJorteCalendarAutoSync: function(v) {
            set("jorteCalendarAutoSync", v);
        },
        removeJorteCalendarAutoSync: function() {
            remove('jorteCalendarAutoSync');
        },
        getGoogleCalendarAutoSync: function() {
            return getInt("googleCalendarAutoSync");
        },
        setGoogleCalendarAutoSync: function(v) {
            set("googleCalendarAutoSync", v);
        },
        removeGoogleCalendarAutoSync: function() {
            remove('googleCalendarAutoSync');
        }
    };
}());
