'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.calendarSettings', [])

        // calendar controller

        .controller('calendarSettingsCtrl', ['$rootScope', '$scope', 'syncSvc', '$location', 'calendarSvc', 'evtCalendarSvc', 'dialogService',
            function($rootScope, $scope, syncSvc, $location, calendarSvc, evtCalendarSvc, dialogService) {

                $scope.evtCalList = [];
                $scope.calList = [];
                var locEvtCals = [];
                var locCals = [];
                var screenHt = $(window).height() - $('#icon_set').height() - $('#choose_cal_head').height();
                $scope.screenHt = screenHt;
                function getEvtCalendarsList(resultCB) {
                    evtCalendarSvc.getAllDeliverCalendars(function(results) {
                        locEvtCals = results;
                        resultCB(processEvtCalendars(locEvtCals));
                    });
                }

                function getNormCalendarsList(resultCB) {
                    evtCalendarSvc.getCalendarsWithEventCount(function(results) {
                        locCals = results;
                        resultCB(processCalendars(locCals));
                    });
                }
                if (!$rootScope.syncRunning) {
                    getEvtCalendarsList(function(renderList) {
                        $scope.evtCalList = renderList;
                        getNormCalendarsList(function(normRenderList) {
                            $scope.calList = normRenderList;
                            $scope.$apply();
                        });
                    });
                }
                function processCalendars(list) {
                    var renderList = [];
                    var renderItem;
                    for (var i = 0; i < list.length; i++) {
                        var row = list[i];
                        if (((row.type === 0 || row.type === 100) && jorteConfig.getJorteCalendarEnabled())
                                || (row.type === 200 && jorteConfig.getNationalHolidaysEnabled())
                                || (row.type === 300 && jorteConfig.getGoogleCalendarEnabled())) {
                            renderItem = {};

                            renderItem.itemId = row.id;
                            renderItem.name = row.name;
                            renderItem.selected = row.selected;
                            renderItem.name = row.name;
                            renderItem.type = row.type;
                            renderItem.color = row.color;

                            if (row.type === 0 || row.type === 100 || row.type === 200) {
                                renderItem.jorteHeadLabel = getMSG('JorteHead');
                                renderItem.googleHeadLabel = '';
                            } else {
                                renderItem.googleHeadLabel = getMSG('GoogleHead');
                                renderItem.jorteHeadLabel = '';
                            }
                            if (row.cnt) {
                                renderItem.eventCount = row.cnt;
                            }
                            if (row.type !== 100 && row.type !== 200) {
                                renderItem.showColor = true;
                            }
                            renderList.push(renderItem);
                        }
                    }
                    return renderList;
                }

                function processEvtCalendars(list) {
                    var renderList = [];
                    var renderItem;
                    for (var i = 0; i < list.length; i++) {
                        var renderItem = {};
                        var row = list[i];
                        renderItem.itemId = row.id;
                        renderItem.selected = row.selected;
                        renderItem.globalId = row.global_id;
                        renderItem.iconData = row.icon_data;
                        renderItem.title = row.title;
                        renderItem.provider = row.provider;
                        renderItem.type = row.type;
                        renderItem.color = row.color;
                        renderList.push(renderItem);
                        if (row.type !== 100 && row.type !== 200) {
                            renderItem.showColor = true;
                        }
                    }
                    return renderList;
                }

                $scope.swapSelection = function(calId, type) {

                    var calItem = null;
                    var list = type === 0 ? locEvtCals : locCals;

                    for (var i = 0; i < list.length; i++) {
                        if (calId === list[i].id) {
                            calItem = list[i];
                            break;
                        }
                    }
                    if (!calItem) {
                        return;
                    }
                    if (type === 0) {
                        evtCalendarSvc.updateDeliverCalendarSelectionFlag(calId, function() {
                            if (calItem.selected) {
                                calItem.selected = 0;
                            } else {
                                calItem.selected = 1;
                            }
                            $scope.evtCalList = processEvtCalendars(list);
                            $scope.$apply();
                        });
                    } else {
                        calendarSvc.updateCalendarSelectionFlag(calId, function() {
                            if (calItem.selected) {
                                calItem.selected = 0;
                            } else {
                                calItem.selected = 1;
                            }
                            $scope.calList = processCalendars(list);
                            $scope.$apply();
                        });
                    }
                };

                $scope.onColorClick = function(calId, type) {
                    var curItem = {};
                    var list = type === 0 ? locEvtCals : locCals;
                    for (var i = 0; i < list.length; i++) {
                        if (list[i].id === calId) {
                            curItem = list[i];
                            break;
                        }
                    }
                    var colorModel = {
                        colorCode: curItem.color ? curItem.color : '',
                        selectedColor: function(color) {
                            if (type === 0) {
                                evtCalendarSvc.updateDeliverCalendarColor(calId, color, function() {
                                    curItem.color = color;
                                    $scope.evtCalList = processEvtCalendars(list);
                                    $scope.$apply();
                                });
                            } else {
                                calendarSvc.updateCalendarColor(calId, color, function() {
                                    curItem.color = color;
                                    $scope.calList = processCalendars(list);
                                    $scope.$apply();
                                });
                            }
                        }
                    };
                    dialogService.open('colorPickerPopup', 'colorPicker', colorModel, {title: getMSG('SelectColorHead')});
                };

                $scope.addCalClick = function() {
                    dialogService.open('addCalPopup', 'addCalPopup', null, {title: getMSG('AddCalendarHead')});
                };

                $scope.$on('eventCalendarDeleted', function(evt, item) {
                    for (var i = 0; i < locEvtCals.length; i++) {
                        if (locEvtCals[i].id === item.itemId) {
                            locEvtCals.splice(i, 1);
                            break;
                        }
                    }
                    getEvtCalendarsList(function(renderList) {
                        $scope.evtCalList = renderList;
                        $scope.$apply();
                    });
                });

                $scope.$on('refreshCalendarList', function() {
                    getNormCalendarsList(function(normRenderList) {
                        $scope.calList = normRenderList;
                        $scope.$apply();
                    });
                });

                $scope.onEvtCalItemClick = function(calId) {
                    var modelData = {
                        calendarId: calId
                    };
                    dialogService.open("evtCalDetailPopup", "evtCalDetailPopup", modelData, {title: getMSG('ChooseEventCalandarHead')});

                };

                $scope.onCalItemClick = function(calId) {
                    var modelData = {
                        calendarId: calId
                    };
                    dialogService.open("calDetailPopup", "calDetailPopup", modelData, {title: getMSG('CalendarInformationHead')});
                };

                $scope.onEventCalendarClick = function() {
                    $location.path('/eventCalendar');
                };

                $scope.syncAllTypesOfCalendars = function() {
                    if (!jorteConfig.getJorteAccount() && !jorteConfig.getGoogleAccount()) {
                        $location.path('/settings/calendarSync/');
                        return;
                    }
                    syncSvc.sync({jorteCalendar: true}, function () {
                        syncSvc.sync({jorteTaskList: true}, function () {
                            syncSvc.sync({googleCalendar: true}, function () {
                                syncSvc.sync({googleTaskList: true}, function () {
                                    $rootScope.$broadcast('syncCompleted', null);
                                });
                            });
                        });
                    });
                };
            }])
        .controller('evtCalDetailPopupCtrl', ['$rootScope', '$scope', 'evtCalendarSvc', 'dialogService', 'calendarApiSvc',
            function($rootScope, $scope, evtCalendarSvc, dialogService, calendarApiSvc) {
                var calId = $scope.model.calendarId;

                $scope.renderItem = {};
                evtCalendarSvc.getDeliverCalendar(calId, function(deliverCalendar) {

                    var renderItem = {};
                    renderItem.calendarId = deliverCalendar.id;
                    renderItem.globalId = deliverCalendar.global_id;
                    renderItem.chooseEvtCalHeadLabel = getMSG('ChooseEventCalandarHead');
                    renderItem.deleteHeadLabel = getMSG('DeleteHead');
                    renderItem.closeHeadLabel = getMSG('CloseHead');
                    renderItem.iconData = deliverCalendar.icon_data;
                    renderItem.title = deliverCalendar.title;
                    renderItem.cid = deliverCalendar.cid;
                    renderItem.providedByLabel = getMSG('Provided_by');
                    renderItem.provider = deliverCalendar.provider;
                    renderItem.totalUser = deliverCalendar.total_user;
                    renderItem.lastUpdateFmtd = jorteUtils.formatDate(new Date(jorteUtils.parseDateString(deliverCalendar.last_update)), getMSG('LongDateFormat2'), cal_string);

                    if (deliverCalendar.content) {
                        renderItem.detailedInfoHeadLabel = getMSG('DetailedInformationHead');
                        renderItem.content = deliverCalendar.content;
                    }
                    if (deliverCalendar.image_url) {
                        renderItem.imageUrl = deliverCalendar.image_url;
                    }
                    if (deliverCalendar.updated_info) {
                        renderItem.updatedInfo = deliverCalendar.updated_info;
                        renderItem.updateInfoHeadLabel = getMSG('UpdateInformationHead');
                    }
                    if (deliverCalendar.about) {
                        renderItem.about = deliverCalendar.about;
                        renderItem.aboutHeadLabel = getMSG('AboutHead');
                    }
                    renderItem.urls = [];
                    if (deliverCalendar.url) {
                        var urls = JSON.parse(deliverCalendar.url);
                        var urlStrings = JSON.parse(deliverCalendar.url_string);
                        if (urls && urlStrings) {
                            for (var ui = 0; ui < Math.min(urls.length, urlStrings.length); ui++) {
                                var url = urls[ui];
                                var urlString = urlStrings[ui];
                                if (url) {
                                    renderItem.urls.push({'index': ui, 'url': url, 'text': urlString ? urlString : url});
                                }
                            }
                        }
                    }
                    if (deliverCalendar.addon_info) {
                        var addOnInfos = JSON.parse(deliverCalendar.addon_info);
                        if (addOnInfos) {
                            renderItem.addOnInfos = [];
                            for (var ai = 0; ai < addOnInfos.length; ai++) {
                                var anInfo = {};
                                var addOnInfo = addOnInfos[ai];
                                anInfo.title = addOnInfo.title;
                                anInfo.content = addOnInfo.content;
                                anInfo.imageUrl = addOnInfo.imageUrl;
                                if (!anInfo.title) {
                                    anInfo.title = anInfo.content;
                                    anInfo.content = '';
                                }
                                renderItem.addOnInfos.push(anInfo);
                            }
                        }
                    }
                    $scope.renderItem = renderItem;
                    $scope.$apply();
                });
                $scope.onCloseClick = function() {
                    dialogService.close("evtCalDetailPopup");
                };
                var opInProgress = false;
                $scope.onDeleteClick = function() {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        return;
                    }
                    if (opInProgress) {
                        return;
                    }
                    opInProgress = true;
                    var confirmMessage = getMSG('ECDeleteConfirmHead', {calName: $scope.renderItem.title});
                    var r = confirm(confirmMessage);
                    if (r) {
                        evtCalendarSvc.deleteDeliverCalendarByGlobalId($scope.renderItem.globalId, function() {
                            try {
                                $rootScope.$broadcast('eventCalendarDeleted', $scope.renderItem);
                            } catch (e) {
                                console.log('error ', e);
                            }
                            if (!jorteConfig.getPublicDeviceId()) {
                                calendarApiSvc.start(function(success) {
                                    if (success) {
                                        unSubscribe();
                                    }
                                });
                            } else {
                                unSubscribe();
                            }
                            function unSubscribe() {
                                calendarApiSvc.subscribe($scope.renderItem.globalId, 0, function() {
                                    dialogService.close("evtCalDetailPopup");
                                });
                            }
                        });
                    } else {
                        opInProgress = false;
                    }
                };
                $scope.openUrl = function(url) {
                    window.open(url);
                };

            }])

        .controller('calDetailPopupCtrl', ['$rootScope', '$scope', 'calendarSvc', 'dialogService',
            function($rootScope, $scope, calendarSvc, dialogService) {
                var calId = $scope.model.calendarId;
                $scope.renderItem = {};
                $scope.calDetailFeching = false;
                $scope.onCloseClick = function() {
                    $scope.calDetailFeching = false;
                    dialogService.close("calDetailPopup");
                };

                function eventFetchPagination(cal, totalCount, resultCB) {
                    var calendar = {};
                    $.extend(calendar, cal);
                    calendar.eventInstances = [];
                    $scope.calDetailFeching = true;
                    function pagination(is_advance, eventCount, callBack) {
                        calendarSvc.getCalendarWithEventInstances(cal, is_advance, eventCount, function (result) {
                            if (result && result.length > 0) {
                                if (calendar.eventInstances && calendar.eventInstances.length > 0) {
                                    for (var j = 0; j < result.length; j++) {
                                        var is_exist = false;
                                        for (var k = 0; k < calendar.eventInstances.length; k++) {
                                            if (result[j].id === calendar.eventInstances[k].id) {
                                                is_exist = true;
                                                break;
                                            }
                                        }
                                        if (!is_exist) {
                                            calendar.eventInstances.push(result[j]);
                                        }
                                    }
                                } else {
                                    calendar.eventInstances = result;
                                }
                                eventCount += result.length;
                            }
                            callBack && callBack(eventCount);
                        });
                    }

                    function fetchAllEventListData(eventCount, is_advance) {
                        var event_count = totalCount;
                        if ($scope.calDetailFeching) {
                            setTimeout(function () {
                                pagination(is_advance, eventCount, function (count) {
                                    if (count < event_count) {
                                        eventCount = count;
                                        resultCB && resultCB(calendar);
                                        fetchAllEventListData(eventCount, true);
                                    } else {

                                        for (var i = 0; i < calendar.eventInstances.length; i++) {
                                            for (var j = 0; j < calendar.eventInstances.length - 1 - i; j++) {
                                                if (calendar.eventInstances[j].begin < calendar.eventInstances[j + 1].begin) {
                                                    var temp = calendar.eventInstances[j];
                                                    calendar.eventInstances[j] = calendar.eventInstances[j + 1];
                                                    calendar.eventInstances[j + 1 ] = temp;
                                                }
                                            }
                                        }
                                        resultCB && resultCB(calendar);
                                    }
                                });
                            }, 10);
                        }
                    }
                    fetchAllEventListData(0, false);
                }

                var navigItem = null;
                function displayData(completeCB) {
                    calendarSvc.getSingleCalendar(calId, function (cal) {
                        if (cal) {
                            calendarSvc.getEventsCount(calId, function (count) {
                                cal.cnt = count;
                                eventFetchPagination(cal, count, function (calendar) {
                                    var renderItem = {};
                                    if (calendar) {
                                        renderItem.totalHeadLabel = getMSG('TotalHead');
                                        renderItem.eventCount = calendar.cnt;
                                        renderItem.calendarName = calendar.name;
                                        renderItem.typeHeadLabel = getMSG('TypeHead');
                                        renderItem.closeHeadLabel = getMSG('CloseHead');

                                        renderItem.type = calendar.type;
                                        if (calendar.type === 0 || calendar.type === 100 || calendar.type === 200) {
                                            renderItem.jorteCalHeadLabel = getMSG('JorteCalendarHead');
                                            renderItem.classifHeadLabel = getMSG('ClassificationHead');

                                            renderItem.isPublick = calendar.is_public;
                                            if (calendar.is_public) {
                                                renderItem.publicHeadLabel = getMSG('PublicHead');
                                            } else {
                                                renderItem.privatHeadLabel = getMSG('PrivateHead');
                                            }
                                            renderItem.memoHeadLabel = getMSG('MemoHead');

                                            if (calendar.description) {
                                                renderItem.description = calendar.description;
                                            }

                                        } else {
                                            renderItem.googleCalHeadLabel = getMSG('GoogleCalendarHead');
                                        }

                                        renderItem.syncHeadLabel = getMSG('SyncHead');

                                        if (calendar.sync_events) {
                                            renderItem.syncLabel = getMSG('SyncronizedHead');
                                        } else {
                                            renderItem.notSyncLabel = getMSG('NotSynchronizedHead');
                                        }

                                        if (calendar.category) {
                                            renderItem.categoryHeadLabel = getMSG('CategoryHead');
                                            renderItem.category = calendar.category;
                                        }

                                        if (calendar.country) {
                                            renderItem.countryHeadLabel = getMSG('CountryHead');
                                            renderItem.country = calendar.country;
                                        }

                                        if (calendar.language) {
                                            renderItem.language = calendar.language;
                                            renderItem.languageHeadLabel = getMSG('LanguageHead');
                                        }

                                        if (calendar.timezone) {
                                            renderItem.timezonHeadLabel = getMSG('TimeZoneHead');
                                            renderItem.timezone = calendar.timezone;
                                        }
                                        renderItem.instances = [];

                                        for (var i = 0; i < calendar.eventInstances.length; i++) {
                                            var row = calendar.eventInstances[i];
                                            var holiday = row.holiday || row.type === 100 || row.type === 200;
                                            var cDate = new Date(row.begin);
                                            var eDate = new Date(row.end);
                                            var sDate = jorteUtils.formatDate(cDate, getMSG('LongDateFormat2'), cal_string);
                                            var sTime = (row.start_time !== null) ? jorteUtils.formatDate(cDate, getMSG('ShortDateFormat3'), cal_string) : '';
                                            var eTime = (row.end_time !== null) ? jorteUtils.formatDate(eDate, getMSG('ShortDateFormat3'), cal_string) : '';
                                            if (row.day_time === 7) {
                                                var d = new Date(row.end);
                                                d.setMinutes(d.getMinutes() + 1);
                                                eTime = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                            } else if (row.day_time === 8) {
                                                var d = new Date(row.end);
                                                eTime = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                            }
                                            eTime = (eTime !== '' && eTime !== sTime) ? eTime : '';
                                            var day = jorteUtils.formatDate(cDate, 'ddd');

                                            var inst = {};
                                            inst.start_date = row.start_date;
                                            inst.itemId = row.id;
                                            inst.itemType = 0;
                                            inst.itemDate = new Date(row.begin);
                                            inst.day = day;
                                            inst.holiday = holiday;
                                            inst.sDate = sDate;
                                            inst.sTime = sTime;
                                            inst.eTime = eTime;
                                            inst.textColor = jorteUtils.getColor(row);
                                            inst.icon = row.icon;
                                            inst.name = row.name;
                                            inst.index = i;
                                            inst.is_public = calendar.is_public;
                                            inst.is_share = calendar.is_share;
                                            if (row.details) {
                                                inst.details = row.details;
                                            }
                                            renderItem.instances.push(inst);
                                        }
                                        $scope.renderItem = renderItem;
                                        $scope.$apply();
                                        completeCB && completeCB();
                                    }
                                });
                            });
                        }
                    });

                }
                displayData();
                $scope.onEvtItemClick = function(index) {
                    var evtItem = $scope.renderItem.instances[index];
                    var navigItems = [];
                    navigItems.push(evtItem);
                    navigItem = evtItem;
                    var dateObj = new Date(evtItem.itemDate);
                    var date_caption = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                    var modelData = {itemIndex: 0, renderList: navigItems, 'dateObj': dateObj};

                    dialogService.open("eventTaskDetailPopup", "eventTaskDetailPopup", modelData, {title: date_caption, minHeight: 360, headerVisible: false});
                };

                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    $rootScope.$broadcast("refreshCalendarList");
                    displayData(function() {
                        try {
                            var navigList = [];
                            $rootScope.$broadcast('navigItemsListChanged', navigList);
                        } catch (e) {
                            console.log('broadcast navigItemsListChanged ', e);
                        }
                    });
                });
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    $rootScope.$broadcast("refreshCalendarList");
                    displayData(function() {
                        try {
                            var navigList = [];
                            $rootScope.$broadcast('navigItemsListChanged', navigList);
                        } catch (e) {
                            console.log('broadcast navigItemsListChanged ', e);
                        }
                    });
                });
                
                $scope.$on('eventTaskItemCompleted', function() {
                    displayData();
                });

                $scope.$on('eventUpdated', function (evt, data) {
                    displayData(function () {
                        try {
                            var evtItem = null;
                            var eventId = null;
                            eventId = data.make_completed ? (data.dataObj && data.parent ? data.parent : data.event_id) : data.event_id;
                            for (var i = 0; i < $scope.renderItem.instances.length; i++) {
                                if ($scope.renderItem.instances[i].itemId === eventId) {
                                    evtItem = $scope.renderItem.instances[i];
                                }
                            }
                            var navigList = [];
                            if (evtItem) {
                                navigList.push(evtItem);
                                $rootScope.$broadcast('navigItemsListChanged', navigList);
                            }
                        } catch (e) {
                            console.log('broadcast navigItemsListChanged ', e);
                        }
                    });
                });
            }])
        .controller('addCalPopupCtrl', ['$rootScope', '$scope', 'dialogService',
            function($rootScope, $scope, dialogService) {

                $scope.googleCalActivate = false;
                $scope.jorteCalEnabled = false;
                $scope.googleCalEnabled = false;
                $scope.holidayEnabled = false;
                var user = jorteConfig.getGoogleAccount();
                if (user) {
                    $scope.googleCalActivate = true;
                } else {
                    $scope.googleCalActivate = false;
                }

                if (jorteConfig.getJorteCalendarEnabled()) {
                    $scope.jorteCalEnabled = true;
                }
                if (jorteConfig.getNationalHolidaysEnabled()) {
                    $scope.holidayCalEnabled = true;
                }
                if (jorteConfig.getGoogleCalendarEnabled()) {
                    $scope.googleCalEnabled = true;
                }

                $scope.onCloseClick = function() {
                    if ($scope.jorteCalEnabled) {
                        jorteConfig.setJorteCalendarEnabled(true);
                    } else {
                        jorteConfig.setJorteCalendarEnabled(false);
                    }
                    if ($scope.googleCalEnabled) {
                        jorteConfig.setGoogleCalendarEnabled(true);
                    } else {
                        jorteConfig.setGoogleCalendarEnabled(false);
                    }
                    if ($scope.holidayCalEnabled) {
                        jorteConfig.setNationalHolidaysEnabled(true);
                    } else {
                        jorteConfig.setNationalHolidaysEnabled(false);
                    }
                    try {
                        $rootScope.$broadcast("refreshCalendarList");
                    } catch (e) {
                        console.log('error ', e);
                    }
                    dialogService.close('addCalPopup');
                };

            }]);
