'use strict';

/**
 * Jorte date picker controller
 * 
 */
angular.module('controllers.datePicker', [])

        // date picker controller
        .controller('datePickerCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.currentLang = getMSG('CurrentActiveLanguage');
                var dateObj = $scope.model.currDate;
                var setCallback = $scope.model.onSet;

                setdatePopup(dateObj);

                function setdatePopup(date) {
                    if (!date || typeof date !== 'object') {
                        date = new Date();
                    }
                    $scope.day = date.getDate();
                    $scope.month = cal_string.monthNamesShort[date.getMonth()];
                    $scope.year = date.getFullYear();
                    dateObj = date;
                }

                function changeDate(mode, incr) {
                    var d = $scope.day;
                    var m = $.inArray($scope.month, cal_string.monthNamesShort);
                    var y = $scope.year;
                    var date = new Date(y, m, d);
                    var new_date;
                    switch (mode) {
                        case 1:
                            new_date = jorteUtils.addDays(date, incr);
                            break;
                        case 2:
                            new_date = jorteUtils.addMonths(date, incr);
                            break;
                        case 3:
                            new_date = jorteUtils.addYears(date, incr);
                            break;
                    }
                    setdatePopup(new_date);
                }
                $scope.dayAdd = function(incr) {
                    changeDate(1, incr);
                };

                $scope.monthAdd = function(incr) {
                    changeDate(2, incr);
                };

                $scope.yearAdd = function(incr) {
                    changeDate(3, incr);
                };
                $scope.setDate = function() {
                    setCallback(dateObj);
                };
                $scope.hideDate = function() {
                    dialogService.close("dateSelectPopup");
                };
                $scope.clearDate = function() {
                    setCallback(null);
                };
            }]);
