'use strict';

/**
 * Jorte time picker controller
 * 
 */
angular.module('controllers.timePicker', [])

        // time picker controller
        .controller('timePickerCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {

                var time = $scope.model.currTime;
                var setCallback = $scope.model.onSet;

                $scope.onSetClick = function() {
                    time = '';
                    time += $scope.vals[0];
                    time += $scope.vals[1];
                    time += ':';
                    time += $scope.vals[2];
                    time += $scope.vals[3];
                    setCallback(time);
                };
                $scope.onClearClick = function() {
                    setCallback('--:--');
                };

                $scope.onBackClick = function() {
                    dialogService.close("timeSelectPopup");
                };

                $scope.index = 0;
                $scope.vals = ["-", "-", "-", "-"];
                if (time) {
                    var parts = time.split('');
                    $scope.vals = parts;
                }
                function fillZeros() {
                    for (var i in $scope.vals) {
                        $scope.vals[i] = $scope.vals[i] === "-" ? "0" : $scope.vals[i];
                    }
                }
                function validateValue(val) {
                    switch ($scope.index) {
                        case 0:
                            return !(val > 2);
                        case 1:
                            return !($scope.vals[0] === '2' && val > 3);
                        case 2:
                            return !(val > 5);
                        case 3:
                            return true;
                        default:
                            return true;
                    }
                }
                $scope.onNumClick = function(num) {
                    if (num === 'b') {
                        $scope.index = $scope.index <= 0 ? 3 : $scope.index - 1;
                    } else if (num === 'now') {
                        var time = jorteUtils.formatDate(new Date(), 'HH:mm');
                        var t = time.toString().replace(':', '');
                        var parts = t.split('');
                        $scope.vals = parts;
                        $scope.index = 0;
                    } else {
                        if (validateValue(parseInt(num))) {
                            fillZeros();
                            $scope.vals[$scope.index] = num + '';
                            if (($scope.vals[0] > 1) && ($scope.vals[1] > 3)) {
                                $scope.vals[1] = '0';
                            }
                            if (($scope.vals[0] === '-') && ($scope.vals[1] >= 0)) {
                                $scope.vals[0] = '0';
                            }
                            if (($scope.vals[2] === '-') && ($scope.vals[3] >= 0)) {
                                $scope.vals[2] = '0';
                            }
                            $scope.index = $scope.index >= 3 ? 0 : $scope.index + 1;
                        }

                    }
                };

                $scope.onBoxClick = function(num) {
                    $scope.index = num;
                };

            }]);
