'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.customize', [])
        .controller('customizeCtrl', ['$rootScope', '$scope', 'dialogService', 'fontSvc', 'themeSvc',
            function($rootScope, $scope, dialogService, fontSvc, themeSvc) {
                // $scope.model contains the object passed to open in config.model
                var locThemes = [];
                var themeId = jorteConfig.getCurrentTheme();
                $scope.themeList = [];
                function initThemeList() {
                    themeSvc.getAllThemes(function(list) {
                        locThemes = list;
                        if (!themeId) {
                            themeId = locThemes[0].id + '';
                        }
                        $scope.themeList = processThemes(list);                        
                        var themeHt = $('.cutomize_div').height() - ($('#cal_title_bg').height() + 16) - ($('#cust_close_header').height() + 8) - ($('.cust_color_btn').height() + 2) - 69;
                        $scope.themeHt = themeHt;
                        $scope.$apply();

                    });
                }

                initThemeList();
                initFontsTag();

                function processThemes(list) {
                    var renderList = [];
                    var thNames = ["JorteWhiteHead", "BlackHead", "PeachOrangeHead", "OceanBlueHead",
                        "StrawberryMilkHead", "LimeGreenHead", "LemonChoffonHead"];

                    for (var i = 0; i < list.length; i++) {
                        var renderItem = {};
                        var theme = list[i];
                        if (theme.is_static === 1) {
                            theme.name = getMSG(thNames[theme.id - 1]);
                            theme.details = theme.name;
                        }
                        renderItem.name = theme.name;
                        renderItem.details = theme.details;
                        renderItem.parent = theme.parent;
                        renderItem.author = theme.author;
                        renderItem.itemId = theme.id;
                        renderItem.color = theme.color;
                        renderItem.path = theme.path;
                        renderItem.isStatic = theme.is_static;
                        if (theme.id + '' === themeId) {
                            renderItem.selected = true;
                        } else {
                            renderItem.selected = false;
                        }
                        renderItem.index = i;
                        renderItem.themeContent = theme.theme_content;
                        renderList.push(renderItem);
                    }
                    return renderList;
                }

                function initFontsTag() {
                    fontSvc.getAllFontValues(function(result) {
                        var styleContent = '';
                        processFont(0, result);
                        function processFont(i, result) {
                            if (i >= result.length) {
                                insertStyleContent(styleContent);
                                return;
                            }

                            var fontFamily = result[i].font_family;
                            if (!/style/i.test(result[i].path)) {
                                var sdcard = navigator.getDeviceStorage('sdcard');
                                var request = sdcard.get(result[i].path);
                                request.onsuccess = function() {
                                    var file = this.result;
                                    var fontURL = window.URL.createObjectURL(file);
                                    styleContent += "@font-face {font-family: '" + fontFamily + "'; src: url('" + fontURL + "');}";
                                    processFont(++i, result);
                                };
                                request.onerror = function() {
                                    console.warn("Unable to get the file: " + this.error);
                                    processFont(++i, result);
                                };
                            } else {
                                styleContent += "@font-face {font-family: '" + fontFamily + "'; src: url('" + result[i].path + "');}";
                                processFont(++i, result);
                            }
                        }

                        function insertStyleContent(styleContent) {
                            var newStyle = document.createElement('style');
                            newStyle.appendChild(document.createTextNode(styleContent));
                            document.head.appendChild(newStyle);

                            /** Set selected fonts to classes*/

                            for (var j = 0; j < result.length; j++) {
                                if (result[j].is_selected === 1) {
                                    var setFontNew = "html,body,div,span,h1,h2,h3,h4,h5,h6,p,em,img,i,dl,dt,dd,ol,ul,li,form,label,table,tbody,tfoot,thead,tr,th,td,article,footer,header,hgroup,menu,nav,section,input,.rpt_list_box{font-family:" + result[j].font_family + ";}";
                                    $rootScope.newFont = setFontNew;

                                }
                            }
                            var customFont = jorteConfig.getNumberFont() >= 0 ? result[jorteConfig.getNumberFont()].font_family : "sans-serif";
                            var fontSet = ".fc-day-number{font-family:" + customFont + ";}";
                            $rootScope.numFont = fontSet;

                            // Set the font with previous text selected font
                            var textFont = jorteConfig.getTextFont() >= 0 ? result[jorteConfig.getTextFont()].font_family : "sans-serif";
                            var fontSetText = "html,body,div,span,h1,h2,h3,h4,h5,h6,p,em,img,i,dl,dt,dd,ol,ul,li,form,label,table,tbody,tfoot,thead,tr,th,td,article,footer,header,hgroup,menu,nav,section,input,.rpt_list_box{font-family:" + textFont + ";}";
                            $rootScope.textFont = fontSetText;

                            // Set the font with previous month selected font
                            var monthFont = jorteConfig.getMonthFont() >= 0 ? result[jorteConfig.getMonthFont()].font_family : "sans-serif";
                            var fontSetMonth = ".fc-header-title,.fc-header-title * {font-family:" + monthFont + ";}";
                            $rootScope.monthFont = fontSetMonth;
                            $rootScope.$apply();
                        }
                    });
                    var fontHt = $('.cutomize_div').height() - ($('#cal_title_bg').height() + 16) - ($('#cust_close_header').height() + 8) - 28;
                    $scope.fontHt = fontHt;
                }

                $scope.onThemeCheck = function(index) {
                    if ($scope.themeList[index].selected) {
                        return;
                    }
                    for (var i = 0; i < $scope.themeList.length; i++) {
                        $scope.themeList[i].selected = false;
                    }
                    $scope.themeList[index].selected = true;
                    activateTheme($scope.themeList[index]);
                };

                function activateTheme(aTheme) {
                    if (themeId !== aTheme.itemId + '') {
                        jorteConfig.setCurrentTheme(aTheme.itemId);
                        themeId = aTheme.itemId + '';
                        $rootScope.themeStyle = aTheme.themeContent;
                        $rootScope.$broadcast('themeChanged', themeId);
                    }
                }

                $scope.onCustColorClick = function() {
                    var curTheme = null;
                    for (var i = 0; i < $scope.themeList.length; i++) {
                        if ($scope.themeList[i].selected) {
                            curTheme = $scope.themeList[i];
                            break;
                        }
                    }
                    if (!curTheme) {
                        return;
                    }
                    var modelData = {
                        currentTheme: curTheme,
                        onDeleteCb: function() {
                            themeId = null;
                            initThemeList();
                            activateTheme($scope.themeList[0]);
                        }
                    };
                    dialogService.open("themeEditPopup", "themeEditPopup", modelData, {title: curTheme.name});
                };

                $scope.settingsParam = {
                    showFont: false,
                    showColor: false
                };

                $scope.$watch('params.customize', function(newVal, oldVal) {
                    $scope.settingsParam.showColor = newVal;
                    if (!newVal) {
                        $scope.settingsParam.showFont = newVal;
                    }
                });

                $scope.showColor = function() {
                    $scope.settingsParam.showFont = false;
                    $scope.settingsParam.showColor = true;
                };

                $scope.showFont = function() {
                    $scope.settingsParam.showFont = true;
                    $scope.settingsParam.showColor = false;
                };

                $scope.closePopUp = function() {
                    $("#bottom").css('overflow-y', 'auto');
                    $scope.settingsParam.showFont = false;
                    $scope.$parent.params.customize = false;
                    $scope.settingsParam.showColor = false;
                };

                $scope.selectFont = function(usageType, titileMsg) {
                    var usageFontModel = usageType;
                    var fontModel = {
                        fontUsage: usageFontModel,
                        nFontUsageCb: function(fontType, intex) {
                            if (intex === 1) {
                                var setFontNew = "html,body,div,span,h1,h2,h3,h4,h5,h6,p,em,img,i,dl,dt,dd,ol,ul,li,form,label,table,tbody,tfoot,thead,tr,th,td,article,footer,header,hgroup,menu,nav,section,input,.rpt_list_box{font-family:" + fontType + ";}";
                                $rootScope.newFont = setFontNew;

                                var fontSetNum = ".fc-day-number{font-family:" + fontType + ";}";
                                $rootScope.numFont = fontSetNum;

                                var fontSetMonth = ".fc-header-title, .fc-header-title * {font-family:" + fontType + ";}";
                                $rootScope.monthFont = fontSetMonth;

                                var fontSetText = "html,body,div,span,h1,h2,h3,h4,h5,h6,p,em,img,i,dl,dt,dd,ol,ul,li,form,label,table,tbody,tfoot,thead,tr,th,td,article,footer,header,hgroup,menu,nav,section,input,.rpt_list_box{font-family:" + fontType + ";}";
                                $rootScope.textFont = fontSetText;

                            }
                            else if (intex === 2) {
                                var fontSetNum = ".fc-day-number{font-family:" + fontType + ";}";
                                $rootScope.numFont = fontSetNum;

                            } else if (intex === 3) {
                                var fontSetText = "html,body,div,span,h1,h2,h3,h4,h5,h6,p,em,img,i,dl,dt,dd,ol,ul,li,form,label,table,tbody,tfoot,thead,tr,th,td,article,footer,header,hgroup,menu,nav,section,input,.rpt_list_box{font-family:" + fontType + ";}";
                                $rootScope.textFont = fontSetText;
                            }
                            else if (intex === 4) {
                                var fontSetMonth = ".fc-header-title, .fc-header-title * {font-family:" + fontType + ";}";
                                $rootScope.monthFont = fontSetMonth;
                            }
                        }
                    };
                    dialogService.open("fontListPopup", "fontList", fontModel, {title: getMSG(titileMsg), minHeight: 220});
                    setTimeout(function() {
                        dialogService.refresh('fontListPopup');
                    },500);
                };
                               
                $scope.revertFont = function() {
                    fontSvc.deSelectAllFonts(function() {
                        $rootScope.newFont = "";
                        $rootScope.numFont = "";
                        $rootScope.monthFont = "";
                        $rootScope.textFont = "";
                        jorteConfig.setNumberFont(-1);
                        jorteConfig.setTextFont(-1);
                        jorteConfig.setMonthFont(-1);
                        $rootScope.$apply();
                    });
                };

                $scope.onDownloadFontClick = function() {
                    dialogService.open("fontDownloadPopup", "fontDownloadPopup", null, {title: getMSG('DownloadFonts')});
                };
            }
        ])
        .controller('fontListCtrl', ['$scope', 'dialogService', 'fontSvc',
            function($scope, dialogService, fontSvc) {
                var fontUsageType = $scope.model.fontUsage;
                var list = [];

                $scope.params = {
                    fontUsageType: fontUsageType,
                    numFont: jorteConfig.getNumberFont(),
                    monthFount: jorteConfig.getMonthFont(),
                    textFont: jorteConfig.getTextFont(),
                    currentFont: '',
                    noFontSelected: true,
                    noFontSelectedNum: true,
                    noFontSelectedMonth: true,
                    noFontSelectedTxet: true,
                    renderList: list
                },
                $scope.showFontList = function() {
                    $scope.params.noFontSelectedNum = ($scope.params.numFont === 2) ? true : false;
                    $scope.params.noFontSelectedMonth = ($scope.params.monthFount === 2) ? true : false;
                    $scope.params.noFontSelectedText = ($scope.params.textFont === 2) ? true : false;
                    fontSvc.getAllFontValues(function(list) {
                        $scope.params.renderList = processFontsResult(list);
                        $scope.$apply();
                    });
                };

                function processFontsResult(res) {
                    var renderList = [];
                    var renderItem;
                    for (var i = 0; i < res.length; i++) {
                        renderItem = {};
                        renderItem.isSelected = res[i].is_selected === 1;
                        renderItem.fontFamily = res[i].font_family;
                        if (1 === res[i].is_selected) {
                            $scope.params.currentFont = res[i].font_family;
                            $scope.params.noFontSelected = false;
                        }
                        renderItem.isSelectedUsage = (i === 0) ? true : false;

                        renderItem.details = res[i].details;
                        renderItem.name = res[i].name;
                        renderItem.path = res[i].path;
                        renderItem.global_id = res[i].global_id;
                        renderItem.index = i;
                        renderList.push(renderItem);
                    }
                    return renderList;
                }

                $scope.onFontItemClick = function(index, fontUsingType) {
                    var selectedFont = 'sans-serif';
                    if (index < $scope.params.renderList.length) {
                        selectedFont = $scope.params.renderList[index].fontFamily;
                    }
                    if (fontUsingType === 1) {
                        $scope.model.nFontUsageCb(selectedFont, 1);
                        fontSvc.updateFontSelection($scope.params.currentFont, selectedFont, function(newFont) {

                        });
                        jorteConfig.setNumberFont(index);
                        jorteConfig.setTextFont(index);
                        jorteConfig.setMonthFont(index);

                    } else if (fontUsingType === 2) {
                        jorteConfig.setNumberFont(index);
                        $scope.model.nFontUsageCb(selectedFont, 2);
                    } else if (fontUsingType === 3) {
                        jorteConfig.setTextFont(index);
                        $scope.model.nFontUsageCb(selectedFont, 3);
                    } else if (fontUsingType === 4) {
                        jorteConfig.setMonthFont(index);
                        $scope.model.nFontUsageCb(selectedFont, 4);
                    }

                    dialogService.close("fontListPopup");
                };

                $scope.onCancelClick = function() {
                    dialogService.close("fontListPopup");
                };

                $scope.showFontList();
            }
        ])

        .controller('fontDownloadCtrl', ['$scope', '$rootScope', 'dialogService', 'fontSvc', '$http',
            function($scope, $rootScope, dialogService, fontSvc, $http) {
                var filePath = 'jorte/font/';
                $scope.fonts = [];
                $scope.dFont = null;
                $scope.dFontDetails = null;
                var locale = $rootScope.currentLocale;
                var parts = locale.split('-');
                if (parts.length > 1) {
                    locale = parts[0];
                }
                var fontListUrl = 'http://ap2.jorte.net/jortefont/font/list?method=GET&token=62a0330063205699d47e4a1199c1a69f1d78e77b04521e4c35326aaded20ce43&locale=' + locale;
                function getFontsList() {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        dialogService.close('fontDownloadPopup');
                        return;
                    }
                    $http({'method': 'GET', 'url': fontListUrl})
                            .success(function(data) {
                                onListGetSuccess(data);
                            })
                            .error(function(data, status) {
                                console.log('Error ', data, status);
                                onListGetError();
                            });
                    function onListGetError() {
                        console.log('Error on getting font list');
                        dialogService.close('fontDownloadPopup');
                    }
                    function onListGetSuccess(data) {
                        fontSvc.getAllFontValues(function(list) {
                            var lines = data.split("\n");
                            var fonts = [];
                            for (var i in lines) {
                                if (!$.trim(lines[i])) {
                                    continue;
                                }
                                var props = lines[i].split(",");
                                var font = {
                                    'gid': parseInt($.trim(props[0])),
                                    'name': $.trim(props[1]),
                                    'imageUrl': $.trim(props[2]),
                                    'fontUrl': $.trim(props[3])
                                };
                                for (var j = 0; j < list.length; j++) {
                                    if (list[j].global_id && parseInt(list[j].global_id) === font.gid) {
                                        font.isDownloaded = true;
                                        break;
                                    }
                                }
                                fonts.push(font);
                            }
                            for (var i = 0; i < fonts.length; i++) {
                                for (var j = 0; j < fonts.length - i - 1; j++) {
                                    if (fonts[j].gid > fonts[j + 1].gid) {
                                        var tmp = fonts[j];
                                        fonts[j] = fonts[j + 1];
                                        fonts[j + 1] = tmp;
                                    }
                                }
                            }
                            $scope.fonts = fonts;
                            $scope.$apply();
                        });
                    }
                }

                getFontsList();

                $scope.onDownloadClick = function() {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        dialogService.close('fontDownloadPopup');
                        return;
                    }

                    var selFont = null;
                    for (var i in $scope.fonts) {
                        if ($scope.fonts[i].gid === $scope.dFont) {
                            selFont = $scope.fonts[i];
                            break;
                        }
                    }
                    if (selFont) {
                        $scope.downloading = true;
                        var oReq = new XMLHttpRequest({mozSystem: true});
                        oReq.open("GET", selFont.fontUrl, true);
                        oReq.responseType = "blob";
                        oReq.onload = function(xhr) {
                            $scope.downloading = false;
                            if (this.status === 200 && this.readyState === 4 && oReq.response.size > 0) {
                                onDownloadSuccess(oReq.response);
                            } else {
                                console.log('failed :' + this.status);
                                onDownloadFail();
                            }
                        };
                        oReq.onerror = function(xhr) {
                            $scope.downloading = false;
                            console.log(' Error ', xhr);
                            onDownloadFail();
                        };
                        oReq.send(null);

                    }
                    function onDownloadFail() {
                        alert(getMSG('DownloadFailed'));
                        dialogService.close('fontDownloadPopup');
                    }

                    function onDownloadSuccess(data) {
                        var reader = new FileReader();
                        reader.onload = function(theFile) {
                            var zip = new JSZip(theFile.target.result);
                            $.each(zip.files, function(index, zipEntry) {
                                if (zipEntry.name.match(/^.*\..*$/) && !zipEntry.name.match(/^.*\.txt.*$/i)) {
                                    saveFontFile(zipEntry);
                                }
                            });
                        };
                        reader.readAsArrayBuffer(data);
                    }

                    function isExistFont(filePath, callBack) {
                        var sdcard = navigator.getDeviceStorage('sdcard');
                        var request = sdcard.get(filePath);

                        request.onsuccess = function() {
                            var request = sdcard.delete(filePath);

                            request.onsuccess = function() {
                                callBack && callBack();
                            };
                            request.onerror = function() {
                                console.log("Unable to delete the file: ", this.error);
                                callBack && callBack();
                            };
                        };
                        request.onerror = function() {
                            callBack && callBack();
                        };
                    }

                    function saveFontFile(zipEntry) {
                        var sdcard = navigator.getDeviceStorage('sdcard');
                        var name = zipEntry.name;
                        var parts = name.split('/');
                        var font_name = parts[1];
                        parts = font_name.split('.');
                        var font_family = parts[0];
                        var details = $scope.dFontDetails;
                        var global_id = $scope.dFont;
                        var data = zipEntry.asUint8Array();
                        var file = new Blob([data]);
                        isExistFont(filePath + name, function() {
                            var request = sdcard.addNamed(file, filePath + name);

                            request.onsuccess = function() {
                                var font = new FontsJorte();
                                font.name = font_name, font.details = details, font.path = this.result,
                                        font.is_selected = 0, font.font_family = font_family, font.global_id = global_id;
                                fontSvc.saveFont(font, function() {

                                    var request = sdcard.get(font.path);

                                    request.onsuccess = function() {
                                        var file = this.result;
                                        var fontURL = window.URL.createObjectURL(file);
                                        var newStyle = document.createElement('style');
                                        newStyle.appendChild(document.createTextNode("@font-face {font-family: '" + font_family + "'; src: url('" + fontURL + "');}"));
                                        document.head.appendChild(newStyle);
                                        dialogService.close('fontDownloadPopup');
                                    };
                                    request.onerror = function() {
                                        console.warn("Unable to get the file: ", this.error);
                                        dialogService.close('fontDownloadPopup');
                                    };

                                });
                            };
                            request.onerror = function() {
                                alert(getMSG('SdCardError'));
                                dialogService.close('fontDownloadPopup');
                                console.warn('Unable to write the file: ', this.error);
                            };
                        });
                    }
                };

                $scope.selectFont = function(font, name, details) {
                    $scope.dFont = font;
                    $scope.name = name;
                    $scope.dFontDetails = details;
                };
            }]);