'use strict';
/* 
 * Set Jorte Theme 
 * 
 */

angular.module('controllers.theme', [])

        .controller('themeEditPopupCtrl', ['$scope', '$location', 'themeSvc', 'dialogService',
            function($scope, $location, themeSvc, dialogService) {
                $scope.editTheme = $scope.model.currentTheme;
                var onDeleteCb = $scope.model.onDeleteCb;

                $scope.onCancelClick = function() {
                    dialogService.close("themeEditPopup");
                };
                $scope.onEditClick = function(isCopy) {
                    themeSvc.editTheme = $scope.editTheme;
                    themeSvc.isCopy = isCopy;
                    dialogService.close("themeEditPopup");
                    $location.path('/themeColorList');
                };
                $scope.onDeleteClick = function() {
                    if (!confirm(getMSG('ContentOneThemeHead'))) {
                        return;
                    }
                    themeSvc.deleteTheme($scope.editTheme.itemId, function() {
                        onDeleteCb && onDeleteCb();
                        dialogService.close("themeEditPopup");
                    });
                };
            }])

        .controller('themeColorListCtrl', ['$rootScope', '$scope', '$location', 'themeSvc', 'dialogService',
            function($rootScope, $scope, $location, themeSvc, dialogService) {
                $scope.editTheme = themeSvc.editTheme;
                $scope.themeName = $scope.editTheme.name;
                $scope.themeDesc = $scope.editTheme.details;
                $scope.author = $scope.editTheme.author;
                var nameBackup = '';
                var colorRules = ['link_color', 'error_color', 'fc-day-header.fc-sun',
                    'fc-day-header', 'fc-day-header.fc-sat', 'fc-day.fc-sun', 'fc-day.fc-sat',
                    'fc-day', 'fc-header-title', 'important', 'complete', 'fc-week-number-custom',
                    'header_todo'];
                var bgColorRules = ['bg_color', 'fc-day-header.fc-sun', 'fc-day-header', 'fc-day-header.fc-sat',
                    'fc-day.fc-sun', 'fc-day.fc-sat', 'fc-day', 'fc-selected-custom', 'header_todo', 'fc-day.fc-other-month'];
                var lineRule = ['th_border_color'];

                var extraCssList = [THEME_JORTEWHTE_EXTRA, THEME_BLACK_EXTRA, THEME_PEACHORANGE_EXTRA, THEME_OCEANBLUE_EXTRA,
                    THEME_STRAWBERRY_EXTRA, THEME_LIMEGREEN_EXTRA, THEME_LEMON_EXTRA];

                $("#color_edit_scroller p.txt_c").each(function(i, e) {
                    $(e).css('background-color', $(e).css('color'));
                });
                $("#color_edit_scroller p.brd_c").each(function(i, e) {
                    $(e).css('background-color', $(e).css('border-top-color'));
                });

                var isCopy = themeSvc.isCopy;
                if (isCopy) {
                    themeSvc.getCountOfThemesWithParent(!$scope.editTheme.parent ? $scope.editTheme.itemId : $scope.editTheme.parent,
                            function(count) {
                                $scope.themeName = $scope.editTheme.name + " " + count;
                                nameBackup = $scope.themeName;
                                $scope.$apply();
                            }
                    );
                }

                $scope.onCloseClick = function() {
                    $location.path('/');
                };

                $scope.onEditTitleClick = function() {
                    var modelData = {
                        name: $scope.themeName + '',
                        details: $scope.themeDesc,
                        author: $scope.author,
                        setData: function(newData) {
                            if (newData.name) {
                                $scope.themeName = newData.name;
                            } else {
                                $scope.themeName = nameBackup;
                            }
                            $scope.themeDesc = newData.details;
                            $scope.author = newData.author;
                        }
                    };
                    dialogService.open("themeTitleEditPopup", "themeTitleEditPopup", modelData, {title: getMSG('EditTitleHead')});
                };


                $scope.onColorBoxClick = function($event) {
                    var selColor = $($event.target).css('background-color');
                    var modelData = {
                        color: selColor,
                        setColor: function(color) {
                            $($event.target).css('background-color', color);
                        }
                    };
                    dialogService.open("colorPicPopup", "colorPicPopup", modelData, {title: getMSG('EditColorHead')});
                };

                $scope.onSaveClick = function() {
                    var content = "";

                    $.each(bgColorRules, function(key, elm) {
                        if (elm === 'fc-day-header' || elm === 'fc-day') {
                            content += '\n.' + elm + '{background-color:' + $('#color_edit_scroller .bg_c.' + elm)
                                    .not('.fc-sun').not('.fc-sat').not('.fc-other-month').css('background-color') + ';}';
                        } else {
                            content += '\n.' + elm + '{background-color:' + $('#color_edit_scroller .bg_c.' + elm).css('background-color') + ';}';
                        }
                    });

                    $.each(colorRules, function(key, elm) {
                        if (elm === 'fc-day-header' || elm === 'fc-day') {
                            content += '\n.' + elm + '{color:' + $('#color_edit_scroller .txt_c.' + elm)
                                    .not('.fc-sun').not('.fc-sat').css('background-color') + ';}';
                        } else {
                            content += '\n.' + elm + '{color:' + $('#color_edit_scroller  .txt_c.' + elm).css('background-color') + ';}';
                        }
                    });

                    $.each(lineRule, function(key, elm) {
                        content += '\n.' + elm + '{border-color:' + $('#color_edit_scroller .brd_c.' + elm).css('background-color') + ';}';
                    });

                    var parentId = null;
                    if ($scope.editTheme.isStatic) {
                        parentId = $scope.editTheme.itemId;
                    } else {
                        parentId = $scope.editTheme.parent;
                    }
                    content = content + extraCssList[parseInt(parentId) - 1];
                    var themeColor = $('#backbg .customize_checkbox').css('background-color');
                    if (isCopy) {
                        var newTheme = new ThemeJorte();
                        newTheme.name = $scope.themeName, newTheme.details = $scope.themeDesc,
                                newTheme.author = $scope.author, newTheme.color = themeColor,
                                newTheme.path = '', newTheme.parent = parseInt(parentId), newTheme.file_name = '';

                        themeSvc.saveTheme(newTheme, content, function(themeId) {
                            jorteConfig.setCurrentTheme(themeId);
                            $rootScope.themeStyle = content;
                            $location.path('/');
                            $scope.$apply();
                        });
                    } else {
                        var themeData = {};
                        themeData.name = $scope.themeName, themeData.details = $scope.themeDesc,
                                themeData.author = $scope.author, themeData.path = '',
                                themeData.color = themeColor, themeData.file_name = '',
                                themeData.content = content, themeData.themeId = $scope.editTheme.itemId;
                        themeSvc.updateTheme(themeData, function(themeId) {
                            jorteConfig.setCurrentTheme(themeId);
                            $rootScope.themeStyle = content;
                            $location.path('/');
                            $scope.$apply();
                        });
                    }
                };
            }])

        .controller('colorPicPopupCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.color = $scope.model.color;
                var setColorCB = $scope.model.setColor;
                $scope.red = 255;
                $scope.green = 255;
                $scope.blue = 255;

                var m = $scope.color.match(/^rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/i);
                if (m) {
                    $scope.red = m[1];
                    $scope.green = m[2];
                    $scope.blue = m[3];
                }
                function updateSlider() {

                    $("#color_slider_1").attr('aria-valuenow', $scope.red).on("change", function() {
                        $scope.red = parseInt($(this).attr('aria-valuenow'));
                        $scope.color = "rgb(" + $scope.red + ", " + $scope.green + ", " + $scope.blue + " )";
                        $scope.$apply();
                    });
                    seekBars.bind("#color_slider_1");

                    $("#color_slider_2").attr('aria-valuenow', $scope.green).on("change", function() {
                        $scope.green = parseInt($(this).attr('aria-valuenow'));
                        $scope.color = "rgb(" + $scope.red + ", " + $scope.green + ", " + $scope.blue + " )";
                        $scope.$apply();
                    });
                    seekBars.bind("#color_slider_2");

                    $("#color_slider_3").attr('aria-valuenow', $scope.blue).on("change", function() {
                        $scope.blue = parseInt($(this).attr('aria-valuenow'));
                        $scope.color = "rgb(" + $scope.red + ", " + $scope.green + ", " + $scope.blue + " )";
                        $scope.$apply();
                    });
                    seekBars.bind("#color_slider_3");

                }
                setTimeout(updateSlider, 100);

                $scope.onCancelClick = function() {
                    dialogService.close("colorPicPopup");
                };
                $scope.onOkClick = function() {
                    $scope.red = $scope.red > 255 ? 255 : $scope.red;
                    $scope.green = $scope.green > 255 ? 255 : $scope.green;
                    $scope.blue = $scope.blue > 255 ? 255 : $scope.blue;
                    $scope.color = "rgb(" + $scope.red + ", " + $scope.green + ", " + $scope.blue + " )";
                    setColorCB($scope.color);
                    dialogService.close("colorPicPopup");
                };
            }])

        .controller('themeTitleEditPopupCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {

                $scope.data = $scope.model;
                $scope.onCancelClick = function() {
                    dialogService.close("themeTitleEditPopup");
                };
                $scope.onOkClick = function() {
                    $scope.data.setData($scope.data);
                    dialogService.close("themeTitleEditPopup");
                };
            }]);
