'use strict';

/**
 * Jorte main controllers
 * 
 */
angular.module('controllers.dayEvents', [])

        // day events controller
        .controller('dayEventsCtrl', ['$rootScope', '$scope', 'dialogService',
            function($rootScope, $scope, dialogService) {
                //Populate day events
                $scope.headTitle = '';
                $scope.eventTaskItems = [];
                var localResult = [];
                var dateVal;
                function getEventTaskItems(bottom, newVal, afterShowCB) {
                    if (!newVal) {
                        return;
                    }
                    localResult = [];
                    var startTime = new Date(newVal);
                    startTime.setHours(0, 0, 0, 0);
                    var endTime = new Date(newVal);
                    endTime.setHours(23, 59, 59, 999);
                    var newList = $scope.eventTaskItems;

                    if (!newList) {
                        return;
                    }
                    for (var i in newList) {
                        var instance = newList[i];
                        if ((startTime <= instance.begin && endTime >= instance.begin) ||
                                (startTime <= instance.end && endTime >= instance.end) ||
                                (instance.begin <= startTime && instance.end >= startTime)) {
                            localResult.push(instance);
                        }
                    }
                    jorteUtils.sortEvents(localResult);
                    $scope.dayEvents = [];
                    $scope.dayEvents = processResult(localResult);
                    if (bottom) { //To show events/tasks at the bottom part on click
                        try {
                            if (dialogService.dialogs['eventTaskListPopup']) {
                                $rootScope.$broadcast('eventTaskItemsPopup', $scope.eventTaskItems);
                            }

                        } catch (e) {
                            console.log('broadcast eventTaskItemsPopup ', e);
                        }
                    } else { //For detail popup
                        $scope.$apply();
                        try {
                            if (dialogService.dialogs['eventTaskDetailPopup_BottomEvtsAndTasks']) {
                                $rootScope.$broadcast('navigItemsListChanged', $scope.dayEvents);
                            }
                        } catch (e) {
                            console.log('broadcast navigItemsListChanged ', e);
                        }
                    }
                    afterShowCB && afterShowCB();
                }
                $scope.$on('eventTaskItems', function(evt, newList) {
                    for (var i in newList) {
                        var locItem = newList[i];
                        if (locItem.isdeliverCalendar === 1) {
                            $scope.eventTaskItems['del_' + locItem.instance_id] = locItem;
                        } else {
                            $scope.eventTaskItems[locItem.instance_id] = locItem;
                            if(locItem.parent && locItem.originalStartDate){
                                var instance_id = locItem.parent+ '#' +locItem.originalStartDate;
                                delete $scope.eventTaskItems[instance_id];
                            }
                        }
                    }
                    $scope.$apply();
                    if (!dateVal) {
                        return;
                    }
                    $scope.headTitle = jorteUtils.formatDate(dateVal, getMSG('LongDateFormat2'), cal_string);
                    getEventTaskItems(false, dateVal);
                });
                $scope.$watch('calendarLoaded', function(newVal, oldVal) {
                    if (!newVal && oldVal) {
                        $scope.eventTaskItems = [];
                        $scope.dayEvents = [];
                    }
                });
                //On day click
                $scope.$watch('params.clickedDate', function(newVal, oldVal) {
                    if (!newVal) {
                        return;
                    }
                    dateVal = newVal;
                    $scope.headTitle = jorteUtils.formatDate(newVal, getMSG('LongDateFormat2'), cal_string);
                    getEventTaskItems(true, newVal);
                });

                $scope.$on('showDayEvents', function(evt, modelData) { //broad cast from notification/reminders list
                    if (!modelData.dateObj || !modelData.itemId) {
                        return;
                    }
                    dateVal = modelData.dateObj;
                    for (var i in dialogService.dialogs) {
                        try {
                            dialogService.close(i);
                        } catch (e) {
                            console.log('while closing popup', e);
                        }
                    }
                    loadItems(dateVal, function() {
                        var showIndex = -1;
                        for (var i = 0; i < $scope.dayEvents.length; i++) {
                            if ($scope.dayEvents[i].itemId === modelData.itemId
                                    && $scope.dayEvents[i].itemType === modelData.itemType) {
                                showIndex = i + 1;
                                break;
                            }
                        }
                        if (showIndex <= $scope.dayEvents.length) {
                            $scope.onItemClick(showIndex);
                        }
                    });
                });

                function loadItems(newVal, afterShowCB) {
                    var startTime = new Date(newVal);
                    startTime.setHours(0, 0, 0, 0);
                    var endTime = new Date(newVal);
                    endTime.setHours(23, 59, 59, 999);
                    $scope.headTitle = jorteUtils.formatDate(newVal, getMSG('LongDateFormat2'), cal_string);
                    getEventTaskItems(true, newVal, function() {
                        try {
                            if (dialogService.dialogs['eventTaskDetailPopup_BottomEvtsAndTasks']) {
                                $rootScope.$broadcast('navigItemsListChanged', $scope.dayEvents);
                            }
                        } catch (e) {
                            console.log('broadcast navigItemsListChanged ', e);
                        }
                        afterShowCB && afterShowCB();
                    });
                }

                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    var parent;
                    if(changedItem.details && !changedItem.details[0].parent){
                        parent = changedItem.itemId;
                    }
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === changedItem.itemId && locItem.type === changedItem.itemType
                                || (locItem.type === 2 && locItem.calendar_id === changedItem.calendarId)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            localResult.splice(i, 1);
                            i--;
                        }
                    }
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if ((locItem.id === changedItem.itemId && locItem.type === changedItem.itemType)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            delete $scope.eventTaskItems[i];
                        }
                    }

                    $scope.dayEvents = processResult(localResult);
                    $scope.$apply();
                });
                
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.instance_id === changedItem.itemInstanceId) {
                            localResult.splice(i, 1);
                            break;
                        }
                    }
                    if (changedItem.itemInstanceId) {
                        delete $scope.eventTaskItems[changedItem.itemInstanceId];
                    }
                    $scope.dayEvents = processResult(localResult);
                    $scope.$apply();
                });
                
                $scope.$on('repeatEventsDeleted', function(evt, eventId) {

                    for (var i = 0; i < localResult.length; i++) {
                        var locItem = localResult[i];
                        if (locItem.id === eventId && locItem.type === 0||(locItem.parent && locItem.parent === eventId)) {
                            localResult.splice(i, 1);
                            i--;
                        }
                    }
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.id === eventId && locItem.type === 0||(locItem.parent && locItem.parent === eventId)) {
                            delete $scope.eventTaskItems[i];
                        }
                    }

                    $scope.dayEvents = processResult(localResult);
                    $scope.$apply();
                });
                
                $scope.$on('eventUpdated', function(evt, data) {
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.id === data.event_id && locItem.type === 0) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                    $scope.$apply();
                });
                $scope.$on('holidayDeleted', function(evt) {
                    for (var i in $scope.eventTaskItems) {
                        var locItem = $scope.eventTaskItems[i];
                        if (locItem.provider === 200) {
                            delete $scope.eventTaskItems[i];
                        }
                    }
                });
                $scope.onItemClick = function(index) {
                    var date_caption = jorteUtils.formatDate(dateVal, getMSG('LongDateFormat2'), cal_string);
                    var modelData = {itemIndex: index - 1, renderList: $scope.dayEvents, 'dateObj': dateVal};
                    dialogService.open("eventTaskDetailPopup_BottomEvtsAndTasks", "eventTaskDetailPopup", modelData, {title: date_caption, minHeight: 360, headerVisible: false});
                };

                function processResult(result) {
                    var dayEvents = [];
                    var itemIndex = 0;
                    for (var i = 0; i < result.length; i++) {
                        var item = result[i];
                        if (!item.instance_id) {
                            continue;
                        }
                        if (item.type === 0) {//event
                            if (item.completed && jorteConfig.getDispCompletedEvent() === 0) {//hide completed evt
                                continue;
                            }
                        } else if (item.type === 1) { //task
                            if (!jorteConfig.getDisplayTask() || (item.completed && jorteConfig.getHideCompletedTask())) {
                                continue;
                            }
                        }
                        var dayEvent = {}, color = '';
                        dayEvent.id = item.id;
                        dayEvent.name = (item.name) ? item.name : ((item.holiday) ? getMSG('NoSubjectHoliday') : getMSG('NoSubjectHead'));

                        if (item.completed === 1 && jorteConfig.getDispCompletedEvent() === 1) {
                            color = jorteConfig.COLORS.completed;
                        } else if (item.importance || item.holiday || item.provider === 200) {
                            color = jorteConfig.COLORS.red;
                        } else if (item.color) {
                            color = item.color;
                        } else {
                            var eventColor = jorteConfig.JORTE_THEME.title_color[jorteConfig.getCurrentTheme() - 1];
                            color = item.cal_color ? item.cal_color : eventColor;
                        }
                        dayEvent.color = color;

                        if (item.type === 0) {

                            dayEvent.start_date = (item.start_date && item.start_time) ? jorteUtils.formatDate(new Date(item.start_date), getMSG('ShortDateFormat3')) : '';
                            var due_date = '';
                            if (item.end_date && item.end_time) {
                                if (item.day_time === 7) {
                                    var d = new Date(item.end_date);
                                    d.setMinutes(d.getMinutes() + 1);
                                    due_date = jorteUtils.formatDate(d, getMSG('ShortDateFormat3'));
                                } else if (item.day_time === 8) {
                                    var d = new Date(item.end_date);
                                    due_date = jorteUtils.formatDate(d, getMSG('ShortDateFormat3'));
                                }else{
                                    due_date = jorteUtils.formatDate(new Date(item.end_date), getMSG('ShortDateFormat3'));
                                }
                            }
                            dayEvent.due_date = due_date;
                            dayEvent.icon = (item.icon) ? item.icon : '';
                            dayEvent.location = (item.location) ? jorteUtils.htmlEscape(item.location) : '';
                        } else if (item.type === 1) {

                            dayEvent.start_date = (item.start_date) ? jorteUtils.formatDate(new Date(item.start_date), getMSG('ShortDateFormat1'), cal_string) : '';
                            dayEvent.due_date = (item.end_date) ? jorteUtils.formatDate(new Date(item.end_date), getMSG('ShortDateFormat1'), cal_string) : '';
                            dayEvent.start_time = (item.start_time !== null) ? jorteUtils.parseMinutes(item.start_time) : '';
                            dayEvent.due_time = (item.end_time !== null) ? jorteUtils.parseMinutes(item.end_time) : '';
                            dayEvent.icon = (item.icon) ? item.icon : '';
                            dayEvent.location = (item.location) ? jorteUtils.htmlEscape(item.location) : '';
                        } else if (item.type === 2) {
                            if (item.icon) {
                                if (item.icon.indexOf("http") !== -1) {
                                    dayEvent.icon = item.icon;
                                } else {
                                    var iconMap = JSON.parse(item.icon_map);
                                    if (iconMap['default']) {
                                        iconMap = iconMap['default'];
                                    } else if (iconMap['logo']) {
                                        iconMap = iconMap['logo'];
                                    } else {
                                        iconMap = [''];
                                    }
                                    var iconArray = item.icon.split(/[\/|_!\-\+&,:\*]/);
                                    dayEvent.icon = iconArray[0] ? iconMap[iconArray[0]] : '';
                                }
                            } else {
                                dayEvent.icon = item.icon_data;
                            }

                            var evtCalDetails = "";
                            if (item.begin) {
                                var tt = jorteUtils.TimeConvertOption(item.begin, 'HH:mm');
                                evtCalDetails += tt === '00:00' ? '' : tt;

                            }
                            if (item.end) {
                                var tt = jorteUtils.TimeConvertOption(item.end, 'HH:mm');
                                evtCalDetails += "-" + tt === '00:00' ? '' : tt;
                            }
                            if (item.location) {
                                evtCalDetails += " " + item.location;
                            }
                            dayEvent.evtCalDetails = evtCalDetails;
                        }
                        /** For detail popup */
                        dayEvent.itemId = item.id;
                        dayEvent.itemType = item.type;
                        dayEvent.itemInstanceId = item.instance_id;
                        dayEvent.itemIndex = ++itemIndex;
                        dayEvent.calendarId = item.calendar_id;
                        dayEvent.is_public = item.is_public;
                        dayEvent.is_share = item.is_share;
                        if (item.details) {
                            dayEvent.details = item.details;
                        }
                        dayEvents.push(dayEvent);
                    }
                    return dayEvents;
                }
            }]);
