'use strict';

/**
 * Jorte controllers
 * 
 */
angular.module('controllers.dayEventsPopup', [])

        //controller display list or events and task and handle previous / next day list
        .controller('dayEventsPopupListCtrl', ['$rootScope', '$scope', 'dialogService',
            function($rootScope, $scope, dialogService) {

                var dateObj = $scope.model.dateObj;
                var itemList = [];

                function processResults(taskAndEvents) {
                    if (!taskAndEvents) {
                        return;
                    }
                    var dispCompleted = jorteConfig.getDispCompletedEvent();
                    var renderList = [];
                    var itemIndex = 0;
                    for (var i = 0; i < taskAndEvents.length; i++) {
                        var item = taskAndEvents[i];
                        if (!item.instance_id) {
                            continue;
                        }
                        var renderItem = {};
                        var name = getMSG('NoSubjectHead');
                        var nameHoliday = getMSG('NoSubjectHoliday');

                        if (item.type === 0) {
                            if (item.completed && dispCompleted === 0) {//hide completed evt
                                continue;
                            }
                        } else if (item.type === 1) { //task
                            if (!jorteConfig.getDisplayTask() || (item.completed && jorteConfig.getHideCompletedTask())) {
                                continue;
                            }
                        } else if (item.type === 2) {
                            var icon = item.icon;
                            if (icon) {
                                if (icon.indexOf("http") !== -1) {
                                    renderItem.deliverEventIcon = icon;
                                } else {
                                    var iconMap = JSON.parse(item.icon_map);
                                    if (iconMap['default']) {
                                        iconMap = iconMap['default'];
                                    } else if (iconMap['logo']) {
                                        iconMap = iconMap['logo'];
                                    } else {
                                        iconMap = [''];
                                    }
                                    var iconArray = icon.split(/[\/|_!\-\+&,:\*]/);
                                    var symbol = icon.match(/[\/|_!\-\+&,:\*]/g);
                                    renderItem.deliverEventIcon = iconMap[iconArray[0]];
                                    renderItem.deliverEventIconWidth = (iconArray.length === 1) ? '100%' : '45%';
                                    if (iconArray.length > 1) {
                                        if (symbol[0]) {
                                            renderItem.deliverEventSymbol = symbol[0];
                                        }
                                        renderItem.deliverEventIcon2 = iconMap[iconArray[1]];
                                        renderItem.deliverEventIcon2Width = (iconArray.length === 1) ? '100%' : '45%';
                                    }
                                }
                            } else {
                                renderItem.deliverEventIcon = item.icon_data;
                            }
                        }

                        var dateText = '';
                        if (item.type !== 2) {
                            if (item.type === 0) {

                                if (item.holiday === 1 || item.all_day === 1) {
                                    dateText = '';
                                } else {
                                    var currentDate_obj = dateObj;
                                    var currentDate = new Date(currentDate_obj.getFullYear(), currentDate_obj.getMonth(), currentDate_obj.getDate(), 0, 0, 0);

                                    if (item.begin) {
                                        if (jorteUtils.numberOfdaysCalc(item.begin, currentDate) === 0 && item.start_time !== null) {
                                            dateText += jorteUtils.TimeConvertOption(item.begin, getMSG('ShortDateFormat3'));
                                        }
                                    }

                                    if (item.end) {
                                        if ((jorteUtils.numberOfdaysCalc(item.end, currentDate) === 0  && item.day_time !== 8||jorteUtils.numberOfdaysCalc(item.end_inst, currentDate) <= 1  && item.day_time === 8) && item.end_time !== null) {
                                            var end = jorteUtils.TimeConvertOption(item.end, getMSG('ShortDateFormat3'));
                                            if(item.day_time === 7){
                                                var d = new Date(item.end);
                                                d.setMinutes(d.getMinutes() + 1);
                                                end = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                            }else if(item.day_time === 8){
                                                var d = new Date(item.end_inst);
                                                end = jorteUtils.TimeConvertOption(d.getTime(), getMSG('ShortDateFormat3'));
                                            }
                                            dateText += " - " + end;
                                        }
                                    }
                                }

                            } else {
                                if (item.start_time !== null) {
                                    dateText += jorteUtils.parseMinutes(item.start_time);
                                }
                                if (item.end_time !== null) {
                                    dateText += " - " + jorteUtils.parseMinutes(item.end_time);
                                }
                                dateText += " ";
                            }
                            if (item.location) {
                                dateText += item.location;
                            }
                            if (item.start_time !== null || item.end_time !== null) {
                                renderItem.lineBreak = true;
                            }
                        }
                        if (item.name) {
                            name = item.name; // jorteUtils.htmlEscape(item.name);
                        } else if (item.holiday === 1) {
                            name = nameHoliday;
                        }

                        renderItem.dateText = dateText;
                        renderItem.itemName = name;
                        renderItem.itemType = item.type;
                        renderItem.itemId = item.id;
                        renderItem.index = ++itemIndex;
                        renderItem.itemBegin = item.begin;
                        renderItem.itemInstanceId = item.instance_id;
                        renderItem.itemIcon = item.icon;
                        renderItem.itemStartDate = item.start_date;
                        renderItem.itemColor = jorteUtils.getColor(item);
                        renderItem.calendarId = item.calendar_id;
                        renderItem.is_public = item.is_public;
                        renderItem.is_share = item.is_share;
                        if (item.details) {
                            renderItem.details = item.details;
                        }
                        renderList.push(renderItem);
                    }
                    return renderList;
                }
                //Previous day button navigation
                $scope.showPrevious = function() {
                    showEventTaskList(-1);
                };
                //Next day button navigation
                $scope.showNext = function() {
                    showEventTaskList(1);
                };
                $scope.reloadList = function() {
                    showEventTaskList(0);
                };
                //Broadcast if an item is deleted
                $scope.$on('eventTaskItemDeleted', function(evt, changedItem) {
                    var parent;
                    if(changedItem.details && !changedItem.details[0].parent){
                        parent = changedItem.itemId;
                    }
                    for (var i = 0; i < itemList.length; i++) {
                        var locItem = itemList[i];
                        if ((locItem.id === changedItem.itemId && locItem.type === changedItem.itemType)
                                || (locItem.type === 2 && locItem.calendar_id === changedItem.calendarId)||(parent && locItem.parent && locItem.parent === parent && locItem.type === changedItem.itemType)) {
                            itemList.splice(i, 1);
                            i--;
                        }
                    }
                    $scope.renderList = processResults(itemList);
                    $scope.$apply();
                });
                
                $scope.$on('singleRepeatEventDeleted', function(evt, changedItem) {
                    for (var i = 0; i < itemList.length; i++) {
                        var locItem = itemList[i];
                        if (locItem.instance_id === changedItem.itemInstanceId) {
                            itemList.splice(i, 1);
                            break;
                        }
                    }
                    $scope.renderList = processResults(itemList);
                    $scope.$apply();
                });
                
                $scope.$on('repeatEventsDeleted', function(evt, eventId) {
                    for (var i = 0; i < itemList.length; i++) {
                        var locItem = itemList[i];
                        if ((locItem.id === eventId && locItem.type === 0)||(locItem.parent && locItem.parent === eventId)) {
                            itemList.splice(i, 1);
                            i--;
                        }
                    }
                    $scope.renderList = processResults(itemList);
                    $scope.$apply();
                }); 
                
                function getEventTaskItems(newVal, afterShowCB) {
                    itemList = [];
                    var startTime = new Date(newVal);
                    startTime.setHours(0, 0, 0, 0);
                    var endTime = new Date(newVal);
                    endTime.setHours(23, 59, 59, 999);
                    var newList = $scope.eventTaskItems;
                    if (!newList) {
                        return;
                    }
                    for (var i in newList) {
                        var instance = newList[i];
                        if ((startTime <= instance.begin && endTime >= instance.begin) ||
                                (startTime <= instance.end && endTime >= instance.end) ||
                                (instance.begin <= startTime && instance.end >= startTime)) {
                            itemList.push(instance);
                        }
                    }

                    jorteUtils.sortEvents(itemList);

                    $scope.renderList = [];
                    $scope.renderList = processResults(itemList);
                    afterShowCB && afterShowCB();
                }
                function showEventTaskList(num, afterShowCB) {
                    if (!dateObj) {
                        return;
                    }
                    dateObj = num === 0 ? dateObj : jorteUtils.addDays(dateObj, num);
                    var new_date = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                    $("#overlay_form_newEvent").closest('div.ui-dialog').find('span.ui-dialog-title').text(new_date);
                    getEventTaskItems(dateObj, function() {
                        afterShowCB && afterShowCB();
                    });
                }
                function showEventTaskListDate(afterShowCB) {
                    if (!dateObj) {
                        return;
                    }
                    var new_date = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                    $("#overlay_form_newEvent").closest('div.ui-dialog').find('span.ui-dialog-title').text(new_date);
                    getEventTaskItems(dateObj, function() {
                        $scope.$apply();

                        if ($scope.renderList && $scope.renderList.length > 0) {
                            $rootScope.$broadcast('navigItemsListChanged', $scope.renderList);
                        }
                        afterShowCB && afterShowCB();
                    });
                }

                $scope.$on('eventTaskItemsPopup', function(evt, newList) {
                    $scope.eventTaskItems = newList;
                    showEventTaskList(0);
                });
                $scope.$on('eventTaskItems', function(evt, newList) {
                    for (var i in newList) {
                        var locItem = newList[i];
                        if (locItem.isdeliverCalendar === 1) {
                            $scope.eventTaskItems['del_' + locItem.instance_id] = locItem;
                        } else {
                            $scope.eventTaskItems[locItem.instance_id] = locItem;
                            if(locItem.parent && locItem.originalStartDate){
                                var instance_id = locItem.parent+ '#' +locItem.originalStartDate;
                                delete $scope.eventTaskItems[instance_id];
                            }
                        }
                    }
                    $scope.$apply();
                    showEventTaskListDate();
                });
                $scope.$on('syncCompleted', function() {
                    $scope.eventTaskItems = [];
                    $scope.renderList = [];
                });
                //On tapping an item
                $scope.onItemClick = function(index) {
                    var date_caption = jorteUtils.formatDate(dateObj, getMSG('LongDateFormat2'), cal_string);
                    var modelData = {itemIndex: index - 1, renderList: $scope.renderList, 'dateObj': dateObj};
                    dialogService.open("eventTaskDetailPopup", "eventTaskDetailPopup", modelData, {title: date_caption, minHeight: 360, headerVisible: false});
                };
                //Create event form
                $scope.showCreateEvent = function() {
                    dialogService.open("createEventPopup", "createEvent", {clickedDate: dateObj}, {headerVisible: false});
                };

            }]);