'use strict';

angular.module('controllers.eventCalendar', [])

        // main controller
        .controller('eventCalendarCtrl', ['$scope', '$location', 'calendarApiSvc', 'evtCalendarSvc', 'dialogService',
            function($scope, $location, calendarApiSvc, evtCalendarSvc, dialogService) {
                var offset = 0;
                var limit = 30;
                var locale = navigator.language.replace("-", "_");
                var timezone = jorteConfig.TIME_ZONE;
                $scope.resultsType = 0;
                $scope.calMainScreenHt = $(window).height() - $('#cal_main_head').height();
                if (locale === 'ja') {
                    locale = "ja_JP";
                }
                $scope.onRecommendClick = function() {
                    offset = 0;
                    loadRecommendedCalendars(function(calendars) {
                        $scope.loadMoreButton = calendars.length === limit;
                        $scope.renderList = processRecommendedCalendars(calendars);
                        $scope.resultsType = 0;
                    });
                };

                $scope.onRankingClick = function() {
                    offset = 0;
                    loadRankingCalendars(function(calendars) {
                        $scope.loadMoreButton = calendars.length === limit;
                        $scope.renderList = processRankingCalendars(calendars);
                        $scope.resultsType = 1;
                    });
                };

                $scope.loadMoreButton = true;
                $scope.loadMoreCalendars = function() {
                    offset = offset + limit;
                    if ($scope.resultsType === 1) {
                        loadRankingCalendars(function(calendars) {
                            $scope.loadMoreButton = calendars.length === limit;
                            var newRenderList = processRankingCalendars(calendars);
                            for (var i = 0; i < newRenderList.length; i++) {
                                $scope.renderList.push(newRenderList[i]);
                            }
                        });
                    } else {
                        loadRecommendedCalendars(function(calendars) {
                            $scope.loadMoreButton = calendars.length === limit;
                            var newRenderList = processRecommendedCalendars(calendars);
                            for (var i = 0; i < newRenderList.length; i++) {
                                $scope.renderList.push(newRenderList[i]);
                            }
                        });
                    }
                };

                function loadRankingCalendars(resultCB) {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        $scope.loadMoreButton = false;
                        return;
                    } else {
                        $scope.loadMoreButton = true;
                    }
                    var opts = {
                        locale: locale,
                        limit: limit,
                        offset: offset,
                        timezoneId: timezone
                    };
                    calendarApiSvc.getRankingCalendars(opts, function(result) {
                        resultCB(result.response.calendars);
                    });
                }

                function loadRecommendedCalendars(resultCB) {

                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        $scope.loadMoreButton = false;
                        return;
                    } else {
                        $scope.loadMoreButton = true;
                    }
                    var opts = {
                        locale: locale,
                        limit: limit,
                        offset: offset,
                        timezoneId: timezone
                    };
                    calendarApiSvc.getRecommendedCalendars(opts, function(result) {
                        resultCB(result.response.calendars);

                    });
                }

                function processRankingCalendars(calendars) {
                    var renderList = [];
                    for (var i = 0; i < calendars.length; i++) {
                        var renderItem = {};
                        var item = calendars[i];
                        renderItem.calendarId = item.calendarId;
                        renderItem.iconData = item.iconData;
                        renderItem.title = item.title;
                        renderItem.CID = item.CID;
                        renderItem.providedByLabel = getMSG('Provided_by');
                        renderItem.provider = item.provider;
                        renderItem.totalUser = item.totalUser;
                        var ud = jorteUtils.parseDateString(item.lastUpdate);
                        renderItem.updateDateFmtd = jorteUtils.formatDate(ud, getMSG('LongDateFormat2'), cal_string);
                        renderItem.content = item.content;
                        if (item.addonInfo) {
                            renderItem.addonInfo = item.addonInfo;
                            renderItem.detailedInfoHeadLabel = getMSG('DetailedInformationHead');

                            if (item.url && item.urlString) {
                                renderItem.urls = [];
                                var urls = item.url;
                                var urlStrings = item.urlString;
                                for (var j = 0; j < Math.min(urls.length, urlStrings.length); j++) {
                                    var url = urls[j];
                                    var urlString = urlStrings[j];
                                    if (url) {
                                        renderItem.urls.push({'url': url, 'text': urlString ? urlString : url});
                                    }
                                }
                            }
                        }
                        renderList.push(renderItem);
                    }
                    return renderList;
                }

                function processRecommendedCalendars(calendars) {
                    var renderList = [];
                    for (var i = 0; i < calendars.length; i++) {
                        var renderItem = {};
                        renderItem.calendarId = calendars[i].calendarId;
                        renderItem.CID = calendars[i].CID;
                        renderItem.isCategory = calendars[i].isCategory;
                        renderItem.iconData = calendars[i].iconData;
                        var ud = jorteUtils.parseDateString(calendars[i].lastUpdate);
                        renderItem.title = calendars[i].title;
                        renderItem.providedByLabel = getMSG('Provided_by');
                        renderItem.provider = calendars[i].provider;
                        renderItem.totalUser = calendars[i].totalUser;
                        renderItem.updateDateFmtd = jorteUtils.formatDate(ud, getMSG('LongDateFormat2'), cal_string);
                        renderList.push(renderItem);
                    }
                    return renderList;
                }

                $scope.onRecommendClick(); //init popup with recommend calendars

                $scope.onSearchClick = function() {
                    evtCalendarSvc.currentItem = null;
                    $location.path('/eventCalendarSearch');
                };

                $scope.onItemClick = function(calendarId) {
                    var clickedItem = null;
                    for (var i = 0; i < $scope.renderList.length; i++) {
                        var item = $scope.renderList[i];
                        if (item.calendarId === calendarId) {
                            clickedItem = item;
                            break;
                        }
                    }
                    if (clickedItem) {
                        evtCalendarSvc.currentItem = clickedItem;
                        $location.path('/eventCalendarSearch/');
                    }
                };

                $scope.showDetail = function(calendarId) {

                    var clickedItem = null;
                    for (var i = 0; i < $scope.renderList.length; i++) {
                        var item = $scope.renderList[i];
                        if (item.calendarId === calendarId) {
                            clickedItem = item;
                            break;
                        }
                    }
                    if (clickedItem) {
                        var modelData = {
                            renderItem: clickedItem
                        };
                        dialogService.open("calendarDetailPopup", "calendarDetailPopup", modelData, {title: getMSG('CalendarDetail')});
                    }
                };
            }])

        .controller('calendarDetailPopupCtrl', ['$scope', 'calendarApiSvc', 'evtCalendarSvc', 'dialogService',
            function($scope, calendarApiSvc, evtCalendarSvc, dialogService) {
                var timezone = jorteConfig.TIME_ZONE;

                $scope.renderItem = $scope.model.renderItem;
                var calendarExists = false;
                evtCalendarSvc.getDeliverCalendarByGlobalId($scope.renderItem.calendarId, function(data) {
                    if (data.length > 0) {
                        $scope.addDelLabel = getMSG('DeleteHead');
                        calendarExists = true;
                    } else {
                        $scope.addDelLabel = getMSG('AddHead');
                    }
                    $scope.$apply();
                });
                $scope.onCloseClick = function() {
                    dialogService.close("calendarDetailPopup");
                };
                var opInProgress = false;
                $scope.onAddDelClick = function() {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        return;
                    }
                    if (opInProgress) {
                        return;
                    }
                    opInProgress = true;
                    if (calendarExists) {
                        var confirmMessage = getMSG('DeleteHead') + " '" + $scope.renderItem.title + "' " + getMSG('AreYouSureHead');
                        var r = confirm(confirmMessage);
                        if (r) {
                            evtCalendarSvc.deleteDeliverCalendarByGlobalId($scope.renderItem.calendarId, function() {
                                if (!jorteConfig.getPublicDeviceId()) {
                                    calendarApiSvc.start(function(success) {
                                        if (success) {
                                            unSubscribe();
                                        }
                                    });
                                } else {
                                    unSubscribe();
                                }
                                function unSubscribe() {
                                    calendarApiSvc.subscribe($scope.renderItem.calendarId, 0, function() {
                                        dialogService.close("calendarDetailPopup");
                                    });
                                }
                            });
                        } else {
                            opInProgress = false;
                        }
                    } else {
                        var confirmMessage = getMSG('ECApplyHead', {calName: $scope.renderItem.title});
                        if (confirm(confirmMessage)) {
                            addEventCalendar($scope.renderItem.calendarId, function(status) {
                                dialogService.close("calendarDetailPopup");
                            });
                        } else {
                            opInProgress = false;
                        }
                    }
                };
                $scope.openUrl = function(url) {
                    window.open(url);
                };

                function addEventCalendar(calendarId, completeCB) {
                    var opts = {
                        calendarIds: calendarId,
                        timezoneId: timezone
                    };
                    calendarApiSvc.getCalendar(opts, function(data) {

                        var cals = data.response.calendars;
                        var urls = JSON.stringify(cals[0].url);
                        var url_string = JSON.stringify(cals[0].urlString);
                        var addonInfo = JSON.stringify(cals[0].addonInfo);
                        var dc = new DeliverCalendarsJorte();
                        var co = cals[0];
                        dc.global_id = co.calendarId, dc.disp_type = co.dispType, dc.title = co.title, dc.content = co.content,
                                dc.provider = co.provider, dc.last_update = co.lastUpdate, dc.total_user = co.totalUser, dc.star_user = co.starUser,
                                dc.star_total = co.starTotal, dc.icon_data = co.iconData, dc.version = co.version, dc.calendar_version = co.calendarVersion,
                                dc.expire = co.expire, dc.term = co.term, dc.min_version = co.minVersion, dc.inquiry = co.isInquiry, dc.evaluation = co.isEvaluation,
                                dc.url = urls, dc.url_string = url_string, dc.description = co.description, dc.image_url = co.imageUrl,
                                dc.updated_info = co.updatedInfo, dc.about = co.about, dc.cid = co.CID, dc.icon_map = JSON.stringify(co.iconMap),
                                dc.header_title = co.headerTitle, dc.addon_info = addonInfo, dc.sync_version = -1, dc.selected = 1, dc.sort_order = 1,
                                dc.alt_icon = "", dc.icon_set_name = "", dc.color = "";

                        evtCalendarSvc.addDeliverCalendar(dc);

                        if (!jorteConfig.getPublicDeviceId()) {
                            calendarApiSvc.start(function(success) {
                                if (success) {
                                    subscribe();
                                } else {
                                    completeCB();
                                }
                            });
                        } else {
                            subscribe();
                        }
                        function subscribe() {
                            calendarApiSvc.subscribe(co.calendarId, 1, function(data) {
                                if (data.response.message === 'OK') {
                                    var opts = {
                                        version: 0,
                                        calendarId: co.calendarId,
                                        limit: 1000,
                                        productIds: [],
                                        platform: 'firefoxOs'
                                    };
                                    calendarApiSvc.getCalendarItems(opts, function(data) {

                                        var evts = data.response.commands;
                                        evtCalendarSvc.getDeliverCalendarByGlobalId(calendarId, function(data) {
                                            var apiGivenTime;
                                            var convertedDate;
                                            var dt = new Date();
                                            var end = null;
                                            var begin = null;
                                            var timeZonOfEventCalendar = null;
                                            var isTimeZoneCoversionNeeded = false;
                                            for (var i = 0; i < evts.length; i++) {
                                                timeZonOfEventCalendar = evts[i].params.timezoneId;
                                                isTimeZoneCoversionNeeded = (evts[i].params.isAllDay ? false : true);

                                                if (evts[i].params.begin) {
                                                    apiGivenTime = jorteUtils.parseDateString(evts[i].params.begin);
                                                    if (isTimeZoneCoversionNeeded) {
                                                        var apiOffset = timezones[timeZonOfEventCalendar];
                                                        var locOffset = timezones[jorteConfig.TIME_ZONE];
                                                        convertedDate = new Date(apiGivenTime.getTime() - ((apiOffset - locOffset) * 60 * 1000));

                                                    } else {
                                                        convertedDate = apiGivenTime;
                                                    }
                                                    dt.setFullYear(convertedDate.getFullYear(), convertedDate.getMonth(), convertedDate.getDate());
                                                    dt.setHours(convertedDate.getHours(), convertedDate.getMinutes(), convertedDate.getSeconds(), convertedDate.getMilliseconds());
                                                    begin = dt.getTime();
                                                }

                                                if (evts[i].params.end) {
                                                    apiGivenTime = jorteUtils.parseDateString(evts[i].params.end);
                                                    if (isTimeZoneCoversionNeeded) {
                                                        var apiOffset = timezones[timeZonOfEventCalendar];
                                                        var locOffset = timezones[jorteConfig.TIME_ZONE];
                                                        convertedDate = new Date(apiGivenTime.getTime() - ((apiOffset - locOffset) * 60 * 1000));
                                                    } else {
                                                        convertedDate = apiGivenTime;
                                                    }
                                                    dt.setFullYear(convertedDate.getFullYear(), convertedDate.getMonth(), convertedDate.getDate());
                                                    dt.setHours(convertedDate.getHours(), convertedDate.getMinutes(), convertedDate.getSeconds(), convertedDate.getMilliseconds());
                                                    end = dt.getTime();
                                                }
                                                var picture = null;
                                                var imageInfo = evts[i].params.imageInfo;
                                                if (imageInfo) {
                                                    for (var j = 0; j < imageInfo.length; j++) {
                                                        picture = (picture === null ? imageInfo[j].url : ',' + imageInfo[j].url);
                                                    }
                                                }
                                                var de = new DeliverEventsJorte();
                                                var eo = evts[i];
                                                de.global_id = eo.params.id, de.calendar_id = parseInt(data[0].id), de.calendar_global_id = calendarId,
                                                        de.begin = begin, de.end = end, de.all_day = eo.params.isAllDay,
                                                        de.timezone = eo.params.timezoneId, de.title = eo.params.title,
                                                        de.content = eo.params.content, de.location = eo.params.location, de.icon_id = eo.params.iconId,
                                                        de.icon_only = eo.params.iconOnly, de.icon_position = eo.params.iconPosition,
                                                        de.use_calendar_icon = eo.params.useCalendarIcon, de.url = eo.params.url,
                                                        de.url_string = eo.params.urlString, de.value = picture, de.has_alarm = 0,
                                                        de.version = eo.params.version, de.value_version = 0;
                                                evtCalendarSvc.addDeliverEvent(de);
                                            }
                                            completeCB();
                                        });
                                    });
                                } else {
                                    completeCB();
                                }
                            });
                        }

                    });
                }

            }])

        .controller('eventCalendarSearchCtrl', ['$scope', 'calendarApiSvc', 'evtCalendarSvc', 'dialogService',
            function($scope, calendarApiSvc, evtCalendarSvc, dialogService) {
                var locale = navigator.language.replace("-", "_");
                var timezone = jorteConfig.TIME_ZONE;
                var offset = 0;
                var limit = 30;
                var searchId = '';
                var cid = '';
                var sortOrder = 3;
                $scope.keyWord = '';
                $scope.cidText = getMSG('CIDHead');
                $scope.ht = $(window).height() - $('#event_search_area').height() - 5;

                var currentItem = evtCalendarSvc.currentItem;
                if (currentItem) {
                    if (currentItem.isCategory) {
                        cid = '';
                    } else {
                        cid = currentItem.CID;
                    }
                    searchId = currentItem.calendarId;
                    $scope.renderItem = evtCalendarSvc.currentItem;
                }
                $scope.showCIDBlock = searchId ? false : true;

                function searchCalendars(resultCB) {
                    var opts = {
                        locale: locale,
                        limit: limit,
                        offset: offset,
                        orderBy: sortOrder,
                        CID: cid ? cid : '',
                        keyword: $scope.keyWord,
                        searchId: searchId ? searchId : '',
                        timezoneId: timezone
                    };
                    calendarApiSvc.searchCalendars(opts, function(result) {
                        var calendars = result.response ? result.response.calendars : [];
                        resultCB(calendars);
                    });
                }

                searchCalendars(function(calendars) {
                    if (!navigator.onLine) {
                        alert(getMSG('NetworkNotAvailable'));
                        $scope.loadMoreButton = false;
                        return;
                    } else {
                        $scope.loadMoreButton = true;
                    }
                    $scope.loadMoreButton = calendars.length === limit;
                    $scope.renderList = processCalendars(calendars);
                });

                function processCalendars(calendars) {
                    var renderList = [];
                    for (var i = 0; i < calendars.length; i++) {
                        var renderItem = {};
                        var item = calendars[i];
                        renderItem.calendarId = item.calendarId;
                        renderItem.iconData = item.iconData;
                        renderItem.title = item.title;
                        renderItem.CID = item.CID;
                        renderItem.providedByLabel = getMSG('Provided_by');
                        renderItem.provider = item.provider;
                        renderItem.totalUser = item.totalUser;
                        var ud = jorteUtils.parseDateString(calendars[i].lastUpdate);
                        renderItem.updateDateFmtd = jorteUtils.formatDate(ud, getMSG('LongDateFormat2'), cal_string);
                        renderItem.content = item.content;
                        if (item.addonInfo) {
                            renderItem.addonInfo = item.addonInfo;
                            renderItem.detailedInfoHeadLabel = getMSG('DetailedInformationHead');

                            if (item.url && item.urlString) {
                                renderItem.urls = [];
                                var urls = item.url;
                                var urlStrings = item.urlString;
                                for (var j = 0; j < Math.min(urls.length, urlStrings.length); j++) {
                                    var url = urls[j];
                                    var urlString = urlStrings[j];
                                    if (url) {
                                        renderItem.urls.push({'url': url, 'text': urlString ? urlString : url});
                                    }
                                }
                            }
                        }
                        renderList.push(renderItem);
                    }
                    return renderList;
                }

                $scope.loadMoreCalendars = function() {
                    offset = offset + limit;
                    searchCalendars(function(calendars) {
                        $scope.loadMoreButton = calendars.length === limit;
                        var newRenderList = processCalendars(calendars);
                        for (var i = 0; i < newRenderList.length; i++) {
                            $scope.renderList.push(newRenderList[i]);
                        }
                    });
                };

                $scope.onSearchClick = function() {
                    offset = 0;
                    searchCalendars(function(calendars) {
                        $scope.loadMoreButton = calendars.length === limit;
                        $scope.renderList = processCalendars(calendars);
                    });
                };

                $scope.onSortClick = function() {
                    var _scope = $scope;
                    var modelData = {
                        currOrder: sortOrder,
                        onSelect: function(newOrder) {
                            sortOrder = newOrder;
                            _scope.onSearchClick();
                        }
                    };
                    dialogService.open("sortOrderPopup", "sortOrderPopup", modelData, {title: getMSG('SelectHead')});
                };

                $scope.onShowCIDClick = function() {
                    var _scope = $scope;
                    var modelData = {
                        currCID: cid,
                        onSet: function(newCid) {
                            dialogService.close("cidSelectPopup");
                            cid = newCid;
                            $scope.cidText = cid ? " CID - " + cid : getMSG('CIDHead');
                            _scope.onSearchClick();

                        }
                    };
                    dialogService.open("cidSelectPopup", "cidSelectPopup", modelData, {title: getMSG('SelectHead')});
                };

                $scope.showDetail = function(calendarId) {
                    var clickedItem = null;
                    for (var i = 0; i < $scope.renderList.length; i++) {
                        var item = $scope.renderList[i];
                        if (item.calendarId === calendarId) {
                            clickedItem = item;
                            break;
                        }
                    }
                    if (clickedItem) {
                        var modelData = {
                            renderItem: clickedItem
                        };
                        dialogService.open("calendarDetailPopup", "calendarDetailPopup", modelData, {title: getMSG('CalendarDetail')});
                    }
                };
            }])

        .controller('sortOrderPopupCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                $scope.currOrder = $scope.model.currOrder;
                var callBack = $scope.model.onSelect;
                $scope.onSortClick = function(newOrder) {
                    callBack && callBack(newOrder);
                    dialogService.close("sortOrderPopup");
                };
            }])

        .controller('cidSelectPopupCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {

                var cid = $scope.model.currCID;
                var setCallback = $scope.model.onSet;

                $scope.onSetClick = function() {
                    cid = '';
                    for (var i in $scope.vals) {
                        cid += $scope.vals[i];
                    }
                    if (cid === '000000' || cid === '------') {
                        cid = '';
                    }
                    setCallback(cid);
                };
                $scope.onClearClick = function() {
                    $scope.cid = '';
                    setCallback('');
                };

                $scope.onBackClick = function() {
                    dialogService.close("cidSelectPopup");
                };

                $scope.index = 0;
                $scope.vals = ["-", "-", "-", "-", "-", "-"];
                if (cid) {
                    var parts = cid.split('');
                    $scope.vals = parts;
                }
                function fillZeros() {
                    for (var i in $scope.vals) {
                        $scope.vals[i] = $scope.vals[i] === "-" ? "0" : $scope.vals[i];
                    }
                }
                $scope.onNumClick = function(num) {
                    if (num === 'f') {
                        $scope.index = $scope.index >= 5 ? 0 : $scope.index + 1;
                    } else if (num === 'b') {
                        $scope.index = $scope.index <= 0 ? 5 : $scope.index - 1;
                    } else {
                        fillZeros();
                        $scope.vals[$scope.index] = num + '';
                        $scope.index = $scope.index >= 5 ? 0 : $scope.index + 1;
                    }
                };

                $scope.onBoxClick = function(num) {
                    $scope.index = num;
                };

            }]);