'use strict';
/*
 * Create event controller
 */
angular.module('controllers.createEvent', [])

        //Event create controller

        .controller('createEventCtrl', ['$rootScope', '$scope', 'dialogService', 'mainSvc', 'eventSvc', 'rruleSvc', 'templateSvc', 'notificationSvc', 'syncSvc',
            function($rootScope, $scope, dialogService, mainSvc, eventSvc, rruleSvc, templateSvc, notificationSvc, syncSvc) {

                var defaultReminder = (jorteConfig.getDefaultReminder() === 'None') ? 10 : jorteConfig.getDefaultReminder();
                var remList = [];
                var day = jorteUtils.formatDate($scope.model.clickedDate, 'ddd');
                var weekDays = [
                    {val: (day === 'Mon') ? true : false, label: getMSG('MonHead'), dayText: 'Mon'},
                    {val: (day === 'Tue') ? true : false, label: getMSG('TueHead'), dayText: 'Tue'},
                    {val: (day === 'Wed') ? true : false, label: getMSG('WedHead'), dayText: 'Wed'},
                    {val: (day === 'Thu') ? true : false, label: getMSG('ThuHead'), dayText: 'Thu'},
                    {val: (day === 'Fri') ? true : false, label: getMSG('FriHead'), dayText: 'Fri'},
                    {val: (day === 'Sat') ? true : false, label: getMSG('SatHead'), dayText: 'Sat'},
                    {val: (day === 'Sun') ? true : false, label: getMSG('SunHead'), dayText: 'Sun'}
                ];
                var calendarList = [];
                var name, startDate, endDate, startTime, endTime, content, fromTask = false;
                if ($scope.model.swapValue && $scope.model.swapValue.val === 2) {//From task create popup
                    fromTask = true;
                    name = $scope.model.swapValue.name;
                    startDate = $scope.model.swapValue.startDate;
                    endDate = $scope.model.swapValue.endDate;
                    startTime = $scope.model.swapValue.startTime;
                    endTime = $scope.model.swapValue.endTime;
                    content = $scope.model.swapValue.content;
                }
                //Default set to none
                if (jorteConfig.getDefaultReminder() !== 'None') {
                    // Init rem button
                    remList.push({id: new Date().getTime(), rem_id: null, type: parseInt(defaultReminder), minutes: parseInt(defaultReminder), label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                }
                var stDt = ($scope.model.clickedDate) ? $scope.model.clickedDate : (startDate && startDate !== '----/--/--' ? startDate : new Date());
                var endDt = ($scope.model.clickedDate) ? $scope.model.clickedDate : (endDate && endDate !== '----/--/--' ? endDate : new Date());
                //Create form params initialization
                $scope.crtEvtParams = {
                    eventName: (name) ? name : '',
                    timeShow: (fromTask) ? false : true,
                    timeDetailShow: (fromTask) ? true : false,
                    timeType: false,
                    timeTypeVal: 0,
                    timeTypeLabel: jorteUtils.dayTimefinder(0),
                    startDate: stDt,
                    startDateDisp: jorteUtils.formatDate(new Date(stDt), getMSG('LongDateFormat2'), cal_string),
                    startTime: (startTime) ? startTime : '--:--',
                    endDate: endDt,
                    endDateDisp: jorteUtils.formatDate(new Date(endDt), getMSG('LongDateFormat2'), cal_string),
                    endTime: (endTime) ? endTime : '--:--',
                    allDay: false,
                    holiday: false,
                    color: null,
                    memo: (content) ? content : null,
                    eventIcon: null,
                    reminder: remList,
                    googleTz: jorteConfig.TIME_ZONE,
                    eventNamePlaceholder: getMSG('EventNameHead'),
                    repeatParams: {
                        currentDate: $scope.model.clickedDate,
                        type: 0,
                        label: jorteUtils.getRepeatText(0),
                        repeatInterval: 1,
                        startDate: jorteUtils.formatDate($scope.model.clickedDate, getMSG('LongDateFormat2'), cal_string),
                        endDate: false, //To show without end date or not
                        specify: false, //To show/hide specify options
                        repNum: 5, //To show repeat number or specify day
                        specifyDay: null,
                        specifyDayWeekly: day,
                        rule: null,
                        weekDays: weekDays, //For weekly
                        stdDate: false, //For monthly
                        outlineLabel: getMSG('OneTimeEventHead')
                    },
                    myCalendar: {
                        showCalendarList: false
                    },
                    template: null,
                    submitOk: false
                };
                $scope.crtEvtParams.headerTitle = jorteUtils.formatDate($scope.crtEvtParams.startDate, getMSG('LongDateFormat2'), cal_string);
                mainSvc.getSelectedCalendars(function(data) {
                    if (data.length === 0) {
                        alert(getMSG('NoCalendarSelectedHead'));
                        dialogService.close("createEventPopup");
                    } else {
                        var pos = 0;
                        for (var j = 0; j < data.length; j++) {
                            if (data[j].id === jorteConfig.getDefaultCalendar()) {
                                pos = j;
                                break;
                            }
                        }
                        calendarList = data;
                        $scope.crtEvtParams.myCalendar.calendarListId = data[pos].id;
                        $scope.crtEvtParams.myCalendar.calendarListName = data[pos].name;
                        $scope.crtEvtParams.myCalendar.calendarType = data[pos].type;
                        $scope.crtEvtParams.myCalendar.cal_global_id = data[pos].global_id;
                    }
                    if (data.length > 1) {
                        $scope.crtEvtParams.myCalendar.showCalendarList = true;
                    }
                    $scope.crtEvtParams.submitOk = true;
                    $scope.$apply();
                });

                //Event icon popup
                $scope.iconListPopup = function() {
                    var iconListModel = {
                        iconSrc: $scope.crtEvtParams.eventIcon,
                        eventIcon: function(val) {
                            $scope.crtEvtParams.eventIcon = val;
                        }
                    };
                    dialogService.open('iconListPopup', 'iconList', iconListModel, {title: getMSG('IconHead')});
                };
                //show event template
                $scope.eventTemplate = function() {
                    var templateModel = {
                        type: 0,
                        selectedTemplate: function(template) {
                            $scope.crtEvtParams.eventName = template;
                        }
                    };
                    dialogService.open("eventTemplateFormPopUp", "eventTemplateForm", templateModel, {title: getMSG('Select_Title')});
                };
                //Date and time picker show function
                $scope.timeDetail = function() {
                    $scope.crtEvtParams.timeShow = false;
                    $scope.crtEvtParams.timeDetailShow = true;
                    $scope.crtEvtParams.timeType = true;
                };
                //Popup for selecting day time
                $scope.eventSessionPopup = function() {
                    var sessionValue = [
                        {startTime: '--:--', endTime: '--:--'},
                        {startTime: '--:--', endTime: '--:--'},
                        {startTime: '05:00', endTime: '10:00'},
                        {startTime: '07:00', endTime: '12:00'},
                        {startTime: '12:00', endTime: '13:00'},
                        {startTime: '13:00', endTime: '18:00'},
                        {startTime: '17:00', endTime: '20:00'},
                        {startTime: '19:00', endTime: '24:00'},
                        {startTime: '23:00', endTime: '26:00'}
                    ];
                    var eventSessionModel = {
                        timeTypeVal: $scope.crtEvtParams.timeTypeVal,
                        dayTime: function(val) {
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(val);
                            $scope.crtEvtParams.timeTypeVal = val;
                            $scope.crtEvtParams.allDay = (val !== 1) ? false : true;//Make all day unchecked if time selection changed
                            $scope.crtEvtParams.startTime = sessionValue[val].startTime;
                            $scope.crtEvtParams.endTime = sessionValue[val].endTime;
                        }
                    };
                    dialogService.open('eventSessionPopup', 'eventSession', eventSessionModel, {title: getMSG('SelectHead')});
                };
                //Set allday
                $scope.setAllDay = function(status) {
                    switch (status) {
                        case true:
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(1);
                            $scope.crtEvtParams.timeTypeVal = 1;
                            $scope.crtEvtParams.allDay = true;
                            $scope.crtEvtParams.startTime = '--:--';
                            $scope.crtEvtParams.endTime = '--:--';
                            break;
                        case false:
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(0);
                            $scope.crtEvtParams.timeTypeVal = 0;
                            $scope.crtEvtParams.allDay = false;
                            break;
                    }
                };
                //Set Holiday
                $scope.setHoliday = function(status) {
                    switch (status) {
                        case true:
                            $scope.crtEvtParams.holiday = true;
                            $scope.crtEvtParams.allDay = false;
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(0);
                            $scope.crtEvtParams.timeTypeVal = 0;
                            $scope.crtEvtParams.startTime = '--:--';
                            $scope.crtEvtParams.endTime = '--:--';
                            break;
                        case false:
                            $scope.crtEvtParams.holiday = false;
                            break;
                    }
                };
                //Color picker
                $scope.colorPickerPopup = function() {
                    var colorModel = {
                        colorCode: ($scope.crtEvtParams.color) ? $scope.crtEvtParams.color : '',
                        selectedColor: function(colorCode) {
                            $scope.crtEvtParams.color = colorCode;
                        }
                    };
                    dialogService.open('colorPickerPopup', 'colorPicker', colorModel, {title: getMSG('SelectColorHead')});
                };
                //Repeat form popup
                $scope.repeatPopup = function() {
                    var repeatModel = {
                        repeatCrtParam: angular.copy($scope.crtEvtParams.repeatParams),
                        repeatCrtParamsCb: function(rVal) {
                            $scope.crtEvtParams.repeatParams = rVal;
                        }
                    };
                    dialogService.open('repeat0Popup', 'repeat0', repeatModel, {title: getMSG('RepeatSelectHead')});
                };
                // Add new
                $scope.reminderAdd = function() {
                    if (remList.length < 5) {
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                    }
                };
                // Remove
                $scope.reminderRemove = function(pos) {
                    remList.splice(pos, 1);
                };
                $scope.showReminderPopup = function(val, pos) {
                    // The data for the dialog
                    var reminderModel = {
                        remPos: pos,
                        remVal: val,
                        reminderVal: function(val, pos) {
                            remList.splice(pos, 1, {id: new Date().getTime(), rem_id: null, type: val, minutes: val, label: jorteUtils.getReminderText(parseInt(val))});
                        }
                    };
                    dialogService.open("reminderPopup", "reminder", reminderModel, {refreshPopup: true, title: getMSG('SelectHead')});
                };
                //Create event popup
                $scope.createEvent = function() {
                    $scope.crtEvtParams.submitOk = true;
                    var create_date = new Date().getTime(), complete_date = null, update_date = (new Date()).getTime();
                    var calendar_id = $scope.crtEvtParams.myCalendar.calendarListId;

                    var type = $scope.crtEvtParams.myCalendar.calendarType === 300 ? 300 : 1;
                    var timezone = $scope.crtEvtParams.myCalendar.calendarType !== 300 ? jorteConfig.TIME_ZONE : $scope.crtEvtParams.googleTz;
                    var name = ($scope.crtEvtParams.eventName.replace(/^\s\s*/, '')) ? $scope.crtEvtParams.eventName.replace(/^\s\s*/, '') : null;
                    var content = ($scope.crtEvtParams.memo) ? $scope.crtEvtParams.memo : null;
                    var location = ($scope.crtEvtParams.location) ? $scope.crtEvtParams.location : null;
                    var all_day = ($scope.crtEvtParams.allDay) ? 1 : 0;
                    var holiday = ($scope.crtEvtParams.holiday) ? 1 : 0;
                    var importance = ($scope.crtEvtParams.important) ? 1 : 0;
                    var completed = ($scope.crtEvtParams.completed) ? 1 : 0;
                    var hours = 0;
                    var minutes = 0;
                    var ehours = 23;
                    var eminutes = 59;

                    var day_time = $scope.crtEvtParams.timeTypeVal;
                    var start_time = $scope.crtEvtParams.startTime;
                    var startTime = null;
                    var endTime = null;

                    if (start_time !== '--:--' && all_day === 0 && holiday === 0) {
                        var start_time_arr = start_time.split(':');
                        hours = start_time_arr[0];
                        minutes = start_time_arr[1];
                        startTime = 60 * parseInt(hours) + parseInt(minutes);
                    }
                    
                    var start_date_obj = $scope.crtEvtParams.startDate;
                    var sdate = new Date(start_date_obj.getFullYear(), start_date_obj.getMonth(), start_date_obj.getDate(), hours, minutes, 0);
                    sdate = jorteUtils.calcTime(timezone, sdate.getTime());
                    var start_date = sdate.getTime();
                    var end_time = (day_time === 7) ? '23:59' : $scope.crtEvtParams.endTime; //Check for night event

                    if (end_time !== '--:--' && all_day === 0 && holiday === 0) {
                        var end_time_arr = end_time.split(':');
                        ehours = end_time_arr[0];
                        eminutes = end_time_arr[1];
                        endTime = 60 * parseInt(ehours) + parseInt(eminutes);
                    }

                    var end_date_obj = $scope.crtEvtParams.endDate;
                    var edate = new Date(end_date_obj.getFullYear(), end_date_obj.getMonth(), end_date_obj.getDate(), ehours, eminutes, 0);
                    edate = jorteUtils.calcTime(timezone, edate.getTime());
                    var end_date = edate.getTime();
                    var icon = $scope.crtEvtParams.eventIcon;
                    var color = $scope.crtEvtParams.color;                    
                    if (completed === 1) {
                        complete_date = new Date().getTime();
                    }
                    var repeatSelectObj = null;
                    var rule = null;
                    var repeatFlag = false;
                    var long_flag = false;
                    var repeatParams = $scope.crtEvtParams.repeatParams;
                    var specifyDay = repeatParams.specifyDay;
                    if (specifyDay) {
                        specifyDay = new Date(specifyDay);
                        var d = new Date(specifyDay.getFullYear(), specifyDay.getMonth(), specifyDay.getDate(), ehours, eminutes, 0);
                        d.setTime(d.getTime() - d.getTimezoneOffset() * 60 * 1000);
                        repeatParams.specifyDay = d;
                    }
                    repeatParams.rule = rruleSvc.getRRule(repeatParams);
                    var repeat = repeatParams.rule;
                    if (repeat) {
                        repeat = repeat.toString();
                        repeatSelectObj = RRule.parseString(repeat);
                        if (!repeatSelectObj.count && !repeatSelectObj.until) {
                            repeatSelectObj.count = 90;
                            repeatFlag = true;
                        }
                        repeatSelectObj.dtstart = sdate;
                        rule = new RRule(repeatSelectObj);
                    }

                    if ((end_date - start_date) > (1000 * 60 * 60 * 24)) {
                        long_flag = true;
                    }

                    var date_diff = end_date - start_date;
                    var instance_dates = [sdate.toString()];
                    var length = instance_dates.length;
                    var last_date = null;

                    if (rule) {
                        instance_dates = rule.all();
                        instance_dates = instance_dates.toString().split(',');
                        if(!instance_dates || instance_dates.length===1 && instance_dates[0]===""){
                            instance_dates = [sdate.toString()];
                        }
                        if (repeatFlag && instance_dates.length !== 0) {
                            length = instance_dates.length - 1;
                        }else{
                            length = instance_dates.length - 1;
                        }
                        last_date = new Date(instance_dates[length]).getTime();
                    }
                    var beginDates = [], reminderList = [];
                    for (var i = 0; i < length; i++) {
                        var begin = new Date(instance_dates[i]).getTime();
                        beginDates.push(begin); //For setting alarm/notification
                    }
                    for (var i = 0; i < remList.length; i++) {
                        var rem = remList[i];
                        var reminder = {};
                        reminder.id = rem['id'];
                        reminder.minutes = parseInt(rem['minutes']), reminder.type = parseInt(rem['type']);
                        reminder.beginDates = beginDates;
                        reminderList.push(reminder);
                    }
                    var event = new EventJorte();
                    event.calendar_id = calendar_id, event.name = name, event.content = content, event.icon = icon, event.color = color,
                            event.start_date = start_date, event.end_date = end_date, event.start_time = startTime, event.end_time = endTime,
                            event.type = type, event.timezone = timezone, event.repeat = repeat, event.importance = importance, event.all_day = all_day,
                            event.holiday = holiday, event.day_time = day_time, event.location = location, event.completed = completed,
                            event.complete_date = complete_date, event.create_date = create_date, event.update_date = update_date,
                            event.last_date = last_date, event.reminders = reminderList, event.rep_flag = repeat ? 1 : 0, event.long_flag = long_flag ? 1 : 0;
                    var tm;
                    if (name) {
                        var tm = new TemplateJorte();
                        tm.event_name = name, tm.flag = 1, tm.create_date = create_date, tm.update_date = update_date, tm.type = 0;
                    }
                    var data = {
                        event: event,
                        instance_dates: instance_dates,
                        repeatSelectObj: repeatSelectObj,
                        date_diff: date_diff
                    };
                    eventSvc.createEvent(data, function(eventId) {
                        data.event.id = eventId;
                        if (jorteConfig.getDefaultCalendar() !== calendar_id) {
                            if (confirm(getMSG('ChangeDefCalHead'))) {
                                jorteConfig.setDefaultCalendar(calendar_id);
                            }
                        }
                        if (tm) {
                            templateSvc.createUniqueHistory(tm, function() {
                            });
                        }
                        notificationSvc.itemUpdateStatusCheck(eventId, true);

                        var params = {id: eventId, calendar_id: calendar_id, calendar_type: type};
                        if (type !== 300) {
                            params.jorteCalendar = true;
                        } else {
                            params.googleCalendar = true;
                        }
                        $rootScope.$broadcast('eventAdded', {createdDate: $scope.crtEvtParams.startDate, event_id: eventId});
                        var bData = angular.copy(data);
                        bData.clickedDate = $scope.model.clickedDate;
                        bData.event_id = eventId;
                        if ($scope.crtEvtParams.myCalendar.cal_global_id) {
                            syncSvc.syncSingleEvent(params, function () {
                                setTimeout(function () {
                                    $rootScope.$broadcast('eventUpdated', bData);
                                }, 10);

                            });
                        }
                        dialogService.close('createEventPopup');
                    });
                };
                //Close popup
                $scope.closePopup = function() {
                    var r = confirm(getMSG('ExitSaveHead'));
                    if (r === true) {
                        dialogService.close('createEventPopup');
                    }
                };
                //Swap between task and events
                $scope.swapEvent = function() {
                    // The data for the dialog
                    var swapModel = {
                        val: 1,
                        name: $scope.crtEvtParams.eventName,
                        startDate: $scope.crtEvtParams.startDate,
                        endDate: $scope.crtEvtParams.endDate,
                        startTime: $scope.crtEvtParams.startTime,
                        endTime: $scope.crtEvtParams.endTime,
                        content: $scope.crtEvtParams.memo
                    };
                    dialogService.open("swapEventPopup", "swapEvent", swapModel, {title: getMSG('SelectHead')});
                };

                function findCalendar(id) {
                    var calendar;
                    for (var i = 0, item = null; i < calendarList.length; i++) {
                        item = calendarList[i];
                        if (item.id === id) {
                            calendar = item;
                            break;
                        }
                    }
                    return calendar;
                }
                $scope.showMyCalendarList = function() {
                    var calendarListModel = {
                        calendarList: angular.copy(calendarList),
                        calendarListId: $scope.crtEvtParams.myCalendar.calendarListId,
                        calendarListIdCb: function(calendarListId, name) {
                            $scope.crtEvtParams.myCalendar.calendarListId = calendarListId;
                            $scope.crtEvtParams.myCalendar.calendarListName = name;
                            var calendar = findCalendar(calendarListId);
                            $scope.crtEvtParams.myCalendar.calendarType = calendar.type;
                            $scope.crtEvtParams.myCalendar.cal_global_id = calendar.global_id;
                            if ($scope.crtEvtParams.myCalendar.calendarType === 300) {
                                $scope.crtEvtParams.timeShow = false;
                                $scope.crtEvtParams.timeDetailShow = true;
                            } else {
                                $scope.crtEvtParams.googleTz = jorteConfig.TIME_ZONE;
                            }
                        }
                    };
                    dialogService.open("myCalendarListPopup", "myCalendarList", calendarListModel, {refreshPopup: true, minHeight: 160, title: getMSG('SelectHead')});
                };
                //Google timezone
                $scope.googleTimezone = function() {
                    var gTzModel = {
                        defTz: $scope.crtEvtParams.googleTz,
                        googleTimeZoneCb: function(val) {
                            $scope.crtEvtParams.googleTz = val;
                        }
                    };
                    dialogService.open("googleTimezonePopup", "googleTimezone", gTzModel, {title: getMSG('SelectHead')});
                };
                $scope.onShowTimeClick = function(type) {
                    var time = null;
                    if (type === 1) {
                        time = $scope.crtEvtParams.startTime;
                    } else if (type === 2) {
                        time = $scope.crtEvtParams.endTime;
                    }
                    if (!time) {
                        return;
                    }

                    time = time.replace(':', '');
                    var modelData = {
                        currTime: time,
                        onSet: function(newTime) {
                            dialogService.close("timeSelectPopup");
                            if (type === 1) {
                                $scope.crtEvtParams.startTime = newTime;
                                if ($scope.crtEvtParams.startDate === $scope.crtEvtParams.endDate) {
                                    if ($scope.crtEvtParams.endTime !== '--:--' && newTime > $scope.crtEvtParams.endTime) {
                                        $scope.crtEvtParams.endTime = newTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.crtEvtParams.endTime = newTime;
                                if ($scope.crtEvtParams.startDate === $scope.crtEvtParams.endDate) {
                                    if ($scope.crtEvtParams.startTime !== '--:--' && newTime !== '--:--' && newTime < $scope.crtEvtParams.startTime) {
                                        $scope.crtEvtParams.startTime = newTime;
                                    }
                                }
                            }
                        }
                    };
                    dialogService.open("timeSelectPopup", "timeSelectPopup", modelData, {title: getMSG('SetTimeHead'), width: '70%'});
                };
                $scope.onShowDateClick = function(type) {
                    var date = null;
                    if (type === 1) {
                        date = $scope.crtEvtParams.startDate;
                    } else if (type === 2) {
                        date = $scope.crtEvtParams.endDate;
                    }
                    if (!date) {
                        date = new Date();
                    }
                    var modelData = {
                        currDate: date,
                        onSet: function(newDate) {

                            if (type === 1) {
                                $scope.crtEvtParams.startDate = newDate;
                                $scope.crtEvtParams.startDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                if (newDate > $scope.crtEvtParams.endDate) {
                                    $scope.crtEvtParams.endDate = newDate;
                                    $scope.crtEvtParams.endDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                }
                                if ($scope.crtEvtParams.startDate === $scope.crtEvtParams.endDate) {
                                    if ($scope.crtEvtParams.endTime !== '--:--' && $scope.crtEvtParams.startTime > $scope.crtEvtParams.endTime) {
                                        $scope.crtEvtParams.endTime = $scope.crtEvtParams.startTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.crtEvtParams.endDate = newDate;
                                $scope.crtEvtParams.endDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                if ($scope.crtEvtParams.startDate > newDate) {
                                    $scope.crtEvtParams.startDate = newDate;
                                    $scope.crtEvtParams.startDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                }
                                if ($scope.crtEvtParams.startDate === $scope.crtEvtParams.endDate) {
                                    if ($scope.crtEvtParams.startTime !== '--:--' && $scope.crtEvtParams.endTime < $scope.crtEvtParams.startTime) {
                                        $scope.crtEvtParams.startTime = $scope.crtEvtParams.endTime;
                                    }
                                }
                            }
                            dialogService.close("dateSelectPopup");
                        }
                    };
                    var titleDate = jorteUtils.formatDate(date, getMSG('LongDateFormat2'), cal_string);
                    dialogService.open("dateSelectPopup", "dateSelectPopup", modelData, {title: titleDate});
                };
            }
        ])
        //Calendar list controller
        .controller('myCalendarListCtrl', ['$scope', 'dialogService',
            function($scope, dialogService) {
                // The data for the dialog
                $scope.calendarList = $scope.model.calendarList;
                $scope.calendarListId = $scope.model.calendarListId;
                $scope.selectCalendarList = function(id, name) {
                    $scope.model.calendarListIdCb(id, name);
                    dialogService.close("myCalendarListPopup");
                };
            }]);
     