'use strict';
/*
 * Create event controller
 */
angular.module('controllers.editEvent', [])

        //Event create controller
        .controller('editEventCtrl', ['$rootScope', '$scope', 'dialogService', 'eventSvc', 'rruleSvc', 'mainSvc', 'syncSvc', 'notificationSvc',
            function ($rootScope, $scope, dialogService, eventSvc, rruleSvc, mainSvc, syncSvc, notificationSvc) {
                var editRepeatType = $scope.model.repeatType || 2; //1:edit single event,2:edit all events,3:edit this & future events
                var clickedDate = $scope.model.clickedDate;
                var eventItem = $scope.model.item;
                var oldEventCancelled = eventItem.cancelled;
                var event_id = eventItem.id;
                var remList = [];
                var defaultReminder = (jorteConfig.getDefaultReminder() === 'None') ? 10 : jorteConfig.getDefaultReminder();
                for (var i = 0; i < eventItem.reminders.length; i++) {
                    var rem = eventItem.reminders[i];
                    remList.push({id: rem.id, rem_id: null, type: rem.type, minutes: rem.minutes, label: jorteUtils.getReminderText(parseInt(rem.type))});
                }
                var startDate_obj, endDate_obj;
                if (editRepeatType === 1 || editRepeatType === 3) {
                    startDate_obj = (eventItem.start_date) ? jorteUtils.calcTimeLocal(eventItem.timezone, eventItem.start_date) : new Date();
                    endDate_obj = (eventItem.end_date) ? jorteUtils.calcTimeLocal(eventItem.timezone, eventItem.end_date) : new Date();
                } else if (editRepeatType === 2 || !editRepeatType) {
                    startDate_obj = (eventItem.event_start) ? jorteUtils.calcTimeLocal(eventItem.timezone, eventItem.event_start) : new Date();
                    endDate_obj = (eventItem.event_end) ? jorteUtils.calcTimeLocal(eventItem.timezone, eventItem.event_end) : new Date();
                }
                var endDateObj = endDate_obj;
                var startTimeDisp;
                if (eventItem.start_time) {
                    startTimeDisp = jorteUtils.formatDate(startDate_obj, 'HH:mm');
                } else {
                    if (eventItem.start_time === 0) {
                        startTimeDisp = '00:00';
                    } else {
                        startTimeDisp = '--:--';
                    }
                }
                var endTimeDisp;
                if (eventItem.end_time) {
                    endTimeDisp = (eventItem.day_time === 7) ? '24:00' : jorteUtils.formatDate(endDate_obj, 'HH:mm');
                } else {
                    if (eventItem.end_time === 0) {
                        endTimeDisp = '00:00';
                    } else {
                        endTimeDisp = '--:--';
                    }
                }
                if(eventItem.day_time === 8){
                    jorteUtils.addDays(endDateObj, -1, true);
                    endTimeDisp =  jorteUtils.parseMinutes(eventItem.end_time);
                }
                var repeat_str = (eventItem.repeat) ? eventItem.repeat : null;
                //show event template
                $scope.eventTemplate = function () {
                    var templateModel = {
                        type: 0,
                        selectedTemplate: function (template) {
                            $scope.crtEvtParams.eventName = template;
                        }
                    };
                    dialogService.open("eventTemplateFormPopUp", "eventTemplateForm", templateModel, {title: getMSG('Select_Title')});
                };

                var day = jorteUtils.formatDate(startDate_obj, 'ddd');
                var weekDays = [
                    {val: (day === 'Mon') ? true : false, label: getMSG('MonHead'), dayText: 'Mon'},
                    {val: (day === 'Tue') ? true : false, label: getMSG('TueHead'), dayText: 'Tue'},
                    {val: (day === 'Wed') ? true : false, label: getMSG('WedHead'), dayText: 'Wed'},
                    {val: (day === 'Thu') ? true : false, label: getMSG('ThuHead'), dayText: 'Thu'},
                    {val: (day === 'Fri') ? true : false, label: getMSG('FriHead'), dayText: 'Fri'},
                    {val: (day === 'Sat') ? true : false, label: getMSG('SatHead'), dayText: 'Sat'},
                    {val: (day === 'Sun') ? true : false, label: getMSG('SunHead'), dayText: 'Sun'}
                ];
                //Create form params initialization
                $scope.crtEvtParams = {
                    eventName: (eventItem.name) ? eventItem.name : '',
                    timeShow: true,
                    timeDetailShow: false,
                    timeType: false,
                    timeTypeLabel: jorteUtils.dayTimefinder(eventItem.day_time),
                    timeTypeVal: eventItem.day_time,
                    startDate: startDate_obj,
                    startDateDisp: jorteUtils.formatDate(new Date(startDate_obj), getMSG('LongDateFormat2'), cal_string),
                    startTime: startTimeDisp,
                    endDate: endDateObj,
                    endDateDisp: jorteUtils.formatDate(new Date(endDateObj), getMSG('LongDateFormat2'), cal_string),
                    endTime: endTimeDisp,
                    allDay: (eventItem.all_day === 1) ? true : false,
                    holiday: (eventItem.holiday) ? true : false,
                    color: (eventItem.color) ? eventItem.color : null,
                    eventIcon: (eventItem.icon) ? eventItem.icon : null,
                    important: (eventItem.importance) ? 1 : 0,
                    completed: (eventItem.completed) ? 1 : 0,
                    location: (eventItem.location) ? eventItem.location : null,
                    memo: (eventItem.content) ? eventItem.content : null,
                    reminder: remList,
                    allDayLabel: jorteUtils.dayTimefinder(1),
                    noneLabel: jorteUtils.dayTimefinder(0),
                    showCalendarList: false,
                    calendarListId: eventItem.calendar_id,
                    calendarListName: (eventItem.calendar) ? eventItem.calendar : getMSG('MyCalenderHead'),
                    calendarType: eventItem.calendar_type,
                    cal_global_id: eventItem.cal_global_id,
                    sync_events: eventItem.sync_events,
                    googleTz: (eventItem.timezone) ? eventItem.timezone : jorteConfig.TIME_ZONE,
                    popTitle: $scope.model.title,
                    eventNamePlaceholder: getMSG('EventNameHead'),
                    disableRepeat: editRepeatType === 1 || eventItem.parent ? true : false,
                    is_repeat: eventItem.repeat && editRepeatType === 2 ? true : false,
                    repeatParams: {
                        currentDate: startDate_obj,
                        type: 0,
                        label: jorteUtils.getRepeatText(0),
                        repeatInterval: 1,
                        startDate: jorteUtils.formatDate(new Date(startDate_obj), getMSG('LongDateFormat2'), cal_string),
                        endDate: false, //To show without end date or not
                        specify: false, //To show/hide specify options
                        repNum: 5, //To show repeat number or specify day
                        specifyDay: null,
                        specifyDayWeekly: day,
                        rule: null,
                        weekDays: weekDays, //For weekly
                        stdDate: false, //For monthly
                        outlineLabel: getMSG('OneTimeEventHead')
                    }
                };
                $scope.crtEvtParams.headerTitle = jorteUtils.formatDate($scope.model.clickedDate, getMSG('LongDateFormat2'), cal_string);

                //Event icon popup
                $scope.iconListPopup = function () {
                    var mHt = $(window).height() / 2;
                    var iconListModel = {
                        iconSrc: $scope.crtEvtParams.eventIcon,
                        eventIcon: function (val) {
                            $scope.crtEvtParams.eventIcon = val;
                        }
                    };
                    dialogService.open('iconListPopup', 'iconList', iconListModel, {title: getMSG('IconHead'), minHeight: mHt});
                };

                //Date and time picker show function
                $scope.timeDetail = function () {
                    $scope.crtEvtParams.timeShow = false;
                    $scope.crtEvtParams.timeDetailShow = true;
                    $scope.crtEvtParams.timeType = true;
                    $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(eventItem.day_time);
                    $scope.crtEvtParams.timeTypeVal = eventItem.day_time;
                };
                //Popup for selecting day time
                $scope.eventSessionPopup = function () {
                    var sessionValue = [
                        {startTime: '--:--', endTime: '--:--'},
                        {startTime: '--:--', endTime: '--:--'},
                        {startTime: '05:00', endTime: '10:00'},
                        {startTime: '07:00', endTime: '12:00'},
                        {startTime: '12:00', endTime: '13:00'},
                        {startTime: '13:00', endTime: '18:00'},
                        {startTime: '17:00', endTime: '20:00'},
                        {startTime: '19:00', endTime: '24:00'},
                        {startTime: '23:00', endTime: '26:00'}
                    ];
                    var eventSessionModel = {
                        timeTypeVal: $scope.crtEvtParams.timeTypeVal,
                        dayTime: function (val) {
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(val);
                            $scope.crtEvtParams.timeTypeVal = val;
                            $scope.crtEvtParams.allDay = (val !== 1) ? false : true;//Make all day unchecked if time selection changed
                            $scope.crtEvtParams.startTime = sessionValue[val].startTime;
                            $scope.crtEvtParams.endTime = sessionValue[val].endTime;
                        }
                    };
                    dialogService.open('eventSessionPopup', 'eventSession', eventSessionModel, {title: getMSG('SelectHead')});
                };
                //Set allday
                $scope.setAllDay = function(status) {
                    switch (status) {
                        case true:
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(1);
                            $scope.crtEvtParams.timeTypeVal = 1;
                            $scope.crtEvtParams.allDay = true;
                            $scope.crtEvtParams.startTime = '--:--';
                            $scope.crtEvtParams.endTime = '--:--';
                            break;
                        case false:
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(0);
                            $scope.crtEvtParams.timeTypeVal = 0;
                            $scope.crtEvtParams.allDay = false;
                            break;
                    }
                };
                //Set Holiday
                $scope.setHoliday = function(status) {
                    switch (status) {
                        case true:
                            $scope.crtEvtParams.holiday = true;
                            $scope.crtEvtParams.allDay = false;
                            $scope.crtEvtParams.timeTypeLabel = jorteUtils.dayTimefinder(0);
                            $scope.crtEvtParams.timeTypeVal = 0;
                            $scope.crtEvtParams.startTime = '--:--';
                            $scope.crtEvtParams.endTime = '--:--';
                            break;
                        case false:
                            $scope.crtEvtParams.holiday = false;
                            break;
                    }
                };
                //Color picker
                $scope.colorPickerPopup = function () {
                    var colorModel = {
                        colorCode: ($scope.crtEvtParams.color) ? $scope.crtEvtParams.color : '',
                        selectedColor: function (colorCode) {
                            $scope.crtEvtParams.color = colorCode;
                        }
                    };
                    dialogService.open('colorPickerPopup', 'colorPicker', colorModel, {title: getMSG('SelectColorHead')});
                };

                /*
                 * Repeat form values
                 */
                if (repeat_str) {
                    var repeatSelectObj = null;
                    repeatSelectObj = RRule.parseString(repeat_str);
                    if (repeatSelectObj.freq === RRule.DAILY) { //Daily
                        $scope.crtEvtParams.repeatParams.type = 1;
                        $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(1);
                        getRepeatVal(repeatSelectObj, 1);
                    } else if (repeatSelectObj.freq === RRule.WEEKLY) { //Weekly
                        var days = repeatSelectObj.byweekday;
                        days = days.toString();
                        //Mon to Fri
                        if (days.indexOf("MO") !== -1 && days.indexOf("TU") !== -1 && days.indexOf("WE") !== -1
                                && days.indexOf("TH") !== -1 && days.indexOf("FR") !== -1 && days.indexOf("SA") === -1
                                && days.indexOf("SU") === -1) {
                            $scope.crtEvtParams.repeatParams.type = 2;
                            $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(2);
                            getRepeatVal(repeatSelectObj, 2);
                        } else if (days.indexOf("MO") !== -1 && days.indexOf("TU") === -1 && days.indexOf("WE") !== -1
                                && days.indexOf("TH") === -1 && days.indexOf("FR") !== -1 && days.indexOf("SA") === -1
                                && days.indexOf("SU") === -1) {
                            //Mon, wed,fri
                            $scope.crtEvtParams.repeatParams.type = 3;
                            $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(3);
                            getRepeatVal(repeatSelectObj, 3);
                        } else if (days.indexOf("MO") === -1 && days.indexOf("TU") !== -1 && days.indexOf("WE") === -1
                                && days.indexOf("TH") !== -1 && days.indexOf("FR") === -1 && days.indexOf("SA") === -1
                                && days.indexOf("SU") === -1) {
                            //Tue,Thu
                            $scope.crtEvtParams.repeatParams.type = 3;
                            $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(3);
                            getRepeatVal(repeatSelectObj, 3);
                        } else {
                            //Weekly
                            $scope.crtEvtParams.repeatParams.type = 4;
                            $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(4);
                            getRepeatVal(repeatSelectObj, 4);
                        }
                    } else if (repeatSelectObj.freq === RRule.MONTHLY) { //Monthly
                        $scope.crtEvtParams.repeatParams.type = 5;
                        $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(5);
                        getRepeatVal(repeatSelectObj, 5);
                    } else if (repeatSelectObj.freq === RRule.YEARLY) { //Yearly
                        $scope.crtEvtParams.repeatParams.type = 6;
                        $scope.crtEvtParams.repeatParams.label = jorteUtils.getRepeatText(6);
                        getRepeatVal(repeatSelectObj, 6);
                    }
                }
                //Repeat form popup
                $scope.repeatPopup = function () {
                    var repeatModel = {
                        repeatCrtParam: angular.copy($scope.crtEvtParams.repeatParams),
                        repeatCrtParamsCb: function (rVal) {
                            $scope.crtEvtParams.repeatParams = rVal;
                        }
                    };
                    dialogService.open('repeat0Popup', 'repeat0', repeatModel, {title: getMSG('RepeatSelectHead')});
                };

                // Add new
                $scope.reminderAdd = function () {
                    if (remList.length < 5) {
                        remList.push({id: new Date().getTime(), rem_id: null, type: defaultReminder, minutes: defaultReminder, label: jorteUtils.getReminderText(parseInt(defaultReminder))});
                    }
                };
                // Remove
                $scope.reminderRemove = function (pos) {
                    remList.splice(pos, 1);
                };
                //Reminder select popup
                $scope.showReminderPopup = function (val, pos) {
                    // The data for the dialog
                    var reminderModel = {
                        remPos: pos,
                        remVal: val,
                        reminderVal: function (val, pos) {
                            remList.splice(pos, 1, {id: new Date().getTime(), rem_id: null, type: val, minutes: val, label: jorteUtils.getReminderText(parseInt(val))});
                        }
                    };
                    dialogService.open("reminderPopup", "reminder", reminderModel, {refreshPopup: true, title: getMSG('SelectHead')});
                };
                //Close popup
                $scope.closePopup = function () {
                    var r = confirm(getMSG('ExitSaveHead'));
                    if (r === true) {
                        dialogService.close('eventEditPopup');
                    }
                };
                //Create event popup
                $scope.editEvent = function () {
                    var complete_date = null, update_date = (new Date()).getTime();
                    var calendar_id = $scope.crtEvtParams.calendarListId;
                    var calendarType = $scope.crtEvtParams.calendarType;
                    var type = $scope.crtEvtParams.calendarType === 300 ? 300 : 1;
                    var timezone = $scope.crtEvtParams.googleTz;
                    var name = ($scope.crtEvtParams.eventName.replace(/^\s\s*/, '')) ? $scope.crtEvtParams.eventName.replace(/^\s\s*/, '') : null;
                    var content = ($scope.crtEvtParams.memo) ? $scope.crtEvtParams.memo : null;
                    var location = ($scope.crtEvtParams.location) ? $scope.crtEvtParams.location : null;
                    var all_day = ($scope.crtEvtParams.allDay) ? 1 : 0;
                    var holiday = ($scope.crtEvtParams.holiday) ? 1 : 0;
                    var importance = ($scope.crtEvtParams.important) ? 1 : 0;
                    var completed = ($scope.crtEvtParams.completed) ? 1 : 0;
                    var hours = 0;
                    var minutes = 0;
                    var ehours = 23;
                    var eminutes = 59;
                    var cancelled = [];
                    var deleteChild = false;

                    var day_time = $scope.crtEvtParams.timeTypeVal;
                    var start_time = $scope.crtEvtParams.startTime;
                    var startTime = null;
                    var endTime = null;

                    if (start_time !== '--:--' && all_day === 0 && holiday === 0) {
                        var start_time_arr = start_time.split(':');
                        hours = start_time_arr[0];
                        minutes = start_time_arr[1];
                        startTime = 60 * parseInt(hours) + parseInt(minutes);
                    }

                    var start_date_obj = $scope.crtEvtParams.startDate;
                    var sdate = new Date(start_date_obj.getFullYear(), start_date_obj.getMonth(), start_date_obj.getDate(), hours, minutes, 0);
                    sdate = jorteUtils.calcTime(timezone, sdate.getTime());
                    var start_date = sdate.getTime();

                    var end_time = (day_time === 7) ? '23:59' : $scope.crtEvtParams.endTime; //Check for night event

                    if (end_time !== '--:--' && all_day === 0 && holiday === 0) {
                        var end_time_arr = end_time.split(':');
                        ehours = end_time_arr[0];
                        eminutes = end_time_arr[1];
                        endTime = 60 * parseInt(ehours) + parseInt(eminutes);
                    }

                    var end_date_obj = $scope.crtEvtParams.endDate;
                    var edate = new Date(end_date_obj.getFullYear(), end_date_obj.getMonth(), end_date_obj.getDate(), ehours, eminutes, 0);
                    edate = jorteUtils.calcTime(timezone, edate.getTime());
                    var end_date = edate.getTime();

                    var icon = $scope.crtEvtParams.eventIcon;
                    var color = $scope.crtEvtParams.color;
                    if (completed === 1) {
                        complete_date = new Date().getTime();
                    }
                    $scope.crtEvtParams.repeatParams.rule = rruleSvc.getRRule($scope.crtEvtParams.repeatParams);
                    var repeatSelectObj = null;
                    var rule = null;
                    var repeatFlag = false;
                    var long_flag = false;
                    var exdate = eventItem.exdate;                   
                    var repeatParams = $scope.crtEvtParams.repeatParams;
                    var specifyDay = repeatParams.specifyDay;
                    if (specifyDay) {
                        specifyDay = new Date(specifyDay);
                        var d = new Date(specifyDay.getFullYear(), specifyDay.getMonth(), specifyDay.getDate(), ehours, eminutes, 0);
                        d.setTime(d.getTime() - d.getTimezoneOffset() * 60 * 1000);
                        repeatParams.specifyDay = d;
                    }
                    repeatParams.rule = rruleSvc.getRRule(repeatParams);
                    var repeat = editRepeatType !== 1 ? repeatParams.rule : null;
                    if (repeat) {
                        repeat = repeat.toString();
                        repeatSelectObj = RRule.parseString(repeat);
                        if (!repeatSelectObj.count && !repeatSelectObj.until) {
                            repeatSelectObj.count = 90;
                            repeatFlag = true;
                        }
                        repeatSelectObj.dtstart = sdate;
                        rule = new RRule(repeatSelectObj);
                    }

                    if ((end_date - start_date) > (1000 * 60 * 60 * 24)) {
                        long_flag = true;
                    }

                    var date_diff = end_date - start_date;
                    var instance_dates = [sdate.toString()];
                    var length = instance_dates.length;
                    var last_date = null;

                    if (rule) {
                        instance_dates = rule.all();
                        instance_dates = instance_dates.toString().split(',');
                        if (!instance_dates || instance_dates.length === 1 && instance_dates[0] === "") {
                            instance_dates = [sdate.toString()];
                        }
                        if (oldEventCancelled) {
                            cancelled = oldEventCancelled;
                            if (instance_dates) {
                                for (var k = 0; k < instance_dates.length; k++) {
                                    if (cancelled.indexOf(new Date(instance_dates[k]).getTime()) > -1) {
                                        instance_dates.splice(k, 1);
                                        k--;
                                    }
                                }
                            }
                        }
                        if (repeatFlag && instance_dates.length !== 0) {
                            length = instance_dates.length - 1;
                        } else {
                            length = instance_dates.length - 1;
                        }
                        last_date = new Date(instance_dates[length]).getTime();
                    }
                    var beginDates = [], reminderList = [];
                    for (var i = 0; i < length; i++) {
                        var begin = new Date(instance_dates[i]).getTime();
                        beginDates.push(begin); //For setting alarm/notification
                    }
                    for (var i = 0; i < remList.length; i++) {
                        var rem = remList[i];
                        var reminder = {};
                        reminder.id = rem['id'];
                        reminder.minutes = parseInt(rem['minutes']), reminder.type = parseInt(rem['type']);
                        reminder.beginDates = beginDates;
                        reminderList.push(reminder);
                    }
                    if (eventItem.start_date === eventItem.event_start && editRepeatType === 3) {
                        editRepeatType = 2;
                    }
                    switch (editRepeatType) {
                        case 1:
                            repeat = null;
                            var event = new EventJorte();
                            event.calendar_id = calendar_id, event.name = name, event.content = content, event.icon = icon, event.color = color,
                                    event.start_date = start_date, event.end_date = end_date, event.start_time = startTime, event.end_time = endTime,
                                    event.type = type, event.timezone = timezone, event.repeat = repeat, event.importance = importance, event.all_day = all_day,
                                    event.holiday = holiday, event.day_time = day_time, event.location = location, event.completed = completed,
                                    event.complete_date = complete_date, event.create_date = update_date, event.update_date = update_date,
                                    event.last_date = last_date, event.reminders = reminderList, event.rep_flag = repeat ? 1 : 0, event.long_flag = long_flag ? 1 : 0,
                                    event.originalStartDate = eventItem.start_date, event.originalTimezone = eventItem.timezone, event.parent = eventItem.id, event.parent_global = eventItem.global_id;
                            event.seqno = eventItem.seqno, event.sync_version = eventItem.sync_version;
                            var data = {
                                event: event,
                                instance_dates: instance_dates,
                                repeatSelectObj: repeatSelectObj,
                                date_diff: date_diff
                            };
                            eventSvc.createEvent(data, function (eventId) {
                                data.event.id = eventId;
                                if (jorteConfig.getDefaultCalendar() !== calendar_id) {
                                    if (confirm(getMSG('ChangeDefCalHead'))) {
                                        jorteConfig.setDefaultCalendar(calendar_id);
                                    }
                                }
                                notificationSvc.itemUpdateStatusCheck(eventId, true);
                                var params = {id: eventId, calendar_id: calendar_id, calendar_type: type};
                                if (type !== 300) {
                                    params.jorteCalendar = true;
                                } else {
                                    params.googleCalendar = true;
                                }
                                $rootScope.$broadcast('eventAdded', {createdDate: $scope.crtEvtParams.startDate, event_id: eventId, dataObj: data});
                                var bData = angular.copy(data);
                                bData.clickedDate = clickedDate;
                                bData.event_id = eventId;
                                if ($scope.crtEvtParams.cal_global_id) {
                                    syncSvc.syncSingleEvent(params, function () {
                                        setTimeout(function() {
                                            $rootScope.$broadcast('eventUpdated', bData);
                                        }, 10);

                                    });
                                }
                                dialogService.close('eventEditPopup');
                            });
                            break;
                        case 2:
                            if (eventItem.timezone !== timezone || eventItem.start_time !== startTime || eventItem.all_day !== all_day) {
                                deleteChild = true;
                                exdate = null;
                                cancelled = [];
                            }
                            var changeEvent = {};
                            var hasChange = false;
                            if (type === 300) {
                                if (eventItem.name !== name) {
                                    changeEvent.name = name;
                                    hasChange = true;
                                }
                                if (eventItem.content !== content) {
                                    changeEvent.content = content;
                                    hasChange = true;
                                }
                                if (eventItem.importance !== importance) {
                                    changeEvent.importance = importance;
                                    hasChange = true;
                                }
                                if (eventItem.completed !== completed) {
                                    changeEvent.completed = completed;
                                    hasChange = true;
                                }
                                if (eventItem.location !== location) {
                                    changeEvent.location = location;
                                    hasChange = true;
                                }
                            }
                            var data = {
                                event_id: event_id,
                                calendar_id: calendar_id,
                                name: name,
                                content: content,
                                icon: icon,
                                color: color,
                                start_date: start_date,
                                end_date: end_date,
                                startTime: startTime,
                                endTime: endTime,
                                type: type,
                                timezone: timezone,
                                repeat: repeat,
                                importance: importance,
                                all_day: all_day,
                                holiday: holiday,
                                day_time: day_time,
                                location: location,
                                completed: completed,
                                complete_date: complete_date,
                                update_date: update_date,
                                instance_dates: instance_dates,
                                repeatSelectObj: repeatSelectObj,
                                date_diff: date_diff,
                                reminders: reminderList,
                                last_date: last_date,
                                rep_flag: repeat ? 1 : 0,
                                exdate: exdate,
                                long_flag: long_flag ? 1 : 0,
                                editRepeatType: editRepeatType,
                                originalStartDate: eventItem.start_date,
                                deleteChild: deleteChild,
                                changeEvent: hasChange ? changeEvent : null,
                                calendarType: calendarType,
                                cancelled : cancelled
                            };


                            eventSvc.updateEventDetails(data, function () {
                                var bData = angular.copy(data);
                                bData.clickedDate = clickedDate;
                                $rootScope.$broadcast('repeatEventsDeleted', event_id);
                                var params = {id: event_id, calendar_id: calendar_id, calendar_type: type};
                                if (type !== 300) {
                                    params.jorteCalendar = true;
                                } else {
                                    params.googleCalendar = true;
                                }
                                $rootScope.$broadcast('eventUpdated', bData);

                                if ($scope.crtEvtParams.cal_global_id) {
                                    syncSvc.syncSingleEvent(params, function () {
                                        setTimeout(function() {
                                            $rootScope.$broadcast('eventUpdated', bData);
                                        }, 10);
                                    });
                                }
                                dialogService.close('eventEditPopup');
                            });
                            break;
                        case 3:
                            var OldRepeatSelectObj = null, OldRepeat = null;
                            if (eventItem.repeat) {
                                var OldRepeats = eventItem.repeat.toString();
                                OldRepeatSelectObj = RRule.parseString(OldRepeats);
                                var dateObj = new Date(eventItem.start_date);
                                var rEnd = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate(), dateObj.getHours(), dateObj.getMinutes(), dateObj.getSeconds() - 1);
                                rEnd = jorteUtils.calcTime(eventItem.timezone, rEnd.getTime());
                                delete OldRepeatSelectObj.count;
                                OldRepeatSelectObj.until = rEnd;
                                OldRepeat = new RRule(OldRepeatSelectObj);
                                OldRepeat = OldRepeat.toString();
                            }
                            var rdata = {
                                event_id: event_id,
                                repeat: OldRepeat,
                                update_date: update_date,
                                repeatSelectObj: OldRepeatSelectObj,
                                editRepeatType: editRepeatType,
                                repeat_end: rEnd
                            };

                            var bData = angular.copy(rdata);
                            eventSvc.updateFutureEventDetails(rdata, function() {
                                bData.clickedDate = clickedDate;
                                $rootScope.$broadcast('repeatEventsDeleted', event_id);//broadcast to listeners for update their model/view
                                $rootScope.$broadcast('eventUpdated', bData);
                            });
                            var event = new EventJorte();
                            event.calendar_id = calendar_id, event.name = name, event.content = content, event.icon = icon, event.color = color,
                                    event.start_date = start_date, event.end_date = end_date, event.start_time = startTime, event.end_time = endTime,
                                    event.type = type, event.timezone = timezone, event.repeat = repeat, event.importance = importance, event.all_day = all_day,
                                    event.holiday = holiday, event.day_time = day_time, event.location = location, event.completed = completed,
                                    event.complete_date = complete_date, event.create_date = update_date, event.update_date = update_date,
                                    event.last_date = last_date, event.reminders = reminderList, event.rep_flag = repeat ? 1 : 0, event.long_flag = long_flag ? 1 : 0,
                                    event.seqno = eventItem.seqno;
                            var data = {
                                event: event,
                                instance_dates: instance_dates,
                                repeatSelectObj: repeatSelectObj,
                                date_diff: date_diff
                            };
                            eventSvc.createEvent(data, function (eventId) {
                                data.event.id = eventId;
                                notificationSvc.itemUpdateStatusCheck(eventId, true);
                                var params = {id: event_id, calendar_id: calendar_id, calendar_type: type};
                                if (type !== 300) {
                                    params.jorteCalendar = true;
                                } else {
                                    params.googleCalendar = true;
                                }
                                $rootScope.$broadcast('eventAdded', {createdDate: $scope.crtEvtParams.startDate, event_id: eventId, dataObj: data});

                                if ($scope.crtEvtParams.cal_global_id) {
                                    syncSvc.syncSingleEvent(params, function () {//sync main event
                                        setTimeout(function() {
                                           $rootScope.$broadcast('eventUpdated', bData);
                                        }, 10);
                                        var param = {id: eventId, calendar_id: calendar_id, calendar_type: type};
                                        if (type !== 300) {
                                            param.jorteCalendar = true;
                                        } else {
                                            param.googleCalendar = true;
                                        }

                                        var cData = angular.copy(data);
                                        cData.clickedDate = clickedDate;
                                        cData.event_id = eventId;
                                        syncSvc.syncSingleEvent(param, function () {//sync future event
                                            setTimeout(function () {
                                                $rootScope.$broadcast('eventUpdated', cData);
                                            }, 10);
                                        });
                                    });
                                }
                                dialogService.close('eventEditPopup');
                            });
                            break;
                    }
                };

                function getRepeatVal(repeatSelectObj, type) {
                    if (repeatSelectObj.interval) {
                        $scope.crtEvtParams.repeatParams.repeatInterval = repeatSelectObj.interval;
                    }
                    if (repeatSelectObj.count) {
                        $scope.crtEvtParams.repeatParams.repNum = repeatSelectObj.count;
                        $scope.crtEvtParams.repeatParams.endDate = true;
                        $scope.crtEvtParams.repeatParams.specify = false;
                    }

                    if (repeatSelectObj.until) {
                        $scope.crtEvtParams.repeatParams.specifyDay = repeatSelectObj.until;
                        $scope.crtEvtParams.repeatParams.endDate = true;
                        $scope.crtEvtParams.repeatParams.specify = true;
                    }
                    if (type === 4) { //Weekly
                        var days = repeatSelectObj.byweekday;
                        days = days.toString();
                        var weekDays = [
                            {val: (days.indexOf('MO') !== -1) ? true : false, label: getMSG('MonHead'), dayText: 'Mon'},
                            {val: (days.indexOf('TU') !== -1) ? true : false, label: getMSG('TueHead'), dayText: 'Tue'},
                            {val: (days.indexOf('WE') !== -1) ? true : false, label: getMSG('WedHead'), dayText: 'Wed'},
                            {val: (days.indexOf('TH') !== -1) ? true : false, label: getMSG('ThuHead'), dayText: 'Thu'},
                            {val: (days.indexOf('FR') !== -1) ? true : false, label: getMSG('FriHead'), dayText: 'Fri'},
                            {val: (days.indexOf('SA') !== -1) ? true : false, label: getMSG('SatHead'), dayText: 'Sat'},
                            {val: (days.indexOf('SU') !== -1) ? true : false, label: getMSG('SunHead'), dayText: 'Sun'}
                        ];
                        $scope.crtEvtParams.repeatParams.weekDays = weekDays;
                    }
                    if (type === 5) { //Monthly
                        var dayy = clickedDate.getDay();
                        var standardDate = false;
                        var standardDayWeek = false;

                        if (dayy === 0 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.SU)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 6)) {
                            standardDayWeek = true;
                        } else if (dayy === 1 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.MO)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 0)) {
                            standardDayWeek = true;
                        } else if (dayy === 2 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.TU)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 1)) {
                            standardDayWeek = true;
                        } else if (dayy === 3 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.WE)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 2)) {
                            standardDayWeek = true;
                        } else if (dayy === 4 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.TH)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 3)) {
                            standardDayWeek = true;
                        } else if (dayy === 5 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.FR)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 4)) {
                            standardDayWeek = true;
                        } else if (dayy === 6 && (repeatSelectObj.wkst && repeatSelectObj.wkst === RRule.SA)||(repeatSelectObj.byweekday && repeatSelectObj.byweekday[0].weekday === 5)) {
                            standardDayWeek = true;
                        } else {
                            standardDate = true;
                        }
                        if (standardDayWeek) {
                            $scope.crtEvtParams.repeatParams.stdDate = true;
                        } else if (standardDate) {
                            $scope.crtEvtParams.repeatParams.stdDate = false;
                        }
                    }
                    var rrRes = rruleSvc.getRRLabel($scope.crtEvtParams.repeatParams);
                    $scope.crtEvtParams.repeatParams.outlineLabel = rrRes.label;
                }

                //Google timezone
                $scope.googleTimezone = function () {
                    var gTzModel = {
                        defTz: $scope.crtEvtParams.googleTz,
                        googleTimeZoneCb: function (val) {
                            $scope.crtEvtParams.googleTz = val;
                        }
                    };
                    dialogService.open("googleTimezonePopup", "googleTimezone", gTzModel, {title: getMSG('SelectHead')});
                };

                $scope.onShowTimeClick = function(type) {
                    var time = null;
                    if (type === 1) {
                        time = $scope.crtEvtParams.startTime;
                    } else if (type === 2) {
                        time = $scope.crtEvtParams.endTime;
                    }
                    if (!time) {
                        return;
                    }

                    time = time.replace(':', '');
                    var modelData = {
                        currTime: time,
                        onSet: function (newTime) {
                            dialogService.close("timeSelectPopup");
                            var startDate = new Date($scope.crtEvtParams.startDate);
                            startDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate(), 0, 0, 0).getTime();
                            var endDate = new Date($scope.crtEvtParams.endDate);
                            endDate = new Date(endDate.getFullYear(), endDate.getMonth(), endDate.getDate(), 0, 0, 0).getTime();
                            if (type === 1) {
                                $scope.crtEvtParams.startTime = newTime;
                                if (startDate === endDate) {
                                    if ($scope.crtEvtParams.endTime !== '--:--' && newTime > $scope.crtEvtParams.endTime) {
                                        $scope.crtEvtParams.endTime = newTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.crtEvtParams.endTime = newTime;
                                if (startDate === endDate) {
                                    if ($scope.crtEvtParams.startTime !== '--:--' && newTime !== '--:--' && newTime < $scope.crtEvtParams.startTime) {
                                        $scope.crtEvtParams.startTime = newTime;
                                    }
                                }
                            }
                        }
                    };
                    dialogService.open("timeSelectPopup", "timeSelectPopup", modelData, {title: getMSG('SetTimeHead'), width: '70%'});
                };

                $scope.onShowDateClick = function(type) {
                    var date = null;
                    var startDate = new Date($scope.crtEvtParams.startDate);
                    startDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate(), 0, 0, 0);
                    var endDate = new Date($scope.crtEvtParams.endDate);
                    endDate = new Date(endDate.getFullYear(), endDate.getMonth(), endDate.getDate(), 0, 0, 0);
                    if (type === 1) {
                        date = startDate;
                    } else if (type === 2) {
                        date = endDate;
                    }
                    if (!date) {
                        date = new Date();
                    }
                    var modelData = {
                        currDate: date,
                        onSet: function (newDate) {
                            dialogService.close("dateSelectPopup");
                            if (type === 1) {
                                $scope.crtEvtParams.startDate = newDate;
                                $scope.crtEvtParams.startDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                if (newDate.getTime() > endDate.getTime()) {
                                    $scope.crtEvtParams.endDate = newDate;
                                    $scope.crtEvtParams.endDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                }
                                if (newDate.getTime() === endDate.getTime()) {
                                    if ($scope.crtEvtParams.endTime !== '--:--' && $scope.crtEvtParams.startTime > $scope.crtEvtParams.endTime) {
                                        $scope.crtEvtParams.endTime = $scope.crtEvtParams.startTime;
                                    }
                                }
                            } else if (type === 2) {
                                $scope.crtEvtParams.endDate = newDate;
                                $scope.crtEvtParams.endDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                if (startDate.getTime() > newDate.getTime()) {
                                    $scope.crtEvtParams.startDate = newDate;
                                    $scope.crtEvtParams.startDateDisp = jorteUtils.formatDate(new Date(newDate), getMSG('LongDateFormat2'), cal_string);
                                }
                                if (startDate.getTime() === newDate.getTime()) {
                                    if ($scope.crtEvtParams.startTime !== '--:--' && $scope.crtEvtParams.endTime < $scope.crtEvtParams.startTime) {
                                        $scope.crtEvtParams.startTime = $scope.crtEvtParams.endTime;
                                    }
                                }
                            }

                        }
                    };
                    var titleDate = jorteUtils.formatDate(date, getMSG('LongDateFormat2'), cal_string);
                    dialogService.open("dateSelectPopup", "dateSelectPopup", modelData, {title: titleDate});
                };

                $scope.onItemDelete = function () {
                    if ($scope.model.deleteClickCb && $scope.model.deleteClickCb()) {
                        dialogService.close('eventEditPopup');
                    }
                };
            }])
        //repeatEventSelect controller
        .controller('repeatEventSelectCtrl', ['$scope', 'dialogService',
            function ($scope, dialogService) {
                $scope.eventType = $scope.model.item.calendar_type;
                $scope.singleEvent = !$scope.model.item.global_id && $scope.model.item.calendar_type === 300 ? false : true;
                $scope.swapPopup = function(type) {
                    var models = {
                        title: $scope.model.title,
                        clickedDate: $scope.model.clickedDate,
                        item: $scope.model.item,
                        deleteClickCb: $scope.model.deleteClickCb,
                        repeatType: type
                    };
                    dialogService.close('repeatEventSelectPopup');
                    dialogService.open("eventEditPopup", "editEvent", models, {title: $scope.model.title});
                };
            }])
        //repeatEventDelete controller
        .controller('repeatEventDeleteCtrl', ['$scope', 'dialogService',
            function ($scope, dialogService) {
                $scope.params = {};
                $scope.params.selectVal = 1;
                $scope.eventType = $scope.model.item.calendar_type;
                $scope.singleEvent = !$scope.model.item.global_id && $scope.model.item.calendar_type === 300 ? false : true;
                $scope.swapPopup = function(type) {
                    $scope.model.repeatEventDeleteCb(type, $scope.model.item);
                    dialogService.close('repeatEventDeletePopup');
                };
                //For google events
                $scope.repeatDeleteOk = function() {
                    var type = parseInt($scope.params.selectVal);
                    $scope.model.repeatEventDeleteCb(type, $scope.model.item);
                    dialogService.close('repeatEventDeletePopup');
                };
                //For google events
                $scope.repeatDeleteCancel = function() {
                    dialogService.close('repeatEventDeletePopup');
                };
            }]);